/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.ast.RegexpNode;
import org.jruby.lexer.LexingCommon;
import org.jruby.lexer.yacc.RubyLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.RegexpOptions;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private int nest;

    public StringTerm(int flags2, int begin2, int end2) {
        this.flags = flags2;
        this.begin = (char)begin2;
        this.end = (char)end2;
        this.nest = 0;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    protected ByteList createByteList(RubyLexer lexer) {
        ByteList bytelist = new ByteList(15);
        bytelist.setEncoding(lexer.getEncoding());
        return bytelist;
    }

    private int endFound(RubyLexer lexer) throws IOException {
        if ((this.flags & 8) != 0) {
            this.flags = -1;
            lexer.getPosition();
            return 32;
        }
        if ((this.flags & 4) != 0) {
            RegexpOptions options2 = this.parseRegexpFlags(lexer);
            ByteList regexpBytelist = ByteList.create("");
            lexer.setValue(new RegexpNode(lexer.getPosition(), regexpBytelist, options2));
            return 383;
        }
        lexer.setValue("" + this.end);
        return 373;
    }

    private int parsePeekVariableName(RubyLexer lexer) throws IOException {
        int c = lexer.nextc();
        int significant = -1;
        switch (c) {
            case 36: {
                int c2 = lexer.nextc();
                if (c2 == 45) {
                    int c3 = lexer.nextc();
                    if (c3 == -1) {
                        lexer.pushback(c3);
                        lexer.pushback(c2);
                        return 0;
                    }
                    significant = c3;
                    lexer.pushback(c3);
                    lexer.pushback(c2);
                    break;
                }
                if (lexer.isGlobalCharPunct(c2)) {
                    lexer.setValue("#" + (char)c2);
                    lexer.pushback(c2);
                    lexer.pushback(c);
                    return 372;
                }
                significant = c2;
                lexer.pushback(c2);
                break;
            }
            case 64: {
                int c2 = lexer.nextc();
                if (c2 == 64) {
                    int c3 = lexer.nextc();
                    if (c3 == -1) {
                        lexer.pushback(c3);
                        lexer.pushback(c2);
                        return 0;
                    }
                    significant = c3;
                    lexer.pushback(c3);
                    lexer.pushback(c2);
                    break;
                }
                significant = c2;
                lexer.pushback(c2);
                break;
            }
            case 123: {
                lexer.setValue("#" + (char)c);
                lexer.commandStart = true;
                return 371;
            }
            default: {
                lexer.pushback(c);
                return 0;
            }
        }
        if (significant != -1 && Character.isAlphabetic(significant) || significant == 95) {
            lexer.pushback(c);
            lexer.setValue("#" + significant);
            return 372;
        }
        return 0;
    }

    @Override
    public int parseString(RubyLexer lexer) throws IOException {
        int token;
        boolean spaceSeen = false;
        if (this.flags == -1) {
            lexer.setValue("" + this.end);
            return 373;
        }
        int c = lexer.nextc();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = lexer.nextc())) {
            }
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            return this.endFound(lexer);
        }
        if (spaceSeen) {
            lexer.pushback(c);
            lexer.getPosition();
            return 32;
        }
        ByteList buffer = this.createByteList(lexer);
        lexer.newtok(true);
        if ((this.flags & 2) != 0 && c == 35 && (token = this.parsePeekVariableName(lexer)) != 0) {
            return token;
        }
        lexer.pushback(c);
        Encoding[] enc = new Encoding[]{lexer.getEncoding()};
        if (this.parseStringIntoBuffer(lexer, buffer, enc) == -1) {
            lexer.compile_error("unterminated string meets end of file");
        }
        lexer.setValue(lexer.createStr(buffer, this.flags));
        return 378;
    }

    private RegexpOptions parseRegexpFlags(RubyLexer lexer) throws IOException {
        RegexpOptions options2 = new RegexpOptions();
        StringBuilder unknownFlags = new StringBuilder(10);
        lexer.newtok(true);
        int c = lexer.nextc();
        while (c != -1 && Character.isLetter(c)) {
            switch (c) {
                case 105: {
                    options2.setIgnorecase(true);
                    break;
                }
                case 120: {
                    options2.setExtended(true);
                    break;
                }
                case 109: {
                    options2.setMultiline(true);
                    break;
                }
                case 111: {
                    options2.setOnce(true);
                    break;
                }
                case 110: {
                    options2.setExplicitKCode(KCode.NONE);
                    break;
                }
                case 101: {
                    options2.setExplicitKCode(KCode.EUC);
                    break;
                }
                case 115: {
                    options2.setExplicitKCode(KCode.SJIS);
                    break;
                }
                case 117: {
                    options2.setExplicitKCode(KCode.UTF8);
                    break;
                }
                case 106: {
                    options2.setJava(true);
                    break;
                }
                default: {
                    unknownFlags.append((char)c);
                }
            }
            c = lexer.nextc();
        }
        lexer.pushback(c);
        if (unknownFlags.length() != 0) {
            lexer.compile_error(SyntaxException.PID.REGEXP_UNKNOWN_OPTION, "unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags);
        }
        return options2;
    }

    private void mixedEscape(RubyLexer lexer, Encoding foundEncoding, Encoding parserEncoding) {
        lexer.compile_error(SyntaxException.PID.MIXED_ENCODING, "" + foundEncoding + " mixed within " + parserEncoding);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int parseStringIntoBuffer(RubyLexer lexer, ByteList buffer, Encoding[] enc) throws IOException {
        int c;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape = (this.flags & 1) != 0;
        boolean regexp2 = (this.flags & 4) != 0;
        boolean symbol = (this.flags & 0x10) != 0;
        boolean hasNonAscii = false;
        block5: while ((c = lexer.nextc()) != -1) {
            block28: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                if (lexer.getHeredocIndent() > 0) {
                                    lexer.update_heredoc_indent(c);
                                }
                                if (this.begin == '\u0000' || c != this.begin) break block29;
                                ++this.nest;
                                break block28;
                            }
                            if (c != this.end) break block30;
                            if (this.nest == 0) {
                                lexer.pushback(c);
                                break;
                            }
                            --this.nest;
                            break block28;
                        }
                        if (!expand || c != 35 || lexer.peek(10)) break block31;
                        int c2 = lexer.nextc();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            lexer.pushback(c2);
                            lexer.pushback(c);
                            break;
                        }
                        lexer.pushback(c2);
                        break block28;
                    }
                    if (c != 92) break block32;
                    c = lexer.nextc();
                    switch (c) {
                        case 10: {
                            if (qwords) break block28;
                            if (expand) break;
                            buffer.append(92);
                            break block28;
                        }
                        case 92: {
                            if (!escape) break block28;
                            buffer.append(c);
                            break block28;
                        }
                        case 117: {
                            if (!expand) {
                                buffer.append(92);
                                break block28;
                            } else {
                                if (regexp2) {
                                    lexer.readUTFEscapeRegexpLiteral(buffer);
                                } else {
                                    lexer.readUTFEscape(buffer, true, symbol);
                                }
                                if (!hasNonAscii || buffer.getEncoding() == enc[0]) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                                break;
                            }
                        }
                        default: {
                            if (c == -1) {
                                return -1;
                            }
                            if (!lexer.isASCII(c)) {
                                if (!expand) {
                                    buffer.append(92);
                                }
                                hasNonAscii = true;
                                if (buffer.getEncoding() != enc[0]) {
                                    this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                                    break;
                                }
                                if (lexer.tokadd_mbchar(c, buffer)) continue block5;
                                lexer.compile_error(SyntaxException.PID.INVALID_MULTIBYTE_CHAR, "invalid multibyte char (" + enc[0] + ")");
                                break;
                            }
                            if (regexp2) {
                                if (c == this.end && !this.simple_re_meta(c)) {
                                    buffer.append(c);
                                    break;
                                }
                                lexer.pushback(c);
                                this.parseEscapeIntoBuffer(lexer, buffer);
                                if (!hasNonAscii || buffer.getEncoding() == enc[0]) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                                break;
                            }
                            if (expand) {
                                lexer.pushback(c);
                                if (escape) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break block28;
                            } else if (!(qwords && Character.isWhitespace(c) || c == this.end || this.begin != '\u0000' && c == this.begin)) {
                                buffer.append(92);
                                lexer.pushback(c);
                                break;
                            }
                            break block28;
                        }
                    }
                    continue;
                }
                if (!lexer.isASCII(c)) {
                    hasNonAscii = true;
                    if (buffer.getEncoding() != enc[0]) {
                        this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                        continue;
                    }
                    if (lexer.tokadd_mbchar(c, buffer)) continue;
                    lexer.compile_error(SyntaxException.PID.INVALID_MULTIBYTE_CHAR, "invalid multibyte char (" + enc[0] + ")");
                    continue;
                }
                if (qwords && Character.isWhitespace(c)) {
                    lexer.pushback(c);
                    break;
                }
            }
            if ((c & 0x80) != 0) {
                hasNonAscii = true;
                if (buffer.getEncoding() != enc[0]) {
                    this.mixedEscape(lexer, buffer.getEncoding(), enc[0]);
                    continue;
                }
            }
            buffer.append(c);
        }
        enc[0] = buffer.getEncoding();
        return c;
    }

    private boolean simple_re_meta(int c) {
        switch (c) {
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 62: 
            case 63: 
            case 93: 
            case 94: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private void escaped(RubyLexer lexer, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(lexer, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(RubyLexer lexer, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append(c);
                for (int i2 = 0; i2 < 2; ++i2) {
                    c = lexer.nextc();
                    if (c == -1) {
                        lexer.compile_error("Invalid escape character syntax");
                    }
                    if (!LexingCommon.isOctChar(c)) {
                        lexer.pushback(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append(c);
                c = lexer.nextc();
                if (!LexingCommon.isHexChar(c)) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(c);
                c = lexer.nextc();
                if (LexingCommon.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                lexer.pushback(c);
                break;
            }
            case 77: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(lexer, buffer);
                break;
            }
            case 67: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(lexer, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(lexer, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                if (c != 92 || c != this.end) {
                    buffer.append(92);
                }
                buffer.append(c);
            }
        }
    }
}

