/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionManagement {
    public static String JHOTDRAW_COMPONENT = "CH.ifa.draw/";
    public static String JHOTDRAW_JAR = "jhotdraw.jar";
    public static Package[] packages = new Package[]{Package.getPackage("CH.ifa.draw.applet"), Package.getPackage("CH.ifa.draw.application"), Package.getPackage("CH.ifa.draw.contrib"), Package.getPackage("CH.ifa.draw.figures"), Package.getPackage("CH.ifa.draw.framework"), Package.getPackage("CH.ifa.draw.standard"), Package.getPackage("CH.ifa.draw.util")};

    public static String getJHotDrawVersion() {
        Package pack = packages[4];
        return pack.getSpecificationVersion();
    }

    public static String getPackageVersion(Package lookupPackage) {
        if (lookupPackage == null) {
            return null;
        }
        String specVersion = lookupPackage.getSpecificationVersion();
        if (specVersion != null) {
            return specVersion;
        }
        String normalizedPackageName = VersionManagement.normalizePackageName(lookupPackage.getName());
        String nextPackageName = VersionManagement.getNextPackage(normalizedPackageName);
        return VersionManagement.getPackageVersion(Package.getPackage(nextPackageName));
    }

    public static boolean isCompatibleVersion(String compareVersionString) {
        Package pack = packages[4];
        if (compareVersionString == null) {
            return pack.getSpecificationVersion() == null;
        }
        return pack.isCompatibleWith(compareVersionString);
    }

    public static String readVersionFromFile(String applicationName, String versionFileName) {
        try {
            FileInputStream fileInput = new FileInputStream(versionFileName);
            Manifest manifest = new Manifest();
            manifest.read(fileInput);
            Map<String, Attributes> entries = manifest.getEntries();
            Iterator<Map.Entry<String, Attributes>> entryIterator = entries.entrySet().iterator();
            if (entryIterator.hasNext()) {
                Map.Entry<String, Attributes> currentEntry = entryIterator.next();
                String packageName = currentEntry.getKey().toString();
                packageName = VersionManagement.normalizePackageName(packageName);
                Attributes attributes = currentEntry.getValue();
                String packageSpecVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                packageSpecVersion = VersionManagement.extractVersionInfo(packageSpecVersion);
                return packageSpecVersion;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected static String getNextPackage(String searchPackage) {
        if (searchPackage == null) {
            return null;
        }
        int foundNextPackage = searchPackage.lastIndexOf(46);
        if (foundNextPackage > 0) {
            return searchPackage.substring(0, foundNextPackage);
        }
        return null;
    }

    public static String normalizePackageName(String toBeNormalized) {
        String replaced = toBeNormalized.replace('/', '.');
        if ((replaced = replaced.replace(File.pathSeparatorChar, '.')).endsWith(".")) {
            int lastSeparator = replaced.lastIndexOf(46);
            return replaced.substring(0, lastSeparator);
        }
        return replaced;
    }

    public static String extractVersionInfo(String versionString) {
        if (versionString == null) {
            return null;
        }
        if (versionString.length() == 0) {
            return "";
        }
        int startIndex = versionString.indexOf("\"");
        startIndex = startIndex < 0 ? 0 : ++startIndex;
        int endIndex = versionString.lastIndexOf("\"");
        if (endIndex < 0) {
            endIndex = versionString.length();
        }
        return versionString.substring(startIndex, endIndex);
    }
}

