/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.ObjectWriter;
import com.ibm.xmi.framework.ObjectWriterWrapper;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.XMIFile;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

class FileWriter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int NOT_REFERENCED = 2;
    private static final int REFERENCED = 5;
    protected XMIFile file;
    private String filename;
    protected HashMap objectsToFiles;
    protected HashMap definerToFullName;
    protected HashMap definerToData;
    private HashSet written;
    private ArrayList writing;
    private HashSet processedObjects;
    private HashSet originalTopObjects;
    private ArrayList referencedObjects;
    private ArrayList objects;
    private ArrayList datas;
    private File xmiFile;
    private int option;
    protected ObjectWriterWrapper wrapper;
    private int newCount;

    public FileWriter(XMIFile xMIFile) {
        this.file = xMIFile;
        this.written = new HashSet();
        this.writing = new ArrayList();
        this.objects = new ArrayList();
        this.datas = new ArrayList();
        this.referencedObjects = new ArrayList();
        this.originalTopObjects = new HashSet();
    }

    private boolean equalsXMIFile(String string) {
        File file = new File(string);
        if (file.getName().equals(this.xmiFile.getName())) {
            return true;
        }
        file = new File(string.replace('/', File.separatorChar));
        return file.getName().equals(this.xmiFile.getName());
    }

    protected static boolean hasObject(Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (object != iterator.next()) continue;
            return true;
        }
        return false;
    }

    private boolean fileHasDocumentation() {
        return this.file.getExporter() != null || this.file.getExporterVersion() != null || this.file.getOwner() != null || this.file.getContact() != null || this.file.getLongDescription() != null || this.file.getShortDescription() != null || this.file.getNotice() != null;
    }

    protected boolean fileHasHeader() {
        if (this.fileHasDocumentation()) {
            return true;
        }
        Collection collection = this.file.getModels();
        if (collection.size() > 0) {
            return true;
        }
        collection = this.file.getMetamodels();
        if (collection.size() > 0) {
            return true;
        }
        collection = this.file.getMetametamodels();
        if (collection.size() > 0) {
            return true;
        }
        collection = this.file.getImports();
        return collection.size() > 0;
    }

    public Collection getAllLinks(Object object) {
        Collection[] collectionArray;
        if (this.definerToData == null) {
            this.definerToData = new HashMap();
        }
        if ((collectionArray = (Collection[])this.definerToData.get(object)) == null) {
            collectionArray = new Collection[]{null, null};
            this.definerToData.put(object, collectionArray);
            this.getFeatures(collectionArray, object);
        }
        return collectionArray[1];
    }

    public Collection getAllProperties(Object object) {
        Collection[] collectionArray;
        if (this.definerToData == null) {
            this.definerToData = new HashMap();
        }
        if ((collectionArray = (Collection[])this.definerToData.get(object)) == null) {
            collectionArray = new Collection[]{null, null};
            this.definerToData.put(object, collectionArray);
            this.getFeatures(collectionArray, object);
        }
        return collectionArray[0];
    }

    private void getFeatures(Collection[] collectionArray, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = this.wrapper.getAllFeatures(object).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.wrapper.getType(e);
            if (n == 7 || n == 6 || n == 8) {
                arrayList.add(e);
                continue;
            }
            if (n != 2 && n != 3 && n != 4) continue;
            arrayList2.add(e);
        }
        collectionArray[0] = arrayList;
        collectionArray[1] = arrayList2;
    }

    public Object[] getData(Object object) {
        int n = this.getIndex(object);
        if (n == -1) {
            return null;
        }
        return (Object[])this.datas.get(n);
    }

    private int getIndex(Object object) {
        int n = 0;
        while (n < this.objects.size()) {
            if (this.objects.get(n) == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public XMIFile getFile() {
        return this.file;
    }

    protected String getName(Object object) {
        String string = this.wrapper.getXMIName(object);
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public String getFullName(Object object) {
        String string;
        if (this.definerToFullName == null) {
            this.definerToFullName = new HashMap();
        }
        if ((string = (String)this.definerToFullName.get(object)) == null) {
            string = this.wrapper.getFullName(object, 500);
            this.definerToFullName.put(object, string);
        }
        return string;
    }

    protected Namespace getNamespace(Object object) {
        return null;
    }

    public HashMap getObjectsToFiles() {
        return this.objectsToFiles;
    }

    public int getOption() {
        return this.option;
    }

    public int getOption(int n) {
        return this.option & n;
    }

    public ArrayList getWriting() {
        return this.writing;
    }

    public HashSet getWritten() {
        return this.written;
    }

    protected String[] getXMIAttribs() {
        String[] stringArray = new String[4];
        stringArray[0] = "xmi.version";
        stringArray[1] = this.file.getXMIVersion();
        if (this.file.isPrintTimestamp()) {
            stringArray[2] = "timestamp";
            stringArray[3] = this.file.getTimestamp() != null ? this.file.getTimestamp() : new Date().toString();
        }
        return stringArray;
    }

    private void initialize() {
        this.filename = this.file.getEntry() != null ? this.file.getEntry() : this.file.getFilename();
        this.xmiFile = new File(this.filename);
        this.objectsToFiles = new HashMap();
        if (this.getOption(8) == 8) {
            this.originalTopObjects.addAll(this.file.getObjects());
        }
        Iterator iterator = this.file.getObjects().iterator();
        this.processedObjects = new HashSet();
        int n = 1;
        while (iterator.hasNext()) {
            this.processObject(iterator.next(), "_" + n++, this.filename, 1);
        }
    }

    protected ObjectWriter makeObjectWriter(Object object) {
        ObjectWriter objectWriter = new ObjectWriter(object);
        objectWriter.setWrapper(this.wrapper);
        return objectWriter;
    }

    protected void processLink(Object object) {
    }

    protected void processObject(Object object, String string, String string2, int n) {
        Object object2;
        String string3;
        if (n == 5 && this.getOption(8) != 8) {
            return;
        }
        if (n == 5 && this.getOption(8) == 8 && FileWriter.hasObject(this.originalTopObjects, object)) {
            return;
        }
        if (FileWriter.hasObject(this.processedObjects, object)) {
            return;
        }
        if (n == 5 && !FileWriter.hasObject(this.originalTopObjects, object)) {
            this.referencedObjects.add(object);
        }
        this.processedObjects.add(object);
        String string4 = this.wrapper.getXMIFile(object);
        if (string4 == null) {
            string4 = this.wrapper.getHref(object);
        }
        if (string4 != null) {
            string2 = string4;
        }
        if (this.objectsToFiles.get(object) == null && !this.equalsXMIFile(string2)) {
            this.objectsToFiles.put(object, string2);
        }
        if ((string3 = this.wrapper.getId(object)) == null) {
            string3 = string;
            this.wrapper.setId(object, string);
        }
        int n2 = 1;
        HashMap hashMap = new HashMap(13);
        Collection collection = this.wrapper.getValues(object);
        Collection collection2 = this.processProperties(string, n2, string2, collection, hashMap);
        Collection collection3 = this.processLinks(string, this.newCount, string2, collection, hashMap);
        Collection collection4 = this.wrapper.getExtensions(object);
        Iterator iterator = collection4.iterator();
        while (iterator.hasNext()) {
            object2 = this.wrapper.getContents(iterator.next()).iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                if (this.wrapper.getType(e) != 10) continue;
                this.processObject(e, string + "." + this.newCount++, string2, 2);
            }
        }
        object2 = new Object[6];
        object2[0] = string3;
        object2[1] = this.getNamespace(object);
        if (collection2.size() > 0) {
            object2[2] = collection2;
        }
        if (collection3.size() > 0) {
            object2[3] = collection3;
        }
        if (collection4.size() > 0) {
            object2[4] = collection4;
        }
        object2[5] = hashMap;
        this.objects.add(object);
        this.datas.add(object2);
    }

    protected Collection processProperties(String string, int n, String string2, Collection collection, HashMap hashMap) {
        Collection collection2 = this.wrapper.getProperties(collection);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection2.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.processProperty(e);
                String string3 = this.getName(e);
                Object object = this.wrapper.getValue(e);
                if (object != null) {
                    hashMap.put(string3, object);
                } else {
                    arrayList.add(e);
                }
                if (this.wrapper.getType(e) != 8 || object == null) continue;
                if (!(object instanceof ArrayList)) {
                    this.processObject(object, string + "." + n++, string2, 2);
                    continue;
                }
                Iterator iterator2 = ((AbstractList)((ArrayList)object)).iterator();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    this.processObject(e2, string + "." + n++, string2, 2);
                }
            }
        }
        this.removeNulls(collection2, arrayList);
        this.newCount = n;
        return collection2;
    }

    protected void processProperty(Object object) {
    }

    protected Collection processLinks(String string, int n, String string2, Collection collection, HashMap hashMap) {
        ArrayList arrayList = new ArrayList();
        Collection collection2 = this.wrapper.getLinks(collection);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Object e = iterator.next();
            this.processLink(e);
            Object object = this.wrapper.getValue(e);
            String string3 = this.getName(e);
            if (object != null) {
                hashMap.put(string3, object);
            } else {
                arrayList.add(e);
            }
            if (this.wrapper.getType(e) != 4) {
                if (object == null) continue;
                if (object instanceof ArrayList) {
                    iterator2 = ((AbstractList)((ArrayList)object)).iterator();
                    while (iterator2.hasNext()) {
                        this.processReference(iterator2.next(), string + "." + n++, string2);
                    }
                    continue;
                }
                this.processReference(object, string + "." + n++, string2);
                continue;
            }
            if (object == null) continue;
            if (object instanceof ArrayList) {
                iterator2 = ((AbstractList)((ArrayList)object)).iterator();
                while (iterator2.hasNext()) {
                    this.processObject(iterator2.next(), string + "." + n++, string2, 2);
                }
                continue;
            }
            this.processObject(object, string + "." + n++, string2, 2);
        }
        this.removeNulls(collection2, arrayList);
        this.newCount = n;
        return collection2;
    }

    protected void removeNulls(Collection collection, Collection collection2) {
        if (collection2.size() > 0) {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                collection.remove(iterator.next());
            }
        }
    }

    private void processReference(Object object, String string, String string2) {
        this.processObject(object, string, string2, 5);
        String string3 = this.wrapper.getXMIFile(object);
        if (string3 != null && this.objectsToFiles.get(object) == null && !this.equalsXMIFile(string3)) {
            this.objectsToFiles.put(object, string3);
            if (this.wrapper.getId(object) == null) {
                this.wrapper.setId(object, string + "E");
            }
        }
    }

    public void setOption(int n) {
        this.option = n;
    }

    public void setWriterWrapper(ObjectWriterWrapper objectWriterWrapper) {
        this.wrapper = objectWriterWrapper;
    }

    public void write(int n, int n2) throws Exception {
        this.wrapper.setXMIFile(this.file);
        this.initialize();
        PrintXML.setEncoding(this.file.getEncoding());
        if (this.getOption(2) != 2) {
            this.writeHeader(0, n2);
        }
        this.writeContent(n2, n2);
        PrintXML.printEndDocument();
    }

    protected void writeContent(int n, int n2) throws Exception {
        Collection collection = this.getTopObjects();
        if (this.getOption(2) != 2) {
            if (collection.size() == 0) {
                PrintXML.printStartElement("XMI.content", null, true, n);
            } else {
                PrintXML.printStartElement("XMI.content", null, false, n);
            }
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ObjectWriter objectWriter = this.makeObjectWriter(iterator.next());
            objectWriter.setFileWriter(this);
            objectWriter.write(n + n2, n2);
        }
        if (this.getOption(2) != 2) {
            if (collection.size() != 0) {
                PrintXML.printEndElement("XMI.content", n);
            }
            PrintXML.printEndElement("XMI", 0);
        }
    }

    protected Collection getTopObjects() {
        if (this.getOption(8) != 8) {
            return this.file.getObjects();
        }
        ArrayList arrayList = new ArrayList(this.file.getObjects());
        arrayList.addAll(this.referencedObjects);
        return arrayList;
    }

    protected void writeHeader(int n, int n2) throws Exception {
        PrintXML.printXMLPI("1.0");
        if (this.file.getDTD() != null) {
            PrintXML.printDoctype("XMI", this.file.getDTD());
        }
        String[] stringArray = this.getXMIAttribs();
        PrintXML.printStartElement("XMI", stringArray, false, 0);
        this.writeXMIHeader(n + n2, n2);
    }

    private void writeXMIDocumentation(int n, int n2) throws Exception {
        PrintXML.printStartElement(this.getDocumentation(), null, false, n);
        if (this.file.getExporter() != null) {
            this.writeDocElement(this.getExporter(), this.file.getExporter(), n, n2);
        }
        if (this.file.getExporterVersion() != null) {
            this.writeDocElement(this.getExporterVersion(), this.file.getExporterVersion(), n, n2);
        }
        if (this.file.getOwner() != null) {
            this.writeDocElement(this.getOwner(), this.file.getOwner(), n, n2);
        }
        if (this.file.getContact() != null) {
            this.writeDocElement(this.getContact(), this.file.getContact(), n, n2);
        }
        if (this.file.getLongDescription() != null) {
            this.writeDocElement(this.getLongDescription(), this.file.getLongDescription(), n, n2);
        }
        if (this.file.getShortDescription() != null) {
            this.writeDocElement(this.getShortDescription(), this.file.getShortDescription(), n, n2);
        }
        if (this.file.getNotice() != null) {
            this.writeDocElement(this.getNotice(), this.file.getNotice(), n, n2);
        }
        PrintXML.printEndElement(this.getDocumentation(), n);
    }

    private void writeDocElement(String string, String string2, int n, int n2) throws Exception {
        PrintXML.printStartElement(string, null, false, n + n2);
        PrintXML.printText(string2);
        PrintXML.printEndElement(string, -1);
    }

    protected void writeXMIHeader(int n, int n2) throws Exception {
        if (this.fileHasHeader()) {
            PrintXML.printStartElement("XMI.header", null, false, n);
            this.writeXMIHeaderContent(n, n2);
            PrintXML.printEndElement("XMI.header", n);
        }
    }

    protected void writeXMIHeaderContent(int n, int n2) throws Exception {
        if (this.fileHasDocumentation()) {
            this.writeXMIDocumentation(n + n2, n2);
        }
        Iterator iterator = this.file.getModels().iterator();
        while (iterator.hasNext()) {
            this.writeXMIHeaderElement(iterator.next(), n + n2);
        }
        iterator = this.file.getMetamodels().iterator();
        while (iterator.hasNext()) {
            this.writeXMIHeaderElement(iterator.next(), n + n2);
        }
        iterator = this.file.getMetametamodels().iterator();
        while (iterator.hasNext()) {
            this.writeXMIHeaderElement(iterator.next(), n + n2);
        }
        iterator = this.file.getImports().iterator();
        while (iterator.hasNext()) {
            this.writeXMIHeaderElement(iterator.next(), n + n2);
        }
    }

    private void writeXMIHeaderElement(Object object, int n) throws Exception {
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (object instanceof XMIFile.Metamodel) {
            string = this.getMetamodel();
            string2 = ((XMIFile.Metamodel)object).getName();
            string3 = ((XMIFile.Metamodel)object).getVersion();
            string4 = ((XMIFile.Metamodel)object).getHref();
        } else if (object instanceof XMIFile.Metametamodel) {
            string = this.getMetametamodel();
            string2 = ((XMIFile.Metametamodel)object).getName();
            string3 = ((XMIFile.Metametamodel)object).getVersion();
            string4 = ((XMIFile.Metametamodel)object).getHref();
        } else if (object instanceof XMIFile.Import) {
            string = this.getImport();
            string2 = ((XMIFile.Import)object).getName();
            string3 = ((XMIFile.Import)object).getVersion();
            string4 = ((XMIFile.Import)object).getHref();
        } else if (object instanceof XMIFile.Model) {
            string = this.getModel();
            string2 = ((XMIFile.Model)object).getName();
            string3 = ((XMIFile.Model)object).getVersion();
            string4 = ((XMIFile.Model)object).getHref();
        }
        String[] stringArray = new String[6];
        stringArray[0] = this.getNameAttrib();
        stringArray[1] = string2;
        if (string3 != null) {
            stringArray[2] = this.getVersionAttrib();
            stringArray[3] = string3;
        }
        if (string4 != null) {
            stringArray[4] = "href";
            stringArray[5] = string4;
        }
        PrintXML.printStartElement(string, stringArray, true, n);
    }

    protected String getMetametamodel() {
        return "XMI.metametamodel";
    }

    protected String getMetamodel() {
        return "XMI.metamodel";
    }

    protected String getModel() {
        return "XMI.model";
    }

    protected String getImport() {
        return "XMI.import";
    }

    protected String getVersionAttrib() {
        return "xmi.version";
    }

    protected String getNameAttrib() {
        return "xmi.name";
    }

    protected String getDocumentation() {
        return "XMI.documentation";
    }

    protected String getExporter() {
        return "XMI.exporter";
    }

    protected String getExporterVersion() {
        return "XMI.exporterVersion";
    }

    protected String getOwner() {
        return "XMI.owner";
    }

    protected String getContact() {
        return "XMI.contact";
    }

    protected String getNotice() {
        return "XMI.notice";
    }

    protected String getShortDescription() {
        return "XMI.shortDescription";
    }

    protected String getLongDescription() {
        return "XMI.longDescription";
    }
}

