/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.stats.ExtensionStats;
import org.zaproxy.zap.extension.stats.InMemoryStats;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.utils.Stats;
import org.zaproxy.zap.utils.XMLStringUtil;

public class StatsAPI
extends ApiImplementor {
    private static final String PREFIX = "stats";
    private static final String ACTION_CLEAR_STATS = "clearStats";
    private static final String VIEW_STATS = "stats";
    private static final String VIEW_SITE_STATS = "siteStats";
    private static final String VIEW_ALL_SITES_STATS = "allSitesStats";
    private static final String PARAM_KEY_PREFIX = "keyPrefix";
    private static final String PARAM_SITE = "site";
    private ExtensionStats extension;

    public StatsAPI(ExtensionStats extensionStats) {
        this.extension = extensionStats;
        this.addApiAction(new ApiAction(ACTION_CLEAR_STATS, null, new String[]{PARAM_KEY_PREFIX}));
        this.addApiView(new ApiView("stats", null, new String[]{PARAM_KEY_PREFIX}));
        this.addApiView(new ApiView(VIEW_ALL_SITES_STATS, null, new String[]{PARAM_KEY_PREFIX}));
        this.addApiView(new ApiView(VIEW_SITE_STATS, new String[]{PARAM_SITE}, new String[]{PARAM_KEY_PREFIX}));
    }

    @Override
    public String getPrefix() {
        return "stats";
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        if (ACTION_CLEAR_STATS.equals(string)) {
            Stats.clear(this.getParam(jSONObject, PARAM_KEY_PREFIX, ""));
            return ApiResponseElement.OK;
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse = null;
        InMemoryStats inMemoryStats = this.extension.getInMemoryStats();
        if (inMemoryStats == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
        }
        if ("stats".equals(string)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, Long> entry : inMemoryStats.getStats(this.getParam(jSONObject, PARAM_KEY_PREFIX, "")).entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().toString());
            }
            apiResponse = new ApiResponseSet(string, hashMap);
        } else if (VIEW_ALL_SITES_STATS.equals(string)) {
            apiResponse = new ApiResponseList(string);
            for (Map.Entry<String, Map<String, Long>> entry : inMemoryStats.getAllSiteStats(this.getParam(jSONObject, PARAM_KEY_PREFIX, "")).entrySet()) {
                ((ApiResponseList)apiResponse).addItem(new SiteStatsApiResponse(entry.getKey(), entry.getValue()));
            }
        } else if (VIEW_SITE_STATS.equals(string)) {
            URI uRI;
            String string2 = jSONObject.getString(PARAM_SITE);
            try {
                uRI = new URI(string2, true);
                string2 = SessionStructure.getHostName(uRI);
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_SITE);
            }
            String string3 = uRI.getScheme();
            if (string3 == null || !string3.equalsIgnoreCase("http") && !string3.equalsIgnoreCase("https")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_SITE);
            }
            apiResponse = new SiteStatsApiResponse(string2, inMemoryStats.getSiteStats(string2, this.getParam(jSONObject, PARAM_KEY_PREFIX, "")));
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return apiResponse;
    }

    private static class SiteStatsApiResponse
    extends ApiResponseList {
        private String site;
        private Map<String, Long> stats;

        public SiteStatsApiResponse(String string, Map<String, Long> map) {
            super("statistics");
            this.site = string;
            this.stats = map;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, Long> entry : this.stats.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().toString());
            }
            this.addItem(new ApiResponseSet(string, hashMap));
        }

        @Override
        public void toXML(Document document, Element element) {
            element.setAttribute("type", "list");
            Element element2 = document.createElement(StatsAPI.PARAM_SITE);
            Text text = document.createTextNode(XMLStringUtil.escapeControlChrs(this.site));
            element2.appendChild(text);
            element.appendChild(element2);
            for (Map.Entry<String, Long> entry : this.stats.entrySet()) {
                Element element3 = document.createElement("statistic");
                element3.setAttribute("type", "set");
                Element element4 = document.createElement("key");
                Text text2 = document.createTextNode(XMLStringUtil.escapeControlChrs(entry.getKey()));
                element4.appendChild(text2);
                element3.appendChild(element4);
                Element element5 = document.createElement("value");
                Text text3 = document.createTextNode(XMLStringUtil.escapeControlChrs(entry.getValue().toString()));
                element5.appendChild(text3);
                element3.appendChild(element5);
                element.appendChild(element3);
            }
        }

        @Override
        public JSON toJSON() {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (ApiResponse apiResponse : this.getItems()) {
                if (apiResponse instanceof ApiResponseElement) {
                    jSONArray.add((Object)((ApiResponseElement)apiResponse).getValue());
                    continue;
                }
                jSONArray.add((Object)apiResponse.toJSON());
            }
            jSONObject.put((Object)this.site, (Object)jSONArray);
            return jSONObject;
        }
    }
}

