/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class VFSManager {
    public static final String SERVICE = "org.gjt.sp.jedit.io.VFS";
    private static VFS fileVFS;
    private static VFS urlVFS;
    private static boolean error;
    private static final Object errorLock;
    private static final Vector<ErrorListDialog.ErrorEntry> errors;
    private static final Object vfsUpdateLock;
    private static final List<VFSUpdate> vfsUpdates;
    private static boolean errorDisplayerActive;

    public static void init() {
    }

    public static void start() {
        AwtRunnableQueue.INSTANCE.start();
    }

    public static VFS getFileVFS() {
        return fileVFS;
    }

    public static VFS getUrlVFS() {
        return urlVFS;
    }

    public static VFS getVFSForProtocol(String string) {
        if (string.equals("file")) {
            return fileVFS;
        }
        VFS vFS = (VFS)ServiceManager.getService(SERVICE, string);
        if (vFS != null) {
            return vFS;
        }
        return urlVFS;
    }

    public static VFS getVFSForPath(String string) {
        if (MiscUtilities.isURL(string)) {
            return VFSManager.getVFSForProtocol(MiscUtilities.getProtocolOfURL(string));
        }
        return fileVFS;
    }

    public static String[] getVFSs() {
        LinkedList linkedList = new LinkedList();
        String[] stringArray = ServiceManager.getServiceNames(SERVICE);
        if (stringArray != null) {
            Collections.addAll(linkedList, stringArray);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static void waitForRequests() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
        TaskManager.instance.waitForIoTasks();
    }

    public static boolean errorOccurred() {
        return error;
    }

    public static int getRequestCount() {
        return TaskManager.instance.countIoTasks();
    }

    @Deprecated
    public static void runInAWTThread(Runnable runnable) {
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(runnable);
    }

    @Deprecated
    public static void runInWorkThread(Task task) {
        if (!(task instanceof IoTask)) {
            throw new IllegalArgumentException();
        }
        ThreadUtilities.runInBackground(task);
    }

    public static void error(IOException iOException, String string, Component component) {
        Log.log(9, VFSManager.class, iOException);
        VFSManager.error(component, string, "ioerror", new String[]{iOException.toString()});
    }

    public static void error(Component component, String string, String string2, Object[] objectArray) {
        VFSManager.error(component, string, string2, objectArray, 9);
    }

    public static void error(final Component component, final String string, final String string2, final Object[] objectArray, final int n) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Frame frame = JOptionPane.getFrameForComponent(component);
                Object object = errorLock;
                synchronized (object) {
                    error = true;
                    errors.add(new ErrorListDialog.ErrorEntry(string, string2, objectArray, n));
                    if (errors.size() == 1 && !errorDisplayerActive) {
                        ThreadUtilities.runInBackground(new ErrorDisplayer(frame));
                    }
                }
            }
        };
        ThreadUtilities.runInDispatchThreadAndWait(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendVFSUpdate(VFS vFS, String string, boolean bl) {
        if (bl) {
            VFSManager.sendVFSUpdate(vFS, vFS.getParentOfPath(string), false);
            VFSManager.sendVFSUpdate(vFS, string, false);
        } else {
            if (string.length() != 1 && (string.endsWith("/") || string.endsWith(File.separator))) {
                string = string.substring(0, string.length() - 1);
            }
            Object object = vfsUpdateLock;
            synchronized (object) {
                for (VFSUpdate vFSUpdate : vfsUpdates) {
                    if (!vFSUpdate.getPath().equals(string)) continue;
                    return;
                }
                vfsUpdates.add(new VFSUpdate(string));
                if (vfsUpdates.size() == 1) {
                    AwtRunnableQueue.INSTANCE.runAfterIoTasks(new SendVFSUpdatesSafely());
                }
            }
        }
    }

    private VFSManager() {
    }

    static {
        errorLock = new Object();
        vfsUpdateLock = new Object();
        errorDisplayerActive = false;
        errors = new Vector();
        fileVFS = new FileVFS();
        urlVFS = new UrlVFS();
        vfsUpdates = new ArrayList<VFSUpdate>(10);
    }

    private static class ErrorDisplayer
    implements Runnable {
        private Frame frame;

        public ErrorDisplayer(Frame frame) {
            this.frame = frame;
        }

        private void showDialog(final Frame frame, final Vector<ErrorListDialog.ErrorEntry> vector) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String string = jEdit.getProperty("ioerror.caption" + (vector.size() == 1 ? "-1" : ""), new Integer[]{vector.size()});
                        new ErrorListDialog(frame.isShowing() ? frame : jEdit.getFirstView(), jEdit.getProperty("ioerror.title"), string, vector, false);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.log(9, ErrorDisplayer.class, invocationTargetException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = errorLock;
            synchronized (object) {
                if (errorDisplayerActive) {
                    return;
                }
                errorDisplayerActive = true;
            }
            while (true) {
                Vector<ErrorListDialog.ErrorEntry> vector;
                object = errorLock;
                synchronized (object) {
                    if (errors.size() == 0) {
                        errorDisplayerActive = false;
                        break;
                    }
                }
                int n = -1;
                int n2 = 0;
                while (n != n2) {
                    n = errors.size();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    n2 = errors.size();
                }
                Object object2 = errorLock;
                synchronized (object2) {
                    vector = new Vector<ErrorListDialog.ErrorEntry>(errors);
                    errors.clear();
                    error = false;
                }
                this.showDialog(this.frame, vector);
            }
        }
    }

    static class SendVFSUpdatesSafely
    implements Runnable {
        SendVFSUpdatesSafely() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = vfsUpdateLock;
            synchronized (object) {
                Collections.sort(vfsUpdates, new StandardUtilities.StringCompare());
                for (VFSUpdate vFSUpdate : vfsUpdates) {
                    EditBus.send(vFSUpdate);
                }
                vfsUpdates.clear();
            }
        }
    }
}

