/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDisk;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.control.group.GroupId;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.AbstractLRUMap;
import org.apache.commons.jcs.utils.struct.LRUMap;
import org.apache.commons.jcs.utils.timing.ElapsedTimer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexedDiskCache<K, V>
extends AbstractDiskCache<K, V> {
    private static final Log log = LogFactory.getLog(IndexedDiskCache.class);
    protected final String logCacheName;
    private final String fileName;
    private IndexedDisk dataFile;
    private IndexedDisk keyFile;
    private Map<K, IndexedDiskElementDescriptor> keyHash;
    private final int maxKeySize;
    private File rafDir;
    private boolean doRecycle = true;
    private boolean isRealTimeOptimizationEnabled = true;
    private boolean isShutdownOptimizationEnabled = true;
    private boolean isOptimizing = false;
    private int timesOptimized = 0;
    private volatile Thread currentOptimizationThread;
    private int removeCount = 0;
    private boolean queueInput = false;
    private final ConcurrentSkipListSet<IndexedDiskElementDescriptor> queuedPutList = new ConcurrentSkipListSet<IndexedDiskElementDescriptor>(new PositionComparator());
    private ConcurrentSkipListSet<IndexedDiskElementDescriptor> recycle;
    private final IndexedDiskCacheAttributes cattr;
    private int recycleCnt = 0;
    private int startupSize = 0;
    private AtomicLong bytesFree = new AtomicLong(0L);
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
    private AtomicInteger hitCount = new AtomicInteger(0);
    protected ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();

    public IndexedDiskCache(IndexedDiskCacheAttributes indexedDiskCacheAttributes) {
        this(indexedDiskCacheAttributes, null);
    }

    public IndexedDiskCache(IndexedDiskCacheAttributes indexedDiskCacheAttributes, IElementSerializer iElementSerializer) {
        super(indexedDiskCacheAttributes);
        this.setElementSerializer(iElementSerializer);
        this.cattr = indexedDiskCacheAttributes;
        this.maxKeySize = indexedDiskCacheAttributes.getMaxKeySize();
        this.isRealTimeOptimizationEnabled = indexedDiskCacheAttributes.getOptimizeAtRemoveCount() > 0;
        this.isShutdownOptimizationEnabled = indexedDiskCacheAttributes.isOptimizeOnShutdown();
        this.logCacheName = "Region [" + this.getCacheName() + "] ";
        this.diskLimitType = indexedDiskCacheAttributes.getDiskLimitType();
        this.fileName = this.getCacheName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        try {
            this.initializeFileSystem(indexedDiskCacheAttributes);
            this.initializeKeysAndData(indexedDiskCacheAttributes);
            this.initializeRecycleBin();
            this.setAlive(true);
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Indexed Disk Cache is alive.");
            }
            if (this.isRealTimeOptimizationEnabled && this.keyHash.size() > 0) {
                this.doOptimizeRealTime();
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure initializing for fileName: " + this.fileName + " and directory: " + this.rafDir.getAbsolutePath(), iOException);
        }
    }

    private void initializeFileSystem(IndexedDiskCacheAttributes indexedDiskCacheAttributes) {
        this.rafDir = indexedDiskCacheAttributes.getDiskPath();
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Cache file root directory: " + this.rafDir);
        }
    }

    private void initializeKeysAndData(IndexedDiskCacheAttributes indexedDiskCacheAttributes) throws IOException {
        this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"), this.getElementSerializer());
        this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"), this.getElementSerializer());
        if (indexedDiskCacheAttributes.isClearDiskOnStartup()) {
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "ClearDiskOnStartup is set to true.  Ingnoring any persisted data.");
            }
            this.initializeEmptyStore();
        } else if (this.keyFile.length() > 0L) {
            this.initializeStoreFromPersistedData();
        } else {
            this.initializeEmptyStore();
        }
    }

    private void initializeEmptyStore() throws IOException {
        this.initializeKeyMap();
        if (this.dataFile.length() > 0L) {
            this.dataFile.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStoreFromPersistedData() throws IOException {
        this.loadKeys();
        if (this.keyHash.isEmpty()) {
            this.dataFile.reset();
        } else {
            boolean bl = this.checkKeyDataConsistency(false);
            if (!bl) {
                this.keyHash.clear();
                this.keyFile.reset();
                this.dataFile.reset();
                log.warn(this.logCacheName + "Corruption detected.  Reseting data and keys files.");
            } else {
                IndexedDiskCache indexedDiskCache = this;
                synchronized (indexedDiskCache) {
                    this.startupSize = this.keyHash.size();
                }
            }
        }
    }

    protected void loadKeys() {
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Loading keys for " + this.keyFile.toString());
        }
        this.storageLock.writeLock().lock();
        try {
            this.initializeKeyMap();
            HashMap hashMap = (HashMap)this.keyFile.readObject(new IndexedDiskElementDescriptor(0L, (int)this.keyFile.length() - 4));
            if (hashMap != null) {
                if (log.isDebugEnabled()) {
                    log.debug(this.logCacheName + "Found " + hashMap.size() + " in keys file.");
                }
                this.keyHash.putAll(hashMap);
                if (log.isInfoEnabled()) {
                    log.info(this.logCacheName + "Loaded keys from [" + this.fileName + "], key count: " + this.keyHash.size() + "; up to " + this.maxKeySize + " will be available.");
                }
            }
            if (log.isDebugEnabled()) {
                this.dump(false);
            }
        }
        catch (Exception exception) {
            log.error(this.logCacheName + "Problem loading keys for file " + this.fileName, exception);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    private boolean checkKeyDataConsistency(boolean bl) {
        ElapsedTimer elapsedTimer = new ElapsedTimer();
        log.debug(this.logCacheName + "Performing inital consistency check");
        boolean bl2 = true;
        long l = 0L;
        try {
            l = this.dataFile.length();
            for (Map.Entry<K, IndexedDiskElementDescriptor> entry : this.keyHash.entrySet()) {
                IndexedDiskElementDescriptor indexedDiskElementDescriptor = entry.getValue();
                bl2 = indexedDiskElementDescriptor.pos + 4L + (long)indexedDiskElementDescriptor.len <= l;
                if (bl2) continue;
                log.warn(this.logCacheName + "The dataFile is corrupted!\n raf.length() = " + l + "\n ded.pos = " + indexedDiskElementDescriptor.pos);
                break;
            }
            if (bl2 && bl) {
                bl2 = this.checkForDedOverlaps(this.createPositionSortedDescriptorList());
            }
        }
        catch (IOException iOException) {
            log.error(iOException);
            bl2 = false;
        }
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Finished inital consistency check, isOk = " + bl2 + " in " + elapsedTimer.getElapsedTimeString());
        }
        return bl2;
    }

    protected boolean checkForDedOverlaps(IndexedDiskElementDescriptor[] indexedDiskElementDescriptorArray) {
        long l = System.currentTimeMillis();
        boolean bl = true;
        long l2 = 0L;
        for (int i = 0; i < indexedDiskElementDescriptorArray.length; ++i) {
            IndexedDiskElementDescriptor indexedDiskElementDescriptor = indexedDiskElementDescriptorArray[i];
            if (l2 > indexedDiskElementDescriptor.pos) {
                log.error(this.logCacheName + "Corrupt file: overlapping deds " + indexedDiskElementDescriptor);
                bl = false;
                break;
            }
            l2 = indexedDiskElementDescriptor.pos + 4L + (long)indexedDiskElementDescriptor.len;
        }
        long l3 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Check for DED overlaps took " + (l3 - l) + " ms.");
        }
        return bl;
    }

    protected void saveKeys() {
        try {
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Saving keys to: " + this.fileName + ", key count: " + this.keyHash.size());
            }
            this.keyFile.reset();
            HashMap<K, IndexedDiskElementDescriptor> hashMap = new HashMap<K, IndexedDiskElementDescriptor>();
            hashMap.putAll(this.keyHash);
            if (hashMap.size() > 0) {
                this.keyFile.writeObject(hashMap, 0L);
            }
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Finished saving keys.");
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Problem storing keys.", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdate(ICacheElement<K, V> iCacheElement) {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "No longer alive; aborting put of key = " + iCacheElement.getKey());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Storing element on disk, key: " + iCacheElement.getKey());
        }
        IndexedDiskElementDescriptor indexedDiskElementDescriptor = null;
        IndexedDiskElementDescriptor indexedDiskElementDescriptor2 = null;
        try {
            byte[] byArray = this.getElementSerializer().serialize(iCacheElement);
            this.storageLock.writeLock().lock();
            try {
                indexedDiskElementDescriptor2 = this.keyHash.get(iCacheElement.getKey());
                if (indexedDiskElementDescriptor2 != null && byArray.length <= indexedDiskElementDescriptor2.len) {
                    indexedDiskElementDescriptor = indexedDiskElementDescriptor2;
                    indexedDiskElementDescriptor.len = byArray.length;
                } else {
                    IndexedDiskElementDescriptor indexedDiskElementDescriptor3;
                    indexedDiskElementDescriptor = new IndexedDiskElementDescriptor(this.dataFile.length(), byArray.length);
                    if (this.doRecycle && (indexedDiskElementDescriptor3 = this.recycle.ceiling(indexedDiskElementDescriptor)) != null) {
                        this.recycle.remove(indexedDiskElementDescriptor3);
                        indexedDiskElementDescriptor = indexedDiskElementDescriptor3;
                        indexedDiskElementDescriptor.len = byArray.length;
                        ++this.recycleCnt;
                        this.adjustBytesFree(indexedDiskElementDescriptor, false);
                        if (log.isDebugEnabled()) {
                            log.debug(this.logCacheName + "using recycled ded " + indexedDiskElementDescriptor.pos + " rep.len = " + indexedDiskElementDescriptor3.len + " ded.len = " + indexedDiskElementDescriptor.len);
                        }
                    }
                    this.keyHash.put(iCacheElement.getKey(), indexedDiskElementDescriptor);
                    if (this.queueInput) {
                        this.queuedPutList.add(indexedDiskElementDescriptor);
                        if (log.isDebugEnabled()) {
                            log.debug(this.logCacheName + "added to queued put list." + this.queuedPutList.size());
                        }
                    }
                    if (indexedDiskElementDescriptor2 != null) {
                        this.addToRecycleBin(indexedDiskElementDescriptor2);
                    }
                }
                this.dataFile.write(indexedDiskElementDescriptor, byArray);
            }
            finally {
                this.storageLock.writeLock().unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Put to file: " + this.fileName + ", key: " + iCacheElement.getKey() + ", position: " + indexedDiskElementDescriptor.pos + ", size: " + indexedDiskElementDescriptor.len);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Caught ConcurrentModificationException." + concurrentModificationException);
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure updating element, key: " + iCacheElement.getKey() + " old: " + indexedDiskElementDescriptor2, iOException);
        }
    }

    @Override
    protected ICacheElement<K, V> processGet(K k) {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "No longer alive so returning null for key = " + k);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Trying to get from disk: " + k);
        }
        ICacheElement<K, V> iCacheElement = null;
        try {
            this.storageLock.readLock().lock();
            try {
                iCacheElement = this.readElement(k);
            }
            finally {
                this.storageLock.readLock().unlock();
            }
            if (iCacheElement != null) {
                this.hitCount.incrementAndGet();
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure getting from disk, key = " + k, iOException);
            this.reset();
        }
        return iCacheElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> processGetMatching(String string) {
        HashMap hashMap = new HashMap();
        HashSet<K> hashSet = null;
        this.storageLock.readLock().lock();
        try {
            hashSet = new HashSet<K>(this.keyHash.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        Set set = this.getKeyMatcher().getMatchingKeysFromArray(string, hashSet);
        for (Object k : set) {
            ICacheElement iCacheElement = this.processGet(k);
            if (iCacheElement == null) continue;
            hashMap.put(k, iCacheElement);
        }
        return hashMap;
    }

    private ICacheElement<K, V> readElement(K k) throws IOException {
        ICacheElement iCacheElement = null;
        IndexedDiskElementDescriptor indexedDiskElementDescriptor = this.keyHash.get(k);
        if (indexedDiskElementDescriptor != null) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Found on disk, key: " + k);
            }
            try {
                ICacheElement iCacheElement2;
                iCacheElement = iCacheElement2 = (ICacheElement)this.dataFile.readObject(indexedDiskElementDescriptor);
            }
            catch (IOException iOException) {
                log.error(this.logCacheName + "IO Exception, Problem reading object from file", iOException);
                throw iOException;
            }
            catch (Exception exception) {
                log.error(this.logCacheName + "Exception, Problem reading object from file", exception);
                throw new IOException(this.logCacheName + "Problem reading object from disk. " + exception.getMessage());
            }
        }
        return iCacheElement;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> hashSet = new HashSet<K>();
        this.storageLock.readLock().lock();
        try {
            hashSet.addAll(this.keyHash.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processRemove(K k) {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "No longer alive so returning false for key = " + k);
            return false;
        }
        if (k == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.storageLock.writeLock().lock();
            bl2 = k instanceof String && k.toString().endsWith(":") ? this.performPartialKeyRemoval((String)k) : (k instanceof GroupAttrName && ((GroupAttrName)k).attrName == null ? this.performGroupRemoval(((GroupAttrName)k).groupId) : this.performSingleKeyRemoval(k));
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (bl) {
            this.reset();
        }
        if (bl2) {
            this.doOptimizeRealTime();
        }
        return bl2;
    }

    private boolean performPartialKeyRemoval(String string) {
        boolean bl = false;
        LinkedList<K> linkedList = new LinkedList<K>();
        for (Object object : this.keyHash.keySet()) {
            if (!(object instanceof String) || !object.toString().startsWith(string)) continue;
            linkedList.add(object);
        }
        for (Object object : linkedList) {
            this.performSingleKeyRemoval(object);
            bl = true;
        }
        return bl;
    }

    private boolean performGroupRemoval(GroupId groupId) {
        boolean bl = false;
        LinkedList<K> linkedList = new LinkedList<K>();
        for (Object object : this.keyHash.keySet()) {
            if (!(object instanceof GroupAttrName) || !((GroupAttrName)object).groupId.equals(groupId)) continue;
            linkedList.add(object);
        }
        for (Object object : linkedList) {
            this.performSingleKeyRemoval(object);
            bl = true;
        }
        return bl;
    }

    private boolean performSingleKeyRemoval(K k) {
        IndexedDiskElementDescriptor indexedDiskElementDescriptor = this.keyHash.remove(k);
        boolean bl = indexedDiskElementDescriptor != null;
        this.addToRecycleBin(indexedDiskElementDescriptor);
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Disk removal: Removed from key hash, key [" + k + "] removed = " + bl);
        }
        return bl;
    }

    @Override
    public void processRemoveAll() {
        ICacheEvent<String> iCacheEvent = this.createICacheEvent(this.getCacheName(), "all", "removeAll");
        try {
            this.reset();
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        if (log.isWarnEnabled()) {
            log.warn(this.logCacheName + "Resetting cache");
        }
        try {
            File file;
            File file2;
            boolean bl;
            this.storageLock.writeLock().lock();
            if (this.dataFile != null) {
                this.dataFile.close();
            }
            if (!(bl = (file2 = new File(this.rafDir, this.fileName + ".data")).delete()) && log.isDebugEnabled()) {
                log.debug("Could not delete file " + file2);
            }
            if (this.keyFile != null) {
                this.keyFile.close();
            }
            if (!(bl = (file = new File(this.rafDir, this.fileName + ".key")).delete()) && log.isDebugEnabled()) {
                log.debug("Could not delete file " + file);
            }
            this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"), this.getElementSerializer());
            this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"), this.getElementSerializer());
            this.initializeRecycleBin();
            this.initializeKeyMap();
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure reseting state", iOException);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    private void initializeRecycleBin() {
        this.recycle = new ConcurrentSkipListSet();
    }

    private void initializeKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = this.diskLimitType == IDiskCacheAttributes.DiskLimitType.COUNT ? new LRUMapCountLimited(this.maxKeySize) : new LRUMapSizeLimited(this.maxKeySize);
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Set maxKeySize to: '" + this.maxKeySize + "'");
            }
        } else {
            this.keyHash = new HashMap<K, IndexedDiskElementDescriptor>();
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Set maxKeySize to unlimited'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDispose() {
        ICacheEvent<String> iCacheEvent = this.createICacheEvent(this.getCacheName(), "none", "dispose");
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IndexedDiskCache.this.disposeInternal();
                }
            };
            Thread thread = new Thread(runnable, "IndexedDiskCache-DisposalThread");
            thread.start();
            try {
                thread.join(60000L);
            }
            catch (InterruptedException interruptedException) {
                log.error(this.logCacheName + "Interrupted while waiting for disposal thread to finish.", interruptedException);
            }
        }
        finally {
            this.logICacheEvent(iCacheEvent);
        }
    }

    protected void disposeInternal() {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "Not alive and dispose was called, filename: " + this.fileName);
            return;
        }
        this.setAlive(false);
        Thread thread = this.currentOptimizationThread;
        if (this.isRealTimeOptimizationEnabled && thread != null) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "In dispose, optimization already in progress; waiting for completion.");
            }
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                log.error(this.logCacheName + "Unable to join current optimization thread.", interruptedException);
            }
        } else if (this.isShutdownOptimizationEnabled && this.getBytesFree() > 0L) {
            this.optimizeFile();
        }
        this.saveKeys();
        try {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Closing files, base filename: " + this.fileName);
            }
            this.dataFile.close();
            this.dataFile = null;
            this.keyFile.close();
            this.keyFile = null;
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure closing files in dispose, filename: " + this.fileName, iOException);
        }
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Shutdown complete.");
        }
    }

    protected void addToRecycleBin(IndexedDiskElementDescriptor indexedDiskElementDescriptor) {
        if (indexedDiskElementDescriptor != null) {
            this.storageLock.readLock().lock();
            try {
                this.adjustBytesFree(indexedDiskElementDescriptor, true);
                if (this.doRecycle) {
                    this.recycle.add(indexedDiskElementDescriptor);
                    if (log.isDebugEnabled()) {
                        log.debug(this.logCacheName + "recycled ded" + indexedDiskElementDescriptor);
                    }
                }
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }
    }

    protected void doOptimizeRealTime() {
        if (this.isRealTimeOptimizationEnabled && !this.isOptimizing && this.removeCount++ >= this.cattr.getOptimizeAtRemoveCount()) {
            this.isOptimizing = true;
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Optimizing file. removeCount [" + this.removeCount + "] OptimizeAtRemoveCount [" + this.cattr.getOptimizeAtRemoveCount() + "]");
            }
            if (this.currentOptimizationThread == null) {
                this.storageLock.writeLock().lock();
                try {
                    if (this.currentOptimizationThread == null) {
                        this.currentOptimizationThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                IndexedDiskCache.this.optimizeFile();
                                IndexedDiskCache.this.currentOptimizationThread = null;
                            }
                        }, "IndexedDiskCache-OptimizationThread");
                    }
                }
                finally {
                    this.storageLock.writeLock().unlock();
                }
                if (this.currentOptimizationThread != null) {
                    this.currentOptimizationThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimizeFile() {
        ElapsedTimer elapsedTimer = new ElapsedTimer();
        ++this.timesOptimized;
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Beginning Optimization #" + this.timesOptimized);
        }
        IndexedDiskElementDescriptor[] indexedDiskElementDescriptorArray = null;
        this.storageLock.writeLock().lock();
        try {
            this.queueInput = true;
            this.doRecycle = false;
            indexedDiskElementDescriptorArray = this.createPositionSortedDescriptorList();
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        long l = this.defragFile(indexedDiskElementDescriptorArray, 0L);
        this.storageLock.writeLock().lock();
        try {
            try {
                if (!this.queuedPutList.isEmpty()) {
                    indexedDiskElementDescriptorArray = this.queuedPutList.toArray(new IndexedDiskElementDescriptor[this.queuedPutList.size()]);
                    l = this.defragFile(indexedDiskElementDescriptorArray, l);
                }
                this.dataFile.truncate(l);
            }
            catch (IOException iOException) {
                log.error(this.logCacheName + "Error optimizing queued puts.", iOException);
            }
            this.removeCount = 0;
            this.resetBytesFree();
            this.initializeRecycleBin();
            this.queuedPutList.clear();
            this.queueInput = false;
            this.doRecycle = true;
            this.isOptimizing = false;
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Finished #" + this.timesOptimized + " Optimization took " + elapsedTimer.getElapsedTimeString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long defragFile(IndexedDiskElementDescriptor[] indexedDiskElementDescriptorArray, long l) {
        ElapsedTimer elapsedTimer = new ElapsedTimer();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        try {
            l2 = this.dataFile.length();
            l4 = l;
            for (int i = 0; i < indexedDiskElementDescriptorArray.length; ++i) {
                this.storageLock.writeLock().lock();
                try {
                    if (l4 != indexedDiskElementDescriptorArray[i].pos) {
                        this.dataFile.move(indexedDiskElementDescriptorArray[i], l4);
                    }
                    l4 = indexedDiskElementDescriptorArray[i].pos + 4L + (long)indexedDiskElementDescriptorArray[i].len;
                    continue;
                }
                finally {
                    this.storageLock.writeLock().unlock();
                }
            }
            l3 = this.dataFile.length();
            long l5 = l4;
            return l5;
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Error occurred during defragmentation.", iOException);
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Defragmentation took " + elapsedTimer.getElapsedTimeString() + ". File Size (before=" + l2 + ") (after=" + l3 + ") (truncating to " + l4 + ")");
            }
        }
        return 0L;
    }

    private IndexedDiskElementDescriptor[] createPositionSortedDescriptorList() {
        IndexedDiskElementDescriptor[] indexedDiskElementDescriptorArray = new IndexedDiskElementDescriptor[this.keyHash.size()];
        Iterator<Map.Entry<K, IndexedDiskElementDescriptor>> iterator = this.keyHash.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<K, IndexedDiskElementDescriptor> entry = iterator.next();
            indexedDiskElementDescriptorArray[n] = entry.getValue();
            ++n;
        }
        Arrays.sort(indexedDiskElementDescriptorArray, new PositionComparator());
        return indexedDiskElementDescriptorArray;
    }

    @Override
    public int getSize() {
        return this.keyHash.size();
    }

    protected int getRecyleBinSize() {
        return this.recycle.size();
    }

    protected int getRecyleCount() {
        return this.recycleCnt;
    }

    protected long getBytesFree() {
        return this.bytesFree.get();
    }

    private void resetBytesFree() {
        this.bytesFree.set(0L);
    }

    private void adjustBytesFree(IndexedDiskElementDescriptor indexedDiskElementDescriptor, boolean bl) {
        if (indexedDiskElementDescriptor != null) {
            int n = indexedDiskElementDescriptor.len + 4;
            if (bl) {
                this.bytesFree.addAndGet(n);
            } else {
                this.bytesFree.addAndGet(-n);
            }
        }
    }

    protected long getDataFileSize() throws IOException {
        long l = 0L;
        this.storageLock.readLock().lock();
        try {
            if (this.dataFile != null) {
                l = this.dataFile.length();
            }
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return l;
    }

    public void dump() {
        this.dump(true);
    }

    public void dump(boolean bl) {
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "[dump] Number of keys: " + this.keyHash.size());
            for (Map.Entry<K, IndexedDiskElementDescriptor> entry : this.keyHash.entrySet()) {
                K k = entry.getKey();
                IndexedDiskElementDescriptor indexedDiskElementDescriptor = entry.getValue();
                log.debug(this.logCacheName + "[dump] Disk element, key: " + k + ", pos: " + indexedDiskElementDescriptor.pos + ", ded.len" + indexedDiskElementDescriptor.len + (bl ? ", val: " + this.get(k) : ""));
            }
        }
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cattr;
    }

    @Override
    public synchronized IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Indexed Disk Cache");
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Boolean>("Is Alive", this.isAlive()));
        arrayList.add(new StatElement<Integer>("Key Map Size", this.keyHash != null ? this.keyHash.size() : -1));
        try {
            arrayList.add(new StatElement<Long>("Data File Length", this.dataFile != null ? this.dataFile.length() : -1L));
        }
        catch (IOException iOException) {
            log.error(iOException);
        }
        arrayList.add(new StatElement<Integer>("Max Key Size", this.maxKeySize));
        arrayList.add(new StatElement<AtomicInteger>("Hit Count", this.hitCount));
        arrayList.add(new StatElement<AtomicLong>("Bytes Free", this.bytesFree));
        arrayList.add(new StatElement<Integer>("Optimize Operation Count", this.removeCount));
        arrayList.add(new StatElement<Integer>("Times Optimized", this.timesOptimized));
        arrayList.add(new StatElement<Integer>("Recycle Count", this.recycleCnt));
        arrayList.add(new StatElement<Integer>("Recycle Bin Size", this.recycle.size()));
        arrayList.add(new StatElement<Integer>("Startup Size", this.startupSize));
        IStats iStats = super.getStatistics();
        arrayList.addAll(iStats.getStatElements());
        stats.setStatElements(arrayList);
        return stats;
    }

    protected int getTimesOptimized() {
        return this.timesOptimized;
    }

    @Override
    protected String getDiskLocation() {
        return this.dataFile.getFilePath();
    }

    public class LRUMapCountLimited
    extends LRUMap<K, IndexedDiskElementDescriptor> {
        public LRUMapCountLimited(int n) {
            super(n);
        }

        @Override
        protected void processRemovedLRU(K k, IndexedDiskElementDescriptor indexedDiskElementDescriptor) {
            IndexedDiskCache.this.addToRecycleBin(indexedDiskElementDescriptor);
            if (log.isDebugEnabled()) {
                log.debug(IndexedDiskCache.this.logCacheName + "Removing key: [" + k + "] from key store.");
                log.debug(IndexedDiskCache.this.logCacheName + "Key store size: [" + this.size() + "].");
            }
            IndexedDiskCache.this.doOptimizeRealTime();
        }
    }

    public class LRUMapSizeLimited
    extends AbstractLRUMap<K, IndexedDiskElementDescriptor> {
        public static final String TAG = "orig";
        private AtomicInteger contentSize;
        private int maxSize;

        public LRUMapSizeLimited() {
            this(-1);
        }

        public LRUMapSizeLimited(int n) {
            this.maxSize = n;
            this.contentSize = new AtomicInteger(0);
        }

        private void subLengthFromCacheSize(IndexedDiskElementDescriptor indexedDiskElementDescriptor) {
            this.contentSize.addAndGet((indexedDiskElementDescriptor.len + 4) / -1024 - 1);
        }

        private void addLengthToCacheSize(IndexedDiskElementDescriptor indexedDiskElementDescriptor) {
            this.contentSize.addAndGet((indexedDiskElementDescriptor.len + 4) / 1024 + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexedDiskElementDescriptor put(K k, IndexedDiskElementDescriptor indexedDiskElementDescriptor) {
            IndexedDiskElementDescriptor indexedDiskElementDescriptor2 = null;
            try {
                indexedDiskElementDescriptor2 = super.put(k, indexedDiskElementDescriptor);
            }
            finally {
                if (indexedDiskElementDescriptor != null) {
                    this.addLengthToCacheSize(indexedDiskElementDescriptor);
                }
                if (indexedDiskElementDescriptor2 != null) {
                    this.subLengthFromCacheSize(indexedDiskElementDescriptor2);
                }
            }
            return indexedDiskElementDescriptor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexedDiskElementDescriptor remove(Object object) {
            IndexedDiskElementDescriptor indexedDiskElementDescriptor = null;
            try {
                IndexedDiskElementDescriptor indexedDiskElementDescriptor2 = indexedDiskElementDescriptor = (IndexedDiskElementDescriptor)super.remove(object);
                return indexedDiskElementDescriptor2;
            }
            finally {
                if (indexedDiskElementDescriptor != null) {
                    this.subLengthFromCacheSize(indexedDiskElementDescriptor);
                }
            }
        }

        @Override
        protected void processRemovedLRU(K k, IndexedDiskElementDescriptor indexedDiskElementDescriptor) {
            if (indexedDiskElementDescriptor != null) {
                this.subLengthFromCacheSize(indexedDiskElementDescriptor);
            }
            IndexedDiskCache.this.addToRecycleBin(indexedDiskElementDescriptor);
            if (log.isDebugEnabled()) {
                log.debug(IndexedDiskCache.this.logCacheName + "Removing key: [" + k + "] from key store.");
                log.debug(IndexedDiskCache.this.logCacheName + "Key store size: [" + this.size() + "].");
            }
            IndexedDiskCache.this.doOptimizeRealTime();
        }

        @Override
        protected boolean shouldRemove() {
            return this.maxSize > 0 && this.contentSize.get() > this.maxSize && this.size() > 0;
        }
    }

    protected static final class PositionComparator
    implements Comparator<IndexedDiskElementDescriptor>,
    Serializable {
        private static final long serialVersionUID = -8387365338590814113L;

        protected PositionComparator() {
        }

        @Override
        public int compare(IndexedDiskElementDescriptor indexedDiskElementDescriptor, IndexedDiskElementDescriptor indexedDiskElementDescriptor2) {
            if (indexedDiskElementDescriptor.pos < indexedDiskElementDescriptor2.pos) {
                return -1;
            }
            if (indexedDiskElementDescriptor.pos == indexedDiskElementDescriptor2.pos) {
                return 0;
            }
            return 1;
        }
    }
}

