/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.GeoImageSessionImporter;
import org.openstreetmap.josm.io.session.GpxTracksSessionImporter;
import org.openstreetmap.josm.io.session.ImagerySessionImporter;
import org.openstreetmap.josm.io.session.MarkerSessionImporter;
import org.openstreetmap.josm.io.session.NoteSessionImporter;
import org.openstreetmap.josm.io.session.OsmDataSessionImporter;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SessionReader {
    private static final Map<String, Class<? extends SessionLayerImporter>> sessionLayerImporters = new HashMap<String, Class<? extends SessionLayerImporter>>();
    private URI sessionFileURI;
    private boolean zip;
    private ZipFile zipFile;
    private List<Layer> layers = new ArrayList<Layer>();
    private int active = -1;
    private final List<Runnable> postLoadTasks = new ArrayList<Runnable>();
    private ViewportData viewport;

    public static void registerSessionLayerImporter(String string, Class<? extends SessionLayerImporter> clazz) {
        sessionLayerImporters.put(string, clazz);
    }

    public static SessionLayerImporter getSessionLayerImporter(String string) {
        Class<? extends SessionLayerImporter> clazz = sessionLayerImporters.get(string);
        if (clazz == null) {
            return null;
        }
        SessionLayerImporter sessionLayerImporter = null;
        try {
            sessionLayerImporter = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        return sessionLayerImporter;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public Layer getActive() {
        return this.active >= 0 && this.active < this.layers.size() ? this.layers.get(this.layers.size() - 1 - this.active) : null;
    }

    public List<Runnable> getPostLoadTasks() {
        return this.postLoadTasks;
    }

    public ViewportData getViewport() {
        return this.viewport;
    }

    private static void error(String string) throws IllegalDataException {
        throw new IllegalDataException(string);
    }

    private void parseJos(Document document, ProgressMonitor progressMonitor) throws IllegalDataException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Object object5;
        Object object6;
        Element element;
        String string;
        Element element2 = document.getDocumentElement();
        if (!"josm-session".equals(element2.getTagName())) {
            SessionReader.error(I18n.tr("Unexpected root element ''{0}'' in session file", element2.getTagName()));
        }
        if (!"0.1".equals(string = element2.getAttribute("version"))) {
            SessionReader.error(I18n.tr("Version ''{0}'' of session file is not supported. Expected: 0.1", string));
        }
        if ((element = SessionReader.getElementByTagName(element2, "viewport")) != null) {
            object6 = null;
            object5 = SessionReader.getElementByTagName(element, "center");
            if (object5 != null && object5.hasAttribute("lat") && object5.hasAttribute("lon")) {
                try {
                    object4 = new LatLon(Double.parseDouble(object5.getAttribute("lat")), Double.parseDouble(object5.getAttribute("lon")));
                    object6 = Projections.project((LatLon)object4);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
            }
            if (object6 != null && (object4 = SessionReader.getElementByTagName(element, "scale")) != null && object4.hasAttribute("meter-per-pixel")) {
                try {
                    double d = Double.parseDouble(object4.getAttribute("meter-per-pixel"));
                    Projection projection = Main.getProjection();
                    double d2 = 0.01 * projection.getDefaultZoomInPPD();
                    serializable = projection.eastNorth2latlon(new EastNorth(((EastNorth)object6).east() - d2, ((EastNorth)object6).north()));
                    object3 = projection.eastNorth2latlon(new EastNorth(((EastNorth)object6).east() + d2, ((EastNorth)object6).north()));
                    double d3 = ((LatLon)serializable).greatCircleDistance((LatLon)object3) / d2 / 2.0;
                    double d4 = d / d3;
                    this.viewport = new ViewportData((EastNorth)object6, d4);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
            }
        }
        if ((object6 = SessionReader.getElementByTagName(element2, "layers")) == null) {
            return;
        }
        object5 = object6.getAttribute("active");
        try {
            this.active = object5 != null && !((String)object5).isEmpty() ? Integer.parseInt((String)object5) - 1 : -1;
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn("Unsupported value for 'active' layer attribute. Ignoring it. Error was: " + numberFormatException.getMessage());
            this.active = -1;
        }
        object4 = new MultiMap();
        HashMap<Serializable, Object> hashMap = new HashMap<Serializable, Object>();
        NodeList nodeList = object6.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"layer".equals((object2 = (Element)node).getTagName())) continue;
            if (!object2.hasAttribute("index")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''index'' for element ''layer''", new Object[0]));
            }
            serializable = null;
            try {
                serializable = Integer.valueOf(object2.getAttribute("index"));
            }
            catch (NumberFormatException numberFormatException) {
                Main.warn(numberFormatException);
            }
            if (serializable == null) {
                SessionReader.error(I18n.tr("unexpected format of attribute ''index'' for element ''layer''", new Object[0]));
            }
            if (hashMap.containsKey(serializable)) {
                SessionReader.error(I18n.tr("attribute ''index'' ({0}) for element ''layer'' must be unique", Integer.toString((Integer)serializable)));
            }
            hashMap.put(serializable, object2);
            ((MultiMap)object4).putVoid(serializable);
            object3 = object2.getAttribute("depends");
            if (object3 == null || ((String)object3).isEmpty()) continue;
            for (String string2 : ((String)object3).split(",")) {
                object = null;
                try {
                    object = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
                if (object == null) continue;
                ((MultiMap)object4).put(serializable, object);
            }
        }
        List list = Utils.topologicalSort(object4);
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        object2 = new HashMap();
        serializable = new HashMap();
        progressMonitor.setTicksCount(list.size());
        object3 = list.iterator();
        block16: while (object3.hasNext()) {
            Object object7;
            String string2;
            int n = (Integer)object3.next();
            Element element3 = (Element)hashMap.get(n);
            if (element3 == null) {
                SessionReader.error(I18n.tr("missing layer with index {0}", n));
                return;
            }
            if (!element3.hasAttribute("name")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''name'' for element ''layer''", new Object[0]));
                return;
            }
            String string3 = element3.getAttribute("name");
            serializable.put(n, string3);
            if (!element3.hasAttribute("type")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''type'' for element ''layer''", new Object[0]));
                return;
            }
            string2 = element3.getAttribute("type");
            object = SessionReader.getSessionLayerImporter(string2);
            if (object == null && !GraphicsEnvironment.isHeadless()) {
                object7 = new CancelOrContinueDialog();
                ((CancelOrContinueDialog)object7).show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer of type ''{0}'' because no suitable importer was found.", string2), 2, progressMonitor);
                if (!((CancelOrContinueDialog)object7).isCancel()) continue;
                progressMonitor.cancel();
                return;
            }
            if (object != null) {
                CancelOrContinueDialog cancelOrContinueDialog;
                Object object8;
                object2.put(n, object);
                object7 = new ArrayList();
                Object object9 = ((MultiMap)object4).get(n).iterator();
                while (object9.hasNext()) {
                    int n2 = (Integer)object9.next();
                    object8 = (SessionLayerImporter)object2.get(n2);
                    if (object8 == null) {
                        cancelOrContinueDialog = new CancelOrContinueDialog();
                        cancelOrContinueDialog.show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer {0} because it depends on layer {1} which has been skipped.", n, n2), 2, progressMonitor);
                        if (!cancelOrContinueDialog.isCancel()) continue block16;
                        progressMonitor.cancel();
                        return;
                    }
                    object7.add(new LayerDependency(n2, (Layer)treeMap.get(n2), (SessionLayerImporter)object8));
                }
                object9 = new ImportSupport(string3, n, (List<LayerDependency>)object7);
                Layer layer = null;
                object8 = null;
                try {
                    layer = object.load(element3, (ImportSupport)object9, progressMonitor.createSubTaskMonitor(1, false));
                    if (layer == null) {
                        throw new IllegalStateException("Importer " + object + " returned null for " + object9);
                    }
                }
                catch (IOException | IllegalStateException | IllegalDataException exception) {
                    object8 = exception;
                }
                if (object8 != null) {
                    Main.error((Throwable)object8);
                    if (!GraphicsEnvironment.isHeadless()) {
                        cancelOrContinueDialog = new CancelOrContinueDialog();
                        cancelOrContinueDialog.show(I18n.tr("Error loading layer", new Object[0]), I18n.tr("<html>Could not load layer {0} ''{1}''.<br>Error is:<br>{2}</html>", n, string3, ((Throwable)object8).getMessage()), 0, progressMonitor);
                        if (!cancelOrContinueDialog.isCancel()) continue;
                        progressMonitor.cancel();
                        return;
                    }
                }
                treeMap.put(n, layer);
            }
            progressMonitor.worked(1);
        }
        this.layers = new ArrayList<Layer>();
        for (Map.Entry entry : treeMap.entrySet()) {
            Layer layer = (Layer)entry.getValue();
            if (layer == null) continue;
            Element element4 = (Element)hashMap.get(entry.getKey());
            if (element4.hasAttribute("visible")) {
                layer.setVisible(Boolean.parseBoolean(element4.getAttribute("visible")));
            }
            if (element4.hasAttribute("opacity")) {
                try {
                    double d = Double.parseDouble(element4.getAttribute("opacity"));
                    layer.setOpacity(d);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
            }
            layer.setName((String)serializable.get(entry.getKey()));
            this.layers.add(layer);
        }
    }

    public void loadSession(File file, boolean bl, ProgressMonitor progressMonitor) throws IllegalDataException, IOException {
        try (InputStream inputStream = this.createInputStream(file, bl);){
            this.loadSession(inputStream, file.toURI(), bl, progressMonitor != null ? progressMonitor : NullProgressMonitor.INSTANCE);
        }
    }

    private InputStream createInputStream(File file, boolean bl) throws IOException, IllegalDataException {
        if (bl) {
            try {
                this.zipFile = new ZipFile(file, StandardCharsets.UTF_8);
                return SessionReader.getZipInputStream(this.zipFile);
            }
            catch (ZipException zipException) {
                throw new IOException(zipException);
            }
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException);
        }
    }

    private static InputStream getZipInputStream(ZipFile zipFile) throws IOException, IllegalDataException {
        ZipEntry zipEntry = null;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (!Utils.hasExtension(zipEntry2.getName(), "jos")) continue;
            zipEntry = zipEntry2;
            break;
        }
        if (zipEntry == null) {
            SessionReader.error(I18n.tr("expected .jos file inside .joz archive", new Object[0]));
        }
        return zipFile.getInputStream(zipEntry);
    }

    private void loadSession(InputStream inputStream, URI uRI, boolean bl, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        this.sessionFileURI = uRI;
        this.zip = bl;
        try {
            this.parseJos(Utils.parseSafeDOM(inputStream), progressMonitor);
        }
        catch (SAXException sAXException) {
            throw new IllegalDataException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
    }

    private static Element getElementByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        return nodeList.getLength() > 0 ? (Element)nodeList.item(0) : null;
    }

    static {
        SessionReader.registerSessionLayerImporter("osm-data", OsmDataSessionImporter.class);
        SessionReader.registerSessionLayerImporter("imagery", ImagerySessionImporter.class);
        SessionReader.registerSessionLayerImporter("tracks", GpxTracksSessionImporter.class);
        SessionReader.registerSessionLayerImporter("geoimage", GeoImageSessionImporter.class);
        SessionReader.registerSessionLayerImporter("markers", MarkerSessionImporter.class);
        SessionReader.registerSessionLayerImporter("osm-notes", NoteSessionImporter.class);
    }

    private static class CancelOrContinueDialog {
        private boolean cancel;

        private CancelOrContinueDialog() {
        }

        public void show(String string, String string2, int n, ProgressMonitor progressMonitor) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, I18n.tr("Cancel", new Object[0]), I18n.tr("Skip layer and continue", new Object[0]));
                    extendedDialog.setButtonIcons("cancel", "dialogs/next");
                    extendedDialog.setIcon(n);
                    extendedDialog.setContent(string2);
                    extendedDialog.showDialog();
                    this.cancel = extendedDialog.getValue() != 2;
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }

        public boolean isCancel() {
            return this.cancel;
        }
    }

    public static class LayerDependency {
        private final Integer index;
        private final Layer layer;
        private final SessionLayerImporter importer;

        public LayerDependency(Integer n, Layer layer, SessionLayerImporter sessionLayerImporter) {
            this.index = n;
            this.layer = layer;
            this.importer = sessionLayerImporter;
        }

        public SessionLayerImporter getImporter() {
            return this.importer;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Layer getLayer() {
            return this.layer;
        }
    }

    public class ImportSupport {
        private final String layerName;
        private final int layerIndex;
        private final List<LayerDependency> layerDependencies;
        private String inZipPath;

        public ImportSupport(String string, int n, List<LayerDependency> list) {
            this.layerName = string;
            this.layerIndex = n;
            this.layerDependencies = list;
        }

        public void addPostLayersTask(Runnable runnable) {
            SessionReader.this.postLoadTasks.add(runnable);
        }

        public InputStream getInputStream(String string) throws IOException {
            ZipEntry zipEntry;
            File file = this.getFile(string);
            if (file != null) {
                try {
                    return new BufferedInputStream(Compression.getUncompressedFileInputStream(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getPath()), fileNotFoundException);
                }
            }
            if (this.inZipPath != null && (zipEntry = SessionReader.this.zipFile.getEntry(this.inZipPath)) != null) {
                return SessionReader.this.zipFile.getInputStream(zipEntry);
            }
            throw new IOException(I18n.tr("Unable to locate file  ''{0}''.", string));
        }

        public File getFile(String string) throws IOException {
            this.inZipPath = null;
            try {
                URI uRI = new URI(string);
                if ("file".equals(uRI.getScheme())) {
                    return new File(uRI);
                }
                if (uRI.getScheme() == null) {
                    File file = new File(string);
                    if (file.isAbsolute()) {
                        return file;
                    }
                    if (this.isZip()) {
                        if (uRI.getPath().startsWith("../")) {
                            String string2 = uRI.getPath().substring(3);
                            return new File(SessionReader.this.sessionFileURI.resolve(string2));
                        }
                        this.inZipPath = string;
                        return null;
                    }
                    return new File(SessionReader.this.sessionFileURI.resolve(uRI));
                }
                throw new IOException(I18n.tr("Unsupported scheme ''{0}'' in URI ''{1}''.", uRI.getScheme(), string));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException);
            }
        }

        public boolean isZip() {
            return SessionReader.this.zip;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public int getLayerIndex() {
            return this.layerIndex;
        }

        public List<LayerDependency> getLayerDependencies() {
            return this.layerDependencies;
        }

        public String toString() {
            return "ImportSupport [layerName=" + this.layerName + ", layerIndex=" + this.layerIndex + ", layerDependencies=" + this.layerDependencies + ", inZipPath=" + this.inZipPath + ']';
        }
    }
}

