/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.control.enums.ElementStyle;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.CursorOwn;
import com.baselet.element.PropertiesParser;
import com.baselet.element.UndoHistory;
import com.baselet.element.UndoInformation;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.facet.common.GroupFacet;
import com.baselet.element.facet.common.LayerFacet;
import com.baselet.element.interfaces.Component;
import com.baselet.element.interfaces.DrawHandlerInterface;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.interfaces.GridElementDeprecatedAddons;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.Stickable;
import com.baselet.element.sticking.StickableMap;
import com.baselet.element.sticking.Stickables;
import com.baselet.element.sticking.StickingPolygon;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NewGridElement
implements GridElement {
    private final Logger log = LoggerFactory.getLogger(NewGridElement.class);
    private DrawHandler drawer;
    private DrawHandler metaDrawer;
    private Component component;
    private DrawHandlerInterface handler;
    private List<String> panelAttributes;
    protected PropertiesParserState state;
    protected final UndoHistory undoStack = new UndoHistory();
    private boolean autoresizePossiblyInProgress = false;

    public void init(Rectangle bounds, String panelAttributes, String additionalAttributes, Component component, DrawHandlerInterface handler) {
        this.component = component;
        this.drawer = component.getDrawHandler();
        this.metaDrawer = component.getMetaDrawHandler();
        this.setPanelAttributesHelper(panelAttributes);
        this.setRectangle(bounds);
        this.handler = handler;
        this.state = new PropertiesParserState(this.createSettings(), this.drawer);
        this.setAdditionalAttributes(additionalAttributes);
    }

    @Override
    public String getPanelAttributes() {
        return SharedUtils.listToString("\n", this.panelAttributes);
    }

    @Override
    public List<String> getPanelAttributesAsList() {
        return this.panelAttributes;
    }

    @Override
    public void setPanelAttributes(String panelAttributes) {
        this.setPanelAttributesHelper(panelAttributes);
        this.updateModelFromText();
    }

    public void setPanelAttributesHelper(String panelAttributes) {
        this.panelAttributes = Arrays.asList(panelAttributes.split("\n", -1));
    }

    @Override
    public void updateModelFromText() {
        this.autoresizePossiblyInProgress = true;
        this.drawer.clearCache();
        this.drawer.resetStyle();
        try {
            PropertiesParser.parsePropertiesAndHandleFacets(this, this.state);
        }
        catch (Exception e) {
            this.log.info("Cannot parse Properties Text", (Throwable)e);
            this.drawer.resetStyle();
            String localizedMessage = e.getLocalizedMessage();
            if (localizedMessage == null) {
                localizedMessage = e.toString();
            }
            this.drawError(this.drawer, localizedMessage);
        }
        this.autoresizePossiblyInProgress = false;
        this.component.afterModelUpdate();
    }

    protected void drawError(DrawHandler drawer, String errorText) {
        drawer.setEnableDrawing(true);
        drawer.setForegroundColor(ColorOwn.RED);
        drawer.setBackgroundColor(ColorOwn.RED.transparency(ColorOwn.Transparency.SELECTION_BACKGROUND));
        drawer.setLineWidth(0.2);
        drawer.drawRectangle(0.0, 0.0, this.getRealSize().width, this.getRealSize().height);
        this.resetAndDrawMetaDrawerContent(this.metaDrawer);
        String[] errorLines = errorText.split("\n");
        double y = (double)this.getRealSize().height * 0.5 - (double)errorLines.length * drawer.textHeightMaxWithSpace() / 2.0 + drawer.textHeightMax();
        int i = 0;
        while (i < errorLines.length) {
            drawer.print(errorLines[i], 3.0, y, AlignHorizontal.LEFT);
            ++i;
            y += drawer.textHeightMaxWithSpace();
        }
    }

    void resetMetaDrawerAndDrawCommonContent(PropertiesParserState state, boolean resetMetaDrawer) {
        this.drawCommonContent(state);
        if (resetMetaDrawer) {
            this.resetAndDrawMetaDrawerContent(this.metaDrawer);
        }
    }

    protected abstract void drawCommonContent(PropertiesParserState var1);

    protected void resetAndDrawMetaDrawerContent(DrawHandler drawer) {
        drawer.clearCache();
        drawer.setForegroundColor(ColorOwn.TRANSPARENT);
        drawer.setBackgroundColor(ColorOwn.SELECTION_BG);
        drawer.drawRectangle(0.0, 0.0, this.getRealSize().width, this.getRealSize().height);
        if (SharedConfig.getInstance().isDev_mode()) {
            drawer.setForegroundColor(ColorOwn.BLACK);
            drawer.setFontSize(10.5);
            drawer.print(this.getId().toString(), new PointDouble(this.getRealSize().width - 3, this.getRealSize().height - 2), AlignHorizontal.RIGHT);
        }
        drawer.resetColorSettings();
        if (SharedConfig.getInstance().isShow_stickingpolygon()) {
            this.drawStickingPolygon(drawer);
        }
    }

    @Override
    public void setProperty(String key, Object newValue) {
        StringBuilder sb = new StringBuilder("");
        for (String line : this.getPanelAttributesAsList()) {
            if (line.startsWith(key)) continue;
            sb.append(line).append("\n");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        if (newValue != null) {
            sb.append("\n").append(key).append("=").append(newValue.toString());
        }
        this.setPanelAttributes(sb.toString());
    }

    @Override
    public String getSetting(String key) {
        for (String line : this.getPanelAttributesAsList()) {
            String[] split;
            if (!line.startsWith(String.valueOf(key) + "=") || (split = line.split("=", 2)).length <= 1) continue;
            return split[1];
        }
        return null;
    }

    @Override
    public String getAdditionalAttributes() {
        return "";
    }

    @Override
    public void setAdditionalAttributes(String additionalAttributes) {
    }

    @Override
    public boolean isInRange(Rectangle rect1) {
        return rect1.contains(this.getRectangle());
    }

    @Override
    public Set<Direction> getResizeArea(int x, int y) {
        HashSet<Direction> returnSet = new HashSet<Direction>();
        if (this.state.getElementStyle() == ElementStyle.NORESIZE || this.state.getElementStyle() == ElementStyle.AUTORESIZE) {
            return returnSet;
        }
        if (x <= 5 && x >= 0) {
            returnSet.add(Direction.LEFT);
        } else if (x <= this.getRectangle().width && x >= this.getRectangle().width - 5) {
            returnSet.add(Direction.RIGHT);
        }
        if (y <= 5 && y >= 0) {
            returnSet.add(Direction.UP);
        } else if (y <= this.getRectangle().height && y >= this.getRectangle().height - 5) {
            returnSet.add(Direction.DOWN);
        }
        return returnSet;
    }

    @Override
    @Deprecated
    public final StickingPolygon generateStickingBorder(Rectangle rect) {
        return this.state.getStickingPolygonGenerator().generateStickingBorder(rect);
    }

    @Override
    public final StickingPolygon generateStickingBorder() {
        return this.generateStickingBorder(this.getRealRectangle());
    }

    private final void drawStickingPolygon(DrawHandler drawer) {
        Rectangle rect = new Rectangle(0, 0, this.getRealSize().width, this.getRealSize().height);
        StickingPolygon poly = this.generateStickingBorder(rect);
        drawer.setLineType(LineType.DASHED);
        drawer.setForegroundColor(ColorOwn.STICKING_POLYGON);
        Vector<StickingPolygon.StickLine> lines = poly.getStickLines();
        drawer.drawLines(lines.toArray(new Line[lines.size()]));
        drawer.setLineType(LineType.SOLID);
        drawer.resetColorSettings();
    }

    @Override
    public void setRectangle(Rectangle bounds) {
        this.component.setBoundsRect(bounds);
    }

    @Override
    public void setLocationDifference(int diffx, int diffy) {
        this.setLocation(this.getRectangle().x + diffx, this.getRectangle().y + diffy);
    }

    @Override
    public void setLocation(int x, int y) {
        Rectangle rect = this.getRectangle();
        rect.setLocation(x, y);
        this.component.setBoundsRect(rect);
    }

    @Override
    public void setSize(int width, int height) {
        if (width != this.getRectangle().width || height != this.getRectangle().height) {
            Rectangle rect = this.getRectangle();
            rect.setSize(width, height);
            this.setRectangle(rect);
            if (!this.autoresizePossiblyInProgress) {
                this.updateModelFromText();
            }
        }
    }

    @Override
    public Rectangle getRectangle() {
        return this.component.getBoundsRect();
    }

    @Override
    public void repaint() {
        this.component.repaintComponent();
    }

    @Override
    public Dimension getRealSize() {
        return new Dimension(this.zoom(this.getRectangle().width), this.zoom(this.getRectangle().height));
    }

    public Rectangle getRealRectangle() {
        return new Rectangle(this.zoom(this.getRectangle().x), this.zoom(this.getRectangle().y), this.zoom(this.getRectangle().width), this.zoom(this.getRectangle().height));
    }

    private int zoom(int val) {
        return val * 10 / this.getGridSize();
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    protected abstract Settings createSettings();

    @Override
    public List<AutocompletionText> getAutocompletionList() {
        ArrayList<AutocompletionText> returnList = new ArrayList<AutocompletionText>();
        this.addAutocompletionTexts(returnList, this.state.getSettings().getFacetsForFirstRun());
        this.addAutocompletionTexts(returnList, this.state.getSettings().getFacetsForSecondRun());
        return returnList;
    }

    private void addAutocompletionTexts(List<AutocompletionText> returnList, List<? extends Facet> facets) {
        for (Facet facet : facets) {
            for (AutocompletionText t : facet.getAutocompletionStrings()) {
                returnList.add(t);
            }
        }
    }

    @Override
    public Integer getLayer() {
        return this.state.getFacetResponse(LayerFacet.class, LayerFacet.DEFAULT_VALUE);
    }

    @Override
    public Integer getGroup() {
        return this.state.getFacetResponse(GroupFacet.class, null);
    }

    public void handleAutoresize(DimensionDouble necessaryElementDimension, AlignHorizontal alignHorizontal) {
        Dimension realSize = this.getRealSize();
        double diffw = necessaryElementDimension.getWidth() - (double)realSize.width;
        double diffh = necessaryElementDimension.getHeight() - (double)realSize.height;
        int diffwInt = SharedUtils.realignTo(false, this.unzoom(diffw), true, this.getGridSize());
        int diffhInt = SharedUtils.realignTo(false, this.unzoom(diffh), true, this.getGridSize());
        List<Direction> directions = null;
        if (alignHorizontal == AlignHorizontal.LEFT) {
            directions = Arrays.asList(Direction.RIGHT, Direction.DOWN);
        } else if (alignHorizontal == AlignHorizontal.RIGHT) {
            diffwInt = -diffwInt;
            directions = Arrays.asList(Direction.LEFT, Direction.DOWN);
        } else if (alignHorizontal == AlignHorizontal.CENTER) {
            diffwInt = SharedUtils.realignTo(false, (double)diffwInt / 2.0, true, this.getGridSize()) * 2;
            directions = Arrays.asList(Direction.RIGHT, Direction.LEFT, Direction.DOWN);
        }
        this.drag(directions, diffwInt, diffhInt, new Point(0, 0), false, true, this.handler.getStickableMap(), false);
    }

    private double unzoom(double diffw) {
        return diffw / 10.0 * (double)this.getGridSize();
    }

    @Override
    public void setRectangleDifference(int diffx, int diffy, int diffw, int diffh, boolean firstDrag, StickableMap stickables, boolean undoable) {
        Rectangle oldRect = this.getRectangle();
        StickingPolygon stickingPolygonBeforeLocationChange = this.generateStickingBorder();
        String oldAddAttr = this.getAdditionalAttributes();
        this.setRectangle(new Rectangle(oldRect.x + diffx, oldRect.y + diffy, oldRect.getWidth() + diffw, oldRect.getHeight() + diffh));
        this.moveStickables(stickables, undoable, oldRect, stickingPolygonBeforeLocationChange, oldAddAttr);
    }

    @Override
    public void drag(Collection<Direction> resizeDirection, int diffX, int diffY, Point mousePosBeforeDrag, boolean isShiftKeyDown, boolean firstDrag, StickableMap stickables, boolean undoable) {
        Rectangle oldRect = this.getRectangle();
        StickingPolygon stickingPolygonBeforeLocationChange = this.generateStickingBorder();
        String oldAddAttr = this.getAdditionalAttributes();
        if (resizeDirection.isEmpty()) {
            this.setLocationDifference(diffX, diffY);
        } else {
            int newHeight;
            Rectangle rect = this.getRectangle();
            if (isShiftKeyDown && this.diagonalResize(resizeDirection)) {
                boolean mouseUp;
                boolean mouseToRight = diffX > 0 && diffX > diffY;
                boolean mouseDown = diffY > 0 && diffY > diffX;
                boolean mouseLeft = diffX < 0 && diffX < diffY;
                boolean bl = mouseUp = diffY < 0 && diffY < diffX;
                if (mouseToRight || mouseLeft) {
                    diffY = diffX;
                }
                if (mouseDown || mouseUp) {
                    diffX = diffY;
                }
            }
            if (resizeDirection.contains((Object)Direction.LEFT) && resizeDirection.contains((Object)Direction.RIGHT)) {
                rect.setX(rect.getX() - diffX / 2);
                rect.setWidth(Math.max(rect.getWidth() + diffX, this.minSize()));
            } else if (resizeDirection.contains((Object)Direction.LEFT)) {
                int newWidth = rect.getWidth() - diffX;
                if (newWidth >= this.minSize()) {
                    rect.setX(rect.getX() + diffX);
                    rect.setWidth(newWidth);
                }
            } else if (resizeDirection.contains((Object)Direction.RIGHT)) {
                rect.setWidth(Math.max(rect.getWidth() + diffX, this.minSize()));
            }
            if (resizeDirection.contains((Object)Direction.UP) && (newHeight = rect.getHeight() - diffY) >= this.minSize()) {
                rect.setY(rect.getY() + diffY);
                rect.setHeight(newHeight);
            }
            if (resizeDirection.contains((Object)Direction.DOWN)) {
                rect.setHeight(Math.max(rect.getHeight() + diffY, this.minSize()));
            }
            this.setRectangle(rect);
            if (!this.autoresizePossiblyInProgress) {
                this.updateModelFromText();
            }
        }
        this.moveStickables(stickables, undoable, oldRect, stickingPolygonBeforeLocationChange, oldAddAttr);
    }

    private void moveStickables(StickableMap stickables, boolean undoable, Rectangle oldRect, StickingPolygon stickingPolygonBeforeLocationChange, String oldAddAttr) {
        Map<Stickable, List<PointChange>> stickableChanges = Stickables.moveStickPointsBasedOnPolygonChanges(stickingPolygonBeforeLocationChange, this.generateStickingBorder(), stickables, this.getGridSize());
        if (undoable) {
            this.undoStack.add(new UndoInformation(this.getRectangle(), oldRect, stickableChanges, this.getGridSize(), oldAddAttr, this.getAdditionalAttributes()));
        }
    }

    @Override
    public void dragEnd() {
    }

    @Override
    public boolean isSelectableOn(Point point) {
        return this.getRectangle().contains(point);
    }

    private boolean diagonalResize(Collection<Direction> resizeDirection) {
        return resizeDirection.contains((Object)Direction.UP) && resizeDirection.contains((Object)Direction.RIGHT) || resizeDirection.contains((Object)Direction.UP) && resizeDirection.contains((Object)Direction.LEFT) || resizeDirection.contains((Object)Direction.DOWN) && resizeDirection.contains((Object)Direction.LEFT) || resizeDirection.contains((Object)Direction.DOWN) && resizeDirection.contains((Object)Direction.RIGHT);
    }

    protected DrawHandlerInterface getHandler() {
        return this.handler;
    }

    public int getGridSize() {
        return this.getHandler().getGridSize();
    }

    private int minSize() {
        return this.handler.getGridSize() * 2;
    }

    @Override
    public void undoDrag() {
        this.execUndoInformation(true);
    }

    private void execUndoInformation(boolean undo) {
        UndoInformation undoInfo = this.undoStack.get(undo);
        if (undoInfo != null) {
            this.setRectangle(this.getRectangle().add(undoInfo.getDiffRectangle(this.getGridSize(), undo)));
            Stickables.applyChanges(undoInfo.getStickableMoves(undo), null);
            this.setAdditionalAttributes(undoInfo.getAdditionalAttributes(undo));
        }
    }

    @Override
    public void redoDrag() {
        this.execUndoInformation(false);
    }

    @Override
    public void mergeUndoDrag() {
        UndoInformation undoInfoA = this.undoStack.remove();
        UndoInformation undoInfoB = this.undoStack.remove();
        this.undoStack.add(undoInfoA.merge(undoInfoB));
    }

    @Override
    public GridElementDeprecatedAddons getDeprecatedAddons() {
        return GridElementDeprecatedAddons.NONE;
    }

    @Override
    public CursorOwn getCursor(Point point, Set<Direction> resizeDirections) {
        return NewGridElement.getCursorStatic(this, point, resizeDirections);
    }

    public static CursorOwn getCursorStatic(GridElement e, Point point, Set<Direction> resizeDirections) {
        if (!e.isSelectableOn(point)) {
            return CursorOwn.DEFAULT;
        }
        if (resizeDirections.isEmpty()) {
            return CursorOwn.HAND;
        }
        if (resizeDirections.contains((Object)Direction.UP) && resizeDirections.contains((Object)Direction.RIGHT)) {
            return CursorOwn.NE;
        }
        if (resizeDirections.contains((Object)Direction.UP) && resizeDirections.contains((Object)Direction.LEFT)) {
            return CursorOwn.NW;
        }
        if (resizeDirections.contains((Object)Direction.DOWN) && resizeDirections.contains((Object)Direction.LEFT)) {
            return CursorOwn.SW;
        }
        if (resizeDirections.contains((Object)Direction.DOWN) && resizeDirections.contains((Object)Direction.RIGHT)) {
            return CursorOwn.SE;
        }
        if (resizeDirections.contains((Object)Direction.UP)) {
            return CursorOwn.N;
        }
        if (resizeDirections.contains((Object)Direction.RIGHT)) {
            return CursorOwn.E;
        }
        if (resizeDirections.contains((Object)Direction.DOWN)) {
            return CursorOwn.S;
        }
        if (resizeDirections.contains((Object)Direction.LEFT)) {
            return CursorOwn.W;
        }
        return CursorOwn.DEFAULT;
    }
}

