/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class InferenceSubstitution
extends Scope.Substitutor
implements Substitution {
    private LookupEnvironment environment;
    private InferenceVariable[] variables;
    private InvocationSite site;

    public InferenceSubstitution(LookupEnvironment lookupEnvironment, InferenceVariable[] inferenceVariableArray, InvocationSite invocationSite) {
        this.environment = lookupEnvironment;
        this.variables = inferenceVariableArray;
        this.site = invocationSite;
    }

    public InferenceSubstitution(InferenceContext18 inferenceContext18) {
        this(inferenceContext18.environment, inferenceContext18.inferenceVariables, inferenceContext18.currentInvocation);
    }

    @Override
    public TypeBinding substitute(Substitution substitution, TypeBinding typeBinding) {
        for (int i = 0; i < this.variables.length; ++i) {
            InferenceVariable inferenceVariable = this.variables[i];
            if (this.site != inferenceVariable.site || !TypeBinding.equalsEquals(this.getP(i), typeBinding)) continue;
            if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled && typeBinding.hasNullTypeAnnotations()) {
                return this.environment.createAnnotatedType(inferenceVariable.withoutToplevelNullAnnotation(), typeBinding.getTypeAnnotations());
            }
            return inferenceVariable;
        }
        return super.substitute(substitution, typeBinding);
    }

    protected TypeBinding getP(int n) {
        return this.variables[n].typeParameter;
    }

    @Override
    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        ReferenceBinding referenceBinding = typeVariableBinding.superclass;
        ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces;
        boolean bl = false;
        block0: for (int i = 0; i < this.variables.length; ++i) {
            InferenceVariable inferenceVariable = this.variables[i];
            TypeBinding typeBinding = this.getP(i);
            if (TypeBinding.equalsEquals(typeBinding, typeVariableBinding)) {
                return inferenceVariable;
            }
            if (TypeBinding.equalsEquals(typeBinding, referenceBinding)) {
                referenceBinding = inferenceVariable;
                bl = true;
                continue;
            }
            if (referenceBindingArray == null) continue;
            int n = referenceBindingArray.length;
            for (int j = 0; j < n; ++j) {
                if (!TypeBinding.equalsEquals(typeBinding, referenceBindingArray[j])) continue;
                if (referenceBindingArray == typeVariableBinding.superInterfaces) {
                    ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n];
                    System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n);
                }
                referenceBindingArray[j] = inferenceVariable;
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            typeVariableBinding = new TypeVariableBinding(typeVariableBinding.sourceName, typeVariableBinding.declaringElement, typeVariableBinding.rank, this.environment);
            typeVariableBinding.superclass = referenceBinding;
            typeVariableBinding.superInterfaces = referenceBindingArray;
            TypeBinding typeBinding = typeVariableBinding.firstBound = referenceBinding != null ? referenceBinding : referenceBindingArray[0];
            if (typeVariableBinding.firstBound.hasNullTypeAnnotations()) {
                typeVariableBinding.tagBits |= 0x100000L;
            }
        }
        return typeVariableBinding;
    }

    @Override
    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public boolean isRawSubstitution() {
        return false;
    }
}

