/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Objects;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public final class NodeRebalanceResult {
    private final Decision.Type nodeDecisionType;
    private final Decision canAllocate;
    private final boolean betterWeightThanCurrent;
    private final boolean deltaAboveThreshold;
    private final float currentWeight;
    private final float weightWithShardAdded;

    public NodeRebalanceResult(Decision.Type nodeDecisionType, Decision canAllocate, boolean betterWeightThanCurrent, boolean deltaAboveThreshold, float currentWeight, float weightWithShardAdded) {
        this.nodeDecisionType = Objects.requireNonNull(nodeDecisionType);
        this.canAllocate = Objects.requireNonNull(canAllocate);
        this.betterWeightThanCurrent = betterWeightThanCurrent;
        this.deltaAboveThreshold = deltaAboveThreshold;
        this.currentWeight = currentWeight;
        this.weightWithShardAdded = weightWithShardAdded;
    }

    public Decision.Type getNodeDecisionType() {
        return this.nodeDecisionType;
    }

    public Decision getCanAllocateDecision() {
        return this.canAllocate;
    }

    public boolean isBetterWeightThanCurrent() {
        return this.betterWeightThanCurrent;
    }

    public boolean isDeltaAboveThreshold() {
        return this.deltaAboveThreshold;
    }

    public float getCurrentWeight() {
        return this.currentWeight;
    }

    public float getWeightWithShardAdded() {
        return this.weightWithShardAdded;
    }
}

