/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.ToJavaNodeGen;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class JavaFunctionMessageResolution {
    JavaFunctionMessageResolution() {
    }

    static abstract class IsExecutableNode
    extends Node {
        IsExecutableNode() {
        }

        public Object access(JavaFunctionObject receiver) {
            return Boolean.TRUE;
        }
    }

    static abstract class ExecuteNode
    extends Node {
        @Node.Child
        private DoExecuteNode doExecute;

        ExecuteNode() {
        }

        public Object access(VirtualFrame frame, JavaFunctionObject function, Object[] args) {
            if (this.doExecute == null || args.length != this.doExecute.numberOfArguments()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.doExecute = this.insert(new DoExecuteNode(args.length));
            }
            return this.doExecute.execute(frame, function.method, function.obj, args);
        }

        static final class DoExecuteNode
        extends Node {
            @Node.Children
            private final ToJavaNode[] toJava;

            DoExecuteNode(int argsLength) {
                this.toJava = new ToJavaNode[argsLength];
                for (int i = 0; i < argsLength; ++i) {
                    this.toJava[i] = ToJavaNodeGen.create();
                }
            }

            int numberOfArguments() {
                return this.toJava.length;
            }

            @ExplodeLoop
            Object execute(VirtualFrame frame, Method method, Object obj, Object[] args) {
                Object[] convertedArguments = new Object[this.toJava.length];
                Class<?>[] types = DoExecuteNode.getTypes(method, this.toJava.length);
                for (int i = 0; i < this.toJava.length; ++i) {
                    convertedArguments[i] = this.toJava[i].execute(frame, args[i], types[i]);
                }
                return DoExecuteNode.doInvoke(method, obj, convertedArguments);
            }

            @CompilerDirectives.TruffleBoundary
            private static Class<?>[] getTypes(Method method, int expectedTypeCount) {
                Class<?>[] argumentTypes = method.getParameterTypes();
                if (method.isVarArgs()) {
                    Class[] types = new Class[expectedTypeCount];
                    for (int i = 0; i < expectedTypeCount; ++i) {
                        types[i] = i < argumentTypes.length - 1 ? argumentTypes[i] : argumentTypes[argumentTypes.length - 1].getComponentType();
                    }
                    return types;
                }
                assert (expectedTypeCount == argumentTypes.length);
                return argumentTypes;
            }

            @CompilerDirectives.TruffleBoundary
            private static Object doInvoke(Method method, Object obj, Object[] args) {
                try {
                    int numberOfArguments = method.getParameterTypes().length;
                    Class<?>[] argumentTypes = method.getParameterTypes();
                    Object[] arguments = new Object[numberOfArguments];
                    if (method.isVarArgs()) {
                        for (int i = 0; i < numberOfArguments - 1; ++i) {
                            arguments[i] = args[i];
                        }
                        Class<?> varArgsType = argumentTypes[numberOfArguments - 1].getComponentType();
                        Object varArgs = Array.newInstance(varArgsType, args.length - numberOfArguments + 1);
                        int i = numberOfArguments - 1;
                        int j = 0;
                        while (i < args.length) {
                            Array.set(varArgs, j, args[i]);
                            ++i;
                            ++j;
                        }
                        arguments[numberOfArguments - 1] = varArgs;
                    } else {
                        for (int i = 0; i < args.length; ++i) {
                            arguments[i] = args[i];
                        }
                    }
                    return DoExecuteNode.reflectiveInvoke(method, obj, arguments);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new IllegalStateException(ex);
                }
            }

            @CompilerDirectives.TruffleBoundary
            private static Object reflectiveInvoke(Method method, Object obj, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
                method.setAccessible(true);
                Object ret = method.invoke(obj, arguments);
                if (ToJavaNode.isPrimitive(ret)) {
                    return ret;
                }
                return JavaInterop.asTruffleObject(ret);
            }
        }
    }
}

