/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Content;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;

final class ClientManagedFileSourceImpl
extends Content
implements Content.CreateURI {
    private final File file;
    private final String name;
    private final String path;

    ClientManagedFileSourceImpl(File file, String name, String path, CharSequence chars) {
        this.file = file.getAbsoluteFile();
        this.name = name;
        this.path = path;
        this.setCode(chars);
    }

    void setCode(CharSequence chars) {
        this.code = chars.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.file.getName();
    }

    @Override
    Object getHashKey() {
        return this.path;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    URI getURI() {
        return this.createURIOnce(this);
    }

    @Override
    public URI createURI() {
        return this.file.toURI();
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.code);
    }

    @Override
    String findMimeType() throws IOException {
        return Files.probeContentType(this.file.toPath());
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }
}

