/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CachedBooleanDispatchNode;
import org.jruby.truffle.language.dispatch.CachedBoxedDispatchNode;
import org.jruby.truffle.language.dispatch.CachedBoxedSymbolDispatchNode;
import org.jruby.truffle.language.dispatch.CachedForeignDispatchNode;
import org.jruby.truffle.language.dispatch.CachedMethodMissingDispatchNode;
import org.jruby.truffle.language.dispatch.CachedReturnMissingDispatchNode;
import org.jruby.truffle.language.dispatch.CachedSingletonDispatchNode;
import org.jruby.truffle.language.dispatch.CachedUnboxedDispatchNode;
import org.jruby.truffle.language.dispatch.DispatchAction;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;
import org.jruby.truffle.language.dispatch.UncachedDispatchNode;
import org.jruby.truffle.language.methods.InternalMethod;

public final class UnresolvedDispatchNode
extends DispatchNode {
    private int depth = 0;
    private final boolean ignoreVisibility;
    private final MissingBehavior missingBehavior;

    public UnresolvedDispatchNode(RubyContext context, boolean ignoreVisibility, MissingBehavior missingBehavior, DispatchAction dispatchAction) {
        super(context, dispatchAction);
        this.ignoreVisibility = ignoreVisibility;
        this.missingBehavior = missingBehavior;
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return false;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        CompilerDirectives.transferToInterpreter();
        if (receiverObject instanceof DynamicObject) {
            ((DynamicObject)receiverObject).updateShape();
        }
        DispatchNode dispatch = this.atomic(() -> {
            DispatchNode newDispathNode;
            DispatchNode first;
            for (DispatchNode lookupDispatch = first = this.getHeadNode().getFirstDispatchNode(); lookupDispatch != null; lookupDispatch = lookupDispatch.getNext()) {
                if (!lookupDispatch.guard(methodName, receiverObject)) continue;
                return lookupDispatch;
            }
            if (this.depth == this.getContext().getOptions().DISPATCH_CACHE) {
                newDispathNode = new UncachedDispatchNode(this.getContext(), this.ignoreVisibility, this.getDispatchAction(), this.missingBehavior);
            } else {
                ++this.depth;
                newDispathNode = RubyGuards.isForeignObject(receiverObject) ? new CachedForeignDispatchNode(this.getContext(), first, methodName) : (RubyGuards.isRubyBasicObject(receiverObject) ? this.doDynamicObject(frame, first, receiverObject, methodName, argumentsObjects) : this.doUnboxedObject(frame, first, receiverObject, methodName));
            }
            first.replace(newDispathNode);
            return newDispathNode;
        });
        return dispatch.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    private DispatchNode doUnboxedObject(VirtualFrame frame, DispatchNode first, Object receiverObject, Object methodName) {
        String methodNameString = this.toString(methodName);
        InternalMethod method = this.lookup(frame, receiverObject, methodNameString, this.ignoreVisibility);
        if (method == null) {
            return this.createMethodMissingNode(first, methodName, receiverObject);
        }
        if (receiverObject instanceof Boolean) {
            Assumption falseUnmodifiedAssumption = Layouts.MODULE.getFields(this.coreLibrary().getFalseClass()).getUnmodifiedAssumption();
            InternalMethod falseMethod = this.lookup(frame, false, methodNameString, this.ignoreVisibility);
            Assumption trueUnmodifiedAssumption = Layouts.MODULE.getFields(this.coreLibrary().getTrueClass()).getUnmodifiedAssumption();
            InternalMethod trueMethod = this.lookup(frame, true, methodNameString, this.ignoreVisibility);
            assert (falseMethod != null || trueMethod != null);
            return new CachedBooleanDispatchNode(this.getContext(), methodName, first, falseUnmodifiedAssumption, falseMethod, trueUnmodifiedAssumption, trueMethod, this.getDispatchAction());
        }
        return new CachedUnboxedDispatchNode(this.getContext(), methodName, first, receiverObject.getClass(), Layouts.MODULE.getFields(this.coreLibrary().getLogicalClass(receiverObject)).getUnmodifiedAssumption(), method, this.getDispatchAction());
    }

    private DispatchNode doDynamicObject(VirtualFrame frame, DispatchNode first, Object receiverObject, Object methodName, Object[] argumentsObjects) {
        String methodNameString = this.toString(methodName);
        InternalMethod method = this.lookup(frame, receiverObject, methodNameString, this.ignoreVisibility);
        if (method == null) {
            return this.createMethodMissingNode(first, methodName, receiverObject);
        }
        DynamicObject receiverMetaClass = this.coreLibrary().getMetaClass(receiverObject);
        if (RubyGuards.isRubySymbol(receiverObject)) {
            return new CachedBoxedSymbolDispatchNode(this.getContext(), methodName, first, method, this.getDispatchAction());
        }
        if (Layouts.CLASS.getIsSingleton(receiverMetaClass)) {
            return new CachedSingletonDispatchNode(this.getContext(), methodName, first, (DynamicObject)receiverObject, receiverMetaClass, method, this.getDispatchAction());
        }
        return new CachedBoxedDispatchNode(this.getContext(), methodName, first, ((DynamicObject)receiverObject).getShape(), receiverMetaClass, method, this.getDispatchAction());
    }

    private String toString(Object methodName) {
        if (methodName instanceof String) {
            return (String)methodName;
        }
        if (RubyGuards.isRubyString(methodName)) {
            return methodName.toString();
        }
        if (RubyGuards.isRubySymbol(methodName)) {
            return Layouts.SYMBOL.getString((DynamicObject)methodName);
        }
        throw new UnsupportedOperationException();
    }

    private DispatchNode createMethodMissingNode(DispatchNode first, Object methodName, Object receiverObject) {
        switch (this.missingBehavior) {
            case RETURN_MISSING: {
                return new CachedReturnMissingDispatchNode(this.getContext(), methodName, first, this.coreLibrary().getMetaClass(receiverObject), this.getDispatchAction());
            }
            case CALL_METHOD_MISSING: {
                InternalMethod method = this.lookup(null, receiverObject, "method_missing", true);
                if (method == null) {
                    throw new RaiseException(this.coreExceptions().runtimeError(receiverObject.toString() + " didn't have a #method_missing", this));
                }
                return new CachedMethodMissingDispatchNode(this.getContext(), methodName, first, this.coreLibrary().getMetaClass(receiverObject), method, this.getDispatchAction());
            }
        }
        throw new UnsupportedOperationException(this.missingBehavior.toString());
    }
}

