/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import java.lang.reflect.Array;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.AbstractRubyMethod;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.platform.Platform;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.truffle.parser.Signature;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.OptArgParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.RequiredKeywordArgumentValueParseNode;
import org.jruby.truffle.parser.ast.UnnamedRestArgParseNode;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.scope.StaticScope;
import org.jruby.truffle.parser.scope.StaticScopeFactory;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.DefinedMessage;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

public class Helpers {
    public static final int MAX_SPECIFIC_ARITY_OBJECT_ARRAY = 10;
    public static final int MAX_SPECIFIC_ARITY_HASH = 5;

    public static CallSite selectAttrAsgnCallSite(IRubyObject receiver, IRubyObject self, CallSite normalSite, CallSite variableSite) {
        if (receiver == self) {
            return variableSite;
        }
        return normalSite;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver, CallSite callSite, IRubyObject value, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver, value);
        return value;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver, CallSite callSite, IRubyObject arg0, IRubyObject value, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver, arg0, value);
        return value;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject value, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver, arg0, arg1, value);
        return value;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject value, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver, new IRubyObject[]{arg0, arg1, arg2, value});
        return value;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver, CallSite callSite, IRubyObject[] args, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver, args);
        return args[args.length - 1];
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver, CallSite callSite, IRubyObject[] args, IRubyObject value, ThreadContext context, IRubyObject caller) {
        IRubyObject[] newArgs = new IRubyObject[args.length + 1];
        System.arraycopy(args, 0, newArgs, 0, args.length);
        newArgs[args.length] = value;
        callSite.call(context, caller, receiver, newArgs);
        return value;
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller, IRubyObject arg, IRubyObject[] receivers) {
        for (int i = 0; i < receivers.length; ++i) {
            IRubyObject receiver = receivers[i];
            if (!Helpers.invokeEqqForCaseWhen(callSite, context, caller, arg, receiver)) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller, IRubyObject arg, IRubyObject receiver) {
        IRubyObject result = callSite.call(context, caller, receiver, arg);
        return result.isTrue();
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller, IRubyObject arg, IRubyObject receiver0, IRubyObject receiver1) {
        IRubyObject result = callSite.call(context, caller, receiver0, arg);
        if (result.isTrue()) {
            return true;
        }
        return Helpers.invokeEqqForCaseWhen(callSite, context, caller, arg, receiver1);
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller, IRubyObject arg, IRubyObject receiver0, IRubyObject receiver1, IRubyObject receiver2) {
        IRubyObject result = callSite.call(context, caller, receiver0, arg);
        if (result.isTrue()) {
            return true;
        }
        return Helpers.invokeEqqForCaseWhen(callSite, context, caller, arg, receiver1, receiver2);
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject[] receivers) {
        for (int i = 0; i < receivers.length; ++i) {
            if (!receivers[i].isTrue()) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver) {
        return receiver.isTrue();
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver0, IRubyObject receiver1) {
        return receiver0.isTrue() || receiver1.isTrue();
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver0, IRubyObject receiver1, IRubyObject receiver2) {
        return receiver0.isTrue() || receiver1.isTrue() || receiver2.isTrue();
    }

    public static String[] parseBlockDescriptor(String descriptor) {
        String[] mangled = descriptor.split(":");
        mangled[0] = JavaNameMangler.demangleMethodName((String)mangled[0]);
        mangled[4] = JavaNameMangler.demangleMethodName((String)mangled[4]);
        return mangled;
    }

    public static RubyClass getSingletonClass(Ruby runtime, IRubyObject receiver) {
        if (receiver instanceof RubyFixnum || receiver instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton");
        }
        return receiver.getSingletonClass();
    }

    @Deprecated
    public static IRubyObject invokeMethodMissing(IRubyObject receiver, String name, IRubyObject[] args) {
        ThreadContext context = receiver.getRuntime().getCurrentContext();
        context.setLastCallStatusAndVisibility(CallType.FUNCTIONAL, Visibility.PUBLIC);
        if (name.equals("method_missing")) {
            return RubyKernel.method_missing((ThreadContext)context, (IRubyObject)receiver, (IRubyObject[])args, (Block)Block.NULL_BLOCK);
        }
        IRubyObject[] newArgs = Helpers.prepareMethodMissingArgs(args, context, name);
        return Helpers.invoke(context, receiver, "method_missing", newArgs, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver, Visibility visibility, String name, CallType callType, IRubyObject[] args, Block block) {
        return Helpers.selectMethodMissing(context, receiver, visibility, name, callType).call(context, receiver, (RubyModule)receiver.getMetaClass(), name, args, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver, Visibility visibility, String name, CallType callType, IRubyObject arg0, Block block) {
        return Helpers.selectMethodMissing(context, receiver, visibility, name, callType).call(context, receiver, (RubyModule)receiver.getMetaClass(), name, arg0, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver, Visibility visibility, String name, CallType callType, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.selectMethodMissing(context, receiver, visibility, name, callType).call(context, receiver, (RubyModule)receiver.getMetaClass(), name, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver, Visibility visibility, String name, CallType callType, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.selectMethodMissing(context, receiver, visibility, name, callType).call(context, receiver, (RubyModule)receiver.getMetaClass(), name, arg0, arg1, arg2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver, Visibility visibility, String name, CallType callType, Block block) {
        return Helpers.selectMethodMissing(context, receiver, visibility, name, callType).call(context, receiver, (RubyModule)receiver.getMetaClass(), name, block);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, IRubyObject receiver, Visibility visibility, String name, CallType callType) {
        Ruby runtime = context.runtime;
        if (name.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = receiver.getMetaClass().searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, visibility, callType);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, RubyClass selfClass, Visibility visibility, String name, CallType callType) {
        Ruby runtime = context.runtime;
        if (name.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = selfClass.searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, visibility, callType);
    }

    public static DynamicMethod selectMethodMissing(RubyClass selfClass, Visibility visibility, String name, CallType callType) {
        Ruby runtime = selfClass.getClassRuntime();
        if (name.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = selfClass.searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, visibility, callType);
    }

    public static final Map<String, String> map(String ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>(keyValues.length / 2);
        int i = 0;
        while (i < keyValues.length) {
            map.put(keyValues[i++], keyValues[i++]);
        }
        return map;
    }

    public static boolean additionOverflowed(long original, long other, long result) {
        return ((original ^ other ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result) & Long.MIN_VALUE) != 0L;
    }

    public static boolean subtractionOverflowed(long original, long other, long result) {
        return ((original ^ (other ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result) & Long.MIN_VALUE) != 0L;
    }

    public static Errno errnoFromException(Throwable t) {
        if (t instanceof ClosedChannelException) {
            return Errno.EBADF;
        }
        if (t.getMessage() != null) {
            String errorMessage = t.getMessage();
            if ("Bad file descriptor".equals(errorMessage)) {
                return Errno.EBADF;
            }
            if ("File not open".equals(errorMessage)) {
                return null;
            }
            if ("An established connection was aborted by the software in your host machine".equals(errorMessage)) {
                return Errno.ECONNABORTED;
            }
            if (t.getMessage().equals("Broken pipe")) {
                return Errno.EPIPE;
            }
            if ("Connection reset by peer".equals(errorMessage) || "An existing connection was forcibly closed by the remote host".equals(errorMessage) || Platform.IS_WINDOWS && errorMessage.contains("connection was aborted")) {
                return Errno.ECONNRESET;
            }
            if (errorMessage.equals("No space left on device")) {
                return Errno.ENOSPC;
            }
            if (errorMessage.equals("Too many open files")) {
                return Errno.EMFILE;
            }
        }
        return null;
    }

    public static RubyModule getNthScopeModule(StaticScope scope, int depth) {
        int n = depth;
        while (n > 0) {
            if ((scope = scope.getEnclosingScope()).getScopeType() == null) continue;
            --n;
        }
        return scope.getModule();
    }

    public static RubyArray viewArgsArray(ThreadContext context, RubyArray rubyArray, int preArgsCount, int postArgsCount) {
        int n = rubyArray.getLength();
        if (preArgsCount + postArgsCount >= n) {
            return RubyArray.newEmptyArray((Ruby)context.runtime);
        }
        return (RubyArray)rubyArray.subseq(context.runtime.getArray(), (long)preArgsCount, (long)(n - preArgsCount - postArgsCount), true);
    }

    public static Class[] getStaticMethodParams(Class target, int args) {
        switch (args) {
            case 0: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, Block.class};
            }
            case 1: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 2: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 3: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 4: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
            }
        }
        throw new RuntimeException("unsupported arity: " + args);
    }

    public static String getStaticMethodSignature(String classname, int args) {
        switch (args) {
            case 0: {
                return CodegenUtils.sig(IRubyObject.class, (String)("L" + classname + ";"), (Class[])new Class[]{ThreadContext.class, IRubyObject.class, Block.class});
            }
            case 1: {
                return CodegenUtils.sig(IRubyObject.class, (String)("L" + classname + ";"), (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class});
            }
            case 2: {
                return CodegenUtils.sig(IRubyObject.class, (String)("L" + classname + ";"), (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class});
            }
            case 3: {
                return CodegenUtils.sig(IRubyObject.class, (String)("L" + classname + ";"), (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class});
            }
            case 4: {
                return CodegenUtils.sig(IRubyObject.class, (String)("L" + classname + ";"), (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class});
            }
        }
        throw new RuntimeException("unsupported arity: " + args);
    }

    private static DynamicMethod selectInternalMM(Ruby runtime, Visibility visibility, CallType callType) {
        if (visibility == Visibility.PRIVATE) {
            return runtime.getPrivateMethodMissing();
        }
        if (visibility == Visibility.PROTECTED) {
            return runtime.getProtectedMethodMissing();
        }
        if (callType == CallType.VARIABLE) {
            return runtime.getVariableMethodMissing();
        }
        if (callType == CallType.SUPER) {
            return runtime.getSuperMethodMissing();
        }
        return runtime.getNormalMethodMissing();
    }

    private static IRubyObject[] prepareMethodMissingArgs(IRubyObject[] args, ThreadContext context, String name) {
        return ArraySupport.newCopy((IRubyObject)context.runtime.newSymbol(name), (IRubyObject[])args);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, Block block) {
        return self.getMetaClass().finvoke(context, self, name, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, Block block) {
        return self.getMetaClass().finvoke(context, self, name, arg0, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
        return self.getMetaClass().finvoke(context, self, name, arg0, arg1, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return self.getMetaClass().finvoke(context, self, name, arg0, arg1, arg2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject[] args, Block block) {
        return self.getMetaClass().finvoke(context, self, name, args, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name) {
        return self.getMetaClass().finvoke(context, self, name);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0) {
        return self.getMetaClass().finvoke(context, self, name, arg0);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1) {
        return self.getMetaClass().finvoke(context, self, name, arg0, arg1);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return self.getMetaClass().finvoke(context, self, name, arg0, arg1, arg2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject ... args) {
        return self.getMetaClass().finvoke(context, self, name, args);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name, IRubyObject[] args, Block block) {
        return asClass.finvoke(context, self, name, args, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name, Block block) {
        return asClass.finvoke(context, self, name, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name, IRubyObject arg0, Block block) {
        return asClass.finvoke(context, self, name, arg0, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
        return asClass.finvoke(context, self, name, arg0, arg1, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return asClass.finvoke(context, self, name, arg0, arg1, arg2, block);
    }

    public static IRubyObject invokeFrom(ThreadContext context, IRubyObject caller, IRubyObject self, String name, IRubyObject[] args, CallType callType, Block block) {
        return self.getMetaClass().invokeFrom(context, callType, caller, self, name, args, block);
    }

    public static IRubyObject invokeFrom(ThreadContext context, IRubyObject caller, IRubyObject self, String name, IRubyObject arg, CallType callType, Block block) {
        return self.getMetaClass().invokeFrom(context, callType, caller, self, name, arg, block);
    }

    public static IRubyObject invokeFrom(ThreadContext context, IRubyObject caller, IRubyObject self, String name, CallType callType) {
        return self.getMetaClass().invokeFrom(context, callType, caller, self, name, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self, String name) {
        return self.getMetaClass().finvokeChecked(context, self, name);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self, JavaSites.CheckedSites sites) {
        return self.getMetaClass().finvokeChecked(context, self, sites);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self, String name, IRubyObject ... args) {
        return self.getMetaClass().finvokeChecked(context, self, name, args);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self, JavaSites.CheckedSites sites, IRubyObject ... args) {
        return self.getMetaClass().finvokeChecked(context, self, sites, args);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
        return Helpers.invokeSuper(context, self, context.getFrameKlazz(), context.getFrameName(), args, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, RubyModule klass, String name, IRubyObject[] args, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context, klass, name);
        RubyClass superClass = Helpers.findImplementerIfNecessary((RubyModule)self.getMetaClass(), klass).getSuperClass();
        Object object = method = superClass != null ? superClass.searchMethod(name) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self, method.getVisibility(), name, CallType.SUPER, args, block);
        }
        return method.call(context, self, (RubyModule)superClass, name, args, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary((RubyModule)self.getMetaClass(), klazz).getSuperClass();
        Object object = method = superClass != null ? superClass.searchMethod(name) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self, method.getVisibility(), name, CallType.SUPER, block);
        }
        return method.call(context, self, (RubyModule)superClass, name, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary((RubyModule)self.getMetaClass(), klazz).getSuperClass();
        Object object = method = superClass != null ? superClass.searchMethod(name) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self, method.getVisibility(), name, CallType.SUPER, arg0, block);
        }
        return method.call(context, self, (RubyModule)superClass, name, arg0, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary((RubyModule)self.getMetaClass(), klazz).getSuperClass();
        Object object = method = superClass != null ? superClass.searchMethod(name) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self, method.getVisibility(), name, CallType.SUPER, arg0, arg1, block);
        }
        return method.call(context, self, (RubyModule)superClass, name, arg0, arg1, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary((RubyModule)self.getMetaClass(), klazz).getSuperClass();
        Object object = method = superClass != null ? superClass.searchMethod(name) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self, method.getVisibility(), name, CallType.SUPER, arg0, arg1, arg2, block);
        }
        return method.call(context, self, (RubyModule)superClass, name, arg0, arg1, arg2, block);
    }

    public static RubyArray ensureRubyArray(IRubyObject value) {
        return Helpers.ensureRubyArray(value.getRuntime(), value);
    }

    public static RubyArray ensureRubyArray(Ruby runtime, IRubyObject value) {
        return value instanceof RubyArray ? (RubyArray)value : RubyArray.newArray((Ruby)runtime, (IRubyObject)value);
    }

    public static IRubyObject nullToNil(IRubyObject value, ThreadContext context) {
        return value != null ? value : context.nil;
    }

    public static IRubyObject nullToNil(IRubyObject value, Ruby runtime) {
        return value != null ? value : runtime.getNil();
    }

    public static IRubyObject nullToNil(IRubyObject value, IRubyObject nil) {
        return value != null ? value : nil;
    }

    public static RubyClass prepareSuperClass(Ruby runtime, IRubyObject rubyClass) {
        RubyClass.checkInheritable((IRubyObject)rubyClass);
        return (RubyClass)rubyClass;
    }

    public static RubyModule prepareClassNamespace(ThreadContext context, StaticScope scope, IRubyObject rubyModule) {
        if ((rubyModule == null || rubyModule.isNil()) && (rubyModule = scope.getModule()) == null) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        if (rubyModule instanceof RubyModule) {
            return (RubyModule)rubyModule;
        }
        throw context.runtime.newTypeError(rubyModule + " is not a class/module");
    }

    public static void handleArgumentSizes(ThreadContext context, Ruby runtime, int given, int required, int opt, int rest) {
        if (opt == 0) {
            if (rest < 0 ? given != required : given < required) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
            }
        } else if (rest < 0) {
            if (given < required) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
            }
            if (given > required + opt) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + (required + opt) + ")");
            }
        } else if (given < required) {
            throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
        }
    }

    public static String getLocalJumpTypeOrRethrow(RaiseException re) {
        RubyException exception = re.getException();
        Ruby runtime = exception.getRuntime();
        if (runtime.getLocalJumpError().isInstance((IRubyObject)exception)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            IRubyObject reason = jumpError.reason();
            return reason.asJavaString();
        }
        throw re;
    }

    public static IRubyObject unwrapLocalJumpErrorValue(RaiseException re) {
        return ((RubyLocalJumpError)re.getException()).exit_value();
    }

    public static IRubyObject processBlockArgument(Ruby runtime, Block block) {
        if (!block.isGiven()) {
            return runtime.getNil();
        }
        return Helpers.processGivenBlock(block, runtime);
    }

    private static IRubyObject processGivenBlock(Block block, Ruby runtime) {
        RubyProc blockArg = block.getProcObject();
        if (blockArg == null) {
            blockArg = runtime.newBlockPassProc(Block.Type.PROC, block);
            blockArg.getBlock().type = Block.Type.PROC;
        }
        return blockArg;
    }

    public static Block getBlockFromBlockPassBody(Ruby runtime, IRubyObject proc, Block currentBlock) {
        if (proc.isNil()) {
            return Block.NULL_BLOCK;
        }
        if (!(proc instanceof RubyProc)) {
            proc = Helpers.coerceProc(proc, runtime);
        }
        return Helpers.getBlockFromProc(currentBlock, proc);
    }

    private static IRubyObject coerceProc(IRubyObject maybeProc, Ruby runtime) throws RaiseException {
        IRubyObject proc = TypeConverter.convertToType((IRubyObject)maybeProc, (RubyClass)runtime.getProc(), (String)"to_proc", (boolean)false);
        if (!(proc instanceof RubyProc)) {
            throw runtime.newTypeError("wrong argument type " + maybeProc.getMetaClass().getName() + " (expected Proc)");
        }
        return proc;
    }

    private static Block getBlockFromProc(Block currentBlock, IRubyObject proc) {
        RubyProc procObject;
        if (currentBlock != null && currentBlock.isGiven() && (procObject = currentBlock.getProcObject()) != null && procObject == proc) {
            return currentBlock;
        }
        return ((RubyProc)proc).getBlock();
    }

    public static Block getBlockFromBlockPassBody(IRubyObject proc, Block currentBlock) {
        return Helpers.getBlockFromBlockPassBody(proc.getRuntime(), proc, currentBlock);
    }

    public static IRubyObject backref(ThreadContext context) {
        return RubyRegexp.getBackRef((ThreadContext)context);
    }

    public static IRubyObject backrefLastMatch(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.last_match((IRubyObject)backref);
    }

    public static IRubyObject backrefMatchPre(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_pre((IRubyObject)backref);
    }

    public static IRubyObject backrefMatchPost(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_post((IRubyObject)backref);
    }

    public static IRubyObject backrefMatchLast(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_last((IRubyObject)backref);
    }

    public static IRubyObject[] appendToObjectArray(IRubyObject[] array, IRubyObject add) {
        return ArraySupport.newCopy((IRubyObject[])array, (IRubyObject)add);
    }

    public static IRubyObject breakLocalJumpError(Ruby runtime, IRubyObject value) {
        throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, value, "unexpected break");
    }

    public static IRubyObject[] concatObjectArrays(IRubyObject[] array, IRubyObject[] add) {
        return Helpers.toArray(array, add);
    }

    public static IRubyObject[] toArray(IRubyObject[] array, IRubyObject ... rest) {
        int len = array.length;
        Object[] newArray = new IRubyObject[len + rest.length];
        ArraySupport.copy((Object[])array, (Object[])newArray, (int)0, (int)len);
        ArraySupport.copy((Object[])rest, (Object[])newArray, (int)len, (int)rest.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj, IRubyObject ... rest) {
        return ArraySupport.newCopy((IRubyObject)obj, (IRubyObject[])rest);
    }

    public static IRubyObject[] toArray(IRubyObject obj0, IRubyObject obj1, IRubyObject ... rest) {
        Object[] newArray = new IRubyObject[2 + rest.length];
        newArray[0] = obj0;
        newArray[1] = obj1;
        ArraySupport.copy((Object[])rest, (Object[])newArray, (int)2, (int)rest.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj0, IRubyObject obj1, IRubyObject obj2, IRubyObject ... rest) {
        Object[] newArray = new IRubyObject[3 + rest.length];
        newArray[0] = obj0;
        newArray[1] = obj1;
        newArray[2] = obj2;
        ArraySupport.copy((Object[])rest, (Object[])newArray, (int)3, (int)rest.length);
        return newArray;
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject[] exceptions, ThreadContext context) {
        for (int i = 0; i < exceptions.length; ++i) {
            IRubyObject result = Helpers.isExceptionHandled(currentException, exceptions[i], context);
            if (!result.isTrue()) continue;
            return result;
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception, ThreadContext context) {
        return Helpers.isExceptionHandled((IRubyObject)currentException, exception, context);
    }

    public static IRubyObject isExceptionHandled(IRubyObject currentException, IRubyObject exception, ThreadContext context) {
        Ruby runtime = context.runtime;
        if (!runtime.getModule().isInstance(exception)) {
            throw runtime.newTypeError("class or module required for rescue clause");
        }
        IRubyObject result = Helpers.invoke(context, exception, "===", currentException);
        if (result.isTrue()) {
            return result;
        }
        return runtime.getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, ThreadContext context) {
        IRubyObject result = Helpers.isExceptionHandled(currentException, exception0, context);
        if (result.isTrue()) {
            return result;
        }
        return Helpers.isExceptionHandled(currentException, exception1, context);
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, IRubyObject exception2, ThreadContext context) {
        IRubyObject result = Helpers.isExceptionHandled(currentException, exception0, context);
        if (result.isTrue()) {
            return result;
        }
        return Helpers.isExceptionHandled(currentException, exception1, exception2, context);
    }

    public static boolean checkJavaException(IRubyObject wrappedEx, Throwable ex, IRubyObject catchable, ThreadContext context) {
        Ruby runtime = context.runtime;
        if (runtime.getException() == catchable || runtime.getObject() == catchable || runtime.getStandardError() == catchable) {
            if (ex instanceof RaiseException) {
                return Helpers.isExceptionHandled(((RaiseException)ex).getException(), catchable, context).isTrue();
            }
            return Helpers.isExceptionHandled(wrappedEx, catchable, context).isTrue();
        }
        if (runtime.getNativeException() == catchable) {
            return true;
        }
        if (catchable instanceof RubyClass && JavaClass.isProxyType((ThreadContext)context, (RubyModule)((RubyClass)catchable))) {
            IRubyObject target;
            if (ex instanceof InternalJavaProxy && (target = ((InternalJavaProxy)ex).___getInvocationHandler().getOrig()) != null) {
                return ((RubyClass)catchable).isInstance(target);
            }
            return ((RubyClass)catchable).isInstance(wrappedEx);
        }
        if (catchable instanceof RubyModule) {
            IRubyObject result = Helpers.invoke(context, catchable, "===", wrappedEx);
            return result.isTrue();
        }
        return false;
    }

    public static boolean checkJavaException(Throwable ex, IRubyObject catchable, ThreadContext context) {
        return Helpers.checkJavaException(Helpers.wrapJavaException(context.runtime, ex), ex, catchable, context);
    }

    public static IRubyObject wrapJavaException(Ruby runtime, Throwable ex) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)runtime, (Object)ex);
    }

    @Deprecated
    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject[] throwables, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwables, context);
        }
        if (throwables.length == 0) {
            return context.runtime.getTrue();
        }
        for (int i = 0; i < throwables.length; ++i) {
            if (!Helpers.checkJavaException(currentThrowable, throwables[i], context)) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    @Deprecated
    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    @Deprecated
    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    @Deprecated
    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, IRubyObject throwable2, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, throwable2, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable2, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static void storeExceptionInErrorInfo(Throwable currentThrowable, ThreadContext context) {
        Object exception = currentThrowable instanceof RaiseException ? ((RaiseException)currentThrowable).getException() : JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)currentThrowable);
        context.setErrorInfo((IRubyObject)exception);
    }

    public static void storeNativeExceptionInErrorInfo(Throwable currentThrowable, ThreadContext context) {
        RubyException exception;
        if (currentThrowable instanceof RaiseException) {
            exception = ((RaiseException)currentThrowable).getException();
        } else {
            Ruby runtime = context.runtime;
            exception = new NativeException(runtime, runtime.getNativeException(), currentThrowable);
            ((NativeException)exception).prepareIntegratedBacktrace(context, currentThrowable.getStackTrace());
        }
        context.setErrorInfo((IRubyObject)exception);
    }

    public static void clearErrorInfo(ThreadContext context) {
        context.setErrorInfo(context.runtime.getNil());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context) {
        Helpers.checkSuperDisabledOrOutOfMethod(context, context.getFrameKlazz(), context.getFrameName());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule klass, String name) {
        if (klass == null) {
            if (name != null) {
                throw context.runtime.newNameError("superclass method '" + name + "' disabled", name);
            }
            throw context.runtime.newNoMethodError("super called outside of method", null, context.nil);
        }
    }

    public static Block ensureSuperBlock(Block given, Block parent) {
        if (!given.isGiven()) {
            return parent;
        }
        return given;
    }

    public static RubyModule findImplementerIfNecessary(RubyModule clazz, RubyModule implementationClass) {
        if (implementationClass.needsImplementer()) {
            return clazz.findImplementer(implementationClass);
        }
        return implementationClass.getMethodLocation();
    }

    public static RubyArray createSubarray(RubyArray input, int start) {
        return (RubyArray)input.subseqLight((long)start, (long)(input.size() - start));
    }

    public static RubyArray createSubarray(RubyArray input, int start, int post) {
        return (RubyArray)input.subseqLight((long)start, (long)(input.size() - post - start));
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime, int start) {
        if (start >= input.length) {
            return RubyArray.newEmptyArray((Ruby)runtime);
        }
        return RubyArray.newArrayMayCopy((Ruby)runtime, (IRubyObject[])input, (int)start);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime, int start, int exclude) {
        int length = input.length - exclude - start;
        if (length <= 0) {
            return RubyArray.newEmptyArray((Ruby)runtime);
        }
        return RubyArray.newArrayMayCopy((Ruby)runtime, (IRubyObject[])input, (int)start, (int)length);
    }

    public static IRubyObject elementOrNull(IRubyObject[] input, int element) {
        if (element >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject optElementOrNull(IRubyObject[] input, int element, int postCount) {
        if (element + postCount >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject elementOrNil(IRubyObject[] input, int element, IRubyObject nil) {
        if (element >= input.length) {
            return nil;
        }
        return input[element];
    }

    public static IRubyObject postElementOrNil(IRubyObject[] input, int postCount, int postIndex, IRubyObject nil) {
        int aryIndex = input.length - postCount + postIndex;
        if (aryIndex >= input.length || aryIndex < 0) {
            return nil;
        }
        return input[aryIndex];
    }

    public static RubyBoolean isWhenTriggered(IRubyObject expression, IRubyObject expressionsObject, ThreadContext context) {
        RubyArray expressions = Helpers.splatValue(expressionsObject);
        int k = expressions.getLength();
        for (int j = 0; j < k; ++j) {
            IRubyObject condition = expressions.eltInternal(j);
            if ((expression == null || !condition.callMethod(context, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject setConstantInModule(ThreadContext context, String name, IRubyObject value, IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw context.runtime.newTypeError(module.toString() + " is not a class/module");
        }
        ((RubyModule)module).setConstant(name, value);
        return value;
    }

    public static IRubyObject[] anewarrayIRubyObjects(int size) {
        return new IRubyObject[size];
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, int start) {
        ary[start] = one;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        ary[start + 2] = three;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        ary[start + 2] = three;
        ary[start + 3] = four;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        ary[start + 2] = three;
        ary[start + 3] = four;
        ary[start + 4] = five;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        ary[start + 2] = three;
        ary[start + 3] = four;
        ary[start + 4] = five;
        ary[start + 5] = six;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        ary[start + 2] = three;
        ary[start + 3] = four;
        ary[start + 4] = five;
        ary[start + 5] = six;
        ary[start + 6] = seven;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        ary[start + 2] = three;
        ary[start + 3] = four;
        ary[start + 4] = five;
        ary[start + 5] = six;
        ary[start + 6] = seven;
        ary[start + 7] = eight;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        ary[start + 2] = three;
        ary[start + 3] = four;
        ary[start + 4] = five;
        ary[start + 5] = six;
        ary[start + 6] = seven;
        ary[start + 7] = eight;
        ary[start + 8] = nine;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten, int start) {
        ary[start] = one;
        ary[start + 1] = two;
        ary[start + 2] = three;
        ary[start + 3] = four;
        ary[start + 4] = five;
        ary[start + 5] = six;
        ary[start + 6] = seven;
        ary[start + 7] = eight;
        ary[start + 8] = nine;
        ary[start + 9] = ten;
        return ary;
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one) {
        return new IRubyObject[]{one};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two) {
        return new IRubyObject[]{one, two};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three) {
        return new IRubyObject[]{one, two, three};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return new IRubyObject[]{one, two, three, four};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return new IRubyObject[]{one, two, three, four, five};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six) {
        return new IRubyObject[]{one, two, three, four, five, six};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven) {
        return new IRubyObject[]{one, two, three, four, five, six, seven};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject)one);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject)one, (IRubyObject)two);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject[])new IRubyObject[]{one, two, three});
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject[])new IRubyObject[]{one, two, three, four});
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject[])new IRubyObject[]{one, two, three, four, five});
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject[])new IRubyObject[]{one, two, three, four, five, six});
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject[])new IRubyObject[]{one, two, three, four, five, six, seven});
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject[])new IRubyObject[]{one, two, three, four, five, six, seven, eight});
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject[])new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine});
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten) {
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject[])new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine, ten});
    }

    public static String[] constructStringArray(String one) {
        return new String[]{one};
    }

    public static String[] constructStringArray(String one, String two) {
        return new String[]{one, two};
    }

    public static String[] constructStringArray(String one, String two, String three) {
        return new String[]{one, two, three};
    }

    public static String[] constructStringArray(String one, String two, String three, String four) {
        return new String[]{one, two, three, four};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five) {
        return new String[]{one, two, three, four, five};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six) {
        return new String[]{one, two, three, four, five, six};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven) {
        return new String[]{one, two, three, four, five, six, seven};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight) {
        return new String[]{one, two, three, four, five, six, seven, eight};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine, String ten) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1) {
        RubyHash hash = RubyHash.newHash((Ruby)runtime);
        hash.fastASet(runtime, key1, value1, prepareString1);
        return hash;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2) {
        RubyHash hash = RubyHash.newHash((Ruby)runtime);
        hash.fastASet(runtime, key1, value1, prepareString1);
        hash.fastASet(runtime, key2, value2, prepareString2);
        return hash;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3) {
        RubyHash hash = RubyHash.newHash((Ruby)runtime);
        hash.fastASet(runtime, key1, value1, prepareString1);
        hash.fastASet(runtime, key2, value2, prepareString2);
        hash.fastASet(runtime, key3, value3, prepareString3);
        return hash;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4) {
        RubyHash hash = RubyHash.newHash((Ruby)runtime);
        hash.fastASet(runtime, key1, value1, prepareString1);
        hash.fastASet(runtime, key2, value2, prepareString2);
        hash.fastASet(runtime, key3, value3, prepareString3);
        hash.fastASet(runtime, key4, value4, prepareString4);
        return hash;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4, IRubyObject key5, IRubyObject value5, boolean prepareString5) {
        RubyHash hash = RubyHash.newHash((Ruby)runtime);
        hash.fastASet(runtime, key1, value1, prepareString1);
        hash.fastASet(runtime, key2, value2, prepareString2);
        hash.fastASet(runtime, key3, value3, prepareString3);
        hash.fastASet(runtime, key4, value4, prepareString4);
        hash.fastASet(runtime, key5, value5, prepareString5);
        return hash;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1) {
        RubyHash hash = RubyHash.newSmallHash((Ruby)runtime);
        hash.fastASetSmall(runtime, key1, value1, prepareString1);
        return hash;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2) {
        RubyHash hash = RubyHash.newSmallHash((Ruby)runtime);
        hash.fastASetSmall(runtime, key1, value1, prepareString1);
        hash.fastASetSmall(runtime, key2, value2, prepareString2);
        return hash;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3) {
        RubyHash hash = RubyHash.newSmallHash((Ruby)runtime);
        hash.fastASetSmall(runtime, key1, value1, prepareString1);
        hash.fastASetSmall(runtime, key2, value2, prepareString2);
        hash.fastASetSmall(runtime, key3, value3, prepareString3);
        return hash;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4) {
        RubyHash hash = RubyHash.newSmallHash((Ruby)runtime);
        hash.fastASetSmall(runtime, key1, value1, prepareString1);
        hash.fastASetSmall(runtime, key2, value2, prepareString2);
        hash.fastASetSmall(runtime, key3, value3, prepareString3);
        hash.fastASetSmall(runtime, key4, value4, prepareString4);
        return hash;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4, IRubyObject key5, IRubyObject value5, boolean prepareString5) {
        RubyHash hash = RubyHash.newSmallHash((Ruby)runtime);
        hash.fastASetSmall(runtime, key1, value1, prepareString1);
        hash.fastASetSmall(runtime, key2, value2, prepareString2);
        hash.fastASetSmall(runtime, key3, value3, prepareString3);
        hash.fastASetSmall(runtime, key4, value4, prepareString4);
        hash.fastASetSmall(runtime, key5, value5, prepareString5);
        return hash;
    }

    public static IRubyObject negate(IRubyObject value, Ruby runtime) {
        if (value.isTrue()) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @Deprecated
    public static IRubyObject stringOrNil(ByteList value, ThreadContext context) {
        if (value == null) {
            return context.nil;
        }
        return RubyString.newStringShared((Ruby)context.runtime, (ByteList)value);
    }

    public static void postLoad(ThreadContext context) {
        context.postNodeEval();
        context.postScopedBody();
    }

    public static void registerEndBlock(Block block, Ruby runtime) {
        runtime.pushExitBlock(runtime.newProc(Block.Type.LAMBDA, block));
    }

    public static IRubyObject match3(RubyRegexp regexp, IRubyObject value, ThreadContext context) {
        if (value instanceof RubyString) {
            return regexp.op_match(context, value);
        }
        return value.callMethod(context, "=~", (IRubyObject)regexp);
    }

    public static IRubyObject match3_19(RubyRegexp regexp, IRubyObject value, ThreadContext context) {
        if (value instanceof RubyString) {
            return regexp.op_match19(context, value);
        }
        return value.callMethod(context, "=~", (IRubyObject)regexp);
    }

    public static IRubyObject getErrorInfo(Ruby runtime) {
        return runtime.getGlobalVariables().get("$!");
    }

    public static void setErrorInfo(Ruby runtime, IRubyObject error) {
        runtime.getGlobalVariables().set("$!", error);
    }

    public static IRubyObject setLastLine(Ruby runtime, ThreadContext context, IRubyObject value) {
        return context.setLastLine(value);
    }

    public static IRubyObject getLastLine(Ruby runtime, ThreadContext context) {
        return context.getLastLine();
    }

    public static IRubyObject setBackref(Ruby runtime, ThreadContext context, IRubyObject value) {
        if (!value.isNil() && !(value instanceof RubyMatchData)) {
            throw runtime.newTypeError(value, runtime.getMatchData());
        }
        return context.setBackRef(value);
    }

    public static IRubyObject getBackref(Ruby runtime, ThreadContext context) {
        return Helpers.backref(context);
    }

    public static IRubyObject preOpAsgnWithOrAnd(IRubyObject receiver, ThreadContext context, IRubyObject self, CallSite varSite) {
        return varSite.call(context, self, receiver);
    }

    public static IRubyObject postOpAsgnWithOrAnd(IRubyObject receiver, IRubyObject value, ThreadContext context, IRubyObject self, CallSite varAsgnSite) {
        varAsgnSite.call(context, self, receiver, value);
        return value;
    }

    public static IRubyObject opAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject arg, CallSite varSite, CallSite opSite, CallSite opAsgnSite) {
        IRubyObject var = varSite.call(context, self, receiver);
        IRubyObject result = opSite.call(context, self, var, arg);
        opAsgnSite.call(context, self, receiver, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject value, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver);
        IRubyObject result = opSite.call(context, self, var, value);
        elementAsgnSite.call(context, self, receiver, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject arg, IRubyObject value, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver, arg);
        IRubyObject result = opSite.call(context, self, var, value);
        elementAsgnSite.call(context, self, receiver, arg, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject arg1, IRubyObject arg2, IRubyObject value, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver, arg1, arg2);
        IRubyObject result = opSite.call(context, self, var, value);
        elementAsgnSite.call(context, self, receiver, arg1, arg2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject value, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver, arg1, arg2, arg3);
        IRubyObject result = opSite.call(context, self, var, value);
        elementAsgnSite.call(context, self, receiver, new IRubyObject[]{arg1, arg2, arg3, result});
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject[] args, IRubyObject value, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver);
        IRubyObject result = opSite.call(context, self, var, value);
        elementAsgnSite.call(context, self, receiver, Helpers.appendToObjectArray(args, result));
        return result;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoOneArg(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject arg, IRubyObject value, CallSite asetSite) {
        asetSite.call(context, self, receiver, arg, value);
        return value;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoTwoArgs(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject[] args, IRubyObject value, CallSite asetSite) {
        asetSite.call(context, self, receiver, args[0], args[1], value);
        return value;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoThreeArgs(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject[] args, IRubyObject value, CallSite asetSite) {
        asetSite.call(context, self, receiver, new IRubyObject[]{args[0], args[1], args[2], value});
        return value;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoNArgs(ThreadContext context, IRubyObject self, IRubyObject receiver, IRubyObject[] args, IRubyObject value, CallSite asetSite) {
        IRubyObject[] newArgs = new IRubyObject[args.length + 1];
        System.arraycopy(args, 0, newArgs, 0, args.length);
        newArgs[args.length] = value;
        asetSite.call(context, self, receiver, newArgs);
        return value;
    }

    public static RubyArray arrayValue(IRubyObject value) {
        Ruby runtime = value.getRuntime();
        return Helpers.arrayValue(runtime.getCurrentContext(), runtime, value);
    }

    public static RubyArray arrayValue(ThreadContext context, Ruby runtime, IRubyObject value) {
        IRubyObject tmp = value.checkArrayType();
        if (tmp.isNil()) {
            if (value.respondsTo("to_a")) {
                IRubyObject avalue = value.callMethod(context, "to_a");
                if (!(avalue instanceof RubyArray)) {
                    if (avalue.isNil()) {
                        return runtime.newArray(value);
                    }
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)avalue;
            }
            DynamicMethod methodMissing = value.getMetaClass().searchMethod("method_missing");
            if (methodMissing.isUndefined() || runtime.isDefaultMethodMissing(methodMissing)) {
                return runtime.newArray(value);
            }
            IRubyObject avalue = methodMissing.call(context, value, (RubyModule)value.getMetaClass(), "to_a", new IRubyObject[]{runtime.newSymbol("to_a")}, Block.NULL_BLOCK);
            if (!(avalue instanceof RubyArray)) {
                if (avalue.isNil()) {
                    return runtime.newArray(value);
                }
                throw runtime.newTypeError("`to_a' did not return Array");
            }
            return (RubyArray)avalue;
        }
        RubyArray arr = (RubyArray)tmp;
        return arr.aryDup();
    }

    public static RubyArray asArray18(ThreadContext context, IRubyObject value) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = value.checkArrayType();
        if (tmp.isNil()) {
            if (value.respondsTo("to_a")) {
                IRubyObject avalue = value.callMethod(context, "to_a");
                if (!(avalue instanceof RubyArray)) {
                    if (avalue.isNil()) {
                        return runtime.newArray(value);
                    }
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)avalue;
            }
            return runtime.newArray(value);
        }
        return (RubyArray)tmp;
    }

    public static RubyArray asArray(ThreadContext context, IRubyObject value) {
        return TypeConverter.rb_Array((ThreadContext)context, (IRubyObject)value);
    }

    public static IRubyObject aryToAry(IRubyObject value) {
        if (value instanceof RubyArray) {
            return value;
        }
        if (value.respondsTo("to_ary")) {
            return TypeConverter.convertToType((IRubyObject)value, (RubyClass)value.getRuntime().getArray(), (String)"to_ary", (boolean)false);
        }
        return value.getRuntime().newArray(value);
    }

    public static IRubyObject aValueSplat(IRubyObject value) {
        if (!(value instanceof RubyArray) || ((RubyArray)value).length().getLongValue() == 0L) {
            return value.getRuntime().getNil();
        }
        RubyArray array = (RubyArray)value;
        return array.getLength() == 1 ? array.first() : array;
    }

    public static IRubyObject aValueSplat19(IRubyObject value) {
        if (!(value instanceof RubyArray)) {
            return value.getRuntime().getNil();
        }
        return (RubyArray)value;
    }

    public static RubyArray splatValue(IRubyObject value) {
        if (value.isNil()) {
            return value.getRuntime().newArray(value);
        }
        return Helpers.arrayValue(value);
    }

    public static RubyArray splatValue19(IRubyObject value) {
        if (value.isNil()) {
            return value.getRuntime().newEmptyArray();
        }
        return Helpers.arrayValue(value);
    }

    public static IRubyObject unsplatValue19(IRubyObject argsResult) {
        IRubyObject newResult;
        RubyArray array;
        if (argsResult instanceof RubyArray && (array = (RubyArray)argsResult).size() == 1 && (!((newResult = array.eltInternal(0)) instanceof RubyArray) || ((RubyArray)newResult).size() != 0)) {
            argsResult = newResult;
        }
        return argsResult;
    }

    @Deprecated
    public static IRubyObject[] splatToArguments(IRubyObject value) {
        return Helpers.splatToArgumentsCommon(value.getRuntime(), value);
    }

    @Deprecated
    public static IRubyObject[] splatToArguments19(IRubyObject value) {
        if (value.isNil()) {
            return IRubyObject.NULL_ARRAY;
        }
        return Helpers.splatToArgumentsCommon(value.getRuntime(), value);
    }

    private static IRubyObject[] splatToArgumentsCommon(Ruby runtime, IRubyObject value) {
        if (value.isNil()) {
            return runtime.getSingleNilArray();
        }
        IRubyObject tmp = value.checkArrayType();
        if (tmp.isNil()) {
            return Helpers.convertSplatToJavaArray(runtime, value);
        }
        return ((RubyArray)tmp).toJavaArrayMaybeUnsafe();
    }

    private static IRubyObject[] convertSplatToJavaArray(Ruby runtime, IRubyObject value) {
        RubyClass metaClass = value.getMetaClass();
        DynamicMethod method = metaClass.searchMethod("to_a");
        if (method.isUndefined() || method.isImplementedBy(runtime.getKernel())) {
            return new IRubyObject[]{value};
        }
        IRubyObject avalue = method.call(runtime.getCurrentContext(), value, (RubyModule)metaClass, "to_a");
        if (!(avalue instanceof RubyArray)) {
            if (avalue.isNil()) {
                return new IRubyObject[]{value};
            }
            throw runtime.newTypeError("`to_a' did not return Array");
        }
        return ((RubyArray)avalue).toJavaArray();
    }

    @Deprecated
    public static IRubyObject[] argsCatToArguments(IRubyObject[] args, IRubyObject cat) {
        IRubyObject[] ary = Helpers.splatToArguments(cat);
        return Helpers.argsCatToArgumentsCommon(args, ary);
    }

    @Deprecated
    public static IRubyObject[] argsCatToArguments19(IRubyObject[] args, IRubyObject cat) {
        IRubyObject[] ary = Helpers.splatToArguments19(cat);
        return Helpers.argsCatToArgumentsCommon(args, ary);
    }

    private static IRubyObject[] argsCatToArgumentsCommon(IRubyObject[] args, IRubyObject[] ary) {
        if (ary.length > 0) {
            IRubyObject[] newArgs = new IRubyObject[args.length + ary.length];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            System.arraycopy(ary, 0, newArgs, args.length, ary.length);
            args = newArgs;
        }
        return args;
    }

    public static RubySymbol addInstanceMethod(RubyModule containingClass, String name, DynamicMethod method, Visibility visibility, ThreadContext context, Ruby runtime) {
        containingClass.addMethod(name, method);
        RubySymbol sym = runtime.fastNewSymbol(name);
        if (visibility == Visibility.MODULE_FUNCTION) {
            Helpers.addModuleMethod(containingClass, name, method, context, sym);
        }
        if (!containingClass.isRefinement()) {
            Helpers.callNormalMethodHook(containingClass, context, sym);
        }
        return sym;
    }

    private static void addModuleMethod(RubyModule containingClass, String name, DynamicMethod method, ThreadContext context, RubySymbol sym) {
        DynamicMethod singletonMethod = method.dup();
        singletonMethod.setImplementationClass((RubyModule)containingClass.getSingletonClass());
        singletonMethod.setVisibility(Visibility.PUBLIC);
        containingClass.getSingletonClass().addMethod(name, singletonMethod);
        containingClass.callMethod(context, "singleton_method_added", (IRubyObject)sym);
    }

    private static void callNormalMethodHook(RubyModule containingClass, ThreadContext context, RubySymbol name) {
        if (containingClass.isSingleton()) {
            Helpers.callSingletonMethodHook(((MetaClass)containingClass).getAttached(), context, name);
        } else {
            containingClass.callMethod(context, "method_added", (IRubyObject)name);
        }
    }

    private static void callSingletonMethodHook(IRubyObject receiver, ThreadContext context, RubySymbol name) {
        receiver.callMethod(context, "singleton_method_added", (IRubyObject)name);
    }

    public static String encodeScope(StaticScope scope) {
        StringBuilder namesBuilder = new StringBuilder(scope.getType().name());
        namesBuilder.append(',');
        boolean first = true;
        for (String name : scope.getVariables()) {
            if (!first) {
                namesBuilder.append(';');
            }
            first = false;
            namesBuilder.append(name);
        }
        namesBuilder.append(',').append(scope.getSignature().encode());
        namesBuilder.append(',').append(scope.getScopeType());
        return namesBuilder.toString();
    }

    public static StaticScope decodeScope(StaticScopeFactory staticScopeFactory, ThreadContext context, StaticScope parent, String scopeString) {
        String[][] decodedScope = Helpers.decodeScopeDescriptor(scopeString);
        String scopeTypeName = decodedScope[0][0];
        String[] names = decodedScope[1];
        StaticScope scope = null;
        switch (StaticScope.Type.valueOf(scopeTypeName)) {
            case BLOCK: {
                scope = staticScopeFactory.newBlockScope(parent, names);
                break;
            }
            case EVAL: {
                scope = staticScopeFactory.newEvalScope(parent, names);
                break;
            }
            case LOCAL: {
                scope = staticScopeFactory.newLocalScope(parent, names);
            }
        }
        Helpers.setAritiesFromDecodedScope(scope, decodedScope[0][2]);
        scope.setScopeType(IRScopeType.valueOf((String)decodedScope[0][3]));
        return scope;
    }

    private static String[][] decodeScopeDescriptor(String scopeString) {
        String[] scopeElements = scopeString.split(",");
        String[] scopeNames = scopeElements[1].length() == 0 ? StringSupport.EMPTY_STRING_ARRAY : Helpers.getScopeNames(scopeElements[1]);
        return new String[][]{scopeElements, scopeNames};
    }

    private static void setAritiesFromDecodedScope(StaticScope scope, String encodedSignature) {
        scope.setSignature(Signature.decode(Long.parseLong(encodedSignature)));
    }

    public static StaticScope decodeScopeAndDetermineModule(StaticScopeFactory staticScopeFactory, ThreadContext context, StaticScope parent, String scopeString) {
        StaticScope scope = Helpers.decodeScope(staticScopeFactory, context, parent, scopeString);
        scope.determineModule();
        return scope;
    }

    public static Visibility performNormalMethodChecksAndDetermineVisibility(Ruby runtime, RubyModule clazz, String name, Visibility visibility) throws RaiseException {
        if (clazz == runtime.getDummy()) {
            throw runtime.newTypeError("no class/module to add method");
        }
        if (clazz == runtime.getObject() && "initialize".equals(name)) {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop");
        }
        if ("__id__".equals(name) || "__send__".equals(name)) {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + name + "' may cause serious problem");
        }
        if ("initialize".equals(name) || "initialize_copy".equals(name) || name.equals("initialize_dup") || name.equals("initialize_clone") || name.equals("respond_to_missing?") || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        return visibility;
    }

    public static RubyClass performSingletonMethodChecks(Ruby runtime, IRubyObject receiver, String name) throws RaiseException {
        if (receiver instanceof RubyFixnum || receiver instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton method \"" + name + "\" for " + receiver.getMetaClass().getBaseName());
        }
        if (receiver.isFrozen()) {
            throw runtime.newFrozenError("object");
        }
        RubyClass rubyClass = receiver.getSingletonClass();
        return rubyClass;
    }

    public static IRubyObject arrayEntryOrNil(RubyArray array, int index) {
        if (index < array.getLength()) {
            return array.eltInternal(index);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilZero(RubyArray array) {
        if (0 < array.getLength()) {
            return array.eltInternal(0);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilOne(RubyArray array) {
        if (1 < array.getLength()) {
            return array.eltInternal(1);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilTwo(RubyArray array) {
        if (2 < array.getLength()) {
            return array.eltInternal(2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNil(RubyArray array, int pre, int post, int index) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + index);
        }
        if (pre + index < array.getLength()) {
            return array.eltInternal(pre + index);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilZero(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 0);
        }
        if (pre + 0 < array.getLength()) {
            return array.eltInternal(pre + 0);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilOne(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 1);
        }
        if (pre + 1 < array.getLength()) {
            return array.eltInternal(pre + 1);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilTwo(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 2);
        }
        if (pre + 2 < array.getLength()) {
            return array.eltInternal(pre + 2);
        }
        return array.getRuntime().getNil();
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime, int index) {
        if (index < array.getLength()) {
            return Helpers.createSubarray(array, index);
        }
        return RubyArray.newEmptyArray((Ruby)runtime);
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime, int index, int post) {
        if (index + post < array.getLength()) {
            return Helpers.createSubarray(array, index, post);
        }
        return RubyArray.newEmptyArray((Ruby)runtime);
    }

    public static RubyModule checkIsModule(IRubyObject maybeModule) {
        if (maybeModule instanceof RubyModule) {
            return (RubyModule)maybeModule;
        }
        throw maybeModule.getRuntime().newTypeError(maybeModule + " is not a class/module");
    }

    public static IRubyObject getGlobalVariable(Ruby runtime, String name) {
        return runtime.getGlobalVariables().get(name);
    }

    public static IRubyObject setGlobalVariable(IRubyObject value, Ruby runtime, String name) {
        return runtime.getGlobalVariables().set(name, value);
    }

    public static IRubyObject getInstanceVariable(IRubyObject self, Ruby runtime, String internedName) {
        IRubyObject result = self.getInstanceVariables().getInstanceVariable(internedName);
        if (result != null) {
            return result;
        }
        if (runtime.isVerbose()) {
            Helpers.warnAboutUninitializedIvar(runtime, internedName);
        }
        return runtime.getNil();
    }

    public static IRubyObject getInstanceVariableNoWarn(IRubyObject self, ThreadContext context, String internedName) {
        IRubyObject result = self.getInstanceVariables().getInstanceVariable(internedName);
        if (result != null) {
            return result;
        }
        return context.nil;
    }

    private static void warnAboutUninitializedIvar(Ruby runtime, String internedName) {
        runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + internedName + " not initialized");
    }

    public static IRubyObject setInstanceVariable(IRubyObject value, IRubyObject self, String name) {
        return self.getInstanceVariables().setInstanceVariable(name, value);
    }

    public static RubyProc newLiteralLambda(ThreadContext context, Block block, IRubyObject self) {
        return RubyProc.newProc((Ruby)context.runtime, (Block)block, (Block.Type)Block.Type.LAMBDA);
    }

    public static void fillNil(IRubyObject[] arr, int from, int to, Ruby runtime) {
        if (arr.length == 0) {
            return;
        }
        Object[] nils = runtime.getNilPrefilledArray();
        int i = from;
        while (i + 128 < to) {
            System.arraycopy(nils, 0, arr, i, 128);
            i += 128;
        }
        ArraySupport.copy((Object[])nils, (Object[])arr, (int)i, (int)(to - i));
    }

    public static void fillNil(IRubyObject[] arr, Ruby runtime) {
        Helpers.fillNil(arr, 0, arr.length, runtime);
    }

    public static boolean isFastSwitchableString(IRubyObject str) {
        return str instanceof RubyString;
    }

    public static boolean isFastSwitchableSingleCharString(IRubyObject str) {
        return str instanceof RubyString && ((RubyString)str).getByteList().length() == 1;
    }

    public static int getFastSwitchString(IRubyObject str) {
        ByteList byteList = ((RubyString)str).getByteList();
        return byteList.hashCode();
    }

    public static int getFastSwitchSingleCharString(IRubyObject str) {
        ByteList byteList = ((RubyString)str).getByteList();
        return byteList.get(0);
    }

    public static boolean isFastSwitchableSymbol(IRubyObject sym) {
        return sym instanceof RubySymbol;
    }

    public static boolean isFastSwitchableSingleCharSymbol(IRubyObject sym) {
        return sym instanceof RubySymbol && ((RubySymbol)sym).asJavaString().length() == 1;
    }

    public static int getFastSwitchSymbol(IRubyObject sym) {
        String str = ((RubySymbol)sym).asJavaString();
        return str.hashCode();
    }

    public static int getFastSwitchSingleCharSymbol(IRubyObject sym) {
        String str = ((RubySymbol)sym).asJavaString();
        return str.charAt(0);
    }

    public static Block getBlock(ThreadContext context, IRubyObject self, ParseNode node) {
        throw new RuntimeException("Should not be called");
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, ParseNode node, Block aBlock) {
        throw new RuntimeException("Should not be called");
    }

    public static RubyBoolean rbEqual(ThreadContext context, IRubyObject a, IRubyObject b) {
        Ruby runtime = context.runtime;
        if (a == b) {
            return runtime.getTrue();
        }
        IRubyObject res = Helpers.invokedynamic(context, a, MethodNames.OP_EQUAL, b);
        return runtime.newBoolean(res.isTrue());
    }

    public static RubyBoolean rbEql(ThreadContext context, IRubyObject a, IRubyObject b) {
        Ruby runtime = context.runtime;
        if (a == b) {
            return runtime.getTrue();
        }
        IRubyObject res = Helpers.invokedynamic(context, a, MethodNames.EQL, b);
        return runtime.newBoolean(res.isTrue());
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args, int min, int max) {
        Helpers.checkArgumentCount(context, args.length, min, max);
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args, int req) {
        Helpers.checkArgumentCount(context, args.length, req, req);
    }

    public static void checkArgumentCount(ThreadContext context, int length, int min, int max) {
        int expected = 0;
        if (length < min) {
            expected = min;
        } else if (max > -1 && length > max) {
            expected = max;
        } else {
            return;
        }
        throw context.runtime.newArgumentError(length, expected);
    }

    public static boolean isModuleAndHasConstant(IRubyObject left, String name) {
        return left instanceof RubyModule && ((RubyModule)left).getConstantFromNoConstMissing(name, false) != null;
    }

    public static RubyString getDefinedConstantOrBoundMethod(IRubyObject left, String name) {
        if (Helpers.isModuleAndHasConstant(left, name)) {
            return left.getRuntime().getDefinedMessage(DefinedMessage.CONSTANT);
        }
        if (left.getMetaClass().isMethodBound(name, true)) {
            return left.getRuntime().getDefinedMessage(DefinedMessage.METHOD);
        }
        return null;
    }

    public static RubyModule getSuperClassForDefined(Ruby runtime, RubyModule klazz) {
        RubyClass superklazz = klazz.getSuperClass();
        if (superklazz == null && klazz.isModule()) {
            superklazz = runtime.getObject();
        }
        return superklazz;
    }

    public static boolean isGenerationEqual(IRubyObject object, int generation) {
        RubyClass metaClass = object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
        return metaClass.getGeneration() == generation;
    }

    public static String[] getScopeNames(String scopeNames) {
        StringTokenizer toker = new StringTokenizer(scopeNames, ";");
        ArrayList<String> list = new ArrayList<String>(10);
        while (toker.hasMoreTokens()) {
            list.add(toker.nextToken().intern());
        }
        return list.toArray(new String[list.size()]);
    }

    public static RubyClass metaclass(IRubyObject object) {
        return object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
    }

    public static String rawBytesToString(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return new String(chars);
    }

    public static byte[] stringToRawBytes(String string) {
        char[] chars = string.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static String encodeCaptureOffsets(int[] scopeOffsets) {
        char[] encoded = new char[scopeOffsets.length * 2];
        for (int i = 0; i < scopeOffsets.length; ++i) {
            int offDepth = scopeOffsets[i];
            char off = (char)(offDepth & 0xFFFF);
            char depth = (char)(offDepth >> 16);
            encoded[2 * i] = off;
            encoded[2 * i + 1] = depth;
        }
        return new String(encoded);
    }

    public static int[] decodeCaptureOffsets(String encoded) {
        char[] chars = encoded.toCharArray();
        int[] scopeOffsets = new int[chars.length / 2];
        for (int i = 0; i < scopeOffsets.length; ++i) {
            char off = chars[2 * i];
            char depth = chars[2 * i + 1];
            scopeOffsets[i] = depth << 16 | off;
        }
        return scopeOffsets;
    }

    public static IRubyObject match2AndUpdateScope(IRubyObject receiver, ThreadContext context, IRubyObject value, String scopeOffsets) {
        IRubyObject match = ((RubyRegexp)receiver).op_match(context, value);
        Helpers.updateScopeWithCaptures(context, Helpers.decodeCaptureOffsets(scopeOffsets), match);
        return match;
    }

    public static IRubyObject match2AndUpdateScope19(IRubyObject receiver, ThreadContext context, IRubyObject value, String scopeOffsets) {
        IRubyObject match = ((RubyRegexp)receiver).op_match19(context, value);
        Helpers.updateScopeWithCaptures(context, Helpers.decodeCaptureOffsets(scopeOffsets), match);
        return match;
    }

    public static void updateScopeWithCaptures(ThreadContext context, int[] scopeOffsets, IRubyObject result) {
        Ruby runtime = context.runtime;
        if (result.isNil()) {
            IRubyObject nil = runtime.getNil();
            for (int i = 0; i < scopeOffsets.length; ++i) {
                context.getCurrentScope().setValue(nil, scopeOffsets[i], 0);
            }
        } else {
            RubyMatchData matchData = (RubyMatchData)context.getBackRef();
            IRubyObject[] namedValues = matchData.getNamedBackrefValues(runtime);
            for (int i = 0; i < scopeOffsets.length; ++i) {
                context.getCurrentScope().setValue(namedValues[i], scopeOffsets[i] & 0xFFFF, scopeOffsets[i] >> 16);
            }
        }
    }

    public static RubyArray argsPush(ThreadContext context, RubyArray first, IRubyObject second) {
        return ((RubyArray)first.dup()).append(second);
    }

    @Deprecated
    public static RubyArray argsPush(RubyArray first, IRubyObject second) {
        return Helpers.argsPush(first.getRuntime().getCurrentContext(), first, second);
    }

    public static RubyArray argsCat(ThreadContext context, IRubyObject first, IRubyObject second) {
        RubyArray secondArgs = IRRuntimeHelpers.irSplat((ThreadContext)context, (IRubyObject)second);
        return ((RubyArray)Helpers.ensureRubyArray(context.runtime, first).dup()).concat((IRubyObject)secondArgs);
    }

    @Deprecated
    public static RubyArray argsCat(IRubyObject first, IRubyObject second) {
        return Helpers.argsCat(first.getRuntime().getCurrentContext(), first, second);
    }

    public static ArgumentDescriptor[] argsNodeToArgumentDescriptors(ArgsParseNode argsNode) {
        int keywordsCount;
        int postCount;
        ArgumentParseNode restArg;
        int optCount;
        ArrayList<ArgumentDescriptor> descs = new ArrayList<ArgumentDescriptor>();
        ParseNode[] args = argsNode.getArgs();
        int preCount = argsNode.getPreCount();
        if (preCount > 0) {
            for (int i = 0; i < preCount; ++i) {
                if (args[i] instanceof MultipleAsgnParseNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonreq));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.req, ((ArgumentParseNode)args[i]).getName()));
            }
        }
        if ((optCount = argsNode.getOptionalArgsCount()) > 0) {
            int optIndex = argsNode.getOptArgIndex();
            for (int i = 0; i < optCount; ++i) {
                ArgumentType type = ArgumentType.opt;
                ParseNode optNode = args[optIndex + i];
                String name = null;
                if (optNode instanceof OptArgParseNode) {
                    name = ((OptArgParseNode)optNode).getName();
                } else if (optNode instanceof LocalAsgnParseNode) {
                    name = ((LocalAsgnParseNode)optNode).getName();
                } else if (optNode instanceof DAsgnParseNode) {
                    name = ((DAsgnParseNode)optNode).getName();
                } else {
                    type = ArgumentType.anonopt;
                }
                descs.add(new ArgumentDescriptor(type, name));
            }
        }
        if ((restArg = argsNode.getRestArgNode()) != null) {
            if (restArg instanceof UnnamedRestArgParseNode) {
                if (((UnnamedRestArgParseNode)restArg).isStar()) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonrest));
                }
            } else {
                descs.add(new ArgumentDescriptor(ArgumentType.rest, restArg.getName()));
            }
        }
        if ((postCount = argsNode.getPostCount()) > 0) {
            int postIndex = argsNode.getPostIndex();
            for (int i = 0; i < postCount; ++i) {
                ParseNode postNode = args[postIndex + i];
                if (postNode instanceof MultipleAsgnParseNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonreq));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.req, ((ArgumentParseNode)postNode).getName()));
            }
        }
        if ((keywordsCount = argsNode.getKeywordCount()) > 0) {
            int keywordsIndex = argsNode.getKeywordsIndex();
            for (int i = 0; i < keywordsCount; ++i) {
                ParseNode keyWordNode = args[keywordsIndex + i];
                for (ParseNode asgnNode : keyWordNode.childNodes()) {
                    if (Helpers.isRequiredKeywordArgumentValueNode(asgnNode)) {
                        descs.add(new ArgumentDescriptor(ArgumentType.keyreq, ((INameNode)((Object)asgnNode)).getName()));
                        continue;
                    }
                    descs.add(new ArgumentDescriptor(ArgumentType.key, ((INameNode)((Object)asgnNode)).getName()));
                }
            }
        }
        if (argsNode.getKeyRest() != null) {
            String argName = argsNode.getKeyRest().getName();
            if (argName == null || argName.length() == 0) {
                descs.add(new ArgumentDescriptor(ArgumentType.anonkeyrest, argName));
            } else {
                descs.add(new ArgumentDescriptor(ArgumentType.keyrest, argsNode.getKeyRest().getName()));
            }
        }
        if (argsNode.getBlock() != null) {
            descs.add(new ArgumentDescriptor(ArgumentType.block, argsNode.getBlock().getName()));
        }
        return descs.toArray(new ArgumentDescriptor[descs.size()]);
    }

    public static ArgumentDescriptor[] parameterListToArgumentDescriptors(String[] parameterList, boolean isLambda) {
        String param;
        ArgumentDescriptor[] parms = new ArgumentDescriptor[parameterList.length];
        for (int i = 0; i < parameterList.length && !(param = parameterList[i]).equals("NONE"); ++i) {
            ArgumentType type;
            if (param.equals("nil")) {
                param = "n";
            }
            if ((type = ArgumentType.valueOf((char)param.charAt(0))) == ArgumentType.req && !isLambda) {
                type = ArgumentType.opt;
            }
            parms[i] = param.length() > 1 ? new ArgumentDescriptor(type, param.substring(1)) : new ArgumentDescriptor(type.anonymousForm());
        }
        return parms;
    }

    public static RubyArray argumentDescriptorsToParameters(Ruby runtime, ArgumentDescriptor[] argsDesc, boolean isLambda) {
        if (argsDesc == null) {
            Thread.dumpStack();
        }
        RubyArray params = RubyArray.newBlankArray((Ruby)runtime, (int)argsDesc.length);
        for (int i = 0; i < argsDesc.length; ++i) {
            ArgumentDescriptor param = argsDesc[i];
            params.store((long)i, (IRubyObject)param.toArrayForm(runtime, isLambda));
        }
        return params;
    }

    public static ArgumentDescriptor[] methodToArgumentDescriptors(DynamicMethod method) {
        if ((method = method.getRealMethod()) instanceof MethodArgs2) {
            return Helpers.parameterListToArgumentDescriptors(((MethodArgs2)method).getParameterList(), true);
        }
        if (method instanceof IRMethodArgs) {
            return ((IRMethodArgs)method).getArgumentDescriptors();
        }
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ArgumentType.anonrest)};
    }

    public static IRubyObject methodToParameters(Ruby runtime, AbstractRubyMethod recv) {
        DynamicMethod method = recv.getMethod().getRealMethod();
        return Helpers.argumentDescriptorsToParameters(runtime, Helpers.methodToArgumentDescriptors(method), true);
    }

    public static RubyString getDefinedCall(ThreadContext context, IRubyObject self, IRubyObject receiver, String name) {
        RubyClass metaClass = receiver.getMetaClass();
        DynamicMethod method = metaClass.searchMethod(name);
        Visibility visibility = method.getVisibility();
        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self)) && !method.isUndefined()) {
            return context.runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        if (receiver.callMethod(context, "respond_to_missing?", new IRubyObject[]{context.runtime.newSymbol(name), context.runtime.getFalse()}).isTrue()) {
            return context.runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        return null;
    }

    public static RubyString getDefinedNot(Ruby runtime, RubyString definition) {
        if (definition != null) {
            return runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        return definition;
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self, MethodNames method) {
        RubyClass metaclass = self.getMetaClass();
        String name = method.realName();
        return Helpers.getMethodCached(context, metaclass, method.ordinal(), name).call(context, self, (RubyModule)metaclass, name);
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self, MethodNames method, IRubyObject arg0) {
        RubyClass metaclass = self.getMetaClass();
        String name = method.realName();
        return Helpers.getMethodCached(context, metaclass, method.ordinal(), name).call(context, self, (RubyModule)metaclass, name, arg0);
    }

    private static DynamicMethod getMethodCached(ThreadContext context, RubyClass metaclass, int index, String name) {
        if (metaclass.getClassIndex() == ClassIndex.NO_INDEX) {
            return metaclass.searchMethod(name);
        }
        return context.runtimeCache.getMethod(context, metaclass, metaclass.getClassIndex().ordinal() * (index + 1), name);
    }

    public static IRubyObject lastElement(IRubyObject[] ary) {
        return ary[ary.length - 1];
    }

    public static RubyString appendAsString(RubyString target, IRubyObject other) {
        return target.append((IRubyObject)other.asString());
    }

    public static RubyString appendAsString19(RubyString target, IRubyObject other) {
        return target.append19((IRubyObject)other.asString());
    }

    public static boolean needsSplat19(int requiredCount, boolean isRest) {
        return isRest && requiredCount > 0 || !isRest && requiredCount > 1;
    }

    public static boolean BEQ(ThreadContext context, IRubyObject value1, IRubyObject value2) {
        return value1.op_equal(context, value2).isTrue();
    }

    public static boolean BNE(ThreadContext context, IRubyObject value1, IRubyObject value2) {
        boolean eql = value2 == context.nil || value2 == UndefinedValue.UNDEFINED ? value1 == value2 : value1.op_equal(context, value2).isTrue();
        return !eql;
    }

    public static RubyModule checkIsRubyModule(ThreadContext context, Object object) {
        if (!(object instanceof RubyModule)) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        return (RubyModule)object;
    }

    public static RubyClass newClassForIR(ThreadContext context, String name, IRubyObject self, RubyModule classContainer, Object superClass, boolean meta) {
        if (meta) {
            return classContainer.getMetaClass();
        }
        RubyClass sc = null;
        if (superClass == UndefinedValue.UNDEFINED) {
            sc = null;
        } else if (superClass != null) {
            RubyClass.checkInheritable((IRubyObject)((IRubyObject)superClass));
            sc = (RubyClass)superClass;
        }
        return classContainer.defineOrGetClassUnder(name, sc);
    }

    public static RubyString appendByteList(RubyString target, ByteList source) {
        target.getByteList().append(source);
        return target;
    }

    public static RubyString appendByteList19(RubyString target, ByteList source, int codeRange) {
        target.cat19(source, codeRange);
        return target;
    }

    public static RubyString shortcutAppend18(RubyString string, IRubyObject object) {
        if (object instanceof RubyFixnum || object instanceof RubyFloat || object instanceof RubySymbol) {
            return string.append(object);
        }
        return string.append((IRubyObject)object.asString());
    }

    public static RubyString shortcutAppend(RubyString string, IRubyObject object) {
        if (object instanceof RubyFixnum || object instanceof RubyFloat || object instanceof RubySymbol) {
            return string.append19(object);
        }
        return string.append19((IRubyObject)object.asString());
    }

    public static void irCheckArgsArrayArity(ThreadContext context, RubyArray args, int required, int opt, boolean rest) {
        int numArgs = args.size();
        if (numArgs < required || !rest && numArgs > required + opt) {
            Arity.raiseArgumentError((Ruby)context.runtime, (int)numArgs, (int)required, (int)(required + opt));
        }
    }

    @Deprecated
    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self, int index) {
        return Helpers.invokedynamic(context, self, MethodNames.values()[index]);
    }

    @Deprecated
    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self, int index, IRubyObject arg0) {
        return Helpers.invokedynamic(context, self, MethodNames.values()[index], arg0);
    }

    public static void throwException(Throwable e) {
        Helpers.throwsUnchecked(e);
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable e) throws T {
        throw e;
    }

    public static String symbolBytesToString(ByteList value) {
        Encoding encoding = value.getEncoding();
        if (encoding == USASCIIEncoding.INSTANCE || encoding == ASCIIEncoding.INSTANCE) {
            return value.toString();
        }
        if (encoding instanceof UnicodeEncoding) {
            return new String(value.getUnsafeBytes(), value.getBegin(), value.getRealSize(), value.getEncoding().getCharset());
        }
        return value.toString();
    }

    public static String decodeByteList(Ruby runtime, ByteList value) {
        byte[] unsafeBytes = value.getUnsafeBytes();
        int begin = value.getBegin();
        int length = value.length();
        Encoding encoding = value.getEncoding();
        if (encoding == UTF8Encoding.INSTANCE) {
            return RubyEncoding.decodeUTF8((byte[])unsafeBytes, (int)begin, (int)length);
        }
        Charset charset = runtime.getEncodingService().charsetForEncoding(encoding);
        if (charset == null) {
            Encoding utf16 = EncodingUtils.getUTF16ForPlatform();
            return EncodingUtils.strConvEnc((ThreadContext)runtime.getCurrentContext(), (ByteList)value, (Encoding)value.getEncoding(), (Encoding)utf16).toString();
        }
        return RubyEncoding.decode((byte[])unsafeBytes, (int)begin, (int)length, (Charset)charset);
    }

    public static String byteListToString(ByteList bytes) {
        Charset charset = bytes.getEncoding().getCharset();
        if (charset != null) {
            return new String(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getRealSize(), charset);
        }
        return bytes.toString();
    }

    public static IRubyObject rewriteStackTraceAndThrow(ThreadContext context, Throwable t) {
        Ruby runtime = context.runtime;
        StackTraceElement[] javaTrace = t.getStackTrace();
        BacktraceData backtraceData = runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(context, javaTrace);
        t.setStackTrace(RaiseException.javaTraceFromRubyTrace((RubyStackTraceElement[])backtraceData.getBacktrace(runtime)));
        Helpers.throwException(t);
        return null;
    }

    public static void rewriteStackTrace(Ruby runtime, Throwable e) {
        StackTraceElement[] javaTrace = e.getStackTrace();
        BacktraceData backtraceData = runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(runtime.getCurrentContext(), javaTrace);
        e.setStackTrace(RaiseException.javaTraceFromRubyTrace((RubyStackTraceElement[])backtraceData.getBacktrace(runtime)));
    }

    public static String stringJoin(String delimiter, String[] strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            sb.append(delimiter).append(strings[i]);
        }
        return sb.toString();
    }

    public static <T> T[] arrayOf(T ... values) {
        return values;
    }

    public static <T> T[] arrayOf(Class<T> t, int size, T fill) {
        Object[] ary = (Object[])Array.newInstance(t, size);
        Arrays.fill(ary, fill);
        return ary;
    }

    public static int memchr(boolean[] ary, int start, int len, boolean find) {
        for (int i = 0; i < len; ++i) {
            if (ary[i + start] != find) continue;
            return i + start;
        }
        return -1;
    }

    public static boolean isRequiredKeywordArgumentValueNode(ParseNode asgnNode) {
        return asgnNode.childNodes().get(0) instanceof RequiredKeywordArgumentValueParseNode;
    }

    public static long hashStart(Ruby runtime, long value) {
        long hash = value + (runtime.isSiphashEnabled() ? runtime.getHashSeedK1() : runtime.getHashSeedK0());
        return hash;
    }

    public static long hashEnd(long value) {
        value = Helpers.murmur_step(value, 10L);
        value = Helpers.murmur_step(value, 17L);
        return value;
    }

    public static RubyFixnum safeHash(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        IRubyObject hval = runtime.safeRecurse(Helpers.sites((ThreadContext)context).recursive_hash, context, (Object)runtime, obj, "hash", true);
        while (!(hval instanceof RubyFixnum)) {
            if (hval instanceof RubyBignum) {
                return ((RubyBignum)hval).hash();
            }
            hval = hval.convertToInteger();
        }
        return (RubyFixnum)hval;
    }

    public static long murmurCombine(long h, long i) {
        long v = 0L;
        v = Helpers.murmur1(v + (h += i));
        v = Helpers.murmur1(v + (h >>> 32));
        return v;
    }

    public static long murmur(long h, long k, int r) {
        long m = 1540483477L;
        h += k;
        h *= m;
        h ^= h >> r;
        return h;
    }

    public static long murmur_finish(long h) {
        h = Helpers.murmur(h, 0L, 10);
        h = Helpers.murmur(h, 0L, 17);
        return h;
    }

    public static long murmur_step(long h, long k) {
        return Helpers.murmur(h, k, 16);
    }

    public static long murmur1(long h) {
        return Helpers.murmur_step(h, 16L);
    }

    private static JavaSites.HelpersSites sites(ThreadContext context) {
        return context.sites.Helpers;
    }

    @Deprecated
    public static String encodeParameterList(List<String[]> args) {
        if (args.size() == 0) {
            return "NONE";
        }
        StringBuilder builder = new StringBuilder();
        boolean added = false;
        for (String[] desc : args) {
            if (added) {
                builder.append(';');
            }
            builder.append(desc[0]).append(desc[1]);
            added = true;
        }
        return builder.toString();
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject[] args, CallType callType, Block block) {
        return self.getMetaClass().invoke(context, self, name, args, callType, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg, CallType callType, Block block) {
        return self.getMetaClass().invoke(context, self, name, arg, callType, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name, CallType callType) {
        return Helpers.invoke(context, self, name, IRubyObject.NULL_ARRAY, callType, Block.NULL_BLOCK);
    }

    private static class MethodMissingMethod
    extends DynamicMethod {
        private final DynamicMethod delegate;
        private final CallType lastCallStatus;
        private final Visibility lastVisibility;

        public MethodMissingMethod(DynamicMethod delegate, Visibility lastVisibility, CallType lastCallStatus) {
            this.delegate = delegate;
            this.lastCallStatus = lastCallStatus;
            this.lastVisibility = lastVisibility;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            context.setLastCallStatusAndVisibility(this.lastCallStatus, this.lastVisibility);
            return this.delegate.call(context, self, clazz, "method_missing", Helpers.prepareMethodMissingArgs(args, context, name), block);
        }

        public DynamicMethod dup() {
            return this;
        }
    }
}

