// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _HLRAlgo_EdgeStatus_HeaderFile
#define _HLRAlgo_EdgeStatus_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Real.hxx>
#include <Standard_ShortReal.hxx>
#include <Standard_Boolean.hxx>
#include <Intrv_Intervals.hxx>
#include <Standard_Integer.hxx>
class Standard_OutOfRange;


//! This class describes the Hidden  Line status of an
//! Edge. It contains :
//!
//! The Bounds of the Edge and their tolerances
//!
//! Two flags indicating if the edge is full visible
//! or full hidden.
//!
//! The Sequence  of visible Intervals  on the Edge.
class HLRAlgo_EdgeStatus 
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT HLRAlgo_EdgeStatus();
  
  //! Creates a  new  EdgeStatus.  Default visible.  The
  //! Edge is   bounded by the  interval  <Start>, <End>
  //! with the tolerances <TolStart>, <TolEnd>.
  Standard_EXPORT HLRAlgo_EdgeStatus(const Standard_Real Start, const Standard_ShortReal TolStart, const Standard_Real End, const Standard_ShortReal TolEnd);
  
  //! Initialize  an  EdgeStatus.  Default visible.  The
  //! Edge is   bounded by the  interval  <Start>, <End>
  //! with the tolerances <TolStart>, <TolEnd>.
  Standard_EXPORT   void Initialize (const Standard_Real Start, const Standard_ShortReal TolStart, const Standard_Real End, const Standard_ShortReal TolEnd) ;
  
      void Bounds (Standard_Real& Start, Standard_ShortReal& TolStart, Standard_Real& End, Standard_ShortReal& TolEnd)  const;
  
  Standard_EXPORT   Standard_Integer NbVisiblePart()  const;
  
  Standard_EXPORT   void VisiblePart (const Standard_Integer Index, Standard_Real& Start, Standard_ShortReal& TolStart, Standard_Real& End, Standard_ShortReal& TolEnd)  const;
  
  //! Hides  the  interval  <Start>,    <End>   with the
  //! tolerances <TolStart>,  <TolEnd>. This interval is
  //! subtracted from the visible  parts.  If the hidden
  //! part is on ( or under ) the face the flag <OnFace>
  //! is True ( or False ).  If the hidden  part is on (
  //! or  inside  ) the boundary  of  the  face the flag
  //! <OnBoundary> is True ( or False ).
  Standard_EXPORT   void Hide (const Standard_Real Start, const Standard_ShortReal TolStart, const Standard_Real End, const Standard_ShortReal TolEnd, const Standard_Boolean OnFace, const Standard_Boolean OnBoundary) ;
  
  //! Hide the whole Edge.
      void HideAll() ;
  
  //! Show the whole Edge.
      void ShowAll() ;
  
      Standard_Boolean AllHidden()  const;
  
      void AllHidden (const Standard_Boolean B) ;
  
      Standard_Boolean AllVisible()  const;
  
      void AllVisible (const Standard_Boolean B) ;




protected:





private:



  Standard_Real myStart;
  Standard_Real myEnd;
  Standard_ShortReal myTolStart;
  Standard_ShortReal myTolEnd;
  Standard_Boolean myFlags;
  Intrv_Intervals myVisibles;


};


#include <HLRAlgo_EdgeStatus.lxx>





#endif // _HLRAlgo_EdgeStatus_HeaderFile
