/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.apache.commons.httpclient.URI;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.FileCopier;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.control.ZapRelease;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.autoupdate.AddOnDependencyChecker;
import org.zaproxy.zap.extension.autoupdate.AutoUpdateAPI;
import org.zaproxy.zap.extension.autoupdate.CheckForUpdateCallback;
import org.zaproxy.zap.extension.autoupdate.DownloadManager;
import org.zaproxy.zap.extension.autoupdate.Downloader;
import org.zaproxy.zap.extension.autoupdate.InvalidCfuUrlException;
import org.zaproxy.zap.extension.autoupdate.ManageAddOnsDialog;
import org.zaproxy.zap.extension.autoupdate.OptionsParamCheckForUpdates;
import org.zaproxy.zap.extension.autoupdate.UninstallationProgressDialogue;
import org.zaproxy.zap.extension.log4j.ExtensionLog4j;
import org.zaproxy.zap.utils.ZapXmlConfiguration;
import org.zaproxy.zap.view.ScanStatus;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionAutoUpdate
extends ExtensionAdaptor
implements CheckForUpdateCallback,
CommandLineListener {
    private static final String ZAP_VERSIONS_REL_XML_SHORT = "https://bit.ly/owaspzap-2-5-0";
    private static final String ZAP_VERSIONS_REL_XML_FULL = "https://raw.githubusercontent.com/zaproxy/zap-admin/master/ZapVersions-2.5.xml";
    private static final String ZAP_VERSIONS_DEV_XML_SHORT = "https://bit.ly/owaspzap-dev";
    private static final String ZAP_VERSIONS_DEV_XML_FULL = "https://raw.githubusercontent.com/zaproxy/zap-admin/master/ZapVersions-dev.xml";
    private static final String ZAP_VERSIONS_WEEKLY_XML_SHORT = "https://bit.ly/owaspzap-devw";
    private static final String VERSION_FILE_NAME = "ZapVersions.xml";
    private ZapMenuItem menuItemCheckUpdate = null;
    private ZapMenuItem menuItemLoadAddOn = null;
    private static final Logger logger = Logger.getLogger(ExtensionAutoUpdate.class);
    private HttpSender httpSender = null;
    private DownloadManager downloadManager = null;
    private ManageAddOnsDialog addonsDialog = null;
    private Thread downloadProgressThread = null;
    private Thread remoteCallThread = null;
    private ScanStatus scanStatus = null;
    private JButton addonsButton = null;
    private JButton outOfDateButton = null;
    private AddOnCollection latestVersionInfo = null;
    private AddOnCollection localVersionInfo = null;
    private AddOnCollection previousVersionInfo = null;
    private AutoUpdateAPI api = null;
    private boolean oldZapAlertAdded = false;
    private boolean noCfuAlertAdded = false;
    private List<Downloader> downloadFiles = new ArrayList<Downloader>();
    private static final int ARG_CFU_INSTALL_IDX = 0;
    private static final int ARG_CFU_INSTALL_ALL_IDX = 1;
    private static final int ARG_CFU_UNINSTALL_IDX = 2;
    private static final int ARG_CFU_UPDATE_IDX = 3;
    private static final int ARG_CFU_LIST_IDX = 4;
    private static final int[] ARG_IDXS = new int[]{0, 1, 2, 3, 4};
    private CommandLineArgument[] arguments = new CommandLineArgument[ARG_IDXS.length];

    public ExtensionAutoUpdate() {
        this.initialize();
    }

    private void initialize() {
        this.setName("ExtensionAutoUpdate");
        this.setOrder(1);
        this.downloadManager = new DownloadManager(Model.getSingleton().getOptionsParam().getConnectionParam());
        this.downloadManager.start();
        this.getPreviousVersionInfo();
    }

    @Override
    public void postInit() {
        switch (ZAP.getProcessType()) {
            case cmdline: 
            case daemon: 
            case zaas: {
                this.warnIfOutOfDate();
                break;
            }
        }
    }

    private ZapMenuItem getMenuItemCheckUpdate() {
        if (this.menuItemCheckUpdate == null) {
            this.menuItemCheckUpdate = new ZapMenuItem("cfu.help.menu.check", KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuItemCheckUpdate.setText(Constant.messages.getString("cfu.help.menu.check"));
            this.menuItemCheckUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionAutoUpdate.this.getAddOnsDialog().setVisible(true);
                    ExtensionAutoUpdate.this.getAddOnsDialog().checkForUpdates();
                }
            });
        }
        return this.menuItemCheckUpdate;
    }

    private ZapMenuItem getMenuItemLoadAddOn() {
        if (this.menuItemLoadAddOn == null) {
            this.menuItemLoadAddOn = new ZapMenuItem("cfu.file.menu.loadaddon", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuItemLoadAddOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JFileChooser jFileChooser = new JFileChooser(Model.getSingleton().getOptionsParam().getUserDirectory());
                        File file = null;
                        jFileChooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                return file.isFile() && file.getName().endsWith(".zap");
                            }

                            @Override
                            public String getDescription() {
                                return Constant.messages.getString("file.format.zap.addon");
                            }
                        });
                        int n = jFileChooser.showOpenDialog(View.getSingleton().getMainFrame());
                        if (n == 0) {
                            file = jFileChooser.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            ExtensionAutoUpdate.this.installLocalAddOn(file);
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            });
        }
        return this.menuItemLoadAddOn;
    }

    private void installLocalAddOn(File file) throws Exception {
        AddOn addOn;
        if (!AddOn.isAddOn(file)) {
            this.showWarningMessageInvalidAddOnFile();
            return;
        }
        try {
            addOn = new AddOn(file);
        }
        catch (Exception exception) {
            this.showWarningMessageInvalidAddOnFile();
            return;
        }
        if (!addOn.canLoadInCurrentVersion()) {
            this.showWarningMessageCantLoadAddOn(addOn);
            return;
        }
        AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(this.getLocalVersionInfo(), this.latestVersionInfo == null ? this.getLocalVersionInfo() : this.latestVersionInfo);
        AddOnDependencyChecker.AddOnChangesResult addOnChangesResult = addOnDependencyChecker.calculateInstallChanges(addOn);
        if (addOnChangesResult.getOldVersions().isEmpty() && addOnChangesResult.getUninstalls().isEmpty()) {
            AddOn.AddOnRunRequirements addOnRunRequirements = addOn.calculateRunRequirements(this.getLocalVersionInfo().getAddOns());
            if (!addOnRunRequirements.isRunnable() && !AddOnRunIssuesUtils.askConfirmationAddOnNotRunnable(Constant.messages.getString("cfu.warn.addOnNotRunnable.message"), Constant.messages.getString("cfu.warn.addOnNotRunnable.question"), this.getLocalVersionInfo(), addOn)) {
                return;
            }
            this.installLocalAddOn(addOn);
            return;
        }
        if (!addOnDependencyChecker.confirmInstallChanges(this.getView().getMainFrame(), addOnChangesResult)) {
            return;
        }
        addOnChangesResult.getInstalls().remove(addOn);
        this.processAddOnChanges(this.getView().getMainFrame(), addOnChangesResult);
        this.installLocalAddOn(addOn);
    }

    private void installLocalAddOn(AddOn addOn) {
        File file;
        try {
            file = ExtensionAutoUpdate.copyAddOnFileToLocalPluginFolder(addOn.getFile());
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            ExtensionAutoUpdate.showWarningMessageAddOnFileAlreadyExists(fileAlreadyExistsException.getFile(), fileAlreadyExistsException.getOtherFile());
            logger.warn((Object)"Unable to copy add-on, a file with the same name already exists.", (Throwable)fileAlreadyExistsException);
            return;
        }
        catch (IOException iOException) {
            ExtensionAutoUpdate.showWarningMessageUnableToCopyAddOnFile();
            logger.warn((Object)"Unable to copy add-on to local plugin folder.", (Throwable)iOException);
            return;
        }
        addOn.setFile(file);
        this.install(addOn);
    }

    private void showWarningMessageInvalidAddOnFile() {
        View.getSingleton().showWarningDialog(Constant.messages.getString("cfu.warn.invalidAddOn"));
    }

    private void showWarningMessageCantLoadAddOn(AddOn addOn) {
        String string = MessageFormat.format(Constant.messages.getString("cfu.warn.cantload"), addOn.getNotBeforeVersion(), addOn.getNotFromVersion());
        View.getSingleton().showWarningDialog(string);
    }

    private static File copyAddOnFileToLocalPluginFolder(File file) throws IOException {
        if (ExtensionAutoUpdate.isFileInLocalPluginFolder(file)) {
            return file;
        }
        File file2 = new File(Constant.FOLDER_LOCAL_PLUGIN, file.getName());
        if (file2.exists()) {
            throw new FileAlreadyExistsException(file.getAbsolutePath(), file2.getAbsolutePath(), "");
        }
        FileCopier fileCopier = new FileCopier();
        fileCopier.copy(file, file2);
        return file2;
    }

    private static boolean isFileInLocalPluginFolder(File file) {
        File file2 = new File(Constant.FOLDER_LOCAL_PLUGIN, file.getName());
        return file2.getAbsolutePath().equals(file.getAbsolutePath());
    }

    private static void showWarningMessageAddOnFileAlreadyExists(String string, String string2) {
        String string3 = MessageFormat.format(Constant.messages.getString("cfu.warn.addOnAlreadExists"), string, string2);
        View.getSingleton().showWarningDialog(string3);
    }

    private static void showWarningMessageUnableToCopyAddOnFile() {
        String string = new File(Constant.FOLDER_LOCAL_PLUGIN).getAbsolutePath();
        String string2 = MessageFormat.format(Constant.messages.getString("cfu.warn.unableToCopyAddOn"), string);
        View.getSingleton().showWarningDialog(string2);
    }

    private synchronized ManageAddOnsDialog getAddOnsDialog() {
        if (this.addonsDialog == null) {
            this.addonsDialog = new ManageAddOnsDialog(this, this.getCurrentVersion(), this.getLocalVersionInfo());
            if (this.previousVersionInfo != null) {
                this.addonsDialog.setPreviousVersionInfo(this.previousVersionInfo);
            }
            if (this.latestVersionInfo != null) {
                this.addonsDialog.setLatestVersionInfo(this.latestVersionInfo);
            }
        }
        return this.addonsDialog;
    }

    private void downloadFile(URL uRL, File file, long l, String string) {
        if (View.isInitialised()) {
            View.getSingleton().getOutputPanel().append(MessageFormat.format(Constant.messages.getString("cfu.output.downloading") + "\n", uRL.toString(), file.getAbsolutePath()));
        }
        this.downloadFiles.add(this.downloadManager.downloadFile(uRL, file, l, string));
        if (View.isInitialised()) {
            if (this.downloadProgressThread != null && !this.downloadProgressThread.isAlive()) {
                this.downloadProgressThread = null;
            }
            if (this.downloadProgressThread == null) {
                this.downloadProgressThread = new Thread(){

                    @Override
                    public void run() {
                        while (ExtensionAutoUpdate.this.downloadManager.getCurrentDownloadCount() > 0) {
                            ExtensionAutoUpdate.this.getScanStatus().setScanCount(ExtensionAutoUpdate.this.downloadManager.getCurrentDownloadCount());
                            if (ExtensionAutoUpdate.this.addonsDialog != null && ExtensionAutoUpdate.this.addonsDialog.isVisible()) {
                                ExtensionAutoUpdate.this.addonsDialog.showProgress();
                            }
                            try {
                                3.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (ExtensionAutoUpdate.this.addonsDialog != null) {
                            ExtensionAutoUpdate.this.addonsDialog.showProgress();
                        }
                        ExtensionAutoUpdate.this.getScanStatus().setScanCount(0);
                        ExtensionAutoUpdate.this.installNewExtensions();
                    }
                };
                this.downloadProgressThread.start();
            }
        }
    }

    public void installNewExtensions() {
        OptionsParamCheckForUpdates optionsParamCheckForUpdates = this.getModel().getOptionsParam().getCheckForUpdatesParam();
        ArrayList<Downloader> arrayList = new ArrayList<Downloader>();
        block4: for (Downloader downloader : this.downloadFiles) {
            if (downloader.getFinished() == null) continue;
            arrayList.add(downloader);
            try {
                Object object;
                Object object2;
                if (!downloader.isValidated()) {
                    logger.debug((Object)("Ignoring unvalidated download: " + downloader.getUrl()));
                    if (this.addonsDialog != null) {
                        this.addonsDialog.notifyAddOnDownloadFailed(downloader.getUrl().toString());
                        continue;
                    }
                    object2 = downloader.getUrl().toString();
                    object = this.latestVersionInfo.getAddOns().iterator();
                    while (object.hasNext()) {
                        AddOn addOn = (AddOn)object.next();
                        if (!((String)object2).equals(addOn.getUrl().toString())) continue;
                        addOn.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
                        continue block4;
                    }
                    continue;
                }
                if (!AddOn.isAddOn(downloader.getTargetFile())) continue;
                object2 = downloader.getTargetFile();
                if (!optionsParamCheckForUpdates.getDownloadDirectory().equals(downloader.getTargetFile().getParentFile())) {
                    try {
                        object2 = new File(optionsParamCheckForUpdates.getDownloadDirectory(), downloader.getTargetFile().getName());
                        logger.info((Object)("Moving downloaded add-on from " + downloader.getTargetFile().getAbsolutePath() + " to " + ((File)object2).getAbsolutePath()));
                        FileUtils.moveFile(downloader.getTargetFile(), (File)object2);
                    }
                    catch (Exception exception) {
                        if (!((File)object2).exists() && downloader.getTargetFile().exists()) {
                            logger.error((Object)("Failed to move downloaded add-on from " + downloader.getTargetFile().getAbsolutePath() + " to " + ((File)object2).getAbsolutePath() + " - left at original location"), (Throwable)exception);
                            object2 = downloader.getTargetFile();
                        }
                        logger.error((Object)("Failed to move downloaded add-on from " + downloader.getTargetFile().getAbsolutePath() + " to " + ((File)object2).getAbsolutePath() + " - skipping"), (Throwable)exception);
                        continue;
                    }
                }
                if (((AddOn)(object = new AddOn((File)object2))).canLoadInCurrentVersion()) {
                    this.install((AddOn)object);
                    continue;
                }
                logger.info((Object)("Cant load add-on " + ((AddOn)object).getName() + " Not before=" + ((AddOn)object).getNotBeforeVersion() + " Not from=" + ((AddOn)object).getNotFromVersion() + " Version=" + Constant.PROGRAM_VERSION));
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        for (Downloader downloader : arrayList) {
            this.downloadFiles.remove(downloader);
        }
    }

    public int getDownloadProgressPercent(URL uRL) throws Exception {
        return this.downloadManager.getProgressPercent(uRL);
    }

    public int getCurrentDownloadCount() {
        return this.downloadManager.getCurrentDownloadCount();
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addHelpMenuItem(this.getMenuItemCheckUpdate());
            extensionHook.getHookMenu().addFileMenuItem(this.getMenuItemLoadAddOn());
            View.getSingleton().addMainToolbarButton(this.getAddonsButton());
            View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.getScanStatus().getCountLabel());
        }
        extensionHook.addCommandLine(this.getCommandLineArguments());
        this.api = new AutoUpdateAPI(this);
        this.api.addApiOptions(this.getModel().getOptionsParam().getCheckForUpdatesParam());
        API.getInstance().registerApiImplementor(this.api);
    }

    private ScanStatus getScanStatus() {
        if (this.scanStatus == null) {
            this.scanStatus = new ScanStatus(new ImageIcon(ExtensionLog4j.class.getResource("/resource/icon/fugue/download.png")), Constant.messages.getString("cfu.downloads.icon.title"));
        }
        return this.scanStatus;
    }

    private JButton getAddonsButton() {
        if (this.addonsButton == null) {
            this.addonsButton = new JButton();
            this.addonsButton.setIcon(new ImageIcon(ExtensionAutoUpdate.class.getResource("/resource/icon/fugue/block.png")));
            this.addonsButton.setToolTipText(Constant.messages.getString("cfu.button.addons.browse"));
            this.addonsButton.setEnabled(true);
            this.addonsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionAutoUpdate.this.getAddOnsDialog().setVisible(true);
                }
            });
        }
        return this.addonsButton;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("autoupdate.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void destroy() {
        this.downloadManager.shutdown(true);
    }

    private HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 7);
        }
        return this.httpSender;
    }

    private int dayDiff(Date date, Date date2) {
        long l = date.getTime() - date2.getTime();
        return (int)(l / 86400000L);
    }

    public void alertIfNewVersions() {
        OptionsParamCheckForUpdates optionsParamCheckForUpdates = this.getModel().getOptionsParam().getCheckForUpdatesParam();
        if (View.isInitialised()) {
            if (optionsParamCheckForUpdates.isCheckOnStartUnset()) {
                int n = this.getView().showConfirmDialog(Constant.messages.getString("cfu.confirm.startCheck"));
                if (n == 0) {
                    optionsParamCheckForUpdates.setCheckOnStart(true);
                    optionsParamCheckForUpdates.setCheckAddonUpdates(true);
                    optionsParamCheckForUpdates.setDownloadNewRelease(true);
                } else {
                    optionsParamCheckForUpdates.setCheckOnStart(false);
                }
                try {
                    this.getModel().getOptionsParam().getConfig().save();
                }
                catch (ConfigurationException configurationException) {
                    logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                    this.getView().showWarningDialog(Constant.messages.getString("cfu.confirm.error"));
                    return;
                }
            }
            if (!optionsParamCheckForUpdates.isCheckOnStart()) {
                this.alertIfOutOfDate(false);
                return;
            }
        }
        if (!optionsParamCheckForUpdates.checkOnStart()) {
            File file;
            ZapRelease zapRelease;
            if (View.isInitialised() && this.getPreviousVersionInfo() != null && (zapRelease = this.getPreviousVersionInfo().getZapRelease()) != null && zapRelease.isNewerThan(this.getCurrentVersion()) && (file = new File(Constant.FOLDER_LOCAL_PLUGIN, zapRelease.getFileName())).exists() && file.length() >= zapRelease.getSize()) {
                this.promptToLaunchReleaseAndClose(zapRelease.getVersion(), file);
            }
            return;
        }
        this.getLatestVersionInfo(this);
    }

    private void warnIfOutOfDate() {
        OptionsParamCheckForUpdates optionsParamCheckForUpdates = this.getModel().getOptionsParam().getCheckForUpdatesParam();
        Date date = new Date();
        Date date2 = Constant.getReleaseCreateDate();
        if (date2 != null && this.dayDiff(date, date2) > 365) {
            if (ZAP.getProcessType().equals((Object)ZAP.ProcessType.cmdline)) {
                CommandLine.error("This ZAP installation is over a year old - its probably very out of date");
            } else {
                logger.warn((Object)"This ZAP installation is over a year old - its probably very out of date");
            }
            return;
        }
        Date date3 = optionsParamCheckForUpdates.getDayLastChecked();
        Date date4 = Constant.getInstallDate();
        if (date4 != null && this.dayDiff(date, date4) >= 90 && (date3 == null || this.dayDiff(date, date3) > 90)) {
            if (ZAP.getProcessType().equals((Object)ZAP.ProcessType.cmdline)) {
                CommandLine.error("No check for updates for over 3 month - add-ons may well be out of date");
            } else {
                logger.warn((Object)"No check for updates for over 3 month - add-ons may well be out of date");
            }
        }
    }

    private void alertIfOutOfDate(boolean bl) {
        OptionsParamCheckForUpdates optionsParamCheckForUpdates = this.getModel().getOptionsParam().getCheckForUpdatesParam();
        Date date = new Date();
        Date date2 = Constant.getReleaseCreateDate();
        Date date3 = optionsParamCheckForUpdates.getDayLastInstallWarned();
        int n = -1;
        logger.debug((Object)("Install created " + date2));
        if (date2 != null) {
            int n2 = this.dayDiff(date, date2);
            logger.debug((Object)("Install is " + n2 + " days old"));
            if (n2 > 365) {
                AbstractButton abstractButton;
                boolean bl2 = false;
                if (bl || date3 == null || this.dayDiff(date, date3) > 30) {
                    abstractButton = new JCheckBox(Constant.messages.getString("cfu.label.cfuonstart"));
                    abstractButton.setSelected(true);
                    String string = Constant.messages.getString("cfu.label.oldzap");
                    n = View.getSingleton().showYesNoDialog(View.getSingleton().getMainFrame(), new Object[]{string, abstractButton});
                    bl2 = abstractButton.isSelected();
                }
                optionsParamCheckForUpdates.setDayLastInstallWarned();
                if (n == 0) {
                    if (bl2) {
                        optionsParamCheckForUpdates.setCheckOnStart(true);
                    }
                    this.getAddOnsDialog().setVisible(true);
                    this.getAddOnsDialog().checkForUpdates();
                } else if (!this.oldZapAlertAdded) {
                    abstractButton = new JButton(Constant.messages.getString("cfu.label.outofdatezap"));
                    abstractButton.setIcon(new ImageIcon(ExtensionAutoUpdate.class.getResource("/resource/icon/16/050.png")));
                    abstractButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ExtensionAutoUpdate.this.alertIfOutOfDate(true);
                        }
                    });
                    View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarLeftComponent(abstractButton);
                    this.oldZapAlertAdded = true;
                }
                return;
            }
        }
        Date date4 = optionsParamCheckForUpdates.getDayLastChecked();
        Date date5 = optionsParamCheckForUpdates.getDayLastUpdateWarned();
        Date date6 = Constant.getInstallDate();
        if (date6 != null && this.dayDiff(date, date6) >= 90 && (date4 == null || this.dayDiff(date, date4) > 90)) {
            boolean bl3 = false;
            if (bl || date5 == null || this.dayDiff(date, date5) > 30) {
                JCheckBox jCheckBox = new JCheckBox(Constant.messages.getString("cfu.label.cfuonstart"));
                jCheckBox.setSelected(true);
                String string = Constant.messages.getString("cfu.label.norecentcfu");
                n = View.getSingleton().showYesNoDialog(View.getSingleton().getMainFrame(), new Object[]{string, jCheckBox});
                bl3 = jCheckBox.isSelected();
            }
            optionsParamCheckForUpdates.setDayLastUpdateWarned();
            if (n == 0) {
                if (bl3) {
                    optionsParamCheckForUpdates.setCheckOnStart(true);
                }
                this.getAddOnsDialog().setVisible(true);
                this.getAddOnsDialog().checkForUpdates();
                if (this.noCfuAlertAdded) {
                    View.getSingleton().getMainFrame().getMainFooterPanel().removeFooterToolbarLeftComponent(this.getOutOfDateButton());
                }
            } else if (!this.noCfuAlertAdded) {
                View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarLeftComponent(this.getOutOfDateButton());
                this.noCfuAlertAdded = true;
            }
        }
    }

    private JButton getOutOfDateButton() {
        if (this.outOfDateButton == null) {
            this.outOfDateButton = new JButton(Constant.messages.getString("cfu.label.outofdateaddons"));
            this.outOfDateButton.setIcon(new ImageIcon(ExtensionAutoUpdate.class.getResource("/resource/icon/16/050.png")));
            this.outOfDateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionAutoUpdate.this.alertIfOutOfDate(true);
                }
            });
        }
        return this.outOfDateButton;
    }

    private AddOnCollection getLocalVersionInfo() {
        if (this.localVersionInfo == null) {
            this.localVersionInfo = ExtensionFactory.getAddOnLoader().getAddOnCollection();
        }
        return this.localVersionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZapXmlConfiguration getRemoteConfigurationUrl(String string) throws IOException, ConfigurationException, InvalidCfuUrlException {
        HttpMessage httpMessage = new HttpMessage(new URI(string, true), Model.getSingleton().getOptionsParam().getConnectionParam());
        this.getHttpSender().sendAndReceive(httpMessage, true);
        if (httpMessage.getResponseHeader().getStatusCode() != 200) {
            throw new IOException();
        }
        if (!httpMessage.getRequestHeader().isSecure()) {
            throw new InvalidCfuUrlException(httpMessage.getRequestHeader().getURI().toString());
        }
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        zapXmlConfiguration.setDelimiterParsingDisabled(true);
        zapXmlConfiguration.load(new StringReader(httpMessage.getResponseBody().toString()));
        File file = new File(Constant.FOLDER_LOCAL_PLUGIN, VERSION_FILE_NAME);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(httpMessage.getResponseBody().toString());
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        return zapXmlConfiguration;
    }

    protected String getLatestVersionNumber() {
        if (this.getLatestVersionInfo() == null || this.getLatestVersionInfo().getZapRelease() == null) {
            return null;
        }
        return this.getLatestVersionInfo().getZapRelease().getVersion();
    }

    protected boolean isLatestVersion() {
        if (this.getLatestVersionInfo() == null || this.getLatestVersionInfo().getZapRelease() == null) {
            return true;
        }
        return !this.getLatestVersionInfo().getZapRelease().isNewerThan(this.getCurrentVersion());
    }

    protected boolean downloadLatestRelease() {
        if (Constant.isKali()) {
            if (View.isInitialised()) {
                View.getSingleton().showMessageDialog(this.getAddOnsDialog(), Constant.messages.getString("cfu.kali.options"));
            }
            return false;
        }
        if (this.getLatestVersionInfo() == null || this.getLatestVersionInfo().getZapRelease() == null) {
            return false;
        }
        ZapRelease zapRelease = this.getLatestVersionInfo().getZapRelease();
        if (zapRelease.isNewerThan(this.getCurrentVersion())) {
            File file = new File(Constant.FOLDER_LOCAL_PLUGIN, zapRelease.getFileName());
            this.downloadFile(zapRelease.getUrl(), file, zapRelease.getSize(), zapRelease.getHash());
            return true;
        }
        return false;
    }

    private AddOnCollection getPreviousVersionInfo() {
        File file;
        if (this.previousVersionInfo == null && (file = new File(Constant.FOLDER_LOCAL_PLUGIN, VERSION_FILE_NAME)).exists()) {
            try {
                this.previousVersionInfo = new AddOnCollection(new ZapXmlConfiguration(file), this.getPlatform());
            }
            catch (ConfigurationException configurationException) {
                logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
            }
        }
        return this.previousVersionInfo;
    }

    protected List<Downloader> getAllDownloadsProgress() {
        return this.downloadManager.getProgress();
    }

    private List<AddOn> getUpdatedAddOns() {
        return this.getLocalVersionInfo().getUpdatedAddOns(this.getLatestVersionInfo());
    }

    private List<AddOn> getNewAddOns() {
        if (this.getPreviousVersionInfo() != null) {
            return this.getPreviousVersionInfo().getNewAddOns(this.getLatestVersionInfo());
        }
        return this.getLocalVersionInfo().getNewAddOns(this.getLatestVersionInfo());
    }

    protected AddOnCollection getLatestVersionInfo() {
        return this.getLatestVersionInfo(null);
    }

    protected AddOnCollection getLatestVersionInfo(final CheckForUpdateCallback checkForUpdateCallback) {
        if (this.latestVersionInfo == null) {
            if (this.remoteCallThread == null || !this.remoteCallThread.isAlive()) {
                this.remoteCallThread = new Thread(){

                    @Override
                    public void run() {
                        String string;
                        String string2;
                        this.setName("ZAP-cfu");
                        if (Constant.isDevBuild()) {
                            string2 = ExtensionAutoUpdate.ZAP_VERSIONS_DEV_XML_SHORT;
                            string = ExtensionAutoUpdate.ZAP_VERSIONS_DEV_XML_FULL;
                        } else if (Constant.isDailyBuild()) {
                            string2 = ExtensionAutoUpdate.ZAP_VERSIONS_WEEKLY_XML_SHORT;
                            string = ExtensionAutoUpdate.ZAP_VERSIONS_DEV_XML_FULL;
                        } else {
                            string2 = ExtensionAutoUpdate.ZAP_VERSIONS_REL_XML_SHORT;
                            string = ExtensionAutoUpdate.ZAP_VERSIONS_REL_XML_FULL;
                        }
                        logger.debug((Object)("Getting latest version info from " + string2));
                        try {
                            ExtensionAutoUpdate.this.latestVersionInfo = new AddOnCollection(ExtensionAutoUpdate.this.getRemoteConfigurationUrl(string2), ExtensionAutoUpdate.this.getPlatform(), false);
                        }
                        catch (Exception exception) {
                            logger.debug((Object)("Failed to access " + string2), (Throwable)exception);
                            logger.debug((Object)("Getting latest version info from " + string));
                            try {
                                ExtensionAutoUpdate.this.latestVersionInfo = new AddOnCollection(ExtensionAutoUpdate.this.getRemoteConfigurationUrl(string), ExtensionAutoUpdate.this.getPlatform(), false);
                            }
                            catch (SSLHandshakeException sSLHandshakeException) {
                                if (checkForUpdateCallback != null) {
                                    checkForUpdateCallback.insecureUrl(string, sSLHandshakeException);
                                }
                            }
                            catch (InvalidCfuUrlException invalidCfuUrlException) {
                                if (checkForUpdateCallback != null) {
                                    checkForUpdateCallback.insecureUrl(string, invalidCfuUrlException);
                                }
                            }
                            catch (Exception exception2) {
                                logger.debug((Object)("Failed to access " + string), (Throwable)exception2);
                            }
                        }
                        if (checkForUpdateCallback != null && ExtensionAutoUpdate.this.latestVersionInfo != null) {
                            logger.debug((Object)("Calling callback with  " + ExtensionAutoUpdate.this.latestVersionInfo));
                            checkForUpdateCallback.gotLatestData(ExtensionAutoUpdate.this.latestVersionInfo);
                        }
                        logger.debug((Object)"Done");
                    }
                };
                this.remoteCallThread.start();
            }
            if (checkForUpdateCallback == null) {
                int n = 0;
                while (this.latestVersionInfo == null && this.remoteCallThread.isAlive() && n < 30) {
                    try {
                        Thread.sleep(1000L);
                        ++n;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.latestVersionInfo;
    }

    private String getCurrentVersion() {
        return Constant.PROGRAM_VERSION;
    }

    private AddOnCollection.Platform getPlatform() {
        if (Constant.isDailyBuild()) {
            return AddOnCollection.Platform.daily;
        }
        if (Constant.isWindows()) {
            return AddOnCollection.Platform.windows;
        }
        if (Constant.isLinux()) {
            return AddOnCollection.Platform.linux;
        }
        return AddOnCollection.Platform.mac;
    }

    protected void promptToLaunchReleaseAndClose(String string, File file) {
        int n = View.getSingleton().showConfirmDialog(MessageFormat.format(Constant.messages.getString("cfu.confirm.launch"), string, file.getAbsolutePath()));
        if (n == 0) {
            Control.getSingleton().exit(false, file);
        }
    }

    private void install(AddOn addOn) {
        AddOn addOn2;
        if (!addOn.canLoadInCurrentVersion()) {
            throw new IllegalArgumentException("Cant load add-on " + addOn.getName() + " Not before=" + addOn.getNotBeforeVersion() + " Not from=" + addOn.getNotFromVersion() + " Version=" + Constant.PROGRAM_VERSION);
        }
        AddOn addOn3 = this.getLocalVersionInfo().getAddOn(addOn.getId());
        if (addOn3 != null && !this.uninstallAddOn(null, addOn3, true)) {
            return;
        }
        logger.info((Object)("Installing new addon " + addOn.getId() + " v" + addOn.getFileVersion()));
        if (View.isInitialised()) {
            View.getSingleton().getOutputPanel().append(MessageFormat.format(Constant.messages.getString("cfu.output.installing") + "\n", addOn.getName(), addOn.getFileVersion()));
        }
        ExtensionFactory.getAddOnLoader().addAddon(addOn);
        if (this.latestVersionInfo != null && (addOn2 = this.latestVersionInfo.getAddOn(addOn.getId())) != null && AddOn.InstallationStatus.DOWNLOADING == addOn2.getInstallationStatus()) {
            addOn2.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
        }
        if (this.addonsDialog != null) {
            this.addonsDialog.notifyAddOnInstalled(addOn);
        }
    }

    private boolean uninstall(AddOn addOn, boolean bl, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        logger.debug((Object)("Trying to uninstall addon " + addOn.getId() + " v" + addOn.getFileVersion()));
        boolean bl2 = ExtensionFactory.getAddOnLoader().removeAddOn(addOn, bl, addOnUninstallationProgressCallback);
        if (bl2) {
            AddOn addOn2;
            logger.debug((Object)("Uninstalled add-on " + addOn.getName()));
            if (this.latestVersionInfo != null && (addOn2 = this.latestVersionInfo.getAddOn(addOn.getId())) != null && addOn2.getInstallationStatus() != AddOn.InstallationStatus.AVAILABLE) {
                addOn2.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
            }
        } else {
            logger.debug((Object)("Failed to uninstall add-on " + addOn.getId() + " v" + addOn.getFileVersion()));
        }
        return bl2;
    }

    @Override
    public void insecureUrl(String string, Exception exception) {
        logger.error((Object)("Failed to get check for updates on " + string), (Throwable)exception);
        if (View.isInitialised()) {
            View.getSingleton().showWarningDialog(Constant.messages.getString("cfu.warn.badurl"));
        }
    }

    @Override
    public void gotLatestData(AddOnCollection addOnCollection) {
        if (addOnCollection == null) {
            return;
        }
        if (this.getView() != null) {
            this.getAddOnsDialog();
        }
        try {
            List<AddOn> list;
            ZapRelease zapRelease = addOnCollection.getZapRelease();
            OptionsParamCheckForUpdates optionsParamCheckForUpdates = this.getModel().getOptionsParam().getCheckForUpdatesParam();
            if (zapRelease.isNewerThan(this.getCurrentVersion())) {
                logger.debug((Object)("There is a newer release: " + zapRelease.getVersion()));
                if (Constant.isKali()) {
                    if (View.isInitialised()) {
                        this.getAddOnsDialog().setVisible(true);
                    }
                    return;
                }
                File file = new File(Constant.FOLDER_LOCAL_PLUGIN, zapRelease.getFileName());
                if (file.exists() && file.length() >= zapRelease.getSize()) {
                    this.promptToLaunchReleaseAndClose(zapRelease.getVersion(), file);
                } else if (optionsParamCheckForUpdates.isDownloadNewRelease()) {
                    logger.debug((Object)"Auto-downloading release");
                    if (this.downloadLatestRelease() && this.addonsDialog != null) {
                        this.addonsDialog.setDownloadingZap();
                    }
                } else if (this.addonsDialog != null) {
                    this.addonsDialog.setVisible(true);
                }
                return;
            }
            boolean bl = this.checkForAddOnUpdates(addOnCollection, optionsParamCheckForUpdates);
            if (bl && this.addonsDialog != null && (list = this.getNewAddOns()).size() > 0) {
                boolean bl2 = false;
                for (AddOn addOn : list) {
                    switch (addOn.getStatus()) {
                        case alpha: {
                            if (!optionsParamCheckForUpdates.isReportAlphaAddons()) break;
                            bl2 = true;
                            break;
                        }
                        case beta: {
                            if (!optionsParamCheckForUpdates.isReportBetaAddons()) break;
                            bl2 = true;
                            break;
                        }
                        case release: {
                            if (!optionsParamCheckForUpdates.isReportReleaseAddons()) break;
                            bl2 = true;
                            break;
                        }
                    }
                }
                if (bl2) {
                    this.getAddOnsDialog().setVisible(true);
                    this.getAddOnsDialog().selectMarketplaceTab();
                }
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean checkForAddOnUpdates(AddOnCollection addOnCollection, OptionsParamCheckForUpdates optionsParamCheckForUpdates) {
        List<AddOn> list = this.getUpdatedAddOns();
        if (list.isEmpty()) {
            return true;
        }
        logger.debug((Object)("There is/are " + list.size() + " newer addons"));
        AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(this.localVersionInfo, addOnCollection);
        HashSet<AddOn> hashSet = new HashSet<AddOn>(list);
        AddOnDependencyChecker.AddOnChangesResult addOnChangesResult = addOnDependencyChecker.calculateUpdateChanges(hashSet);
        if (!addOnChangesResult.getUninstalls().isEmpty() || addOnChangesResult.isNewerJavaVersionRequired()) {
            if (optionsParamCheckForUpdates.isCheckAddonUpdates()) {
                if (this.addonsDialog != null) {
                    this.getAddOnsDialog().setVisible(true);
                    return false;
                }
                logger.info((Object)("Updates not installed some add-ons would be uninstalled or require newer java version: " + addOnChangesResult.getUninstalls()));
            }
            return true;
        }
        if (optionsParamCheckForUpdates.isInstallAddonUpdates()) {
            logger.debug((Object)"Auto-downloading addons");
            this.processAddOnChanges(null, addOnChangesResult);
            return false;
        }
        if (optionsParamCheckForUpdates.isInstallScannerRules()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                if (((AddOn)iterator.next()).getId().contains("scanrules")) continue;
                iterator.remove();
            }
            logger.debug((Object)"Auto-downloading scanner rules");
            this.processAddOnChanges(null, addOnDependencyChecker.calculateUpdateChanges(hashSet));
            return false;
        }
        if (optionsParamCheckForUpdates.isCheckAddonUpdates() && this.addonsDialog != null) {
            this.addonsDialog.setVisible(true);
            return false;
        }
        return true;
    }

    void processAddOnChanges(Window window, AddOnDependencyChecker.AddOnChangesResult addOnChangesResult) {
        HashSet<AddOn> hashSet;
        if (this.addonsDialog != null) {
            this.addonsDialog.setDownloadingUpdates();
        }
        if (this.getView() != null) {
            hashSet = new HashSet<AddOn>(addOnChangesResult.getUninstalls());
            hashSet.addAll(addOnChangesResult.getOldVersions());
            HashSet<Extension> hashSet2 = new HashSet<Extension>();
            hashSet2.addAll(addOnChangesResult.getUnloadExtensions());
            hashSet2.addAll(addOnChangesResult.getSoftUnloadExtensions());
            if (!this.warnUnsavedResourcesOrActiveActions(window, hashSet, (Set<Extension>)hashSet2, true)) {
                return;
            }
        }
        this.uninstallAddOns(window, addOnChangesResult.getUninstalls(), false);
        hashSet = new HashSet<AddOn>(addOnChangesResult.getNewVersions());
        hashSet.addAll(addOnChangesResult.getInstalls());
        for (AddOn addOn : hashSet) {
            if (this.addonsDialog != null) {
                this.addonsDialog.notifyAddOnDownloading(addOn);
            }
            this.downloadAddOn(addOn);
        }
    }

    boolean warnUnsavedResourcesOrActiveActions(Window window, Collection<AddOn> collection, Set<Extension> set, boolean bl) {
        HashSet<AddOn> hashSet = new HashSet<AddOn>(collection);
        this.addDependents(hashSet);
        String string = bl ? "cfu.update." : "cfu.uninstall.";
        String string2 = ExtensionAutoUpdate.getExtensionsUnsavedResources(collection, set);
        String string3 = ExtensionAutoUpdate.getExtensionsActiveActions(collection, set);
        String string4 = null;
        if (!string2.isEmpty()) {
            string4 = string3.isEmpty() ? MessageFormat.format(Constant.messages.getString(string + "message.resourcesNotSaved"), string2) : MessageFormat.format(Constant.messages.getString(string + "message.resourcesNotSavedAndActiveActions"), string2, string3);
        } else if (!string3.isEmpty()) {
            string4 = MessageFormat.format(Constant.messages.getString(string + "message.activeActions"), string3);
        }
        return string4 == null || JOptionPane.showConfirmDialog(this.getWindowParent(window), string4, "OWASP ZAP", 0) == 0;
    }

    private void addDependents(Set<AddOn> set) {
        for (AddOn addOn : this.localVersionInfo.getInstalledAddOns()) {
            if (!addOn.dependsOn(set) || set.contains(addOn)) continue;
            set.add(addOn);
            this.addDependents(set);
        }
    }

    private Window getWindowParent(Window window) {
        if (window != null) {
            return window;
        }
        if (this.addonsDialog != null && this.addonsDialog.isFocused()) {
            return this.addonsDialog;
        }
        return this.getView().getMainFrame();
    }

    private static String getExtensionsUnsavedResources(Collection<AddOn> collection, Set<Extension> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AddOn object : collection) {
            for (Extension extension : object.getLoadedExtensions()) {
                List<String> list = extension.getUnsavedResources();
                if (list == null) continue;
                arrayList.addAll(list);
            }
        }
        for (Extension extension : set) {
            List<String> list = extension.getUnsavedResources();
            if (list == null) continue;
            arrayList.addAll((Collection<String>)list);
        }
        return ExtensionAutoUpdate.wrapEntriesInLiTags(arrayList);
    }

    private static String wrapEntriesInLiTags(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 15);
        for (String string : list) {
            stringBuilder.append("<li>");
            stringBuilder.append(string);
            stringBuilder.append("</li>");
        }
        return stringBuilder.toString();
    }

    private static String getExtensionsActiveActions(Collection<AddOn> collection, Set<Extension> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AddOn object : collection) {
            for (Extension extension : object.getLoadedExtensions()) {
                List<String> list = extension.getActiveActions();
                if (list == null) continue;
                arrayList.addAll(list);
            }
        }
        for (Extension extension : set) {
            List<String> list = extension.getActiveActions();
            if (list == null) continue;
            arrayList.addAll((Collection<String>)list);
        }
        return ExtensionAutoUpdate.wrapEntriesInLiTags(arrayList);
    }

    private void downloadAddOn(AddOn addOn) {
        if (AddOn.InstallationStatus.DOWNLOADING == addOn.getInstallationStatus()) {
            return;
        }
        addOn.setInstallationStatus(AddOn.InstallationStatus.DOWNLOADING);
        this.downloadFile(addOn.getUrl(), addOn.getFile(), addOn.getSize(), addOn.getHash());
    }

    private boolean uninstallAddOn(Window window, AddOn addOn, boolean bl) {
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        hashSet.add(addOn);
        return this.uninstallAddOns(window, hashSet, bl);
    }

    boolean uninstallAddOns(Window window, Set<AddOn> set, boolean bl) {
        if (set == null || set.isEmpty()) {
            return true;
        }
        if (this.getView() != null) {
            return this.uninstallAddOnsWithView(window, set, bl, new HashSet<AddOn>());
        }
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        for (AddOn addOn : set) {
            if (this.uninstall(addOn, false, null)) continue;
            hashSet.add(addOn);
        }
        if (!hashSet.isEmpty()) {
            logger.warn((Object)("It's recommended to restart ZAP. Not all add-ons were successfully uninstalled: " + hashSet));
            return false;
        }
        return true;
    }

    boolean uninstallAddOnsWithView(final Window window, final Set<AddOn> set, final boolean bl, final Set<AddOn> set2) {
        if (set == null || set.isEmpty()) {
            return true;
        }
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAutoUpdate.this.uninstallAddOnsWithView(window, set, bl, set2);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.error((Object)"Failed to uninstall add-ons:", (Throwable)exception);
                return false;
            }
            return set2.isEmpty();
        }
        Window window2 = this.getWindowParent(window);
        final UninstallationProgressDialogue uninstallationProgressDialogue = new UninstallationProgressDialogue(window2, set);
        uninstallationProgressDialogue.addAddOnUninstallListener(new UninstallationProgressDialogue.AddOnUninstallListener(){

            @Override
            public void uninstallingAddOn(AddOn addOn, boolean bl) {
                if (bl) {
                    String string = MessageFormat.format(Constant.messages.getString("cfu.output.replacing") + "\n", addOn.getName(), addOn.getFileVersion());
                    ExtensionAutoUpdate.this.getView().getOutputPanel().append(string);
                }
            }

            @Override
            public void addOnUninstalled(AddOn addOn, boolean bl, boolean bl2) {
                if (bl2) {
                    if (!bl && ExtensionAutoUpdate.this.addonsDialog != null) {
                        ExtensionAutoUpdate.this.addonsDialog.notifyAddOnUninstalled(addOn);
                    }
                    String string = MessageFormat.format(Constant.messages.getString("cfu.output.uninstalled") + "\n", addOn.getName(), addOn.getFileVersion());
                    ExtensionAutoUpdate.this.getView().getOutputPanel().append(string);
                } else {
                    if (ExtensionAutoUpdate.this.addonsDialog != null) {
                        ExtensionAutoUpdate.this.addonsDialog.notifyAddOnFailedUninstallation(addOn);
                    }
                    String string = bl ? MessageFormat.format(Constant.messages.getString("cfu.output.replace.failed") + "\n", addOn.getName(), addOn.getFileVersion()) : MessageFormat.format(Constant.messages.getString("cfu.output.uninstall.failed") + "\n", addOn.getName(), addOn.getFileVersion());
                    ExtensionAutoUpdate.this.getView().getOutputPanel().append(string);
                }
            }
        });
        SwingWorker<Void, UninstallationProgressDialogue.UninstallationProgressEvent> swingWorker = new SwingWorker<Void, UninstallationProgressDialogue.UninstallationProgressEvent>(){

            @Override
            protected void process(List<UninstallationProgressDialogue.UninstallationProgressEvent> list) {
                uninstallationProgressDialogue.update(list);
            }

            @Override
            protected Void doInBackground() {
                UninstallationProgressDialogue.UninstallationProgressHandler uninstallationProgressHandler = new UninstallationProgressDialogue.UninstallationProgressHandler(){

                    @Override
                    protected void publishEvent(UninstallationProgressDialogue.UninstallationProgressEvent uninstallationProgressEvent) {
                        this.publish(new UninstallationProgressDialogue.UninstallationProgressEvent[]{uninstallationProgressEvent});
                    }
                };
                for (AddOn addOn : set) {
                    if (ExtensionAutoUpdate.this.uninstall(addOn, bl, uninstallationProgressHandler)) continue;
                    set2.add(addOn);
                }
                if (!set2.isEmpty()) {
                    logger.warn((Object)("Not all add-ons were successfully uninstalled: " + set2));
                }
                return null;
            }
        };
        uninstallationProgressDialogue.bind(swingWorker);
        swingWorker.execute();
        uninstallationProgressDialogue.setSynchronous(bl);
        uninstallationProgressDialogue.setVisible(true);
        return set2.isEmpty();
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-addoninstall", 1, null, "", "-addoninstall <addon>    " + Constant.messages.getString("cfu.cmdline.install.help"));
        this.arguments[1] = new CommandLineArgument("-addoninstallall", 0, null, "", "-addoninstallall         " + Constant.messages.getString("cfu.cmdline.installall.help"));
        this.arguments[2] = new CommandLineArgument("-addonuninstall", 1, null, "", "-addonuninstall <addon>  " + Constant.messages.getString("cfu.cmdline.uninstall.help"));
        this.arguments[3] = new CommandLineArgument("-addonupdate", 0, null, "", "-addonupdate             " + Constant.messages.getString("cfu.cmdline.update.help"));
        this.arguments[4] = new CommandLineArgument("-addonlist", 0, null, "", "-addonlist               " + Constant.messages.getString("cfu.cmdline.list.help"));
        return this.arguments;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(CommandLineArgument[] commandLineArgumentArray) {
        Object object;
        Object object2;
        Object object3;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        if (this.arguments[3].isEnabled()) {
            object8 = this.getLatestVersionInfo();
            object7 = new OptionsParamCheckForUpdates();
            ((AbstractParam)object7).load((FileConfiguration)new XMLPropertiesConfiguration());
            ((OptionsParamCheckForUpdates)object7).setCheckOnStart(true);
            ((OptionsParamCheckForUpdates)object7).setCheckAddonUpdates(true);
            ((OptionsParamCheckForUpdates)object7).setInstallAddonUpdates(true);
            this.checkForAddOnUpdates((AddOnCollection)object8, (OptionsParamCheckForUpdates)object7);
            this.waitAndInstallDownloads();
            CommandLine.info(Constant.messages.getString("cfu.cmdline.updated"));
        }
        if (this.arguments[1].isEnabled()) {
            object8 = this.getLatestVersionInfo();
            if (object8 == null) {
                CommandLine.error(Constant.messages.getString("cfu.cmdline.nocfu"));
            } else {
                object7 = new AddOnDependencyChecker(this.getLocalVersionInfo(), (AddOnCollection)object8);
                object6 = null;
                object5 = new HashSet();
                for (AddOn object42 : ((AddOnCollection)object8).getAddOns()) {
                    if (object42.getId().equals("coreLang") && (Constant.isDevBuild() || Constant.isDailyBuild())) continue;
                    object3 = this.getLocalVersionInfo().getAddOn(object42.getId());
                    if (object3 != null) {
                        if (!object42.isUpdateTo((AddOn)object3)) continue;
                        object2 = ((AddOnDependencyChecker)object7).calculateUpdateChanges(object42);
                    } else {
                        object2 = ((AddOnDependencyChecker)object7).calculateInstallChanges(object42);
                    }
                    if (!((AddOnDependencyChecker.AddOnChangesResult)object2).getUninstalls().isEmpty()) continue;
                    object5.addAll(((AddOnDependencyChecker.AddOnChangesResult)object2).getInstalls());
                    object5.addAll(((AddOnDependencyChecker.AddOnChangesResult)object2).getNewVersions());
                    if (object6 == null) {
                        object6 = object2;
                        continue;
                    }
                    ((AddOnDependencyChecker.AddOnChangesResult)object6).addResults((AddOnDependencyChecker.AddOnChangesResult)object2);
                }
                if (object5.isEmpty()) {
                    return;
                }
                object = object5.iterator();
                while (object.hasNext()) {
                    AddOn addOn = object.next();
                    CommandLine.info(MessageFormat.format(Constant.messages.getString("cfu.cmdline.addonurl"), addOn.getUrl()));
                }
                this.processAddOnChanges(null, (AddOnDependencyChecker.AddOnChangesResult)object6);
                this.waitAndInstallDownloads();
            }
        }
        if (this.arguments[0].isEnabled()) {
            object8 = this.arguments[0].getArguments();
            object7 = this.getLatestVersionInfo();
            if (object7 == null) {
                CommandLine.error(Constant.messages.getString("cfu.cmdline.nocfu"));
            } else {
                object2 = ((Vector)object8).iterator();
                while (object2.hasNext()) {
                    void var8_14;
                    object6 = object2.next();
                    object5 = ((AddOnCollection)object7).getAddOn((String)object6);
                    if (object5 == null) {
                        CommandLine.error(MessageFormat.format(Constant.messages.getString("cfu.cmdline.noaddon"), object6));
                        continue;
                    }
                    object = new AddOnDependencyChecker(this.getLocalVersionInfo(), (AddOnCollection)object7);
                    object3 = this.getLocalVersionInfo().getAddOn((String)object6);
                    if (object3 != null) {
                        if (!((AddOn)object5).isUpdateTo((AddOn)object3)) {
                            CommandLine.info(MessageFormat.format(Constant.messages.getString("cfu.cmdline.addoninst"), ((AddOn)object3).getFile().getAbsolutePath()));
                            continue;
                        }
                        AddOnDependencyChecker.AddOnChangesResult addOnChangesResult = ((AddOnDependencyChecker)object).calculateUpdateChanges((AddOn)object5);
                    } else {
                        AddOnDependencyChecker.AddOnChangesResult addOnChangesResult = ((AddOnDependencyChecker)object).calculateInstallChanges((AddOn)object5);
                    }
                    if (!var8_14.getUninstalls().isEmpty()) {
                        CommandLine.info(MessageFormat.format(Constant.messages.getString("cfu.cmdline.addoninst.uninstalls.required"), var8_14.getUninstalls()));
                        continue;
                    }
                    HashSet<AddOn> hashSet = new HashSet<AddOn>();
                    hashSet.addAll(var8_14.getInstalls());
                    hashSet.addAll(var8_14.getNewVersions());
                    for (AddOn addOn : hashSet) {
                        CommandLine.info(MessageFormat.format(Constant.messages.getString("cfu.cmdline.addonurl"), addOn.getUrl()));
                    }
                    this.processAddOnChanges(null, (AddOnDependencyChecker.AddOnChangesResult)var8_14);
                }
                this.waitAndInstallDownloads();
            }
        }
        if (this.arguments[2].isEnabled()) {
            object8 = this.arguments[2].getArguments();
            object7 = this.getLocalVersionInfo();
            if (object7 == null) {
                CommandLine.error(Constant.messages.getString("cfu.cmdline.nocfu"));
            } else {
                object2 = ((Vector)object8).iterator();
                while (object2.hasNext()) {
                    object6 = object2.next();
                    object5 = ((AddOnCollection)object7).getAddOn((String)object6);
                    if (object5 == null) {
                        CommandLine.error(MessageFormat.format(Constant.messages.getString("cfu.cmdline.noaddon"), object6));
                        continue;
                    }
                    object = new AddOnDependencyChecker(this.getLocalVersionInfo(), (AddOnCollection)object7);
                    HashSet<AddOn> hashSet = new HashSet<AddOn>();
                    hashSet.add((AddOn)object5);
                    object3 = ((AddOnDependencyChecker)object).calculateUninstallChanges(hashSet);
                    if (((AddOnDependencyChecker.UninstallationResult)object3).getUninstallations().size() > 1) {
                        ((AddOnDependencyChecker.UninstallationResult)object3).getUninstallations().remove(object5);
                        CommandLine.info(MessageFormat.format(Constant.messages.getString("cfu.cmdline.addonuninst.uninstalls.required"), ((AddOnDependencyChecker.UninstallationResult)object3).getUninstallations()));
                        continue;
                    }
                    if (this.uninstallAddOn(null, (AddOn)object5, false)) {
                        CommandLine.info(MessageFormat.format(Constant.messages.getString("cfu.cmdline.uninstallok"), object6));
                        continue;
                    }
                    CommandLine.error(MessageFormat.format(Constant.messages.getString("cfu.cmdline.uninstallfail"), object6));
                }
            }
        }
        if (this.arguments[4].isEnabled()) {
            object8 = this.getLocalVersionInfo();
            object7 = new ArrayList<AddOn>(((AddOnCollection)object8).getAddOns());
            Collections.sort(object7, new Comparator<AddOn>(){

                @Override
                public int compare(AddOn addOn, AddOn addOn2) {
                    return addOn.getName().compareTo(addOn2.getName());
                }
            });
            object2 = object7.iterator();
            while (object2.hasNext()) {
                object6 = (AddOn)((Object)object2.next());
                CommandLine.info(((AddOn)object6).getName() + "\t" + ((AddOn)object6).getId() + "\tv" + ((AddOn)object6).getFileVersion() + "\t" + ((AddOn)object6).getStatus().name() + "\t" + ((AddOn)object6).getDescription());
            }
        }
    }

    private void waitAndInstallDownloads() {
        while (this.downloadManager.getCurrentDownloadCount() > 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (Downloader downloader : this.downloadManager.getProgress()) {
            if (downloader.isValidated()) {
                CommandLine.info(MessageFormat.format(Constant.messages.getString("cfu.cmdline.addondown"), downloader.getTargetFile().getAbsolutePath()));
                continue;
            }
            CommandLine.error(MessageFormat.format(Constant.messages.getString("cfu.cmdline.addondown.failed"), downloader.getTargetFile().getName()));
        }
        if (this.getView() == null) {
            this.installNewExtensions();
        }
    }

    @Override
    public boolean handleFile(File file) {
        return false;
    }

    @Override
    public List<String> getHandledExtensions() {
        return null;
    }
}

