/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.script.DefaultEngineWrapper;
import org.zaproxy.zap.extension.script.HttpSenderScript;
import org.zaproxy.zap.extension.script.HttpSenderScriptHelper;
import org.zaproxy.zap.extension.script.HttpSenderScriptListener;
import org.zaproxy.zap.extension.script.JavascriptEngineWrapper;
import org.zaproxy.zap.extension.script.MultipleWriters;
import org.zaproxy.zap.extension.script.OptionsScriptPanel;
import org.zaproxy.zap.extension.script.ProxyListenerScript;
import org.zaproxy.zap.extension.script.ProxyScript;
import org.zaproxy.zap.extension.script.ScriptAPI;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptEventListener;
import org.zaproxy.zap.extension.script.ScriptNode;
import org.zaproxy.zap.extension.script.ScriptParam;
import org.zaproxy.zap.extension.script.ScriptTreeModel;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptUI;
import org.zaproxy.zap.extension.script.ScriptVars;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.extension.script.TargetedScript;

public class ExtensionScript
extends ExtensionAdaptor
implements CommandLineListener {
    public static final int EXTENSION_ORDER = 60;
    public static final String NAME = "ExtensionScript";
    public static final ImageIcon ICON = new ImageIcon(ZAP.class.getResource("/resource/icon/16/059.png"));
    public static final String SCRIPTS_DIR = "scripts";
    public static final String TEMPLATES_DIR = "scripts" + File.separator + "templates";
    private static final String LANG_ENGINE_SEP = " : ";
    protected static final String SCRIPT_CONSOLE_HOME_PAGE = "https://github.com/zaproxy/zaproxy/wiki/ScriptConsole";
    protected static final String SCRIPT_NAME_ATT = "zap.script.name";
    public static final String TYPE_HTTP_SENDER = "httpsender";
    public static final String TYPE_PROXY = "proxy";
    public static final String TYPE_STANDALONE = "standalone";
    public static final String TYPE_TARGETED = "targeted";
    private static final ImageIcon HTTP_SENDER_ICON = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-httpsender.png"));
    private static final ImageIcon PROXY_ICON = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-proxy.png"));
    private static final ImageIcon STANDALONE_ICON = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-standalone.png"));
    private static final ImageIcon TARGETED_ICON = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-targeted.png"));
    private ScriptEngineManager mgr = new ScriptEngineManager();
    private ScriptParam scriptParam = null;
    private OptionsScriptPanel optionsScriptPanel = null;
    private ScriptTreeModel treeModel = null;
    private List<ScriptEngineWrapper> engineWrappers = new ArrayList<ScriptEngineWrapper>();
    private Map<String, ScriptType> typeMap = new HashMap<String, ScriptType>();
    private ProxyListenerScript proxyListener = null;
    private HttpSenderScriptListener httpSenderScriptListener;
    private List<ScriptEventListener> listeners = new ArrayList<ScriptEventListener>();
    private MultipleWriters writers = new MultipleWriters();
    private ScriptUI scriptUI = null;
    private CommandLineArgument[] arguments = new CommandLineArgument[1];
    private static final int ARG_SCRIPT_IDX = 0;
    private static final Logger logger = Logger.getLogger(ExtensionScript.class);
    private boolean shouldLoadTemplatesOnScriptTypeRegistration;

    public ExtensionScript() {
        this.initialize();
    }

    public ExtensionScript(String string) {
        super(string);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(60);
        ScriptEngine scriptEngine = this.mgr.getEngineByName("ECMAScript");
        if (scriptEngine != null) {
            this.registerScriptEngineWrapper(new JavascriptEngineWrapper(scriptEngine));
        } else {
            logger.error((Object)"No Javascript/ECMAScript engine found");
        }
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        this.registerScriptType(new ScriptType(TYPE_PROXY, "script.type.proxy", PROXY_ICON, true));
        this.registerScriptType(new ScriptType(TYPE_STANDALONE, "script.type.standalone", STANDALONE_ICON, false, new String[]{"append"}));
        this.registerScriptType(new ScriptType(TYPE_TARGETED, "script.type.targeted", TARGETED_ICON, false));
        this.registerScriptType(new ScriptType(TYPE_HTTP_SENDER, "script.type.httpsender", HTTP_SENDER_ICON, true));
        extensionHook.addSessionListener(new ClearScriptVarsOnSessionChange());
        extensionHook.addProxyListener(this.getProxyListener());
        HttpSender.addListener(this.getHttpSenderScriptListener());
        extensionHook.addOptionsParamSet(this.getScriptParam());
        extensionHook.addCommandLine(this.getCommandLineArguments());
        if (View.isInitialised()) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsScriptPanel());
        } else {
            this.addWriter(new PrintWriter(System.out));
        }
        API.getInstance().registerApiImplementor(new ScriptAPI(this));
    }

    private OptionsScriptPanel getOptionsScriptPanel() {
        if (this.optionsScriptPanel == null) {
            this.optionsScriptPanel = new OptionsScriptPanel(this);
        }
        return this.optionsScriptPanel;
    }

    private ProxyListenerScript getProxyListener() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerScript(this);
        }
        return this.proxyListener;
    }

    private HttpSenderScriptListener getHttpSenderScriptListener() {
        if (this.httpSenderScriptListener == null) {
            this.httpSenderScriptListener = new HttpSenderScriptListener(this);
        }
        return this.httpSenderScriptListener;
    }

    public List<String> getScriptingEngines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ScriptEngineFactory> list = this.mgr.getEngineFactories();
        for (ScriptEngineFactory object : list) {
            arrayList.add(object.getLanguageName() + LANG_ENGINE_SEP + object.getEngineName());
        }
        for (ScriptEngineWrapper scriptEngineWrapper : this.engineWrappers) {
            if (list.contains(scriptEngineWrapper.getEngine().getFactory())) continue;
            arrayList.add(scriptEngineWrapper.getLanguageName() + LANG_ENGINE_SEP + scriptEngineWrapper.getEngineName());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void registerScriptEngineWrapper(ScriptEngineWrapper scriptEngineWrapper) {
        logger.debug((Object)("registerEngineWrapper " + scriptEngineWrapper.getLanguageName() + LANG_ENGINE_SEP + scriptEngineWrapper.getEngineName()));
        this.engineWrappers.add(scriptEngineWrapper);
        this.setScriptEngineWrapper(this.getTreeModel().getScriptsNode(), scriptEngineWrapper, scriptEngineWrapper);
        this.setScriptEngineWrapper(this.getTreeModel().getTemplatesNode(), scriptEngineWrapper, scriptEngineWrapper);
        this.loadTemplates(scriptEngineWrapper);
        if (this.scriptUI != null) {
            try {
                this.scriptUI.engineAdded(scriptEngineWrapper);
            }
            catch (Exception exception) {
                logger.error((Object)"An error occurred while notifying ScriptUI:", (Throwable)exception);
            }
        }
    }

    private void setScriptEngineWrapper(ScriptNode scriptNode, ScriptEngineWrapper scriptEngineWrapper, ScriptEngineWrapper scriptEngineWrapper2) {
        Enumeration<TreeNode> enumeration = scriptNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ScriptWrapper scriptWrapper;
            ScriptNode scriptNode2 = (ScriptNode)enumeration.nextElement();
            if (scriptNode2.getUserObject() == null || !(scriptNode2.getUserObject() instanceof ScriptWrapper) || !ExtensionScript.hasSameScriptEngine(scriptWrapper = (ScriptWrapper)scriptNode2.getUserObject(), scriptEngineWrapper)) continue;
            scriptWrapper.setEngine(scriptEngineWrapper2);
            if (scriptEngineWrapper2 == null) {
                if (!scriptWrapper.isEnabled()) continue;
                this.setEnabled(scriptWrapper, false);
                scriptWrapper.setPreviouslyEnabled(true);
                continue;
            }
            if (!scriptWrapper.isPreviouslyEnabled()) continue;
            this.setEnabled(scriptWrapper, true);
            scriptWrapper.setPreviouslyEnabled(false);
        }
    }

    public static boolean hasSameScriptEngine(ScriptWrapper scriptWrapper, ScriptEngineWrapper scriptEngineWrapper) {
        if (scriptWrapper.getEngine() != null) {
            return scriptWrapper.getEngine() == scriptEngineWrapper;
        }
        return ExtensionScript.isSameScriptEngine(scriptWrapper.getEngineName(), scriptEngineWrapper.getEngineName(), scriptEngineWrapper.getLanguageName());
    }

    public static boolean isSameScriptEngine(String string, String string2, String string3) {
        if (string.indexOf(LANG_ENGINE_SEP) > 0) {
            return string.equals(string3 + LANG_ENGINE_SEP + string2);
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.endsWith(string2)) {
            return true;
        }
        return string2.endsWith(string);
    }

    public void removeScriptEngineWrapper(ScriptEngineWrapper scriptEngineWrapper) {
        logger.debug((Object)("Removing script engine: " + scriptEngineWrapper.getLanguageName() + LANG_ENGINE_SEP + scriptEngineWrapper.getEngineName()));
        if (this.engineWrappers.remove(scriptEngineWrapper)) {
            if (this.scriptUI != null) {
                try {
                    this.scriptUI.engineRemoved(scriptEngineWrapper);
                }
                catch (Exception exception) {
                    logger.error((Object)"An error occurred while notifying ScriptUI:", (Throwable)exception);
                }
            }
            this.setScriptEngineWrapper(this.getTreeModel().getScriptsNode(), scriptEngineWrapper, null);
            this.processTemplatesOfRemovedEngine(this.getTreeModel().getTemplatesNode(), scriptEngineWrapper);
        }
    }

    private void processTemplatesOfRemovedEngine(ScriptNode scriptNode, ScriptEngineWrapper scriptEngineWrapper) {
        ArrayList<TreeNode> arrayList = Collections.list(scriptNode.depthFirstEnumeration());
        for (ScriptNode scriptNode2 : arrayList) {
            ScriptWrapper scriptWrapper;
            if (scriptNode2.getUserObject() == null || !(scriptNode2.getUserObject() instanceof ScriptWrapper) || !ExtensionScript.hasSameScriptEngine(scriptWrapper = (ScriptWrapper)scriptNode2.getUserObject(), scriptEngineWrapper)) continue;
            if (scriptEngineWrapper.isDefaultTemplate(scriptWrapper)) {
                this.removeTemplate(scriptWrapper);
                continue;
            }
            scriptWrapper.setEngine(null);
            this.getTreeModel().nodeStructureChanged(scriptWrapper);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ScriptEngineWrapper getEngineWrapper(String string) {
        void var3_6;
        for (ScriptEngineWrapper object2 : this.engineWrappers) {
            if (!ExtensionScript.isSameScriptEngine(string, object2.getEngineName(), object2.getLanguageName())) continue;
            return object2;
        }
        List<ScriptEngineFactory> list = this.mgr.getEngineFactories();
        Object var3_4 = null;
        Object object = list.iterator();
        while (object.hasNext()) {
            ScriptEngineFactory scriptEngineFactory = (ScriptEngineFactory)object.next();
            if (!ExtensionScript.isSameScriptEngine(string, scriptEngineFactory.getEngineName(), scriptEngineFactory.getLanguageName())) continue;
            ScriptEngine scriptEngine = scriptEngineFactory.getScriptEngine();
            break;
        }
        if (var3_6 != null) {
            object = new DefaultEngineWrapper((ScriptEngine)var3_6);
            this.registerScriptEngineWrapper((ScriptEngineWrapper)object);
            return object;
        }
        throw new InvalidParameterException("No such engine: " + string);
    }

    public String getEngineNameForExtension(String string) {
        ScriptEngine scriptEngine = this.mgr.getEngineByExtension(string);
        if (scriptEngine != null) {
            return scriptEngine.getFactory().getLanguageName() + LANG_ENGINE_SEP + scriptEngine.getFactory().getEngineName();
        }
        for (ScriptEngineWrapper scriptEngineWrapper : this.engineWrappers) {
            if (scriptEngineWrapper.getExtensions() == null) continue;
            for (String string2 : scriptEngineWrapper.getExtensions()) {
                if (!string.equals(string2)) continue;
                return scriptEngineWrapper.getLanguageName() + LANG_ENGINE_SEP + scriptEngineWrapper.getEngineName();
            }
        }
        return null;
    }

    protected ScriptParam getScriptParam() {
        if (this.scriptParam == null) {
            this.scriptParam = new ScriptParam();
            this.scriptParam.load(Model.getSingleton().getOptionsParam().getConfig());
        }
        return this.scriptParam;
    }

    public ScriptTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new ScriptTreeModel();
        }
        return this.treeModel;
    }

    public void registerScriptType(ScriptType scriptType) {
        if (this.typeMap.containsKey(scriptType.getName())) {
            throw new InvalidParameterException("ScriptType already registered: " + scriptType.getName());
        }
        this.typeMap.put(scriptType.getName(), scriptType);
        this.getTreeModel().addType(scriptType);
        if (this.shouldLoadTemplatesOnScriptTypeRegistration) {
            this.loadScriptTemplates(scriptType);
        }
    }

    public void removeScripType(ScriptType scriptType) {
        ScriptType scriptType2 = this.typeMap.remove(scriptType.getName());
        if (scriptType2 != null) {
            this.getTreeModel().removeType(scriptType2);
        }
    }

    public ScriptType getScriptType(String string) {
        return this.typeMap.get(string);
    }

    public Collection<ScriptType> getScriptTypes() {
        return this.typeMap.values();
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("script.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void refreshScript(ScriptWrapper scriptWrapper) {
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.refreshScript(scriptWrapper);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public ScriptWrapper getScript(String string) {
        ScriptWrapper scriptWrapper = this.getTreeModel().getScript(string);
        this.refreshScript(scriptWrapper);
        return scriptWrapper;
    }

    public ScriptNode addScript(ScriptWrapper scriptWrapper) {
        return this.addScript(scriptWrapper, true);
    }

    public ScriptNode addScript(ScriptWrapper scriptWrapper, boolean bl) {
        if (scriptWrapper == null) {
            return null;
        }
        ScriptNode scriptNode = this.getTreeModel().addScript(scriptWrapper);
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.scriptAdded(scriptWrapper, bl);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        if (scriptWrapper.isLoadOnStart() && scriptWrapper.getFile() != null) {
            this.getScriptParam().addScript(scriptWrapper);
            this.getScriptParam().saveScripts();
        }
        return scriptNode;
    }

    public void saveScript(ScriptWrapper scriptWrapper) throws IOException {
        this.refreshScript(scriptWrapper);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(scriptWrapper.getFile(), false));
        bufferedWriter.append(scriptWrapper.getContents());
        bufferedWriter.close();
        this.setChanged(scriptWrapper, false);
        this.getScriptParam().removeScript(scriptWrapper);
        this.getScriptParam().addScript(scriptWrapper);
        this.getScriptParam().saveScripts();
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.scriptSaved(scriptWrapper);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void removeScript(ScriptWrapper scriptWrapper) {
        scriptWrapper.setLoadOnStart(false);
        this.getScriptParam().removeScript(scriptWrapper);
        this.getScriptParam().saveScripts();
        this.getTreeModel().removeScript(scriptWrapper);
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.scriptRemoved(scriptWrapper);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void removeTemplate(ScriptWrapper scriptWrapper) {
        this.getTreeModel().removeTemplate(scriptWrapper);
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.templateRemoved(scriptWrapper);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public ScriptNode addTemplate(ScriptWrapper scriptWrapper) {
        return this.addTemplate(scriptWrapper, true);
    }

    public ScriptNode addTemplate(ScriptWrapper scriptWrapper, boolean bl) {
        if (scriptWrapper == null) {
            return null;
        }
        ScriptNode scriptNode = this.getTreeModel().addTemplate(scriptWrapper);
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.templateAdded(scriptWrapper, bl);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return scriptNode;
    }

    @Override
    public void postInit() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(1);
        for (ScriptWrapper object : this.getScriptParam().getScripts()) {
            try {
                this.loadScript(object);
                if (object.getType() != null) {
                    this.addScript(object, false);
                    continue;
                }
                logger.warn((Object)("Failed to add script \"" + object.getName() + "\", script type not found: " + object.getTypeName()));
                arrayList.add(new String[]{object.getName(), object.getEngineName()});
            }
            catch (IOException | InvalidParameterException exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                arrayList.add(new String[]{object.getName(), object.getEngineName()});
            }
        }
        ExtensionScript.informScriptsNotAdded(arrayList);
        this.loadTemplates();
        for (File file : this.getScriptParam().getScriptDirs()) {
            int n = this.addScriptsFromDir(file);
            logger.debug((Object)("Added " + n + " scripts from dir: " + file.getAbsolutePath()));
        }
        this.shouldLoadTemplatesOnScriptTypeRegistration = true;
    }

    private static void informScriptsNotAdded(final List<String[]> list) {
        if (!View.isInitialised() || list.isEmpty()) {
            return;
        }
        final ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(Constant.messages.getString("script.info.scriptsNotAdded.message"));
        JXTable jXTable = new JXTable((TableModel)new AbstractTableModel(){
            private static final long serialVersionUID = -457689656746030560L;

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return Constant.messages.getString("script.info.scriptsNotAdded.table.column.scriptName");
                }
                return Constant.messages.getString("script.info.scriptsNotAdded.table.column.scriptEngine");
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return ((String[])list.get(n))[n2];
            }

            @Override
            public int getRowCount() {
                return list.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }
        });
        jXTable.setColumnControlVisible(true);
        jXTable.setVisibleRowCount(Math.min(list.size() + 1, 5));
        jXTable.packAll();
        arrayList.add(new JScrollPane((Component)jXTable));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(View.getSingleton().getMainFrame(), arrayList.toArray(), "OWASP ZAP", 1);
            }
        });
    }

    public int addScriptsFromDir(File file) {
        logger.debug((Object)("Adding scripts from dir: " + file.getAbsolutePath()));
        int n = 0;
        for (ScriptType scriptType : this.getScriptTypes()) {
            File file2 = new File(file, scriptType.getName());
            if (!file2.exists()) continue;
            for (File file3 : file2.listFiles()) {
                String string = file3.getName().substring(file3.getName().lastIndexOf(".") + 1);
                String string2 = this.getEngineNameForExtension(string);
                if (string2 != null) {
                    try {
                        ScriptWrapper scriptWrapper;
                        String string3;
                        if (file3.canWrite()) {
                            string3 = this.getUniqueScriptName(file3.getName(), string);
                            logger.debug((Object)("Loading script " + string3));
                            scriptWrapper = new ScriptWrapper(string3, "", this.getEngineWrapper(string2), scriptType, false, file3);
                            this.loadScript(scriptWrapper);
                            this.addScript(scriptWrapper, false);
                        } else {
                            string3 = this.getUniqueTemplateName(file3.getName(), string);
                            logger.debug((Object)("Loading script " + string3));
                            scriptWrapper = new ScriptWrapper(string3, "", this.getEngineWrapper(string2), scriptType, false, file3);
                            this.loadScript(scriptWrapper);
                            this.addTemplate(scriptWrapper, false);
                        }
                        ++n;
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                    continue;
                }
                logger.debug((Object)("Ignoring " + file3.getName()));
            }
        }
        return n;
    }

    public int removeScriptsFromDir(File file) {
        logger.debug((Object)("Removing scripts from dir: " + file.getAbsolutePath()));
        int n = 0;
        for (ScriptType scriptType : this.getScriptTypes()) {
            File file2 = new File(file, scriptType.getName());
            if (!file2.exists()) continue;
            for (ScriptWrapper scriptWrapper : this.getScripts(scriptType)) {
                if (!scriptWrapper.getFile().getParentFile().equals(file2)) continue;
                this.removeScript(scriptWrapper);
                ++n;
            }
            for (ScriptWrapper scriptWrapper : this.getTemplates(scriptType)) {
                if (!scriptWrapper.getFile().getParentFile().equals(file2)) continue;
                this.removeTemplate(scriptWrapper);
                ++n;
            }
        }
        return n;
    }

    public int getScriptCount(File file) {
        int n = 0;
        for (ScriptType scriptType : this.getScriptTypes()) {
            File file2 = new File(file, scriptType.getName());
            if (!file2.exists()) continue;
            for (File file3 : file2.listFiles()) {
                String string = file3.getName().substring(file3.getName().lastIndexOf(".") + 1);
                String string2 = this.getEngineNameForExtension(string);
                if (string2 == null) continue;
                ++n;
            }
        }
        return n;
    }

    private String getUniqueScriptName(String string, String string2) {
        if (this.getScript(string) == null) {
            return string;
        }
        String string3 = string.substring(0, string.length() - string2.length() - 1);
        int n = 1;
        while (this.getScript(string = string3 + "(" + ++n + ")." + string2) != null) {
        }
        return string;
    }

    private String getUniqueTemplateName(String string, String string2) {
        if (this.getTreeModel().getTemplate(string) == null) {
            return string;
        }
        String string3 = string.substring(0, string.length() - string2.length() - 1);
        int n = 1;
        do {
            string = string3 + "(" + ++n + ")." + string2;
        } while (this.getTreeModel().getTemplate(string) != null);
        return string;
    }

    private void loadTemplates() {
        this.loadTemplates(null);
    }

    private void loadTemplates(ScriptEngineWrapper scriptEngineWrapper) {
        for (ScriptType scriptType : this.getScriptTypes()) {
            this.loadScriptTemplates(scriptType, scriptEngineWrapper);
        }
    }

    private void loadScriptTemplates(ScriptType scriptType) {
        this.loadScriptTemplates(scriptType, null);
    }

    private void loadScriptTemplates(ScriptType scriptType, ScriptEngineWrapper scriptEngineWrapper) {
        File file = new File(Constant.getZapHome() + File.separator + TEMPLATES_DIR + File.separator + scriptType.getName());
        File file2 = new File(Constant.getZapInstall() + File.separator + TEMPLATES_DIR + File.separator + scriptType.getName());
        if (file.exists()) {
            for (File file3 : file.listFiles()) {
                this.loadTemplate(file3, scriptType, scriptEngineWrapper, false);
            }
        }
        if (file2.exists()) {
            for (File file3 : file2.listFiles()) {
                this.loadTemplate(file3, scriptType, scriptEngineWrapper, true);
            }
        }
    }

    private void loadTemplate(File file, ScriptType scriptType, ScriptEngineWrapper scriptEngineWrapper, boolean bl) {
        String string;
        String string2;
        if (file.getName().indexOf(".") > 0 && this.getTreeModel().getTemplate(file.getName()) == null && (string2 = this.getEngineNameForExtension(string = file.getName().substring(file.getName().lastIndexOf(".") + 1))) != null && (scriptEngineWrapper == null || scriptEngineWrapper.getEngine().getFactory().getExtensions().contains(string))) {
            try {
                ScriptWrapper scriptWrapper = new ScriptWrapper(file.getName(), "", this.getEngineWrapper(string2), scriptType, false, file);
                this.loadScript(scriptWrapper);
                this.addTemplate(scriptWrapper);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (!bl) {
                    logger.error((Object)invalidParameterException.getMessage(), (Throwable)invalidParameterException);
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptWrapper loadScript(ScriptWrapper scriptWrapper) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(scriptWrapper.getFile()));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
        }
        scriptWrapper.setContents(stringBuilder.toString());
        scriptWrapper.setChanged(false);
        if (scriptWrapper.getType() == null) {
            scriptWrapper.setType(this.getScriptType(scriptWrapper.getTypeName()));
        }
        return scriptWrapper;
    }

    public List<ScriptWrapper> getScripts(String string) {
        return this.getScripts(this.getScriptType(string));
    }

    public List<ScriptWrapper> getScripts(ScriptType scriptType) {
        ArrayList<ScriptWrapper> arrayList = new ArrayList<ScriptWrapper>();
        if (scriptType == null) {
            return arrayList;
        }
        for (ScriptNode scriptNode : this.getTreeModel().getNodes(scriptType.getName())) {
            ScriptWrapper scriptWrapper = (ScriptWrapper)scriptNode.getUserObject();
            this.refreshScript(scriptWrapper);
            arrayList.add((ScriptWrapper)scriptNode.getUserObject());
        }
        return arrayList;
    }

    public List<ScriptWrapper> getTemplates(ScriptType scriptType) {
        ArrayList<ScriptWrapper> arrayList = new ArrayList<ScriptWrapper>();
        if (scriptType == null) {
            return arrayList;
        }
        for (ScriptWrapper scriptWrapper : this.getTreeModel().getTemplates(scriptType)) {
            arrayList.add(scriptWrapper);
        }
        return arrayList;
    }

    private Writer getWriters(ScriptWrapper scriptWrapper) {
        Writer writer = scriptWrapper.getWriter();
        if (writer == null) {
            return this.writers;
        }
        MultipleWriters multipleWriters = new MultipleWriters();
        multipleWriters.addWriter(writer);
        multipleWriters.addWriter(this.writers);
        return multipleWriters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invocable invokeScript(ScriptWrapper scriptWrapper) throws ScriptException {
        logger.debug((Object)("invokeScript " + scriptWrapper.getName()));
        this.preInvokeScript(scriptWrapper);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ExtensionFactory.getAddOnLoader());
        try {
            Invocable invocable = this.invokeScriptImpl(scriptWrapper);
            return invocable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private void preInvokeScript(ScriptWrapper scriptWrapper) throws ScriptException {
        if (scriptWrapper.getEngine() == null) {
            scriptWrapper.setEngine(this.getEngineWrapper(scriptWrapper.getEngineName()));
        }
        if (scriptWrapper.getEngine() == null) {
            throw new ScriptException("Failed to find script engine: " + scriptWrapper.getEngineName());
        }
        this.refreshScript(scriptWrapper);
        scriptWrapper.setLastErrorDetails("");
        scriptWrapper.setLastException(null);
        scriptWrapper.setLastOutput("");
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.preInvoke(scriptWrapper);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private Invocable invokeScriptImpl(ScriptWrapper scriptWrapper) {
        ScriptEngine scriptEngine = scriptWrapper.getEngine().getEngine();
        Writer writer = this.getWriters(scriptWrapper);
        scriptEngine.getContext().setWriter(writer);
        scriptEngine.getContext().setAttribute(SCRIPT_NAME_ATT, scriptWrapper.getName(), 100);
        try {
            scriptEngine.eval(scriptWrapper.getContents());
        }
        catch (Exception exception) {
            this.handleScriptException(scriptWrapper, writer, exception);
        }
        if (scriptEngine instanceof Invocable) {
            return (Invocable)((Object)scriptEngine);
        }
        return null;
    }

    public Invocable invokeScriptWithOutAddOnLoader(ScriptWrapper scriptWrapper) throws ScriptException {
        logger.debug((Object)("invokeScriptWithOutAddOnLoader " + scriptWrapper.getName()));
        this.preInvokeScript(scriptWrapper);
        return this.invokeScriptImpl(scriptWrapper);
    }

    public void handleScriptException(ScriptWrapper scriptWrapper, Exception exception) {
        this.handleScriptException(scriptWrapper, this.getWriters(scriptWrapper), exception);
    }

    private void handleScriptException(ScriptWrapper scriptWrapper, Writer writer, Exception exception) {
        Exception exception2 = exception;
        if (exception2 instanceof ScriptException && exception2.getCause() instanceof Exception) {
            exception2 = (Exception)exception2.getCause();
        }
        try {
            writer.append(exception2.toString());
        }
        catch (IOException iOException) {
            logger.error((Object)exception2.getMessage(), (Throwable)exception2);
        }
        this.setError(scriptWrapper, exception2);
        this.setEnabled(scriptWrapper, false);
    }

    public void invokeTargetedScript(ScriptWrapper scriptWrapper, HttpMessage httpMessage) {
        ExtensionScript.validateScriptType(scriptWrapper, TYPE_TARGETED);
        Writer writer = this.getWriters(scriptWrapper);
        try {
            TargetedScript targetedScript = this.getInterface(scriptWrapper, TargetedScript.class);
            if (targetedScript != null) {
                targetedScript.invokeWith(httpMessage);
            } else {
                this.handleFailedScriptInterface(scriptWrapper, writer, Constant.messages.getString("script.interface.targeted.error"));
            }
        }
        catch (Exception exception) {
            this.handleScriptException(scriptWrapper, writer, exception);
        }
    }

    private static void validateScriptType(ScriptWrapper scriptWrapper, String string) throws IllegalArgumentException {
        if (!string.equals(scriptWrapper.getTypeName())) {
            throw new IllegalArgumentException("Script " + scriptWrapper.getName() + " is not a '" + string + "' script: " + scriptWrapper.getTypeName());
        }
    }

    public void handleFailedScriptInterface(ScriptWrapper scriptWrapper, String string) {
        this.handleFailedScriptInterface(scriptWrapper, this.getWriters(scriptWrapper), string);
    }

    private void handleFailedScriptInterface(ScriptWrapper scriptWrapper, Writer writer, String string) {
        try {
            writer.append(string);
        }
        catch (IOException iOException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to append script error message because of an exception:", (Throwable)iOException);
            }
            logger.warn((Object)("Failed to append error message: " + string));
        }
        this.setError(scriptWrapper, string);
        this.setEnabled(scriptWrapper, false);
    }

    public boolean invokeProxyScript(ScriptWrapper scriptWrapper, HttpMessage httpMessage, boolean bl) {
        ExtensionScript.validateScriptType(scriptWrapper, TYPE_PROXY);
        Writer writer = this.getWriters(scriptWrapper);
        try {
            ProxyScript proxyScript = this.getInterface(scriptWrapper, ProxyScript.class);
            if (proxyScript != null) {
                if (bl) {
                    return proxyScript.proxyRequest(httpMessage);
                }
                return proxyScript.proxyResponse(httpMessage);
            }
            this.handleFailedScriptInterface(scriptWrapper, writer, Constant.messages.getString("script.interface.proxy.error"));
        }
        catch (Exception exception) {
            this.handleScriptException(scriptWrapper, writer, exception);
        }
        return true;
    }

    public void invokeSenderScript(ScriptWrapper scriptWrapper, HttpMessage httpMessage, int n, HttpSender httpSender, boolean bl) {
        ExtensionScript.validateScriptType(scriptWrapper, TYPE_HTTP_SENDER);
        Writer writer = this.getWriters(scriptWrapper);
        try {
            HttpSenderScript httpSenderScript = this.getInterface(scriptWrapper, HttpSenderScript.class);
            if (httpSenderScript != null) {
                if (bl) {
                    httpSenderScript.sendingRequest(httpMessage, n, new HttpSenderScriptHelper(httpSender));
                } else {
                    httpSenderScript.responseReceived(httpMessage, n, new HttpSenderScriptHelper(httpSender));
                }
            } else {
                this.handleFailedScriptInterface(scriptWrapper, writer, Constant.messages.getString("script.interface.httpsender.error"));
            }
        }
        catch (Exception exception) {
            this.handleScriptException(scriptWrapper, writer, exception);
        }
    }

    public void setChanged(ScriptWrapper scriptWrapper, boolean bl) {
        scriptWrapper.setChanged(bl);
        ScriptNode scriptNode = this.getTreeModel().getNodeForScript(scriptWrapper);
        if (scriptNode.getNodeName().equals(scriptWrapper.getName())) {
            this.getTreeModel().nodeStructureChanged(scriptWrapper);
        } else {
            scriptNode.setNodeName(scriptWrapper.getName());
            this.getTreeModel().nodeStructureChanged(scriptNode.getParent());
        }
        this.notifyScriptChanged(scriptWrapper);
    }

    private void notifyScriptChanged(ScriptWrapper scriptWrapper) {
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.scriptChanged(scriptWrapper);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void setEnabled(ScriptWrapper scriptWrapper, boolean bl) {
        if (!scriptWrapper.getType().isEnableable()) {
            return;
        }
        if (bl && scriptWrapper.getEngine() == null) {
            return;
        }
        scriptWrapper.setEnabled(bl);
        this.getTreeModel().nodeStructureChanged(scriptWrapper);
        this.notifyScriptChanged(scriptWrapper);
    }

    public void setError(ScriptWrapper scriptWrapper, String string) {
        scriptWrapper.setError(true);
        scriptWrapper.setLastErrorDetails(string);
        scriptWrapper.setLastOutput(string);
        this.getTreeModel().nodeStructureChanged(scriptWrapper);
        for (ScriptEventListener scriptEventListener : this.listeners) {
            try {
                scriptEventListener.scriptError(scriptWrapper);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void setError(ScriptWrapper scriptWrapper, Exception exception) {
        scriptWrapper.setLastException(exception);
        this.setError(scriptWrapper, exception.getMessage());
    }

    public void addListener(ScriptEventListener scriptEventListener) {
        this.listeners.add(scriptEventListener);
    }

    public void removeListener(ScriptEventListener scriptEventListener) {
        this.listeners.remove(scriptEventListener);
    }

    public void addWriter(Writer writer) {
        this.writers.addWriter(writer);
    }

    public void removeWriter(Writer writer) {
        this.writers.removeWriter(writer);
    }

    public ScriptUI getScriptUI() {
        return this.scriptUI;
    }

    public void setScriptUI(ScriptUI scriptUI) {
        if (this.scriptUI != null) {
            throw new InvalidParameterException("A script UI has already been set - only one is supported");
        }
        this.scriptUI = scriptUI;
    }

    public void removeScriptUI() {
        this.scriptUI = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInterface(ScriptWrapper scriptWrapper, Class<T> clazz) throws ScriptException, IOException {
        Object object;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ExtensionFactory.getAddOnLoader());
        try {
            object = scriptWrapper.getInterface(clazz);
            if (object != null) {
                T t = object;
                return t;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        if (scriptWrapper.isRunableStandalone()) {
            return null;
        }
        object = this.invokeScript(scriptWrapper);
        if (object != null) {
            return object.getInterface(clazz);
        }
        return null;
    }

    public <T> T getInterfaceWithOutAddOnLoader(ScriptWrapper scriptWrapper, Class<T> clazz) throws ScriptException, IOException {
        T t = scriptWrapper.getInterface(clazz);
        if (t != null) {
            return t;
        }
        return this.invokeScriptWithOutAddOnLoader(scriptWrapper).getInterface(clazz);
    }

    @Override
    public List<String> getUnsavedResources() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ScriptType scriptType : this.getScriptTypes()) {
            for (ScriptWrapper scriptWrapper : this.getScripts(scriptType)) {
                if (!scriptWrapper.isChanged()) continue;
                arrayList.add(MessageFormat.format(Constant.messages.getString("script.resource"), scriptWrapper.getName()));
            }
        }
        return arrayList;
    }

    private void openCmdLineFile(File file) throws IOException, ScriptException {
        if (!file.exists()) {
            CommandLine.info(MessageFormat.format(Constant.messages.getString("script.cmdline.nofile"), file.getAbsolutePath()));
            return;
        }
        if (!file.canRead()) {
            CommandLine.info(MessageFormat.format(Constant.messages.getString("script.cmdline.noread"), file.getAbsolutePath()));
            return;
        }
        int n = file.getName().lastIndexOf(".");
        if (n <= 0) {
            CommandLine.info(MessageFormat.format(Constant.messages.getString("script.cmdline.noext"), file.getAbsolutePath()));
            return;
        }
        String string = file.getName().substring(n + 1);
        String string2 = this.getEngineNameForExtension(string);
        if (string2 == null) {
            CommandLine.info(MessageFormat.format(Constant.messages.getString("script.cmdline.noengine"), string));
            return;
        }
        ScriptWrapper scriptWrapper = new ScriptWrapper(file.getName(), "", string2, this.getScriptType(TYPE_STANDALONE), true, file);
        this.loadScript(scriptWrapper);
        this.addScript(scriptWrapper);
        if (!View.isInitialised()) {
            this.invokeScript(scriptWrapper);
        }
    }

    @Override
    public void execute(CommandLineArgument[] commandLineArgumentArray) {
        if (this.arguments[0].isEnabled()) {
            for (CommandLineArgument commandLineArgument : commandLineArgumentArray) {
                Vector<String> vector = commandLineArgument.getArguments();
                if (vector == null) continue;
                for (String string : vector) {
                    try {
                        this.openCmdLineFile(new File(string));
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        } else {
            return;
        }
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-script", 1, null, "", "-script <script>         " + Constant.messages.getString("script.cmdline.help"));
        return this.arguments;
    }

    @Override
    public boolean handleFile(File file) {
        int n = file.getName().lastIndexOf(".");
        if (n <= 0) {
            return false;
        }
        String string = file.getName().substring(n + 1);
        String string2 = this.getEngineNameForExtension(string);
        if (string2 == null) {
            return false;
        }
        try {
            this.openCmdLineFile(file);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
        return true;
    }

    @Override
    public List<String> getHandledExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ScriptEngineWrapper scriptEngineWrapper : this.engineWrappers) {
            arrayList.addAll(scriptEngineWrapper.getExtensions());
        }
        return arrayList;
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    private static class ClearScriptVarsOnSessionChange
    implements SessionChangedListener {
        private ClearScriptVarsOnSessionChange() {
        }

        @Override
        public void sessionChanged(Session session) {
        }

        @Override
        public void sessionAboutToChange(Session session) {
            ScriptVars.clear();
        }

        @Override
        public void sessionScopeChanged(Session session) {
        }

        @Override
        public void sessionModeChanged(Control.Mode mode) {
        }
    }
}

