/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.zaproxy.zap.model.Vulnerability;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class VulnerabilitiesLoader {
    private static final Logger logger = Logger.getLogger(VulnerabilitiesLoader.class);
    private final Path directory;
    private final String fileName;
    private final String fileExtension;

    public VulnerabilitiesLoader(Path path, String string, String string2) {
        Validate.notNull(path, "Parameter directory must not be null.");
        Validate.notEmpty(string, "Parameter fileName must not be null nor empty.");
        Validate.notEmpty(string2, "Parameter fileExtension must not be null nor empty.");
        this.directory = path;
        this.fileName = string;
        this.fileExtension = string2;
    }

    public List<Vulnerability> load(Locale locale) {
        List<String> list = this.getListOfVulnerabilitiesFiles();
        for (Locale locale2 : this.getCandidateLocales(locale)) {
            List<Vulnerability> list2;
            String string = this.createFilename(locale2);
            if (!list.contains(string)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loading vulnerabilities from " + string + " for locale " + locale + "."));
            }
            if ((list2 = this.loadVulnerabilitiesFile(this.directory.resolve(string))) == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(list2);
        }
        return Collections.emptyList();
    }

    private List<Locale> getCandidateLocales(Locale locale) {
        return ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales(this.fileName, locale);
    }

    private String createFilename(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder(this.fileName);
        String string = locale.toString();
        if (!string.isEmpty()) {
            stringBuilder.append('_').append(locale);
        }
        stringBuilder.append(this.fileExtension);
        return stringBuilder.toString();
    }

    private List<Vulnerability> loadVulnerabilitiesFile(Path path) {
        String[] stringArray;
        ZapXmlConfiguration zapXmlConfiguration;
        try {
            zapXmlConfiguration = new ZapXmlConfiguration(path.toFile());
        }
        catch (ConfigurationException configurationException) {
            logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
            return null;
        }
        try {
            stringArray = zapXmlConfiguration.getStringArray("vuln_items");
        }
        catch (ConversionException conversionException) {
            logger.error((Object)conversionException.getMessage(), (Throwable)conversionException);
            return null;
        }
        int n = stringArray.length;
        ArrayList<Vulnerability> arrayList = new ArrayList<Vulnerability>(n);
        for (String string : stringArray) {
            ArrayList<String> arrayList2;
            String string2 = "vuln_item_" + string;
            try {
                arrayList2 = new ArrayList<String>(Arrays.asList(zapXmlConfiguration.getStringArray(string2 + ".reference")));
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException.getMessage(), (Throwable)conversionException);
                arrayList2 = new ArrayList(0);
            }
            Vulnerability vulnerability = new Vulnerability(string, zapXmlConfiguration.getString(string2 + ".alert"), zapXmlConfiguration.getString(string2 + ".desc"), zapXmlConfiguration.getString(string2 + ".solution"), arrayList2);
            arrayList.add(vulnerability);
        }
        return arrayList;
    }

    private List<String> getListOfVulnerabilitiesFiles() {
        final Pattern pattern = LocaleUtils.createResourceFilesPattern(this.fileName, this.fileExtension);
        final ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Files.walkFileTree(this.directory, Collections.emptySet(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    String string = path.getFileName().toString();
                    if (pattern.matcher(string).matches()) {
                        arrayList.add(string);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            logger.error((Object)("An error occurred while walking directory: " + this.directory), (Throwable)iOException);
        }
        return arrayList;
    }
}

