/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.util.KeyValuePair;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;

public abstract class SettingCommand
extends Command {
    private final OptionSpec<KeyValuePair> settingOption;

    public SettingCommand(String description) {
        super(description);
        this.settingOption = this.parser.accepts("E", "Configure a setting").withRequiredArg().ofType(KeyValuePair.class);
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (KeyValuePair kvp : this.settingOption.values(options)) {
            if (kvp.value.isEmpty()) {
                throw new UserException(64, "Setting [" + kvp.key + "] must not be empty");
            }
            settings.put(kvp.key, kvp.value);
        }
        SettingCommand.putSystemPropertyIfSettingIsMissing(settings, "path.conf", "es.path.conf");
        SettingCommand.putSystemPropertyIfSettingIsMissing(settings, "path.data", "es.path.data");
        SettingCommand.putSystemPropertyIfSettingIsMissing(settings, "path.home", "es.path.home");
        SettingCommand.putSystemPropertyIfSettingIsMissing(settings, "path.logs", "es.path.logs");
        this.execute(terminal, options, settings);
    }

    protected static void putSystemPropertyIfSettingIsMissing(Map<String, String> settings, String setting, String key) {
        String value = System.getProperty(key);
        if (value != null) {
            if (settings.containsKey(setting)) {
                String message = String.format(Locale.ROOT, "duplicate setting [%s] found via command-line [%s] and system property [%s]", setting, settings.get(setting), value);
                throw new IllegalArgumentException(message);
            }
            settings.put(setting, value);
        }
    }

    protected abstract void execute(Terminal var1, OptionSet var2, Map<String, String> var3) throws Exception;
}

