/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class InspectPrimitiveDataText {
    private static final String INDENT = "  ";
    private static final char NL = '\n';
    private final StringBuilder s = new StringBuilder();
    private final OsmDataLayer layer;

    InspectPrimitiveDataText(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    private InspectPrimitiveDataText add(String string, String ... stringArray) {
        this.s.append(INDENT).append(string);
        for (String string2 : stringArray) {
            this.s.append(string2);
        }
        this.s.append('\n');
        return this;
    }

    private static String getNameAndId(String string, long l) {
        if (string != null) {
            return string + I18n.tr(" ({0})", Long.toString(l));
        }
        return Long.toString(l);
    }

    public void addPrimitive(OsmPrimitive osmPrimitive) {
        this.addHeadline(osmPrimitive);
        if (osmPrimitive.getDataSet() == null || osmPrimitive.getDataSet().getPrimitiveById(osmPrimitive) == null) {
            this.s.append('\n').append(INDENT).append(I18n.tr("not in data set", new Object[0])).append('\n');
            return;
        }
        if (osmPrimitive.isIncomplete()) {
            this.s.append('\n').append(INDENT).append(I18n.tr("incomplete", new Object[0])).append('\n');
            return;
        }
        this.s.append('\n');
        this.addState(osmPrimitive);
        this.addCommon(osmPrimitive);
        this.addAttributes(osmPrimitive);
        this.addSpecial(osmPrimitive);
        this.addReferrers(this.s, osmPrimitive);
        this.addConflicts(osmPrimitive);
        this.s.append('\n');
    }

    void addHeadline(OsmPrimitive osmPrimitive) {
        this.addType(osmPrimitive);
        this.addNameAndId(osmPrimitive);
    }

    void addType(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            this.s.append(I18n.tr("Node: ", new Object[0]));
        } else if (osmPrimitive instanceof Way) {
            this.s.append(I18n.tr("Way: ", new Object[0]));
        } else if (osmPrimitive instanceof Relation) {
            this.s.append(I18n.tr("Relation: ", new Object[0]));
        }
    }

    void addNameAndId(OsmPrimitive osmPrimitive) {
        String string = osmPrimitive.get("name");
        if (string == null) {
            this.s.append(osmPrimitive.getUniqueId());
        } else {
            this.s.append(InspectPrimitiveDataText.getNameAndId(string, osmPrimitive.getUniqueId()));
        }
    }

    void addState(OsmPrimitive osmPrimitive) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(INDENT);
        if (osmPrimitive.isDeleted()) {
            stringBuilder.append(I18n.tr("deleted", new Object[0])).append(INDENT);
        }
        if (!osmPrimitive.isVisible()) {
            stringBuilder.append(I18n.tr("deleted-on-server", new Object[0])).append(INDENT);
        }
        if (osmPrimitive.isModified()) {
            stringBuilder.append(I18n.tr("modified", new Object[0])).append(INDENT);
        }
        if (osmPrimitive.isDisabledAndHidden()) {
            stringBuilder.append(I18n.tr("filtered/hidden", new Object[0])).append(INDENT);
        }
        if (osmPrimitive.isDisabled()) {
            stringBuilder.append(I18n.tr("filtered/disabled", new Object[0])).append(INDENT);
        }
        if (osmPrimitive.hasDirectionKeys()) {
            if (osmPrimitive.reversedDirection()) {
                stringBuilder.append(I18n.tr("has direction keys (reversed)", new Object[0])).append(INDENT);
            } else {
                stringBuilder.append(I18n.tr("has direction keys", new Object[0])).append(INDENT);
            }
        }
        if (!(string = stringBuilder.toString().trim()).isEmpty()) {
            this.add(I18n.tr("State: ", new Object[0]), stringBuilder.toString().trim());
        }
    }

    void addCommon(OsmPrimitive osmPrimitive) {
        this.add(I18n.tr("Data Set: ", new Object[0]), Integer.toHexString(osmPrimitive.getDataSet().hashCode()));
        this.add(I18n.tr("Edited at: ", new Object[0]), osmPrimitive.isTimestampEmpty() ? I18n.tr("<new object>", new Object[0]) : DateUtils.fromTimestamp(osmPrimitive.getRawTimestamp()));
        this.add(I18n.tr("Edited by: ", new Object[0]), osmPrimitive.getUser() == null ? I18n.tr("<new object>", new Object[0]) : InspectPrimitiveDataText.getNameAndId(osmPrimitive.getUser().getName(), osmPrimitive.getUser().getId()));
        this.add(I18n.tr("Version: ", new Object[0]), Integer.toString(osmPrimitive.getVersion()));
        this.add(I18n.tr("In changeset: ", new Object[0]), Integer.toString(osmPrimitive.getChangesetId()));
    }

    void addAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive.hasKeys()) {
            this.add(I18n.tr("Tags: ", new Object[0]), new String[0]);
            for (String string : osmPrimitive.keySet()) {
                this.s.append(INDENT).append(INDENT);
                this.s.append(String.format("\"%s\"=\"%s\"%n", string, osmPrimitive.get(string)));
            }
        }
    }

    void addSpecial(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            this.addCoordinates((Node)osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            this.addBbox(osmPrimitive);
            this.add(I18n.tr("Centroid: ", new Object[0]), Main.getProjection().eastNorth2latlon(Geometry.getCentroid(((Way)osmPrimitive).getNodes())).toStringCSV(", "));
            this.addWayNodes((Way)osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            this.addBbox(osmPrimitive);
            this.addRelationMembers((Relation)osmPrimitive);
        }
    }

    void addRelationMembers(Relation relation) {
        this.add(I18n.trn("{0} Member: ", "{0} Members: ", relation.getMembersCount(), relation.getMembersCount()), new String[0]);
        for (RelationMember relationMember : relation.getMembers()) {
            this.s.append(INDENT).append(INDENT);
            this.addHeadline(relationMember.getMember());
            this.s.append(I18n.tr(" as \"{0}\"", relationMember.getRole()));
            this.s.append('\n');
        }
    }

    void addWayNodes(Way way) {
        this.add(I18n.tr("{0} Nodes: ", way.getNodesCount()), new String[0]);
        for (Node node : way.getNodes()) {
            this.s.append(INDENT).append(INDENT);
            this.addNameAndId(node);
            this.s.append('\n');
        }
    }

    void addBbox(OsmPrimitive osmPrimitive) {
        BBox bBox = osmPrimitive.getBBox();
        if (bBox != null) {
            this.add(I18n.tr("Bounding box: ", new Object[0]), bBox.toStringCSV(", "));
            EastNorth eastNorth = Main.getProjection().latlon2eastNorth(bBox.getBottomRight());
            EastNorth eastNorth2 = Main.getProjection().latlon2eastNorth(bBox.getTopLeft());
            this.add(I18n.tr("Bounding box (projected): ", new Object[0]), Double.toString(eastNorth2.east()), ", ", Double.toString(eastNorth.north()), ", ", Double.toString(eastNorth.east()), ", ", Double.toString(eastNorth2.north()));
            this.add(I18n.tr("Center of bounding box: ", new Object[0]), bBox.getCenter().toStringCSV(", "));
        }
    }

    void addCoordinates(Node node) {
        if (node.getCoor() != null) {
            this.add(I18n.tr("Coordinates: ", new Object[0]), Double.toString(node.getCoor().lat()), ", ", Double.toString(node.getCoor().lon()));
            this.add(I18n.tr("Coordinates (projected): ", new Object[0]), Double.toString(node.getEastNorth().east()), ", ", Double.toString(node.getEastNorth().north()));
        }
    }

    void addReferrers(StringBuilder stringBuilder, OsmPrimitive osmPrimitive) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        if (!list.isEmpty()) {
            this.add(I18n.tr("Part of: ", new Object[0]), new String[0]);
            for (OsmPrimitive osmPrimitive2 : list) {
                stringBuilder.append(INDENT).append(INDENT);
                this.addHeadline(osmPrimitive2);
                stringBuilder.append('\n');
            }
        }
    }

    void addConflicts(OsmPrimitive osmPrimitive) {
        Conflict<?> conflict = this.layer.getConflicts().getConflictForMy(osmPrimitive);
        if (conflict != null) {
            this.add(I18n.tr("In conflict with: ", new Object[0]), new String[0]);
            this.addNameAndId((OsmPrimitive)conflict.getTheir());
        }
    }

    public String toString() {
        return this.s.toString();
    }
}

