/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.TagTableColumnModelBuilder;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.widgets.JosmTable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagTable
extends JosmTable
implements TagEditorModel.EndEditListener {
    private TagCellEditor editor;
    private final TagEditorModel model;
    private Component nextFocusComponent;
    private final CopyOnWriteArrayList<Component> doNotStopCellEditingWhenFocused = new CopyOnWriteArrayList();
    private transient CellEditorRemover editorRemover;
    private DeleteAction deleteAction;
    private AddAction addAction;
    private PasteAction pasteAction;

    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    public AddAction getAddAction() {
        return this.addAction;
    }

    public PasteAction getPasteAction() {
        return this.pasteAction;
    }

    protected final void init(int n) {
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setSelectionMode(1);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(107, 2), "addTag");
        this.getActionMap().put("addTag", this.addAction);
        this.pasteAction = new PasteAction();
        TagCellEditor tagCellEditor = new TagCellEditor(n);
        this.setRowHeight(tagCellEditor.getEditor().getPreferredSize().height);
        this.setTagCellEditor(tagCellEditor);
    }

    public TagTable(TagEditorModel tagEditorModel, int n) {
        super(tagEditorModel, new TagTableColumnModelBuilder(new TagCellRenderer(), I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])).setSelectionModel(tagEditorModel.getColumnSelectionModel()).build(), tagEditorModel.getRowSelectionModel());
        this.model = tagEditorModel;
        tagEditorModel.setEndEditListener(this);
        this.init(n);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredFullWidthSize();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyCode() == 127) {
            if (this.isEditing() && this.getSelectedColumnCount() == 1 && this.getSelectedRowCount() == 1) {
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            this.getDeleteAction().actionPerformed(null);
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionList(autoCompletionList);
        }
    }

    public void setAutoCompletionManager(AutoCompletionManager autoCompletionManager) {
        if (autoCompletionManager == null) {
            Main.warn("argument autocomplete should not be null. Aborting.");
            Thread.dumpStack();
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionManager(autoCompletionManager);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        if (this.editor != null) {
            return this.editor.getAutoCompletionList();
        }
        return null;
    }

    public void setNextFocusComponent(Component component) {
        this.nextFocusComponent = component;
    }

    public TagCellEditor getTableCellEditor() {
        return this.editor;
    }

    public void setTagCellEditor(TagCellEditor tagCellEditor) {
        this.endCellEditing();
        this.editor = tagCellEditor;
        this.getColumnModel().getColumn(0).setCellEditor(tagCellEditor);
        this.getColumnModel().getColumn(1).setCellEditor(tagCellEditor);
    }

    public void requestFocusInCell(int n, int n2) {
        this.changeSelection(n, n2, false, false);
        this.editCellAt(n, n2);
        Component component = this.getEditorComponent();
        if (component != null) {
            component.requestFocusInWindow();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).selectAll();
            }
        }
    }

    public void addComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.addIfAbsent(component);
    }

    public void removeComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.remove(component);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        return super.editCellAt(n, n2, eventObject);
    }

    @Override
    public void endCellEditing() {
        TableCellEditor tableCellEditor;
        if (this.isEditing() && (tableCellEditor = this.getCellEditor()) != null) {
            tableCellEditor.stopCellEditing();
            tableCellEditor.cancelCellEditing();
        }
    }

    @Override
    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeEditor();
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        private final KeyboardFocusManager focusManager;

        CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!TagTable.this.isEditing()) {
                return;
            }
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == TagTable.this) {
                    return;
                }
                if (TagTable.this.doNotStopCellEditingWhenFocused.contains(component)) {
                    return;
                }
                if (!(component instanceof Window)) continue;
                if (component != SwingUtilities.getRoot(TagTable.this) || TagTable.this.getCellEditor().stopCellEditing()) break;
                TagTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    class PasteAction
    extends AbstractAction
    implements PropertyChangeListener {
        PasteAction() {
            new ImageProvider("pastetags").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Paste tags from buffer", new Object[0]));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Relation relation = new Relation();
            TagTable.this.model.applyToPrimitive(relation);
            new OsmTransferHandler().pasteTags(Collections.singleton(relation));
            TagTable.this.model.updateTags(new TagMap(relation.getKeys()).getTags());
        }

        protected final void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction
    implements PropertyChangeListener {
        AddAction() {
            new ImageProvider("dialogs", "add").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Add a new tag", new Object[0]));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            TableCellEditor tableCellEditor = TagTable.this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            if ((n = TagTable.this.model.getRowCount() - 1) < 0 || !((TagModel)TagTable.this.model.getValueAt(n, 0)).getName().trim().isEmpty()) {
                TagTable.this.model.appendNewTag();
            }
            TagTable.this.requestFocusInCell(TagTable.this.model.getRowCount() - 1, 0);
        }

        protected final void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        DeleteAction() {
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Delete the selection in the tag table", new Object[0]));
            TagTable.this.getSelectionModel().addListSelectionListener(this);
            TagTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.updateEnabledState();
        }

        protected void deleteTagNames() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTagNames(nArray);
        }

        protected void deleteTagValues() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTagValues(nArray);
        }

        protected void deleteTags() {
            int[] nArray = TagTable.this.getSelectedRows();
            TagTable.this.model.deleteTags(nArray);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            switch (TagTable.this.getSelectedColumnCount()) {
                case 1: {
                    if (TagTable.this.getSelectedColumn() == 0) {
                        this.deleteTagNames();
                        break;
                    }
                    if (TagTable.this.getSelectedColumn() != 1) break;
                    this.deleteTagValues();
                    break;
                }
                case 2: {
                    this.deleteTags();
                    break;
                }
            }
            TagTable.this.endCellEditing();
            if (TagTable.this.model.getRowCount() == 0) {
                TagTable.this.model.ensureOneTag();
                TagTable.this.requestFocusInCell(0, 0);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            if (TagTable.this.getSelectedColumnCount() >= 1 && TagTable.this.getSelectedRowCount() >= 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TagTable.this.getSelectedColumn();
            int n2 = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (n > 0 || n2 > 0) {
                if (n == 1) {
                    --n;
                } else {
                    n = 1;
                    --n2;
                }
            }
            TagTable.this.requestFocusInCell(n2, n);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = TagTable.this.getSelectedColumn();
            int n2 = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (n2 == -1 && n == -1) {
                TagTable.this.requestFocusInCell(0, 0);
                return;
            }
            if (n == 0) {
                ++n;
            } else if (n == 1 && n2 < TagTable.this.getRowCount() - 1) {
                n = 0;
                ++n2;
            } else if (n == 1 && n2 == TagTable.this.getRowCount() - 1) {
                String string = ((TagModel)TagTable.this.model.getValueAt(n2, 0)).getName();
                if (!string.trim().isEmpty()) {
                    TagTable.this.model.appendNewTag();
                    n = 0;
                    ++n2;
                } else {
                    TagTable.this.clearSelection();
                    if (TagTable.this.nextFocusComponent != null) {
                        TagTable.this.nextFocusComponent.requestFocusInWindow();
                    }
                    return;
                }
            }
            TagTable.this.requestFocusInCell(n2, n);
        }
    }
}

