/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.JavaObjectMessageResolution;
import com.oracle.truffle.api.interop.java.ReadFieldNodeSubNodeGen;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

abstract class ReadFieldNodeSub
extends JavaObjectMessageResolution.ReadFieldNode {
    ReadFieldNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, JavaObject object, Number index) {
        return this.access(frame, object, index);
    }

    @Specialization
    protected Object accessWithTarget(JavaObject object, String name) {
        return this.access(object, name);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new ReadRootNode(language);
    }

    private static final class ReadRootNode
    extends RootNode {
        @Node.Child
        private ReadFieldNodeSub node = ReadFieldNodeSubNodeGen.create();

        protected ReadRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver(frame);
            Object identifier = ForeignAccess.getArguments(frame).get(0);
            try {
                return this.node.executeWithTarget(frame, receiver, identifier);
            }
            catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e.getSuppliedValues());
            }
        }
    }
}

