/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.printf;

import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.core.format.exceptions.InvalidFormatException;
import org.jruby.truffle.core.format.printf.SprintfConfig;

public class PrintfSimpleParser {
    private final char[] source;

    public PrintfSimpleParser(char[] source) {
        this.source = source;
    }

    public List<SprintfConfig> parse() {
        ArrayList<SprintfConfig> configs = new ArrayList<SprintfConfig>();
        ArgType argType = ArgType.NONE;
        int end = this.source.length;
        int i = 0;
        while (i < end) {
            SprintfConfig config;
            int literalEnd;
            for (literalEnd = i; literalEnd < end && this.source[literalEnd] != '%'; ++literalEnd) {
            }
            int literalLength = literalEnd - i;
            if (literalLength > 0) {
                config = new SprintfConfig();
                config.setLiteral(true);
                char[] literalBytes = new char[literalLength];
                System.arraycopy(this.source, i, literalBytes, 0, literalLength);
                config.setLiteralBytes(PrintfSimpleParser.charsToBytes(literalBytes));
                configs.add(config);
            }
            if (literalEnd >= end) break;
            i = literalEnd + 1;
            config = new SprintfConfig();
            configs.add(config);
            boolean finished = false;
            boolean argTypeSet = false;
            block19: while (!finished) {
                char p = i >= this.source.length ? (char)'\u0000' : this.source[i];
                switch (p) {
                    case ' ': {
                        config.checkForFlags();
                        config.setHasSpace(true);
                        ++i;
                        continue block19;
                    }
                    case '#': {
                        config.checkForFlags();
                        config.setFsharp(true);
                        ++i;
                        continue block19;
                    }
                    case '+': {
                        config.checkForFlags();
                        config.setPlus(true);
                        ++i;
                        continue block19;
                    }
                    case '-': {
                        config.checkForFlags();
                        config.setMinus(true);
                        ++i;
                        continue block19;
                    }
                    case '0': {
                        config.checkForFlags();
                        config.setZero(true);
                        ++i;
                        continue block19;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        LookAheadResult r = this.getNum(i, end);
                        i = r.getNextI();
                        if (this.valueAt(i) != null && this.valueAt(i).charValue() == '$') {
                            if (config.getAbsoluteArgumentIndex() != null) {
                                throw new InvalidFormatException("value given twice - " + r.getNumber() + "$");
                            }
                            PrintfSimpleParser.checkPosArg(argType, r.getNumber());
                            argType = ArgType.NUMBERED;
                            argTypeSet = true;
                            config.setAbsoluteArgumentIndex(r.getNumber());
                            ++i;
                            continue block19;
                        }
                        config.checkForWidth();
                        config.setWidth(r.getNumber());
                        continue block19;
                    }
                    case '<': 
                    case '{': {
                        int j;
                        char term = p == '<' ? (char)'>' : '}';
                        for (j = i; j < end && this.source[j] != term; ++j) {
                        }
                        if (j >= end) {
                            throw new InvalidFormatException("malformed name - unmatched parenthesis");
                        }
                        int nameLength = j - (i + 1);
                        char[] nameBytes = new char[nameLength];
                        System.arraycopy(this.source, i + 1, nameBytes, 0, nameLength);
                        config.setNamesBytes(PrintfSimpleParser.charsToBytes(nameBytes));
                        i = j + 1;
                        PrintfSimpleParser.checkNameArg(argType, nameBytes);
                        argType = ArgType.NAMED;
                        argTypeSet = true;
                        if (term != '}') continue block19;
                        config.setFormatType(SprintfConfig.FormatType.OTHER);
                        config.setFormat('s');
                        finished = true;
                        continue block19;
                    }
                    case '*': {
                        config.checkForWidth();
                        LookAheadResult numberDollarWidth = this.getNumberDollar(i + 1, end);
                        if (numberDollarWidth.getNumber() != null) {
                            config.setArgWidth(true);
                            config.setWidth(numberDollarWidth.getNumber());
                            PrintfSimpleParser.checkPosArg(argType, numberDollarWidth.getNumber());
                            argType = ArgType.NUMBERED;
                            i = numberDollarWidth.getNextI();
                            continue block19;
                        }
                        PrintfSimpleParser.checkNextArg(argType, 1);
                        argType = ArgType.UNNUMBERED;
                        config.setWidthStar(true);
                        ++i;
                        continue block19;
                    }
                    case '.': {
                        if (config.hasPrecision()) {
                            throw new InvalidFormatException("precision given twice");
                        }
                        config.setPrecisionVisited(true);
                        if (this.valueAt(i + 1) != null && this.valueAt(i + 1).charValue() == '*') {
                            LookAheadResult numberDollar = this.getNumberDollar(i + 2, end);
                            if (numberDollar.getNumber() != null) {
                                config.setPrecision(numberDollar.getNumber());
                                config.setPrecisionArg(true);
                                PrintfSimpleParser.checkPosArg(argType, numberDollar.getNumber());
                                argType = ArgType.NUMBERED;
                                i = numberDollar.getNextI();
                                continue block19;
                            }
                            PrintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                            config.setPrecisionStar(true);
                            i += 2;
                            continue block19;
                        }
                        LookAheadResult re = this.getNum(i + 1, end);
                        config.setPrecision(re.getNumber());
                        i = re.getNextI();
                        continue block19;
                    }
                    case '\u0000': 
                    case '\n': {
                        --i;
                    }
                    case '%': {
                        if (config.hasFlags()) {
                            throw new InvalidFormatException("invalid format character - %");
                        }
                        config.setLiteral(true);
                        byte[] literal = new byte[]{37};
                        config.setLiteralBytes(literal);
                        ++i;
                        finished = true;
                        continue block19;
                    }
                    case 'c': {
                        config.setFormatType(SprintfConfig.FormatType.OTHER);
                        config.setFormat(p);
                        ++i;
                        if (!argTypeSet) {
                            PrintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        finished = true;
                        continue block19;
                    }
                    case 'p': 
                    case 's': {
                        config.setFormatType(SprintfConfig.FormatType.OTHER);
                        config.setFormat(p);
                        ++i;
                        if (!argTypeSet) {
                            PrintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        finished = true;
                        continue block19;
                    }
                    case 'B': 
                    case 'X': 
                    case 'b': 
                    case 'd': 
                    case 'i': 
                    case 'o': 
                    case 'u': 
                    case 'x': {
                        if (!argTypeSet) {
                            PrintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        config.setFormatType(SprintfConfig.FormatType.INTEGER);
                        config.setFormat(p);
                        finished = true;
                        ++i;
                        continue block19;
                    }
                    case 'A': 
                    case 'E': 
                    case 'G': 
                    case 'a': 
                    case 'e': 
                    case 'f': 
                    case 'g': {
                        if (!argTypeSet) {
                            PrintfSimpleParser.checkNextArg(argType, 1);
                            argType = ArgType.UNNUMBERED;
                        }
                        config.setFormatType(SprintfConfig.FormatType.FLOAT);
                        config.setFormat(p);
                        finished = true;
                        ++i;
                        continue block19;
                    }
                }
                throw new InvalidFormatException("malformed format string - %" + p);
            }
        }
        return configs;
    }

    private static void checkNextArg(ArgType argType, int nextArgumentIndex) {
        switch (argType) {
            case NUMBERED: {
                throw new InvalidFormatException("unnumbered(" + nextArgumentIndex + ") mixed with numbered");
            }
            case NAMED: {
                throw new InvalidFormatException("unnumbered(" + nextArgumentIndex + ") mixed with named");
            }
        }
    }

    private static void checkPosArg(ArgType posarg, int nextArgumentIndex) {
        if (posarg == ArgType.UNNUMBERED) {
            throw new InvalidFormatException("numbered(" + nextArgumentIndex + ") after unnumbered(" + (Object)((Object)posarg) + ")");
        }
        if (posarg == ArgType.NAMED) {
            throw new InvalidFormatException("numbered(" + nextArgumentIndex + ") after named");
        }
        if (nextArgumentIndex < 1) {
            throw new InvalidFormatException("invalid index - " + nextArgumentIndex + "$");
        }
    }

    private static void checkNameArg(ArgType argType, char[] name) {
        if (argType == ArgType.UNNUMBERED) {
            throw new InvalidFormatException("named" + new String(name) + " after unnumbered(%d)");
        }
        if (argType == ArgType.NUMBERED) {
            throw new InvalidFormatException("named" + new String(name) + " after numbered");
        }
    }

    private void checkPosArg(int relativeArgumentIndex, int absoluteArgumentIndex) {
        if (relativeArgumentIndex > 0) {
            throw new InvalidFormatException("numbered(" + absoluteArgumentIndex + ") after unnumbered(" + relativeArgumentIndex + ")");
        }
        if (relativeArgumentIndex == -2) {
            throw new InvalidFormatException("numbered(" + absoluteArgumentIndex + ") after named");
        }
        if (absoluteArgumentIndex < 1) {
            throw new InvalidFormatException("invalid index - " + absoluteArgumentIndex + "$");
        }
    }

    public LookAheadResult getNum(int startI, int end) {
        char nextChar;
        StringBuilder sb = new StringBuilder();
        int moreChars = 0;
        for (int i = startI; i < end && PrintfSimpleParser.isDigit(nextChar = this.source[i]); ++i) {
            sb.append(nextChar);
            ++moreChars;
        }
        int nextI = startI + moreChars;
        if (nextI >= end) {
            throw new InvalidFormatException("malformed format string - %%*[0-9]");
        }
        Integer result = sb.length() > 0 ? Integer.valueOf(Integer.parseInt(sb.toString())) : null;
        return new LookAheadResult(result, nextI);
    }

    public LookAheadResult getNumberDollar(int startI, int end) {
        int nextI;
        LookAheadResult lar = this.getNum(startI, end);
        Integer result = null;
        int newI = startI;
        if (lar.getNumber() != null && this.valueAt(nextI = lar.getNextI()) != null && this.valueAt(nextI).charValue() == '$') {
            result = lar.getNumber();
            newI = nextI + 1;
            if (result < 1) {
                throw new InvalidFormatException("invalid index - " + result + "$");
            }
        }
        return new LookAheadResult(result, newI);
    }

    public static boolean isDigit(char c) {
        return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }

    public Character valueAt(int index) {
        assert (index >= 0);
        if (index < this.source.length) {
            return Character.valueOf(this.source[index]);
        }
        return null;
    }

    private static byte[] charsToBytes(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int n = 0; n < chars.length; ++n) {
            bytes[n] = (byte)chars[n];
        }
        return bytes;
    }

    public static class LookAheadResult {
        private Integer number;
        private int nextI;

        public LookAheadResult(Integer number, int nextI) {
            this.number = number;
            this.nextI = nextI;
        }

        public Integer getNumber() {
            return this.number;
        }

        public int getNextI() {
            return this.nextI;
        }
    }

    private static enum ArgType {
        NONE,
        NUMBERED,
        UNNUMBERED,
        NAMED;

    }
}

