/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawSubstitution;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeTag;
import kotlin.reflect.jvm.internal.impl.renderer.CustomFlexibleRendering;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.CustomSubstitutionCapability;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RawTypeCapabilities
implements TypeCapabilities {
    public static final RawTypeCapabilities INSTANCE;

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        TypeCapability typeCapability;
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        Class<T> clazz = capabilityClass;
        if (Intrinsics.areEqual(clazz, CustomSubstitutionCapability.class)) {
            RawSubstitutionCapability rawSubstitutionCapability = RawSubstitutionCapability.INSTANCE;
            if (rawSubstitutionCapability == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawSubstitutionCapability;
        } else if (Intrinsics.areEqual(clazz, CustomFlexibleRendering.class)) {
            RawFlexibleRendering rawFlexibleRendering = RawFlexibleRendering.INSTANCE;
            if (rawFlexibleRendering == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawFlexibleRendering;
        } else if (Intrinsics.areEqual(clazz, RawTypeTag.class)) {
            RawTypeTag rawTypeTag = RawTypeTag.INSTANCE;
            if (rawTypeTag == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawTypeTag;
        } else {
            typeCapability = null;
        }
        return (T)typeCapability;
    }

    private RawTypeCapabilities() {
        INSTANCE = this;
    }

    static {
        new RawTypeCapabilities();
    }

    private static final class RawSubstitutionCapability
    implements CustomSubstitutionCapability {
        public static final RawSubstitutionCapability INSTANCE;

        @Override
        @Nullable
        public TypeSubstitution getSubstitution() {
            return RawSubstitution.INSTANCE;
        }

        @Override
        @Nullable
        public TypeSubstitution getSubstitutionToComposeWith() {
            return RawSubstitution.INSTANCE;
        }

        private RawSubstitutionCapability() {
            INSTANCE = this;
        }

        static {
            new RawSubstitutionCapability();
        }
    }

    private static final class RawFlexibleRendering
    implements CustomFlexibleRendering {
        public static final RawFlexibleRendering INSTANCE;

        /*
         * WARNING - void declaration
         */
        private final List<String> renderArguments(@NotNull DescriptorRenderer $receiver, KotlinType jetType) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = jetType.getArguments();
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                void var9_9 = destination$iv$iv;
                void v0 = it;
                Intrinsics.checkExpressionValueIsNotNull(v0, "it");
                String string = $receiver.renderTypeProjection((TypeProjection)v0);
                var9_9.add(string);
            }
            return (List)destination$iv$iv;
        }

        private final String replaceArgs(@NotNull String $receiver, String newArgs) {
            if (!StringsKt.contains$default((CharSequence)$receiver, '<', false, 2, null)) {
                return $receiver;
            }
            return StringsKt.substringBefore$default($receiver, '<', null, 2, null) + "<" + newArgs + ">" + StringsKt.substringAfterLast$default($receiver, '>', null, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public String renderInflexible(@NotNull KotlinType type2, @NotNull DescriptorRenderer renderer) {
            void $receiver;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            Intrinsics.checkParameterIsNotNull(renderer, "renderer");
            Object object = type2.getArguments();
            if (!object.isEmpty()) {
                return null;
            }
            object = new StringBuilder();
            StringBuilder stringBuilder = (StringBuilder)object;
            TypeConstructor typeConstructor2 = type2.getConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "type.constructor");
            $receiver.append(renderer.renderTypeConstructor(typeConstructor2));
            $receiver.append("(raw)");
            if (type2.isMarkedNullable()) {
                $receiver.append('?');
            }
            String string = ((StringBuilder)object).toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Pair<String, String> renderBounds(@NotNull Flexibility flexibility, @NotNull DescriptorRenderer renderer) {
            boolean bl;
            String newArgs;
            String upperRendered;
            String lowerRendered;
            block3: {
                void $receiver$iv;
                void destination$iv$iv;
                Iterable $receiver$iv$iv;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
                Intrinsics.checkParameterIsNotNull(renderer, "renderer");
                List<String> lowerArgs = this.renderArguments(renderer, flexibility.getLowerBound());
                List<String> upperArgs = this.renderArguments(renderer, flexibility.getUpperBound());
                lowerRendered = renderer.renderType(flexibility.getLowerBound());
                upperRendered = renderer.renderType(flexibility.getUpperBound());
                Collection collection = upperArgs;
                if (!(!collection.isEmpty())) {
                    return null;
                }
                Iterable iterable = lowerArgs;
                void var9_9 = $receiver$iv2;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    void var14_14 = destination$iv$iv;
                    String string2 = "(raw) " + (String)it;
                    var14_14.add(string2);
                }
                newArgs = CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", null, null, 0, null, null, 62, null);
                $receiver$iv$iv = CollectionsKt.zip((Iterable)lowerArgs, (Iterable)upperArgs);
                for (Object element$iv : $receiver$iv) {
                    Pair it = (Pair)element$iv;
                    if (INSTANCE.onlyOutDiffers((String)it.getFirst(), (String)it.getSecond())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            String newUpper = bl ? this.replaceArgs(upperRendered, newArgs) : upperRendered;
            return new Pair<String, String>(this.replaceArgs(lowerRendered, newArgs), newUpper);
        }

        private final boolean onlyOutDiffers(String first, String second) {
            return Intrinsics.areEqual(first, StringsKt.removePrefix(second, (CharSequence)"out ")) || Intrinsics.areEqual(second, "*");
        }

        private RawFlexibleRendering() {
            INSTANCE = this;
        }

        static {
            new RawFlexibleRendering();
        }
    }
}

