/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.Worker;

public abstract class Tab
extends JPanel {
    private String name;
    private Worker worker;
    protected VMPanel vmPanel;
    private SwingWorker<?, ?> prevSW;

    public Tab(VMPanel vmPanel, String name) {
        this.vmPanel = vmPanel;
        this.name = name;
    }

    public SwingWorker<?, ?> newSwingWorker() {
        return null;
    }

    public void update() {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (!proxyClient.hasPlatformMXBeans()) {
            throw new UnsupportedOperationException("Platform MXBeans not registered in MBeanServer");
        }
        SwingWorker<?, ?> sw = this.newSwingWorker();
        if (!(this.prevSW != null && !this.prevSW.isDone() || sw != null && sw.getState() != SwingWorker.StateValue.PENDING)) {
            this.prevSW = sw;
            if (sw != null) {
                sw.execute();
            }
        }
    }

    public synchronized void dispose() {
        if (this.worker != null) {
            this.worker.stopWorker();
        }
    }

    protected VMPanel getVMPanel() {
        return this.vmPanel;
    }

    OverviewPanel[] getOverviewPanels() {
        return null;
    }

    public synchronized void workerAdd(Runnable job) {
        if (this.worker == null) {
            this.worker = new Worker(this.name + "-" + this.vmPanel.getConnectionName());
            this.worker.start();
        }
        this.worker.add(job);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }
}

