/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MultiSearchRequest
extends ActionRequest
implements CompositeIndicesRequest {
    private int maxConcurrentSearchRequests = 0;
    private List<SearchRequest> requests = new ArrayList<SearchRequest>();
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();

    public MultiSearchRequest add(SearchRequestBuilder request) {
        this.requests.add((SearchRequest)request.request());
        return this;
    }

    public MultiSearchRequest add(SearchRequest request) {
        this.requests.add(request);
        return this;
    }

    public int maxConcurrentSearchRequests() {
        return this.maxConcurrentSearchRequests;
    }

    public MultiSearchRequest maxConcurrentSearchRequests(int maxConcurrentSearchRequests) {
        if (maxConcurrentSearchRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentSearchRequests must be positive");
        }
        this.maxConcurrentSearchRequests = maxConcurrentSearchRequests;
        return this;
    }

    public List<SearchRequest> requests() {
        return this.requests;
    }

    @Override
    public List<? extends IndicesRequest> subRequests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiSearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.maxConcurrentSearchRequests = in.readVInt();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            SearchRequest request = new SearchRequest();
            request.readFrom(in);
            this.requests.add(request);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.maxConcurrentSearchRequests);
        out.writeVInt(this.requests.size());
        for (SearchRequest request : this.requests) {
            request.writeTo(out);
        }
    }
}

