/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.IgnoreOnRecoveryEngineException;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.rest.RestStatus;

public class TranslogRecoveryPerformer {
    private final MapperService mapperService;
    private final Logger logger;
    private final Map<String, Mapping> recoveredTypes = new HashMap<String, Mapping>();
    private final ShardId shardId;

    protected TranslogRecoveryPerformer(ShardId shardId, MapperService mapperService, Logger logger) {
        this.shardId = shardId;
        this.mapperService = mapperService;
        this.logger = logger;
    }

    protected DocumentMapperForType docMapper(String type) {
        return this.mapperService.documentMapperWithAutoCreate(type);
    }

    int performBatchRecovery(Engine engine, Iterable<Translog.Operation> operations) {
        int numOps = 0;
        try {
            for (Translog.Operation operation : operations) {
                this.performRecoveryOperation(engine, operation, false, Engine.Operation.Origin.PEER_RECOVERY);
                ++numOps;
            }
            engine.getTranslog().sync();
        }
        catch (Exception e) {
            throw new BatchOperationException(this.shardId, "failed to apply batch translog operation", numOps, e);
        }
        return numOps;
    }

    public int recoveryFromSnapshot(Engine engine, Translog.Snapshot snapshot) throws IOException {
        Translog.Operation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            try {
                this.performRecoveryOperation(engine, operation, true, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY);
                ++opsRecovered;
            }
            catch (ElasticsearchException e) {
                if (e.status() == RestStatus.BAD_REQUEST) {
                    this.logger.info("ignoring recovery of a corrupt translog entry", (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        return opsRecovered;
    }

    private void maybeAddMappingUpdate(String type, Mapping update, String docId, boolean allowMappingUpdates) {
        if (update == null) {
            return;
        }
        if (!allowMappingUpdates) {
            throw new MapperException("mapping updates are not allowed (type: [" + type + "], id: [" + docId + "])");
        }
        Mapping currentUpdate = this.recoveredTypes.get(type);
        if (currentUpdate == null) {
            this.recoveredTypes.put(type, update);
        } else {
            currentUpdate = currentUpdate.merge(update, false);
        }
    }

    private void performRecoveryOperation(Engine engine, Translog.Operation operation, boolean allowMappingUpdates, Engine.Operation.Origin origin) {
        block10: {
            try {
                switch (operation.opType()) {
                    case INDEX: {
                        Translog.Index index = (Translog.Index)operation;
                        Engine.Index engineIndex = IndexShard.prepareIndex(this.docMapper(index.type()), SourceToParse.source(this.shardId.getIndexName(), index.type(), index.id(), index.source()).routing(index.routing()).parent(index.parent()).timestamp(index.timestamp()).ttl(index.ttl()), index.version(), index.versionType().versionTypeForReplicationAndRecovery(), origin, index.getAutoGeneratedIdTimestamp(), true);
                        this.maybeAddMappingUpdate(engineIndex.type(), engineIndex.parsedDoc().dynamicMappingsUpdate(), engineIndex.id(), allowMappingUpdates);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("[translog] recover [index] op of [{}][{}]", (Object)index.type(), (Object)index.id());
                        }
                        this.index(engine, engineIndex);
                        break;
                    }
                    case DELETE: {
                        Translog.Delete delete = (Translog.Delete)operation;
                        Uid uid = Uid.createUid(delete.uid().text());
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("[translog] recover [delete] op of [{}][{}]", (Object)uid.type(), (Object)uid.id());
                        }
                        Engine.Delete engineDelete = new Engine.Delete(uid.type(), uid.id(), delete.uid(), delete.version(), delete.versionType().versionTypeForReplicationAndRecovery(), origin, System.nanoTime(), false);
                        this.delete(engine, engineDelete);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("No operation defined for [" + operation + "]");
                    }
                }
            }
            catch (ElasticsearchException e) {
                boolean hasIgnoreOnRecoveryException = false;
                ElasticsearchException current = e;
                while (true) {
                    if (current instanceof IgnoreOnRecoveryEngineException) {
                        hasIgnoreOnRecoveryException = true;
                        break;
                    }
                    if (!(current.getCause() instanceof ElasticsearchException)) break;
                    current = (ElasticsearchException)current.getCause();
                }
                if (hasIgnoreOnRecoveryException) break block10;
                throw e;
            }
        }
        this.operationProcessed();
    }

    protected void index(Engine engine, Engine.Index engineIndex) {
        engine.index(engineIndex);
    }

    protected void delete(Engine engine, Engine.Delete engineDelete) {
        engine.delete(engineDelete);
    }

    protected void operationProcessed() {
    }

    public Map<String, Mapping> getRecoveredTypes() {
        return this.recoveredTypes;
    }

    public static class BatchOperationException
    extends ElasticsearchException {
        private final int completedOperations;

        public BatchOperationException(ShardId shardId, String msg, int completedOperations, Throwable cause) {
            super(msg, cause, new Object[0]);
            this.setShard(shardId);
            this.completedOperations = completedOperations;
        }

        public BatchOperationException(StreamInput in) throws IOException {
            super(in);
            this.completedOperations = in.readInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.completedOperations);
        }

        public int completedOperations() {
            return this.completedOperations;
        }
    }
}

