/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.fiber;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.fiber.FiberNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=FiberNodes.class)
public final class FiberNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(FiberTransferNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), ResumeNodeFactory.getInstance(), YieldNodeFactory.getInstance(), AliveNodeFactory.getInstance(), CurrentNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=FiberNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<FiberNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        @Override
        public Class<FiberNodes.AllocateNode> getNodeClass() {
            return FiberNodes.AllocateNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public FiberNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static FiberNodes.AllocateNode create(RubyNode[] arguments) {
            return new AllocateNodeGen(arguments);
        }

        @GeneratedBy(value=FiberNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends FiberNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=FiberNodes.CurrentNode.class)
    public static final class CurrentNodeFactory
    implements NodeFactory<FiberNodes.CurrentNode> {
        private static CurrentNodeFactory currentNodeFactoryInstance;

        private CurrentNodeFactory() {
        }

        @Override
        public Class<FiberNodes.CurrentNode> getNodeClass() {
            return FiberNodes.CurrentNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Object[0]));
        }

        @Override
        public FiberNodes.CurrentNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CurrentNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.CurrentNode> getInstance() {
            if (currentNodeFactoryInstance == null) {
                currentNodeFactoryInstance = new CurrentNodeFactory();
            }
            return currentNodeFactoryInstance;
        }

        public static FiberNodes.CurrentNode create() {
            return new CurrentNodeGen();
        }

        @GeneratedBy(value=FiberNodes.CurrentNode.class)
        public static final class CurrentNodeGen
        extends FiberNodes.CurrentNode {
            private CurrentNodeGen() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.current();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=FiberNodes.AliveNode.class)
    public static final class AliveNodeFactory
    implements NodeFactory<FiberNodes.AliveNode> {
        private static AliveNodeFactory aliveNodeFactoryInstance;

        private AliveNodeFactory() {
        }

        @Override
        public Class<FiberNodes.AliveNode> getNodeClass() {
            return FiberNodes.AliveNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        @Override
        public FiberNodes.AliveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AliveNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.AliveNode> getInstance() {
            if (aliveNodeFactoryInstance == null) {
                aliveNodeFactoryInstance = new AliveNodeFactory();
            }
            return aliveNodeFactoryInstance;
        }

        public static FiberNodes.AliveNode create(RubyNode operand) {
            return new AliveNodeGen(operand);
        }

        @GeneratedBy(value=FiberNodes.AliveNode.class)
        public static final class AliveNodeGen
        extends FiberNodes.AliveNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AliveNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.alive(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=FiberNodes.YieldNode.class)
    public static final class YieldNodeFactory
    implements NodeFactory<FiberNodes.YieldNode> {
        private static YieldNodeFactory yieldNodeFactoryInstance;

        private YieldNodeFactory() {
        }

        @Override
        public Class<FiberNodes.YieldNode> getNodeClass() {
            return FiberNodes.YieldNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        @Override
        public FiberNodes.YieldNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return YieldNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.YieldNode> getInstance() {
            if (yieldNodeFactoryInstance == null) {
                yieldNodeFactoryInstance = new YieldNodeFactory();
            }
            return yieldNodeFactoryInstance;
        }

        public static FiberNodes.YieldNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new YieldNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FiberNodes.YieldNode.class)
        public static final class YieldNodeGen
        extends FiberNodes.YieldNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private YieldNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="yield(VirtualFrame, Object[], BranchProfile)", value=FiberNodes.YieldNode.class)
            private static final class YieldNode_
            extends BaseNode_ {
                private final BranchProfile errorProfile;

                YieldNode_(YieldNodeGen root, BranchProfile errorProfile) {
                    super(root, 1);
                    this.errorProfile = errorProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Object[]) {
                        Object[] arguments0Value_ = (Object[])arguments0Value;
                        return this.root.yield(frameValue, arguments0Value_, this.errorProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(YieldNodeGen root, BranchProfile errorProfile) {
                    return new YieldNode_(root, errorProfile);
                }
            }

            @GeneratedBy(value=FiberNodes.YieldNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(YieldNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(YieldNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FiberNodes.YieldNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected YieldNodeGen root;

                BaseNode_(YieldNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (YieldNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Object[]) {
                        BranchProfile errorProfile1 = BranchProfile.create();
                        return YieldNode_.create(this.root, errorProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=FiberNodes.ResumeNode.class)
    public static final class ResumeNodeFactory
    implements NodeFactory<FiberNodes.ResumeNode> {
        private static ResumeNodeFactory resumeNodeFactoryInstance;

        private ResumeNodeFactory() {
        }

        @Override
        public Class<FiberNodes.ResumeNode> getNodeClass() {
            return FiberNodes.ResumeNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        @Override
        public FiberNodes.ResumeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ResumeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.ResumeNode> getInstance() {
            if (resumeNodeFactoryInstance == null) {
                resumeNodeFactoryInstance = new ResumeNodeFactory();
            }
            return resumeNodeFactoryInstance;
        }

        public static FiberNodes.ResumeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ResumeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FiberNodes.ResumeNode.class)
        public static final class ResumeNodeGen
        extends FiberNodes.ResumeNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ResumeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.resume(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=FiberNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    implements NodeFactory<FiberNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
        }

        @Override
        public Class<FiberNodes.InitializeNode> getNodeClass() {
            return FiberNodes.InitializeNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public FiberNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static FiberNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=FiberNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends FiberNodes.InitializeNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InitializeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.initialize(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberTransferNode.class)
    public static final class FiberTransferNodeFactory
    implements NodeFactory<FiberNodes.FiberTransferNode> {
        private static FiberTransferNodeFactory fiberTransferNodeFactoryInstance;

        private FiberTransferNodeFactory() {
        }

        @Override
        public Class<FiberNodes.FiberTransferNode> getNodeClass() {
            return FiberNodes.FiberTransferNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public FiberNodes.FiberTransferNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberTransferNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberTransferNode> getInstance() {
            if (fiberTransferNodeFactoryInstance == null) {
                fiberTransferNodeFactoryInstance = new FiberTransferNodeFactory();
            }
            return fiberTransferNodeFactoryInstance;
        }

        public static FiberNodes.FiberTransferNode create(RubyNode[] arguments) {
            return new FiberTransferNodeGen(arguments);
        }

        @GeneratedBy(value=FiberNodes.FiberTransferNode.class)
        public static final class FiberTransferNodeGen
        extends FiberNodes.FiberTransferNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FiberTransferNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeTransferControlTo(VirtualFrame frameValue, DynamicObject arguments0Value, boolean arguments1Value, Object[] arguments2Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="transfer(VirtualFrame, DynamicObject, boolean, Object[], BranchProfile)", value=FiberNodes.FiberTransferNode.class)
            private static final class TransferNode_
            extends BaseNode_ {
                private final BranchProfile errorProfile;

                TransferNode_(FiberTransferNodeGen root, BranchProfile errorProfile) {
                    super(root, 1);
                    this.errorProfile = errorProfile;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    Object[] arguments2Value_;
                    boolean arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyFiber(arguments0Value_)) {
                        return this.root.transfer(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, this.errorProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, boolean arguments1Value, Object[] arguments2Value) {
                    if (RubyGuards.isRubyFiber(arguments0Value)) {
                        return this.root.transfer(frameValue, arguments0Value, arguments1Value, arguments2Value, this.errorProfile);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Boolean && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        boolean arguments1Value_ = (Boolean)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (RubyGuards.isRubyFiber(arguments0Value_)) {
                            return this.root.transfer(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, this.errorProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(FiberTransferNodeGen root, BranchProfile errorProfile) {
                    return new TransferNode_(root, errorProfile);
                }
            }

            @GeneratedBy(value=FiberNodes.FiberTransferNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FiberTransferNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(FiberTransferNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FiberNodes.FiberTransferNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected FiberTransferNodeGen root;

                BaseNode_(FiberTransferNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (FiberTransferNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, boolean arguments1Value, Object[] arguments2Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Boolean && arguments2Value instanceof Object[] && RubyGuards.isRubyFiber(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        BranchProfile errorProfile1 = BranchProfile.create();
                        return TransferNode_.create(this.root, errorProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Boolean.TYPE) {
                        return this.root.arguments1_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }
}

