/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import com.fasterxml.jackson.core.JsonParseException;
import java.util.Map;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class JsonProcessor
extends AbstractProcessor {
    public static final String TYPE = "json";
    private final String field;
    private final String targetField;

    JsonProcessor(String tag, String field, String targetField) {
        super(tag);
        this.field = field;
        this.targetField = targetField;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void execute(IngestDocument document) throws Exception {
        String stringValue = (String)document.getFieldValue(this.field, String.class);
        try {
            Map mapValue = JsonXContent.jsonXContent.createParser(stringValue).map();
            document.setFieldValue(this.targetField, (Object)mapValue);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public JsonProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)field);
            return new JsonProcessor(processorTag, field, targetField);
        }
    }
}

