/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.spatial3d.Geo3DDocValuesField;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoOutsideDistance;

class Geo3DPointOutsideDistanceComparator
extends FieldComparator<Double>
implements LeafFieldComparator {
    final String field;
    final GeoOutsideDistance distanceShape;
    final double[] values;
    double bottomDistance;
    double topValue;
    SortedNumericDocValues currentDocs;

    public Geo3DPointOutsideDistanceComparator(String field, GeoOutsideDistance distanceShape, int numHits) {
        this.field = field;
        this.distanceShape = distanceShape;
        this.values = new double[numHits];
    }

    public void setScorer(Scorer scorer) {
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    public void setBottom(int slot) {
        this.bottomDistance = this.values[slot];
    }

    public void setTopValue(Double value) {
        this.topValue = value;
    }

    public int compareBottom(int doc) throws IOException {
        this.currentDocs.setDocument(doc);
        int numValues = this.currentDocs.count();
        if (numValues == 0) {
            return Double.compare(this.bottomDistance, Double.POSITIVE_INFINITY);
        }
        int cmp = -1;
        for (int i = 0; i < numValues; ++i) {
            long encoded = this.currentDocs.valueAt(i);
            double x = Geo3DDocValuesField.decodeXValue(encoded);
            double y = Geo3DDocValuesField.decodeYValue(encoded);
            double z = Geo3DDocValuesField.decodeZValue(encoded);
            cmp = Math.max(cmp, Double.compare(this.bottomDistance, this.distanceShape.computeOutsideDistance(DistanceStyle.ARC, x, y, z)));
        }
        return cmp;
    }

    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.computeMinimumDistance(doc);
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.field);
        if (info != null) {
            Geo3DDocValuesField.checkCompatible(info);
        }
        this.currentDocs = DocValues.getSortedNumeric((LeafReader)reader, (String)this.field);
        return this;
    }

    public Double value(int slot) {
        return this.values[slot] * 6371008.7714;
    }

    public int compareTop(int doc) throws IOException {
        return Double.compare(this.topValue, this.computeMinimumDistance(doc));
    }

    double computeMinimumDistance(int doc) {
        this.currentDocs.setDocument(doc);
        double minValue = Double.POSITIVE_INFINITY;
        int numValues = this.currentDocs.count();
        for (int i = 0; i < numValues; ++i) {
            long encoded = this.currentDocs.valueAt(i);
            double distance = this.distanceShape.computeOutsideDistance(DistanceStyle.ARC, Geo3DDocValuesField.decodeXValue(encoded), Geo3DDocValuesField.decodeYValue(encoded), Geo3DDocValuesField.decodeZValue(encoded));
            minValue = Math.min(minValue, distance);
        }
        return minValue;
    }
}

