/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.tasks.cache.TaskCacheKeyBuilder;
import org.gradle.internal.hash.HashUtil;

public class IgnoredPathFileSnapshot
implements NormalizedFileSnapshot {
    private final IncrementalFileSnapshot snapshot;

    public IgnoredPathFileSnapshot(IncrementalFileSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public String getNormalizedPath() {
        return "";
    }

    public IncrementalFileSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void appendToCacheKey(TaskCacheKeyBuilder builder) {
        builder.putBytes(this.snapshot.getHash().asBytes());
    }

    public int compareTo(NormalizedFileSnapshot o) {
        if (!(o instanceof IgnoredPathFileSnapshot)) {
            return -1;
        }
        return HashUtil.compareHashCodes((HashCode)this.getSnapshot().getHash(), (HashCode)o.getSnapshot().getHash());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredPathFileSnapshot that = (IgnoredPathFileSnapshot)o;
        return Objects.equal((Object)this.snapshot, (Object)that.snapshot);
    }

    public int hashCode() {
        return this.snapshot.hashCode();
    }
}

