/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskPropertyValue;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPropertyInfo
implements Comparable<TaskPropertyInfo> {
    private static final ValidationAction NO_OP_VALIDATION_ACTION = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
        }
    };
    private static final TaskPropertyValue NO_OP_VALUE = new TaskPropertyValue(){

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void checkNotNull(Collection<String> messages) {
        }

        @Override
        public void checkValid(Collection<String> messages) {
        }
    };
    private static final UpdateAction NO_OP_CONFIGURATION_ACTION = new UpdateAction(){

        @Override
        public void update(TaskInternal task, Callable<Object> futureValue) {
        }
    };
    private final TaskPropertyInfo parent;
    private final String propertyName;
    private final Method method;
    private final Class<?> type;
    private final ValidationAction validationAction;
    private final UpdateAction configureAction;
    private final boolean optional;

    TaskPropertyInfo(TaskPropertyInfo parent, String propertyName, Method method, Class<?> type, ValidationAction validationAction, UpdateAction configureAction, boolean optional) {
        this.parent = parent;
        this.propertyName = propertyName;
        this.method = method;
        this.type = type;
        this.validationAction = validationAction == null ? NO_OP_VALIDATION_ACTION : validationAction;
        this.configureAction = configureAction == null ? NO_OP_CONFIGURATION_ACTION : configureAction;
        this.optional = optional;
    }

    public String toString() {
        return this.propertyName;
    }

    public String getName() {
        return this.propertyName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public UpdateAction getConfigureAction() {
        return this.configureAction;
    }

    public TaskPropertyValue getValue(Object rootObject) {
        Object bean;
        if (this.parent != null) {
            TaskPropertyValue parentValue = this.parent.getValue(rootObject);
            if (parentValue.getValue() == null) {
                return NO_OP_VALUE;
            }
            bean = parentValue.getValue();
        } else {
            bean = rootObject;
        }
        final Object value = DeprecationLogger.whileDisabled((Factory)new Factory<Object>(){

            public Object create() {
                return JavaReflectionUtil.method(Object.class, (Method)TaskPropertyInfo.this.method).invoke(bean, new Object[0]);
            }
        });
        return new TaskPropertyValue(){

            @Override
            public Object getValue() {
                return value;
            }

            @Override
            public void checkNotNull(Collection<String> messages) {
                if (value == null && !TaskPropertyInfo.this.optional) {
                    messages.add(String.format("No value has been specified for property '%s'.", TaskPropertyInfo.this.propertyName));
                }
            }

            @Override
            public void checkValid(Collection<String> messages) {
                if (value != null) {
                    TaskPropertyInfo.this.validationAction.validate(TaskPropertyInfo.this.propertyName, value, messages);
                }
            }
        };
    }

    @Override
    public int compareTo(TaskPropertyInfo o) {
        return this.propertyName.compareTo(o.getName());
    }
}

