/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemon;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.UncheckedException;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegate;
    private final CompilerDaemonFactory compilerDaemonFactory;
    private final File daemonWorkingDir;

    public AbstractDaemonCompiler(File daemonWorkingDir, Compiler<T> delegate, CompilerDaemonFactory compilerDaemonFactory) {
        this.daemonWorkingDir = daemonWorkingDir;
        this.delegate = delegate;
        this.compilerDaemonFactory = compilerDaemonFactory;
    }

    public Compiler<T> getDelegate() {
        return this.delegate;
    }

    public WorkResult execute(T spec) {
        DaemonForkOptions daemonForkOptions = this.toDaemonOptions(spec);
        CompilerDaemon daemon = this.compilerDaemonFactory.getDaemon(this.daemonWorkingDir, daemonForkOptions);
        CompileResult result = daemon.execute(this.delegate, spec);
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    protected abstract DaemonForkOptions toDaemonOptions(T var1);
}

