/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.Collection;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.DirectBuildDependencies;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationComponentMetaDataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependenciesToModuleDescriptorConverter;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;

public class DefaultConfigurationComponentMetaDataBuilder
implements ConfigurationComponentMetaDataBuilder {
    private final DependenciesToModuleDescriptorConverter dependenciesConverter;

    public DefaultConfigurationComponentMetaDataBuilder(DependenciesToModuleDescriptorConverter dependenciesConverter) {
        this.dependenciesConverter = dependenciesConverter;
    }

    @Override
    public void addConfigurations(BuildableLocalComponentMetadata metaData, Collection<? extends Configuration> configurations) {
        for (Configuration configuration : configurations) {
            this.addConfiguration(metaData, configuration);
        }
        this.addDependencies(metaData, configurations);
        this.addArtifacts(metaData, configurations);
    }

    private void addConfiguration(BuildableLocalComponentMetadata metaData, Configuration configuration) {
        Set<String> hierarchy = Configurations.getNames(configuration.getHierarchy());
        Set<String> extendsFrom = Configurations.getNames(configuration.getExtendsFrom());
        TaskDependency directBuildDependencies = DirectBuildDependencies.forDependenciesAndArtifacts(configuration);
        metaData.addConfiguration(configuration.getName(), configuration.getDescription(), extendsFrom, hierarchy, configuration.isVisible(), configuration.isTransitive(), configuration.getAttributes(), directBuildDependencies);
    }

    private void addDependencies(BuildableLocalComponentMetadata metaData, Collection<? extends Configuration> configurations) {
        this.dependenciesConverter.addDependencyDescriptors(metaData, configurations);
    }

    private void addArtifacts(BuildableLocalComponentMetadata metaData, Collection<? extends Configuration> configurations) {
        for (Configuration configuration : configurations) {
            metaData.addArtifacts(configuration.getName(), (Iterable<? extends PublishArtifact>)configuration.getArtifacts());
        }
    }
}

