/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class CachedFile
implements Closeable {
    protected String name;
    protected long maxAge;
    protected String destDir;
    protected String httpAccept;
    protected CachingStrategy cachingStrategy;
    private boolean fastFail;
    private HttpClient activeConnection;
    protected File cacheFile;
    protected boolean initialized;
    public static final long DEFAULT_MAXTIME = -1L;
    public static final long DAYS = 86400L;
    private final Map<String, String> httpHeaders = new ConcurrentHashMap<String, String>();

    public CachedFile(String string) {
        this.name = string;
    }

    public CachedFile setName(String string) {
        this.name = string;
        return this;
    }

    public CachedFile setMaxAge(long l) {
        this.maxAge = l;
        return this;
    }

    public CachedFile setDestDir(String string) {
        this.destDir = string;
        return this;
    }

    public CachedFile setHttpAccept(String string) {
        this.httpAccept = string;
        return this;
    }

    public CachedFile setCachingStrategy(CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
        return this;
    }

    public CachedFile setHttpHeaders(Map<String, String> map) {
        this.httpHeaders.putAll(map);
        return this;
    }

    public void setFastFail(boolean bl) {
        this.fastFail = bl;
    }

    public String getName() {
        return this.name;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getHttpAccept() {
        return this.httpAccept;
    }

    public CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public InputStream getInputStream() throws IOException {
        File file = this.getFile();
        if (file == null) {
            if (this.name.startsWith("resource://")) {
                InputStream inputStream = this.getClass().getResourceAsStream(this.name.substring("resource:/".length()));
                if (inputStream == null) {
                    throw new IOException(I18n.tr("Failed to open input stream for resource ''{0}''", this.name));
                }
                return inputStream;
            }
            throw new IOException("No file found for: " + this.name);
        }
        return new FileInputStream(file);
    }

    public byte[] getByteContent() throws IOException {
        try (InputStream inputStream = this.getInputStream();){
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    public BufferedReader getContentReader() throws IOException {
        return new BufferedReader(UTFInputStreamReader.create(this.getInputStream()));
    }

    public synchronized File getFile() throws IOException {
        if (this.initialized) {
            return this.cacheFile;
        }
        this.initialized = true;
        try {
            URL uRL = new URL(this.name);
            if ("file".equals(uRL.getProtocol())) {
                this.cacheFile = new File(this.name.substring("file:/".length() - 1));
                if (!this.cacheFile.exists()) {
                    this.cacheFile = new File(this.name.substring("file://".length() - 1));
                }
            } else {
                this.cacheFile = this.checkLocal(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (this.name.startsWith("resource://")) {
                return null;
            }
            this.cacheFile = this.name.startsWith("josmdir://") ? new File(Main.pref.getUserDataDirectory(), this.name.substring("josmdir://".length())) : (this.name.startsWith("josmplugindir://") ? new File(Main.pref.getPluginsDirectory(), this.name.substring("josmplugindir://".length())) : new File(this.name));
        }
        if (this.cacheFile == null) {
            throw new IOException("Unable to get cache file for " + this.name);
        }
        return this.cacheFile;
    }

    public String findZipEntryPath(String string, String string2) {
        Pair<String, InputStream> pair = this.findZipEntryImpl(string, string2);
        if (pair == null) {
            return null;
        }
        return (String)pair.a;
    }

    public InputStream findZipEntryInputStream(String string, String string2) {
        Pair<String, InputStream> pair = this.findZipEntryImpl(string, string2);
        if (pair == null) {
            return null;
        }
        return (InputStream)pair.b;
    }

    private Pair<String, InputStream> findZipEntryImpl(String string, String string2) {
        Pair<String, Object> pair;
        block8: {
            File file = null;
            try {
                file = this.getFile();
            }
            catch (IOException iOException) {
                Main.warn((Throwable)iOException, false);
            }
            if (file == null) {
                return null;
            }
            pair = null;
            try {
                Object object;
                ZipFile zipFile = new ZipFile(file, StandardCharsets.UTF_8);
                Object object2 = null;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!((ZipEntry)object).getName().endsWith('.' + string) || object2 != null && ((ZipEntry)object).getName().indexOf(string2) < 0) continue;
                    object2 = object;
                }
                if (object2 != null) {
                    object = zipFile.getInputStream((ZipEntry)object2);
                    pair = Pair.create(((ZipEntry)object2).getName(), object);
                } else {
                    Utils.close(zipFile);
                }
            }
            catch (IOException iOException) {
                if (!file.getName().endsWith(".zip")) break block8;
                Main.warn((Throwable)iOException, I18n.tr("Failed to open file with extension ''{2}'' and namepart ''{3}'' in zip file ''{0}''. Exception was: {1}", file.getName(), iOException.toString(), string, string2));
            }
        }
        return pair;
    }

    public static void cleanup(String string) {
        CachedFile.cleanup(string, null);
    }

    public static void cleanup(String string, String string2) {
        try {
            URL uRL = new URL(string);
            if (!"file".equals(uRL.getProtocol())) {
                File file;
                String string3 = CachedFile.getPrefKey(uRL, string2);
                ArrayList<String> arrayList = new ArrayList<String>(Main.pref.getCollection(string3));
                if (arrayList.size() == 2 && (file = new File((String)arrayList.get(1))).exists()) {
                    Utils.deleteFile(file);
                }
                Main.pref.putCollection(string3, null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Main.warn(malformedURLException);
        }
    }

    private static String getPrefKey(URL uRL, String string) {
        StringBuilder stringBuilder = new StringBuilder("mirror.");
        if (string != null) {
            stringBuilder.append(string).append('.');
        }
        stringBuilder.append(uRL.toString());
        return stringBuilder.toString().replaceAll("=", "_");
    }

    private File checkLocal(URL uRL) throws IOException {
        File file;
        String string = CachedFile.getPrefKey(uRL, this.destDir);
        String string2 = uRL.toExternalForm();
        long l = 0L;
        long l2 = this.maxAge;
        Long l3 = null;
        File file2 = null;
        ArrayList<String> arrayList = new ArrayList<String>(Main.pref.getCollection(string));
        boolean bl = false;
        try {
            CachedFile.checkOfflineAccess(string2);
        }
        catch (OfflineAccessException offlineAccessException) {
            Main.trace(offlineAccessException);
            bl = true;
        }
        if (arrayList.size() == 2) {
            file2 = new File((String)arrayList.get(1));
            if (!file2.exists()) {
                file2 = null;
            } else {
                if (this.maxAge == -1L || this.maxAge <= 0L) {
                    l2 = Main.pref.getInteger("mirror.maxtime", 604800);
                }
                l = System.currentTimeMillis() - Long.parseLong((String)arrayList.get(0));
                if (bl || l < l2 * 1000L) {
                    return file2;
                }
                if (this.cachingStrategy == CachingStrategy.IfModifiedSince) {
                    l3 = Long.valueOf((String)arrayList.get(0));
                }
            }
        }
        if (this.destDir == null) {
            this.destDir = Main.pref.getCacheDirectory().getPath();
        }
        if (!(file = new File(this.destDir)).exists()) {
            Utils.mkDirs(file);
        }
        if (bl) {
            return null;
        }
        String string3 = string2.replaceAll("[^A-Za-z0-9_.-]", "_");
        String string4 = "mirror_" + string3;
        file = new File(this.destDir, string4 + ".tmp");
        try {
            this.activeConnection = HttpClient.create(uRL).setAccept(this.httpAccept).setIfModifiedSince(l3 == null ? 0L : l3).setHeaders(this.httpHeaders);
            if (this.fastFail) {
                this.activeConnection.setReadTimeout(1000);
            }
            HttpClient.Response response = this.activeConnection.connect();
            if (l3 != null && response.getResponseCode() == 304) {
                if (Main.isDebugEnabled()) {
                    Main.debug("304 Not Modified (" + string2 + ')');
                }
                if (file2 == null) {
                    throw new AssertionError();
                }
                Main.pref.putCollection(string, Arrays.asList(Long.toString(System.currentTimeMillis()), (String)arrayList.get(1)));
                return file2;
            }
            if (response.getResponseCode() == 404) {
                throw new IOException(I18n.tr("The requested URL {0} was not found", string2));
            }
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(response.getContent());){
                Files.copy(bufferedInputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.activeConnection = null;
            file2 = new File(this.destDir, string4);
            if (Main.platform.rename(file, file2)) {
                Main.pref.putCollection(string, Arrays.asList(Long.toString(System.currentTimeMillis()), file2.toString()));
            } else {
                Main.warn(I18n.tr("Failed to rename file {0} to {1}.", file.getPath(), file2.getPath()));
            }
        }
        catch (IOException iOException) {
            if (l >= l2 * 1000L && l < l2 * 1000L * 2L) {
                Main.warn(I18n.tr("Failed to load {0}, use cached file and retry next time: {1}", string2, iOException));
                return file2;
            }
            throw iOException;
        }
        return file2;
    }

    private static void checkOfflineAccess(String string) {
        OnlineResource.JOSM_WEBSITE.checkOfflineAccess(string, Main.getJOSMWebsite());
        OnlineResource.OSM_API.checkOfflineAccess(string, OsmApi.getOsmApi().getServerUrl());
    }

    @Override
    public void close() {
        if (this.activeConnection != null) {
            this.activeConnection.disconnect();
        }
    }

    public void clear() throws IOException {
        try {
            URL uRL = new URL(this.name);
            if ("file".equals(uRL.getProtocol())) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        File file = this.getFile();
        if (file != null && file.exists()) {
            Utils.deleteFile(file);
        }
    }

    public static enum CachingStrategy {
        MaxAge,
        IfModifiedSince;

    }
}

