/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UncaughtThrowError"}, parent="ArgumentError")
public class RubyUncaughtThrowError
extends RubyException {
    private IRubyObject tag;
    private IRubyObject value;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUncaughtThrowError(runtime, klass);
        }
    };

    static RubyClass createUncaughtThrowErrorClass(Ruby runtime, RubyClass argumentError) {
        RubyClass UncaughtThrowError = runtime.defineClass("UncaughtThrowError", argumentError, ALLOCATOR);
        UncaughtThrowError.defineAnnotatedMethods(RubyUncaughtThrowError.class);
        return UncaughtThrowError;
    }

    protected RubyUncaughtThrowError(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass, exceptionClass.getName());
        this.setMessage(runtime.getNil());
    }

    public static RubyUncaughtThrowError newUncaughtThrowError(Ruby runtime, IRubyObject tag2, IRubyObject value2, RubyString message2) {
        RubyUncaughtThrowError error2 = new RubyUncaughtThrowError(runtime, runtime.getUncaughtThrowError());
        error2.tag = tag2;
        error2.value = value2;
        error2.setMessage(message2);
        return error2;
    }

    @Override
    @JRubyMethod(required=2, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        this.tag = args2[0];
        this.value = args2[1];
        if (args2.length > 2) {
            this.setMessage(args2[2]);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject tag() {
        return this.tag;
    }

    @JRubyMethod
    public IRubyObject value() {
        return this.value;
    }

    @Override
    public RubyString to_s(ThreadContext context) {
        if (this.getMessage().isNil()) {
            return RubyString.newEmptyString(context.runtime);
        }
        if (this.tag == null) {
            return this.getMessage().asString();
        }
        RubyString str = this.getMessage().asString();
        return str.op_format(context, RubyArray.newArray(context.runtime, this.tag));
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        super.copySpecialInstanceVariables(clone2);
        RubyUncaughtThrowError exception2 = (RubyUncaughtThrowError)clone2;
        exception2.tag = this.tag;
        exception2.value = this.value;
    }
}

