/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;

public final class EventBinding<T> {
    private final InstrumentationHandler.AbstractInstrumenter instrumenter;
    private final SourceSectionFilter filter;
    private final T element;
    private final boolean isExecutionEvent;
    private volatile boolean disposed;

    EventBinding(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter query, T element, boolean isExecutionEvent) {
        this.instrumenter = instrumenter;
        this.filter = query;
        this.element = element;
        this.isExecutionEvent = isExecutionEvent;
    }

    public T getElement() {
        return this.element;
    }

    public SourceSectionFilter getFilter() {
        return this.filter;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() throws IllegalStateException {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.disposed) {
            this.instrumenter.disposeBinding(this);
            this.disposed = true;
        }
    }

    boolean isInstrumentedFull(Set<Class<?>> providedTags, RootNode rootNode, Node node, SourceSection nodeSourceSection) {
        if (this.isInstrumentedLeaf(providedTags, node, nodeSourceSection)) {
            if (rootNode == null) {
                return false;
            }
            return this.isInstrumentedRoot(providedTags, rootNode, rootNode.getSourceSection());
        }
        return false;
    }

    boolean isInstrumentedRoot(Set<Class<?>> providedTags, RootNode rootNode, SourceSection rootSourceSection) {
        return this.getInstrumenter().isInstrumentableRoot(rootNode) && this.getFilter().isInstrumentedRoot(providedTags, rootSourceSection);
    }

    boolean isInstrumentedLeaf(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection section) {
        return this.getFilter().isInstrumentedNode(providedTags, instrumentedNode, section);
    }

    boolean isInstrumentedSource(Source source) {
        return this.getInstrumenter().isInstrumentableSource(source) && this.getFilter().isInstrumentedSource(source);
    }

    boolean isExecutionEvent() {
        return this.isExecutionEvent;
    }

    boolean isLanguageBinding() {
        return this.instrumenter instanceof InstrumentationHandler.LanguageClientInstrumenter;
    }

    InstrumentationHandler.AbstractInstrumenter getInstrumenter() {
        return this.instrumenter;
    }

    synchronized void disposeBulk() {
        this.disposed = true;
    }
}

