/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

public final class ObjectStorageOptions {
    public static final boolean PrimitiveLocations = ObjectStorageOptions.booleanOption("truffle.object.PrimitiveLocations", true);
    public static final boolean IntegerLocations = ObjectStorageOptions.booleanOption("truffle.object.IntegerLocations", true);
    public static final boolean DoubleLocations = ObjectStorageOptions.booleanOption("truffle.object.DoubleLocations", true);
    public static final boolean LongLocations = ObjectStorageOptions.booleanOption("truffle.object.LongLocations", true);
    public static final boolean BooleanLocations = ObjectStorageOptions.booleanOption("truffle.object.BooleanLocations", true);
    public static final boolean TypedObjectLocations = ObjectStorageOptions.booleanOption("truffle.object.TypedObjectLocations", true);
    public static final boolean InObjectFields = ObjectStorageOptions.booleanOption("truffle.object.InObjectFields", true);
    public static final boolean TraceReshape = ObjectStorageOptions.booleanOption("truffle.object.TraceReshape", false);
    static final boolean DebugCounters = ObjectStorageOptions.booleanOption("truffle.object.DebugCounters", false);
    static final boolean DumpDebugCounters = ObjectStorageOptions.booleanOption("truffle.object.DumpDebugCounters", true);
    static final boolean DumpShapesDOT = ObjectStorageOptions.booleanOption("truffle.object.DumpShapesDOT", false);
    static final boolean DumpShapesJSON = ObjectStorageOptions.booleanOption("truffle.object.DumpShapesJSON", false);
    static final boolean DumpShapesIGV = ObjectStorageOptions.booleanOption("truffle.object.DumpShapesIGV", false);
    static final boolean DumpShapes = DumpShapesDOT || DumpShapesJSON || DumpShapesIGV;
    static final String DumpShapesPath = System.getProperty("truffle.object.DumpShapesPath", "");
    public static final boolean Profile = ObjectStorageOptions.booleanOption("truffle.object.Profile", false);
    public static final int ProfileTopResults = Integer.getInteger("truffle.object.ProfileTopResults", -1);

    private ObjectStorageOptions() {
    }

    public static boolean booleanOption(String name, boolean defaultValue) {
        String value = System.getProperty(name);
        return value == null ? defaultValue : value.equalsIgnoreCase("true");
    }
}

