/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer4latex;

import com.sun.star.beans.XMultiHierarchicalPropertySet;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.writer4latex.StreamGobbler;

public class ExternalApps {
    public static final String LATEX = "LaTeX";
    public static final String PDFLATEX = "PdfLaTeX";
    public static final String XELATEX = "XeLaTeX";
    public static final String BIBTEX = "BibTeX";
    public static final String MAKEINDEX = "Makeindex";
    public static final String MK4HT = "Mk4ht";
    public static final String DVIPS = "Dvips";
    public static final String DVIVIEWER = "DVIViewer";
    public static final String POSTSCRIPTVIEWER = "PostscriptViewer";
    public static final String PDFVIEWER = "PdfViewer";
    private static final String[] sApps = new String[]{"LaTeX", "PdfLaTeX", "XeLaTeX", "BibTeX", "Makeindex", "Mk4ht", "Dvips", "DVIViewer", "PostscriptViewer", "PdfViewer"};
    private XComponentContext xContext;
    private HashMap<String, String[]> apps;

    public ExternalApps(XComponentContext xContext) {
        this.xContext = xContext;
        this.apps = new HashMap();
        for (int i = 0; i < sApps.length; ++i) {
            this.setApplication(sApps[i], "?", "?");
        }
    }

    public void setApplication(String sAppName, String sExecutable, String sOptions) {
        String[] sValue = new String[]{sExecutable, sOptions};
        this.apps.put(sAppName, sValue);
    }

    public String[] getApplication(String sAppName) {
        return this.apps.get(sAppName);
    }

    public int execute(String sAppName, String sFileName, File workDir, Map<String, String> env, boolean bWaitFor) {
        return this.execute(sAppName, "", sFileName, workDir, env, bWaitFor);
    }

    public int execute(String sAppName, String sCommand, String sFileName, File workDir, Map<String, String> env, boolean bWaitFor) {
        String[] sApp = this.getApplication(sAppName);
        if (sApp == null) {
            return 1;
        }
        try {
            String[] sArguments;
            Vector<String> command = new Vector<String>();
            command.add(sApp[0]);
            for (String s : sArguments = sApp[1].split(" ")) {
                command.add(s.replace("%c", sCommand).replace("%s", sFileName));
            }
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(workDir);
            if (env != null) {
                pb.environment().putAll(env);
            }
            Process proc = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            return bWaitFor ? proc.waitFor() : 0;
        }
        catch (InterruptedException e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
    }

    public void load() {
        Object view;
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            view = registry.getRegistryView("/org.openoffice.da.Writer4LaTeX.Options/Applications", false);
        }
        catch (com.sun.star.uno.Exception e) {
            return;
        }
        XMultiHierarchicalPropertySet xProps = (XMultiHierarchicalPropertySet)UnoRuntime.queryInterface(XMultiHierarchicalPropertySet.class, (Object)view);
        for (int i = 0; i < sApps.length; ++i) {
            String[] sNames = new String[]{sApps[i] + "/Executable", sApps[i] + "/Options"};
            try {
                Object[] values = xProps.getHierarchicalPropertyValues(sNames);
                this.setApplication(sApps[i], (String)values[0], (String)values[1]);
                continue;
            }
            catch (com.sun.star.uno.Exception e) {
                // empty catch block
            }
        }
        registry.disposeRegistryView(view);
    }

    public void save() {
        Object view;
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            view = registry.getRegistryView("/org.openoffice.da.Writer4LaTeX.Options/Applications", true);
        }
        catch (com.sun.star.uno.Exception e) {
            return;
        }
        XMultiHierarchicalPropertySet xProps = (XMultiHierarchicalPropertySet)UnoRuntime.queryInterface(XMultiHierarchicalPropertySet.class, (Object)view);
        for (int i = 0; i < sApps.length; ++i) {
            String[] sNames = new String[]{sApps[i] + "/Executable", sApps[i] + "/Options"};
            Object[] sValues = this.getApplication(sApps[i]);
            try {
                xProps.setHierarchicalPropertyValues(sNames, sValues);
                continue;
            }
            catch (com.sun.star.uno.Exception e) {
                // empty catch block
            }
        }
        XChangesBatch xUpdateContext = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)view);
        try {
            xUpdateContext.commitChanges();
        }
        catch (Exception e) {
            // empty catch block
        }
        registry.disposeRegistryView(view);
    }
}

