/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.api;

import java.util.Iterator;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionListener;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public abstract class RemoteFileSystemConnectionManager {
    private static final DefaultRemoteFileSystemConnectionManager instance = new DefaultRemoteFileSystemConnectionManager();

    public static RemoteFileSystemConnectionManager getInstance() {
        return instance;
    }

    public abstract void addRemoteFileSystemConnectionListener(RemoteFileSystemConnectionListener var1);

    public abstract void removeRemoteFileSystemConnectionListener(RemoteFileSystemConnectionListener var1);

    public abstract boolean isConnectedRemoteFileSystem(FileSystem var1);

    private static final class DefaultRemoteFileSystemConnectionManager
    extends RemoteFileSystemConnectionManager {
        private final Lookup.Result<RemoteFileSystemConnectionManager> res = Lookup.getDefault().lookupResult(RemoteFileSystemConnectionManager.class);
        private static final boolean FIX_SERVICE = true;
        private RemoteFileSystemConnectionManager fixedSelector;

        DefaultRemoteFileSystemConnectionManager() {
        }

        private RemoteFileSystemConnectionManager getService() {
            RemoteFileSystemConnectionManager service = this.fixedSelector;
            if (service == null) {
                Iterator iterator = this.res.allInstances().iterator();
                if (iterator.hasNext()) {
                    RemoteFileSystemConnectionManager selector;
                    service = selector = (RemoteFileSystemConnectionManager)iterator.next();
                }
                if (service != null) {
                    this.fixedSelector = service;
                }
            }
            return service;
        }

        @Override
        public void addRemoteFileSystemConnectionListener(RemoteFileSystemConnectionListener listener) {
            this.getService().addRemoteFileSystemConnectionListener(listener);
        }

        @Override
        public void removeRemoteFileSystemConnectionListener(RemoteFileSystemConnectionListener listener) {
            this.getService().removeRemoteFileSystemConnectionListener(listener);
        }

        @Override
        public boolean isConnectedRemoteFileSystem(FileSystem fs) {
            return this.getService().isConnectedRemoteFileSystem(fs);
        }
    }
}

