/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.remote.support.RemoteProjectSupport;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class RemoteSyncServiceImpl
implements RemoteSyncService {
    public RemoteSyncSupport.Worker getUploader(Lookup.Provider project, ExecutionEnvironment execEnv) throws IOException {
        return new Uploader(project, execEnv);
    }

    private static class Uploader
    implements RemoteSyncSupport.Worker {
        private final ExecutionEnvironment execEnv;
        private final PathMap pathMap;
        private final FileData fileData;
        private final Set<String> checkedDirs = new HashSet<String>();
        private CommonTasksSupport.UploadStatus uploadStatus;

        public Uploader(Lookup.Provider project, ExecutionEnvironment execEnv) throws IOException {
            this.execEnv = execEnv;
            this.pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)this.execEnv);
            if (project == null) {
                this.fileData = null;
            } else {
                FileObject privProjectStorageDir = RemoteProjectSupport.getPrivateStorage(project);
                this.fileData = FileData.get(privProjectStorageDir, execEnv);
            }
        }

        public void process(File file, Writer err) throws RemoteSyncSupport.PathMapperException, InterruptedException, ExecutionException, IOException {
            String remotePath = this.pathMap.getRemotePath(file.getAbsolutePath(), false);
            if (remotePath == null) {
                throw new RemoteSyncSupport.PathMapperException(file);
            }
            this.checkDir(remotePath);
            Future task = CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)this.execEnv, (String)remotePath, (int)448);
            this.uploadStatus = (CommonTasksSupport.UploadStatus)task.get();
            if (this.uploadStatus.isOK()) {
                if (this.fileData != null) {
                    this.fileData.setState(file, FileState.COPIED);
                }
            } else {
                if (this.fileData != null) {
                    this.fileData.setState(file, FileState.ERROR);
                }
                if (err != null) {
                    err.append(this.uploadStatus.getError());
                }
                throw new IOException("RC=" + this.uploadStatus.getExitCode());
            }
        }

        public void close() {
            if (this.fileData != null) {
                this.fileData.store();
            }
        }

        private void checkDir(String remoteFilePath) throws InterruptedException, ExecutionException {
            String remoteDir;
            int slashPos = remoteFilePath.lastIndexOf(47);
            if (slashPos >= 0 && !this.checkedDirs.contains(remoteDir = remoteFilePath.substring(0, slashPos))) {
                this.checkedDirs.add(remoteDir);
                Future task = CommonTasksSupport.mkDir((ExecutionEnvironment)this.execEnv, (String)remoteDir, null);
                task.get();
            }
        }
    }
}

