/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class FakeIncludePair {
    final CsmUID<IncludeImpl> includeUid;
    final CsmUID<CsmOffsetableDeclaration> containerUid;
    private volatile boolean alreadyFixed;

    public FakeIncludePair(CsmUID<IncludeImpl> includeUid, CsmUID<CsmOffsetableDeclaration> containerUID) {
        this.includeUid = includeUid;
        this.containerUid = containerUID;
        this.alreadyFixed = false;
    }

    public boolean isFixed() {
        return this.alreadyFixed;
    }

    public void markFixed() {
        assert (!this.alreadyFixed);
        this.alreadyFixed = true;
    }

    public CsmUID<IncludeImpl> getIncludeUid() {
        return this.includeUid;
    }

    public CsmUID<CsmOffsetableDeclaration> getContainerUid() {
        return this.containerUid;
    }

    private void write(RepositoryDataOutput output) throws IOException {
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUID(this.includeUid, output);
        factory.writeUID(this.containerUid, output);
        output.writeBoolean(this.alreadyFixed);
    }

    private FakeIncludePair(RepositoryDataInput input) throws IOException {
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        this.includeUid = factory.readUID(input);
        this.containerUid = factory.readUID(input);
        this.alreadyFixed = input.readBoolean();
    }

    public static void write(List<FakeIncludePair> coll, RepositoryDataOutput output) throws IOException {
        assert (output != null);
        ArrayList<FakeIncludePair> copy = new ArrayList<FakeIncludePair>(coll);
        int collSize = copy.size();
        output.writeInt(collSize);
        for (FakeIncludePair pair : copy) {
            assert (pair != null);
            pair.write(output);
        }
    }

    public static void read(List<FakeIncludePair> coll, RepositoryDataInput input) throws IOException {
        int collSize = input.readInt();
        for (int i = 0; i < collSize; ++i) {
            FakeIncludePair pair = new FakeIncludePair(input);
            coll.add(pair);
        }
    }

    public String toString() {
        return "FakeIncludePair{includeUid=" + this.includeUid + ", containerUid=" + this.containerUid + ", alreadyFixed=" + this.alreadyFixed + '}';
    }
}

