/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.CsmEvent;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

final class CsmEventListener {
    private final ProjectBase project;
    private final NativeProject nativeProject;
    private volatile boolean enabledEventsHandling = true;
    private final RequestProcessor.Task task;
    private final Object eventsLock = new Object();
    private int suspendCount = 0;
    private HashMap<String, CsmEvent> events = new LinkedHashMap<String, CsmEvent>();
    private static final CsmEvent NULL = CsmEvent.createEmptyEvent(CsmEvent.Kind.NULL);

    public CsmEventListener(ProjectBase project) {
        assert (project.getPlatformProject() instanceof NativeProject);
        this.project = project;
        this.nativeProject = (NativeProject)project.getPlatformProject();
        this.task = ModelSupport.instance().getModel().createModelTask(new Worker(), this.getClass().getSimpleName());
    }

    public ProjectBase getProject() {
        return this.project;
    }

    public NativeProject getNativeProject() {
        return this.nativeProject;
    }

    public void enableListening(boolean enable) {
        if (TraceFlags.TIMING) {
            CsmEvent.LOG.log(Level.INFO, "\n%{0} ProjectListeners {1}...", new Object[]{enable ? "enable" : "disable", this.nativeProject.getProjectDisplayName()});
        }
        this.enabledEventsHandling = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvent(CsmEvent event) {
        switch (event.getKind()) {
            case FILE_INDEXED: 
            case FOLDER_CREATED: 
            case FILE_ATTRIBUTE_CHANGED: 
            case NULL: {
                return;
            }
        }
        CsmEvent.trace("dispatched %s to %s", event, this.project);
        this.checkEvent(event);
        String path = event.getPath();
        Object object = this.eventsLock;
        synchronized (object) {
            CsmEvent prev = this.events.get(path);
            CsmEvent converted = CsmEventListener.convert(prev, event);
            if (TraceFlags.TRACE_EXTERNAL_CHANGES && prev != null && prev != NULL && (prev.getKind() != converted.getKind() || !prev.getPath().equals(converted.getPath()))) {
                CsmEvent.trace("converted %s to %s", prev, converted);
            }
            this.events.put(path, converted);
            if (converted.getKind() == CsmEvent.Kind.NULL) {
                return;
            }
        }
        this.task.schedule(0);
    }

    void checkEvent(CsmEvent event) {
        if (CndUtils.isDebugMode()) {
            NativeFileItem item;
            NativeProject np;
            FileObject fo = event.getFileObject();
            if (fo != null) {
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (!fs.equals(InvalidFileObjectSupport.getDummyFileSystem()) && !fs.equals(this.nativeProject.getFileSystem())) {
                        CndUtils.assertTrue((boolean)false, (String)("Filesystem differs CsmEvent filesystem is " + fs + ", project filesystem is " + this.nativeProject.getFileSystem()));
                    }
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((np = event.getNativeProject()) == null && (item = event.getNativeFileItem()) != null) {
                np = item.getNativeProject();
            }
            if (np != null) assert (np.equals(this.nativeProject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        boolean schedule;
        Object object = this.eventsLock;
        synchronized (object) {
            CndUtils.assertTrue((this.suspendCount > 0 ? 1 : 0) != 0, (String)("resume without suspend " + this.suspendCount));
            --this.suspendCount;
            if (this.suspendCount < 0) {
                this.suspendCount = 0;
            }
            schedule = this.suspendCount == 0;
        }
        if (schedule) {
            this.task.schedule(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspend() {
        Object object = this.eventsLock;
        synchronized (object) {
            CndUtils.assertTrue((this.suspendCount >= 0 ? 1 : 0) != 0, (String)("suspend with " + this.suspendCount));
            ++this.suspendCount;
        }
    }

    void flush() {
        this.task.schedule(0);
        this.task.waitFinished();
    }

    private void processEvents(Collection<CsmEvent> events) {
        if (!this.enabledEventsHandling) {
            CsmEvent.trace("events processing disabled, skipping %d events", events.size());
            return;
        }
        CsmEvent.trace("processing %d events", events.size());
        boolean projectDeleted = false;
        boolean checkForRemoved = false;
        boolean projectRemoved = false;
        boolean allPropertiesChanged = false;
        ArrayList<FileObject> createdFiles = new ArrayList<FileObject>();
        ArrayList<NativeFileItem> addedItems = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> changedItemProps = new ArrayList<NativeFileItem>();
        ArrayList<String> changedFiles = new ArrayList<String>();
        ArrayList<CsmEvent> renamedCreatedItems = new ArrayList<CsmEvent>();
        block18: for (CsmEvent csmEvent : events) {
            CsmEvent.trace("processing %s", csmEvent);
            switch (csmEvent.getKind()) {
                case FILE_DELETED: 
                case ITEM_REMOVED: 
                case FILE_RENAMED_DELETED: 
                case ITEM_RENAMED_DELETED: {
                    checkForRemoved = true;
                    continue block18;
                }
                case FILE_CREATED: 
                case FILE_RENAMED_CREATED: {
                    createdFiles.add(csmEvent.getFileObject());
                    continue block18;
                }
                case ITEM_ADDED: {
                    addedItems.add(csmEvent.getNativeFileItem());
                    continue block18;
                }
                case FOLDER_CREATED: {
                    continue block18;
                }
                case FILE_CHANGED: {
                    changedFiles.add(csmEvent.getPath());
                    continue block18;
                }
                case FILE_ATTRIBUTE_CHANGED: {
                    continue block18;
                }
                case ITEM_PROPERTY_CHANGED: {
                    changedItemProps.add(csmEvent.getNativeFileItem());
                    continue block18;
                }
                case ITEMS_ALL_PROPERTY_CHANGED: {
                    allPropertiesChanged = true;
                    continue block18;
                }
                case ITEM_RENAMED_CREATED: {
                    renamedCreatedItems.add(csmEvent);
                    continue block18;
                }
                case PROJECT_DELETED: {
                    projectDeleted = true;
                    continue block18;
                }
                case FILES_IN_SOURCE_ROOT_DELETED: {
                    checkForRemoved = true;
                    continue block18;
                }
                case FILE_INDEXED: {
                    CndUtils.assertTrue((boolean)false, (String)"FILE_INDEXED event should never reach end listener");
                    continue block18;
                }
                case NULL: {
                    continue block18;
                }
            }
            throw new AssertionError((Object)csmEvent.getKind().name());
        }
        if (projectDeleted) {
            RepositoryUtils.onProjectDeleted(this.nativeProject);
            return;
        }
        if (!renamedCreatedItems.isEmpty()) {
            for (CsmEvent csmEvent : renamedCreatedItems) {
                this.project.onFileItemRenamed(csmEvent.getOldPath(), csmEvent.getNativeFileItem());
            }
        }
        if (allPropertiesChanged) {
            ArrayList<NativeFileItem> items = new ArrayList<NativeFileItem>();
            for (NativeFileItem item : this.nativeProject.getAllFiles()) {
                if (item.isExcluded()) continue;
                switch (item.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: {
                        items.add(item);
                        break;
                    }
                }
            }
            items.addAll(this.nativeProject.getStandardHeadersIndexers());
            this.project.onFileItemsPropertyChanged(items, true);
            changedItemProps.clear();
        }
        if (!changedFiles.isEmpty()) {
            for (String string : changedFiles) {
                CsmFile csmFile = this.project.findFile(string, false, false);
                if (csmFile == null) continue;
                this.project.onFileImplExternalChange((FileImpl)csmFile);
            }
        }
        if (!changedItemProps.isEmpty()) {
            this.project.onFileItemsPropertyChanged(changedItemProps, false);
        }
        if (!createdFiles.isEmpty()) {
            this.project.onFileObjectExternalCreate(createdFiles);
        }
        if (!addedItems.isEmpty()) {
            this.project.onFileItemsAdded(addedItems);
        }
        if (checkForRemoved) {
            this.project.checkForRemoved();
        }
    }

    private static CsmEvent convert(CsmEvent prev, CsmEvent cur) {
        if (prev == null || prev.getKind() == CsmEvent.Kind.NULL) {
            return cur;
        }
        if (prev.getKind() == CsmEvent.Kind.PROJECT_DELETED) {
            return prev;
        }
        if (cur.getKind() == CsmEvent.Kind.PROJECT_DELETED) {
            return cur;
        }
        switch (cur.getKind()) {
            case FILE_DELETED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return cur;
                    }
                    case ITEM_REMOVED: {
                        return cur;
                    }
                    case FILE_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case ITEM_ADDED: {
                        return CsmEventListener.doNull();
                    }
                    case FILE_RENAMED_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case ITEM_RENAMED_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case FILE_RENAMED_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEM_RENAMED_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
            case FILE_CREATED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return CsmEventListener.doFileChanged(CsmEvent.Kind.FILE_CHANGED, cur.getFileObject());
                    }
                    case ITEM_REMOVED: {
                        return CsmEventListener.doFileChanged(CsmEvent.Kind.FILE_CHANGED, cur.getFileObject());
                    }
                    case FILE_CREATED: {
                        return cur;
                    }
                    case ITEM_ADDED: {
                        return prev;
                    }
                    case FILE_RENAMED_CREATED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEM_RENAMED_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_DELETED: {
                        return CsmEventListener.doFileChanged(CsmEvent.Kind.FILE_CHANGED, cur.getFileObject());
                    }
                    case ITEM_RENAMED_DELETED: {
                        return CsmEventListener.doFileChanged(CsmEvent.Kind.FILE_CHANGED, cur.getFileObject());
                    }
                    case FILE_CHANGED: {
                        return prev;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return prev;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                }
                throw new AssertionError((Object)prev.getKind());
            }
            case FILE_RENAMED_CREATED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return CsmEventListener.doFileChanged(CsmEvent.Kind.FILE_CHANGED, cur.getFileObject());
                    }
                    case ITEM_REMOVED: {
                        return CsmEventListener.doFileChanged(CsmEvent.Kind.FILE_CHANGED, cur.getFileObject());
                    }
                    case FILE_CREATED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEM_ADDED: {
                        return prev;
                    }
                    case FILE_RENAMED_CREATED: {
                        return cur;
                    }
                    case ITEM_RENAMED_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_DELETED: {
                        return CsmEventListener.doFileChanged(CsmEvent.Kind.FILE_CHANGED, cur.getFileObject());
                    }
                    case ITEM_RENAMED_DELETED: {
                        return CsmEventListener.doFileChanged(CsmEvent.Kind.FILE_CHANGED, cur.getFileObject());
                    }
                    case FILE_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new AssertionError((Object)prev.getKind());
            }
            case FILE_RENAMED_DELETED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEM_REMOVED: {
                        return cur;
                    }
                    case FILE_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case ITEM_ADDED: {
                        return CsmEventListener.doNull();
                    }
                    case FILE_RENAMED_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case ITEM_RENAMED_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case FILE_RENAMED_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEM_RENAMED_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new AssertionError((Object)prev.getKind());
            }
            case FILE_CHANGED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEM_REMOVED: {
                        return cur;
                    }
                    case FILE_CREATED: {
                        return prev;
                    }
                    case ITEM_ADDED: {
                        return prev;
                    }
                    case FILE_RENAMED_CREATED: {
                        return prev;
                    }
                    case ITEM_RENAMED_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEM_RENAMED_DELETED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return prev;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
            case ITEM_ADDED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return cur;
                    }
                    case ITEM_REMOVED: {
                        return CsmEventListener.doItemChanged(CsmEvent.Kind.ITEM_PROPERTY_CHANGED, cur.getNativeFileItem());
                    }
                    case FILE_CREATED: {
                        return cur;
                    }
                    case ITEM_ADDED: {
                        return cur;
                    }
                    case FILE_RENAMED_CREATED: {
                        return cur;
                    }
                    case ITEM_RENAMED_CREATED: {
                        return cur;
                    }
                    case FILE_RENAMED_DELETED: {
                        return cur;
                    }
                    case ITEM_RENAMED_DELETED: {
                        return cur;
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
            case ITEM_REMOVED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return cur;
                    }
                    case ITEM_REMOVED: {
                        return cur;
                    }
                    case FILE_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case ITEM_ADDED: {
                        return CsmEventListener.doNull();
                    }
                    case FILE_RENAMED_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case ITEM_RENAMED_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case FILE_RENAMED_DELETED: {
                        return cur;
                    }
                    case ITEM_RENAMED_DELETED: {
                        return cur;
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
            case ITEM_PROPERTY_CHANGED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return prev;
                    }
                    case ITEM_REMOVED: {
                        return prev;
                    }
                    case FILE_CREATED: {
                        return cur;
                    }
                    case ITEM_ADDED: {
                        return prev;
                    }
                    case FILE_RENAMED_CREATED: {
                        return cur;
                    }
                    case ITEM_RENAMED_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_DELETED: {
                        return prev;
                    }
                    case ITEM_RENAMED_DELETED: {
                        return prev;
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
            case ITEMS_ALL_PROPERTY_CHANGED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: 
                    case ITEM_REMOVED: 
                    case FILE_RENAMED_DELETED: 
                    case ITEM_RENAMED_DELETED: 
                    case FILE_CREATED: 
                    case FILE_RENAMED_CREATED: 
                    case ITEM_ADDED: 
                    case FILE_CHANGED: 
                    case ITEM_PROPERTY_CHANGED: 
                    case ITEM_RENAMED_CREATED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return cur;
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
            case ITEM_RENAMED_DELETED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return cur;
                    }
                    case ITEM_REMOVED: {
                        return cur;
                    }
                    case FILE_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case ITEM_ADDED: {
                        return CsmEventListener.doNull();
                    }
                    case FILE_RENAMED_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case ITEM_RENAMED_CREATED: {
                        return CsmEventListener.doNull();
                    }
                    case FILE_RENAMED_DELETED: {
                        return cur;
                    }
                    case ITEM_RENAMED_DELETED: {
                        return cur;
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
            case ITEM_RENAMED_CREATED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: {
                        return CsmEventListener.doItemChanged(CsmEvent.Kind.ITEM_PROPERTY_CHANGED, cur.getNativeFileItem());
                    }
                    case ITEM_REMOVED: {
                        return CsmEventListener.doItemChanged(CsmEvent.Kind.ITEM_PROPERTY_CHANGED, cur.getNativeFileItem());
                    }
                    case FILE_CREATED: {
                        return cur;
                    }
                    case ITEM_ADDED: {
                        return prev;
                    }
                    case FILE_RENAMED_CREATED: {
                        return cur;
                    }
                    case ITEM_RENAMED_CREATED: {
                        return cur;
                    }
                    case FILE_RENAMED_DELETED: {
                        return CsmEventListener.doItemChanged(CsmEvent.Kind.ITEM_PROPERTY_CHANGED, cur.getNativeFileItem());
                    }
                    case ITEM_RENAMED_DELETED: {
                        return CsmEventListener.doItemChanged(CsmEvent.Kind.ITEM_PROPERTY_CHANGED, cur.getNativeFileItem());
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case ITEM_PROPERTY_CHANGED: {
                        return cur;
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return CsmEventListener.doAssert(prev, cur, prev);
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
            case FILES_IN_SOURCE_ROOT_DELETED: {
                switch (prev.getKind()) {
                    case FILE_DELETED: 
                    case ITEM_REMOVED: 
                    case FILE_RENAMED_DELETED: 
                    case ITEM_RENAMED_DELETED: 
                    case FILE_CREATED: 
                    case FILE_RENAMED_CREATED: 
                    case ITEM_ADDED: 
                    case FILE_CHANGED: 
                    case ITEM_PROPERTY_CHANGED: 
                    case ITEM_RENAMED_CREATED: {
                        return CsmEventListener.doAssert(prev, cur);
                    }
                    case ITEMS_ALL_PROPERTY_CHANGED: {
                        return prev;
                    }
                    case FILES_IN_SOURCE_ROOT_DELETED: {
                        return cur;
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.getKind()));
            }
        }
        throw new AssertionError((Object)prev.getKind());
    }

    private static CsmEvent doAssert(CsmEvent prev, CsmEvent cur) {
        return CsmEventListener.doAssert(prev, cur, cur);
    }

    private static CsmEvent doAssert(CsmEvent prev, CsmEvent cur, CsmEvent correct) {
        CndUtils.assertTrueInConsole((boolean)false, (String)("invalid states " + prev + " " + cur));
        return correct;
    }

    private static CsmEvent doItemChanged(CsmEvent.Kind kind, NativeFileItem item) {
        CndUtils.assertNotNullInConsole((Object)item, (String)"null NativeFileItem");
        return CsmEvent.createItemEvent(kind, item);
    }

    private static CsmEvent doFileChanged(CsmEvent.Kind kind, FileObject fo) {
        CndUtils.assertNotNullInConsole((Object)fo, (String)"null FileObject");
        return CsmEvent.createFileEvent(CsmEvent.Kind.FILE_CHANGED, fo);
    }

    private static CsmEvent doNull() {
        return NULL;
    }

    private static boolean toBeSuspended(CsmEvent value) {
        switch (value.getKind()) {
            case FILE_DELETED: 
            case ITEM_REMOVED: 
            case FILES_IN_SOURCE_ROOT_DELETED: {
                return true;
            }
            case FILE_INDEXED: 
            case FOLDER_CREATED: 
            case FILE_ATTRIBUTE_CHANGED: 
            case NULL: 
            case FILE_RENAMED_DELETED: 
            case ITEM_RENAMED_DELETED: 
            case FILE_CREATED: 
            case FILE_RENAMED_CREATED: 
            case ITEM_ADDED: 
            case FILE_CHANGED: 
            case ITEM_PROPERTY_CHANGED: 
            case ITEMS_ALL_PROPERTY_CHANGED: 
            case ITEM_RENAMED_CREATED: 
            case PROJECT_DELETED: {
                return false;
            }
        }
        throw new AssertionError((Object)value.getKind().name());
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap curEvents;
            if (!CsmModelAccessor.isModelAlive()) {
                return;
            }
            Object object = CsmEventListener.this.eventsLock;
            synchronized (object) {
                if (CsmEventListener.this.events.isEmpty()) {
                    return;
                }
                curEvents = CsmEventListener.this.events;
                if (CsmEventListener.this.suspendCount == 0) {
                    CsmEventListener.this.events = new LinkedHashMap();
                } else {
                    LinkedHashMap suspendedRemoves = new LinkedHashMap();
                    Iterator it = curEvents.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        CsmEvent value = (CsmEvent)entry.getValue();
                        if (!CsmEventListener.toBeSuspended(value)) continue;
                        suspendedRemoves.put(entry.getKey(), value);
                        it.remove();
                    }
                    CsmEventListener.this.events = suspendedRemoves;
                }
            }
            CsmEventListener.this.processEvents(curEvents.values());
        }
    }
}

