/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.modelimpl.csm.DeclTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ExpressionBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NestedType;
import org.netbeans.modules.cnd.modelimpl.csm.NoType;
import org.netbeans.modules.cnd.modelimpl.csm.ParameterEllipsisImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFunPtrImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariadicSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.CompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.EmptyCompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpandedExpressionBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyCompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyTryCatchStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.fsm.DummyParameterImpl;
import org.netbeans.modules.cnd.modelimpl.fsm.DummyParametersListImpl;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class PersistentUtils {
    private static final String NULL_STRING = new String(new char[]{'\u0000'});
    private static final byte FIRST_INDEX = 1;
    private static final byte VISIBILITY_PUBLIC = 1;
    private static final byte VISIBILITY_PROTECTED = 2;
    private static final byte VISIBILITY_PRIVATE = 3;
    private static final byte VISIBILITY_NONE = 4;
    private static final byte EXPRESSION_BASE = 5;
    private static final byte EXPANDED_EXPRESSION_BASE = 6;
    private static final byte FILE_BUFFER_FILE = 7;
    private static final byte NO_TYPE = 8;
    private static final byte TYPE_IMPL = 9;
    private static final byte NESTED_TYPE = 10;
    private static final byte TYPE_FUN_PTR_IMPL = 11;
    private static final byte TYPE_DECLTYPE_IMPL = 12;
    private static final byte TEMPLATE_PARAM_TYPE = 13;
    private static final byte PREPROC_STATE_STATE_IMPL = 14;
    private static final byte LAZY_COMPOUND_STATEMENT_IMPL = 15;
    private static final byte LAZY_TRY_CATCH_STATEMENT_IMPL = 16;
    private static final byte EMPTY_COMPOUND_STATEMENT_IMPL = 17;
    private static final byte COMPOUND_STATEMENT_IMPL = 18;
    private static final byte DUMMY_PARAMETER_IMPL = 19;
    private static final byte PARAMETER_ELLIPSIS_IMPL = 20;
    private static final byte PARAMETER_IMPL = 21;
    private static final byte PARAM_LIST_IMPL = 22;
    private static final byte FUN_PARAM_LIST_IMPL = 23;
    private static final byte FUN_KR_PARAM_LIST_IMPL = 24;
    private static final byte DUMMY_PARAMS_LIST_IMPL = 25;
    private static final byte TEMPLATE_DESCRIPTOR_IMPL = 26;
    private static final byte SPECIALIZATION_DESCRIPTOR_IMPL = 27;
    private static final byte SPECIALIZATION_PARAMETERS_LIST = 28;
    private static final byte TYPE_BASED_SPECIALIZATION_PARAMETER_IMPL = 29;
    private static final byte EXPRESSION_BASED_SPECIALIZATION_PARAMETER_IMPL = 30;
    private static final byte VARIADIC_SPECIALIZATION_PARAMETER_IMPL = 31;

    public static FileSystem readFileSystem(RepositoryDataInput input) throws IOException {
        FileSystem fs = input.readFileSystem();
        assert (fs != null);
        return fs;
    }

    public static void writeFileSystem(FileSystem fs, RepositoryDataOutput output) throws IOException {
        output.writeFileSystem(fs);
    }

    public static void readErrorDirectives(Set<ErrorDirectiveImpl> errors, FileImpl containingFile, RepositoryDataInput input) throws IOException {
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            ErrorDirectiveImpl offs = new ErrorDirectiveImpl(containingFile, input);
            errors.add(offs);
        }
    }

    public static void writeErrorDirectives(Set<ErrorDirectiveImpl> errors, RepositoryDataOutput output) throws IOException {
        int size = errors.size();
        output.writeInt(size);
        for (ErrorDirectiveImpl error : errors) {
            error.write(output);
        }
    }

    private PersistentUtils() {
    }

    public static void writeParameterList(CsmParameterList<?> paramList, RepositoryDataOutput output) throws IOException {
        if (paramList == null) {
            output.writeByte(-1);
        } else if (paramList instanceof ParameterListImpl) {
            int handler = 22;
            if (paramList instanceof FunctionParameterListImpl) {
                handler = 23;
                if (paramList instanceof FunctionParameterListImpl.FunctionKnRParameterListImpl) {
                    handler = 24;
                }
            }
            if (paramList instanceof DummyParametersListImpl) {
                handler = 25;
            }
            output.writeByte(handler);
            ((ParameterListImpl)paramList).write(output);
        } else {
            throw new IllegalArgumentException("instance of unknown CsmParameterList " + paramList.getClass() + paramList);
        }
    }

    public static CsmParameterList<?> readParameterList(RepositoryDataInput input, CsmScope scope) throws IOException {
        ParameterListImpl paramList;
        byte handler = input.readByte();
        switch (handler) {
            case -1: {
                paramList = null;
                break;
            }
            case 22: {
                paramList = new ParameterListImpl(input, scope);
                break;
            }
            case 23: {
                paramList = new FunctionParameterListImpl(input, scope);
                break;
            }
            case 24: {
                paramList = new FunctionParameterListImpl.FunctionKnRParameterListImpl(input, scope);
                break;
            }
            case 25: {
                paramList = new DummyParametersListImpl(input, scope);
                break;
            }
            default: {
                assert (false) : "unexpected param list implementation " + handler;
                paramList = null;
            }
        }
        return paramList;
    }

    public static void writeParameters(Collection<CsmParameter> params, RepositoryDataOutput output) throws IOException {
        if (params == null || params.isEmpty()) {
            output.writeShort(0);
        } else {
            output.writeShort(params.size());
            for (CsmParameter param : params) {
                PersistentUtils.writeParameter(param, output);
            }
        }
    }

    public static Collection<CsmParameter> readParameters(RepositoryDataInput input, CsmScope scope) throws IOException {
        int size = input.readShort();
        if (size == 0) {
            return null;
        }
        ArrayList<CsmParameter> list = new ArrayList<CsmParameter>(size);
        for (int i = 0; i < size; ++i) {
            list.add(PersistentUtils.readParameter(input, scope));
        }
        list.trimToSize();
        return list;
    }

    private static CsmParameter readParameter(RepositoryDataInput input, CsmScope scope) throws IOException {
        byte handler = input.readByte();
        ParameterImpl obj = null;
        switch (handler) {
            case 19: {
                obj = new ParameterEllipsisImpl(input, scope);
                break;
            }
            case 20: {
                obj = new ParameterEllipsisImpl(input, scope);
                break;
            }
            case 21: {
                obj = new ParameterImpl(input, scope);
                break;
            }
            default: {
                assert (false) : "unexpected handler" + handler;
                break;
            }
        }
        return obj;
    }

    private static void writeParameter(CsmParameter param, RepositoryDataOutput output) throws IOException {
        assert (param != null);
        if (param instanceof DummyParameterImpl) {
            output.writeByte(19);
            ((DummyParameterImpl)param).write(output);
        } else if (param instanceof ParameterEllipsisImpl) {
            output.writeByte(20);
            ((ParameterEllipsisImpl)param).write(output);
        } else if (param instanceof ParameterImpl) {
            output.writeByte(21);
            ((ParameterImpl)param).write(output);
        } else {
            throw new IllegalArgumentException("instance of unknown CsmParameter " + param.getClass() + param);
        }
    }

    public static void writeBuffer(FileBuffer buffer, RepositoryDataOutput output) throws IOException {
        assert (buffer != null);
        if (!(buffer instanceof AbstractFileBuffer)) {
            throw new IllegalArgumentException("instance of unknown FileBuffer " + buffer);
        }
        output.writeByte(7);
        ((AbstractFileBuffer)buffer).write(output);
    }

    public static FileBuffer readBuffer(RepositoryDataInput input) throws IOException {
        byte handler = input.readByte();
        assert (handler == 7);
        FileBufferFile buffer = new FileBufferFile(input);
        return buffer;
    }

    public static void writeStrings(CharSequence[] arr, RepositoryDataOutput output) throws IOException {
        if (arr == null) {
            output.writeInt(-1);
        } else {
            int len = arr.length;
            output.writeInt(len);
            for (int i = 0; i < len; ++i) {
                assert (arr[i] != null);
                PersistentUtils.writeUTF(arr[i], output);
            }
        }
    }

    public static void writeCollectionStrings(Collection<CharSequence> arr, RepositoryDataOutput output) throws IOException {
        if (arr == null) {
            output.writeInt(-1);
        } else {
            int len = arr.size();
            output.writeInt(len);
            for (CharSequence s : arr) {
                assert (s != null);
                PersistentUtils.writeUTF(s, output);
            }
        }
    }

    public static CharSequence[] readStrings(RepositoryDataInput input, APTStringManager manager) throws IOException {
        CharSequence[] arr = null;
        int len = input.readInt();
        if (len != -1) {
            arr = new CharSequence[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = manager.getString(PersistentUtils.readUTF(input, manager));
            }
        }
        return arr;
    }

    public static Collection<CharSequence> readCollectionStrings(RepositoryDataInput input, APTStringManager manager) throws IOException {
        ArrayList<CharSequence> arr = null;
        int len = input.readInt();
        if (len != -1) {
            arr = new ArrayList<CharSequence>(len);
            for (int i = 0; i < len; ++i) {
                arr.add(PersistentUtils.readUTF(input, manager));
            }
        }
        return arr;
    }

    public static void writeUTF(CharSequence st, RepositoryDataOutput aStream) throws IOException {
        if (st == null) {
            aStream.writeUTF(NULL_STRING);
        } else {
            assert (CharSequences.isCompact((CharSequence)st));
            aStream.writeCharSequenceUTF(st);
        }
    }

    public static CharSequence readUTF(RepositoryDataInput aStream, APTStringManager manager) throws IOException {
        CharSequence s = aStream.readCharSequenceUTF();
        if (s.length() == 1 && s.charAt(0) == '\u0000') {
            return null;
        }
        CharSequence res = manager.getString(s);
        assert (CharSequences.isCompact((CharSequence)res));
        return res;
    }

    public static void writeExpression(CsmExpression expr, RepositoryDataOutput output) throws IOException {
        if (expr == null) {
            output.writeByte(-1);
        } else if (expr instanceof ExpandedExpressionBase) {
            output.writeByte(6);
            ((ExpandedExpressionBase)expr).write(output);
        } else if (expr instanceof ExpressionBase) {
            output.writeByte(5);
            ((ExpressionBase)expr).write(output);
        } else {
            throw new IllegalArgumentException("instance of unknown CsmExpression " + expr);
        }
    }

    public static CsmExpression readExpression(RepositoryDataInput input) throws IOException {
        ExpressionBase expr;
        byte handler = input.readByte();
        if (handler == -1) {
            expr = null;
        } else {
            assert (handler == 5 || handler == 6);
            expr = handler == 6 ? new ExpandedExpressionBase(input) : new ExpressionBase(input);
        }
        return expr;
    }

    public static void writeExpressions(Collection<CsmExpression> exprs, RepositoryDataOutput output) throws IOException {
        if (exprs == null) {
            output.writeInt(-1);
        } else {
            int collSize = exprs.size();
            output.writeInt(collSize);
            for (CsmExpression expr : exprs) {
                assert (expr != null);
                PersistentUtils.writeExpression(expr, output);
            }
        }
    }

    public static <T extends Collection<CsmExpression>> T readExpressions(T collection, RepositoryDataInput input) throws IOException {
        int collSize = input.readInt();
        if (collSize != -1) {
            for (int i = 0; i < collSize; ++i) {
                CsmExpression expr = PersistentUtils.readExpression(input);
                assert (expr != null);
                collection.add((CsmExpression)expr);
            }
            return collection;
        }
        collection = null;
        return collection;
    }

    public static void writeExpressionKind(CsmExpression.Kind kind, RepositoryDataOutput output) throws IOException {
        if (kind != null) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        output.writeByte(-1);
    }

    public static CsmExpression.Kind readExpressionKind(RepositoryDataInput input) throws IOException {
        byte handler = input.readByte();
        if (handler != -1) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        CsmExpression.Kind kind = null;
        return kind;
    }

    public static CsmType readType(RepositoryDataInput stream) throws IOException {
        Object obj;
        byte handler = stream.readByte();
        switch (handler) {
            case -1: {
                obj = null;
                break;
            }
            case 8: {
                obj = NoType.instance();
                break;
            }
            case 9: {
                obj = new TypeImpl(stream);
                break;
            }
            case 10: {
                obj = new NestedType(stream);
                break;
            }
            case 11: {
                obj = new TypeFunPtrImpl(stream);
                break;
            }
            case 12: {
                obj = new DeclTypeImpl(stream);
                break;
            }
            case 13: {
                obj = new TemplateParameterTypeImpl(stream);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type handler" + handler);
            }
        }
        return obj;
    }

    public static void writeType(CsmType type, RepositoryDataOutput stream) throws IOException {
        block12: {
            try {
                if (type == null) {
                    stream.writeByte(-1);
                    break block12;
                }
                if (type instanceof NoType) {
                    stream.writeByte(8);
                    break block12;
                }
                if (type instanceof TypeImpl) {
                    if (type instanceof DeclTypeImpl) {
                        stream.writeByte(12);
                        ((DeclTypeImpl)type).write(stream);
                    } else if (type instanceof TypeFunPtrImpl) {
                        stream.writeByte(11);
                        ((TypeFunPtrImpl)type).write(stream);
                    } else if (type instanceof NestedType) {
                        stream.writeByte(10);
                        ((NestedType)type).write(stream);
                    } else {
                        stream.writeByte(9);
                        ((TypeImpl)type).write(stream);
                    }
                    break block12;
                }
                if (type instanceof TemplateParameterTypeImpl) {
                    stream.writeByte(13);
                    ((TemplateParameterTypeImpl)type).write(stream);
                    break block12;
                }
                throw new IllegalArgumentException("instance of unknown class " + type.getClass().getName());
            }
            catch (UTFDataFormatException e) {
                CndUtils.assertTrueInConsole((boolean)false, (String)"type with too long name ", (Object)type);
                throw e;
            }
        }
    }

    public static boolean isPersistable(CsmType type) {
        if (type == null) {
            return true;
        }
        if (type instanceof NoType) {
            return true;
        }
        if (type instanceof TypeImpl) {
            return true;
        }
        return type instanceof TemplateParameterTypeImpl;
    }

    public static <T extends Collection<CsmType>> void readTypes(T collection, RepositoryDataInput input) throws IOException {
        int collSize = input.readInt();
        assert (collSize >= 0);
        for (int i = 0; i < collSize; ++i) {
            CsmType type = PersistentUtils.readType(input);
            assert (type != null);
            collection.add((CsmType)type);
        }
    }

    public static void writeTypes(Collection<? extends CsmType> types, RepositoryDataOutput output) throws IOException {
        assert (types != null);
        int collSize = types.size();
        output.writeInt(collSize);
        for (CsmType csmType : types) {
            assert (csmType != null);
            PersistentUtils.writeType(csmType, output);
        }
    }

    public static TemplateDescriptor readTemplateDescriptor(RepositoryDataInput input) throws IOException {
        byte handler = input.readByte();
        if (handler == -1) {
            return null;
        }
        assert (handler == 26);
        return new TemplateDescriptor(input);
    }

    public static void writeTemplateDescriptor(TemplateDescriptor templateDescriptor, RepositoryDataOutput output) throws IOException {
        if (templateDescriptor == null) {
            output.writeByte(-1);
        } else {
            output.writeByte(26);
            templateDescriptor.write(output);
        }
    }

    public static SpecializationDescriptor readSpecializationDescriptor(RepositoryDataInput input) throws IOException {
        byte handler = input.readByte();
        if (handler == -1) {
            return null;
        }
        assert (handler == 27);
        return new SpecializationDescriptor(input);
    }

    public static void writeSpecializationDescriptor(SpecializationDescriptor specializationDescriptor, RepositoryDataOutput output) throws IOException {
        if (specializationDescriptor == null) {
            output.writeByte(-1);
        } else {
            output.writeByte(27);
            specializationDescriptor.write(output);
        }
    }

    public static void writeSpecializationParameters(List<CsmSpecializationParameter> params, RepositoryDataOutput output) throws IOException {
        if (params == null) {
            output.writeByte(-1);
        } else {
            output.writeByte(28);
            output.writeShort(params.size());
            for (CsmSpecializationParameter p : params) {
                PersistentUtils.writeSpecializationParameter(p, output);
            }
        }
    }

    public static void writeSpecializationParameter(CsmSpecializationParameter param, RepositoryDataOutput output) throws IOException {
        if (param == null) {
            output.writeByte(-1);
        } else if (param instanceof TypeBasedSpecializationParameterImpl) {
            output.writeByte(29);
            ((TypeBasedSpecializationParameterImpl)param).write(output);
        } else if (param instanceof ExpressionBasedSpecializationParameterImpl) {
            output.writeByte(30);
            ((ExpressionBasedSpecializationParameterImpl)param).write(output);
        } else if (param instanceof VariadicSpecializationParameterImpl) {
            output.writeByte(31);
            ((VariadicSpecializationParameterImpl)param).write(output);
        } else assert (false) : "unexpected instance of specialization parameter ";
    }

    public static List<CsmSpecializationParameter> readSpecializationParameters(RepositoryDataInput input) throws IOException {
        byte handler = input.readByte();
        if (handler == -1) {
            return null;
        }
        assert (handler == 28);
        ArrayList<CsmSpecializationParameter> params = new ArrayList<CsmSpecializationParameter>();
        PersistentUtils.readSpecializationParametersList(params, input);
        return params;
    }

    public static void readSpecializationParameters(List<CsmSpecializationParameter> params, RepositoryDataInput input) throws IOException {
        byte handler = input.readByte();
        if (handler == -1) {
            return;
        }
        assert (handler == 28) : "unexpected handler " + handler;
        PersistentUtils.readSpecializationParametersList(params, input);
    }

    private static void readSpecializationParametersList(List<CsmSpecializationParameter> params, RepositoryDataInput input) throws IOException {
        int size = input.readShort();
        for (int i = 0; i < size; ++i) {
            params.add(PersistentUtils.readSpecializationParameter(input));
        }
    }

    public static CsmSpecializationParameter readSpecializationParameter(RepositoryDataInput input) throws IOException {
        byte type = input.readByte();
        if (type == -1) {
            return null;
        }
        if (type == 29) {
            return new TypeBasedSpecializationParameterImpl(input);
        }
        if (type == 30) {
            return new ExpressionBasedSpecializationParameterImpl(input);
        }
        if (type == 31) {
            return new VariadicSpecializationParameterImpl(input);
        }
        assert (false) : "unexpected instance of specialization parameter ";
        return null;
    }

    public static void writeVisibility(CsmVisibility visibility, RepositoryDataOutput output) throws IOException {
        assert (visibility != null);
        int handler = -1;
        if (visibility == CsmVisibility.PUBLIC) {
            handler = 1;
        } else if (visibility == CsmVisibility.PROTECTED) {
            handler = 2;
        } else if (visibility == CsmVisibility.PRIVATE) {
            handler = 3;
        } else if (visibility == CsmVisibility.NONE) {
            handler = 4;
        } else {
            throw new IllegalArgumentException("instance of unknown visibility " + visibility);
        }
        output.writeByte(handler);
    }

    public static CsmVisibility readVisibility(RepositoryDataInput input) throws IOException {
        CsmVisibility visibility = null;
        byte handler = input.readByte();
        switch (handler) {
            case 1: {
                visibility = CsmVisibility.PUBLIC;
                break;
            }
            case 2: {
                visibility = CsmVisibility.PROTECTED;
                break;
            }
            case 3: {
                visibility = CsmVisibility.PRIVATE;
                break;
            }
            case 4: {
                visibility = CsmVisibility.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown handler" + handler);
            }
        }
        return visibility;
    }

    public static void writeCompoundStatement(CsmCompoundStatement body, RepositoryDataOutput output) throws IOException {
        assert (body != null);
        if (body instanceof LazyCompoundStatementImpl) {
            output.writeByte(15);
            ((LazyCompoundStatementImpl)body).write(output);
        } else if (body instanceof LazyTryCatchStatementImpl) {
            output.writeByte(16);
            ((LazyTryCatchStatementImpl)body).write(output);
        } else if (body instanceof EmptyCompoundStatementImpl) {
            output.writeByte(17);
            ((EmptyCompoundStatementImpl)body).write(output);
        } else if (body instanceof CompoundStatementImpl) {
            output.writeByte(15);
            ((CompoundStatementImpl)body).write(output);
        } else {
            throw new IllegalArgumentException("unknown compound statement " + body);
        }
    }

    public static CsmCompoundStatement readCompoundStatement(RepositoryDataInput input) throws IOException {
        StatementBase body;
        byte handler = input.readByte();
        switch (handler) {
            case 15: {
                body = new LazyCompoundStatementImpl(input);
                break;
            }
            case 16: {
                body = new LazyTryCatchStatementImpl(input);
                break;
            }
            case 17: {
                body = new EmptyCompoundStatementImpl(input);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown handler" + handler);
            }
        }
        return body;
    }

    public static void writePreprocState(PreprocHandler.State state, RepositoryDataOutput output) throws IOException {
        PreprocHandler.State cleanedState = APTHandlersSupport.createCleanPreprocState((PreprocHandler.State)state);
        assert (cleanedState.isCleaned());
        APTSerializeUtils.writePreprocState((PreprocHandler.State)cleanedState, (RepositoryDataOutput)output);
    }

    public static PreprocHandler.State readPreprocState(RepositoryDataInput input) throws IOException {
        PreprocHandler.State state = APTSerializeUtils.readPreprocState((RepositoryDataInput)input);
        assert (state.isCleaned());
        return state;
    }
}

