/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;

public class GitVCS
extends VersioningSystem
implements PropertyChangeListener,
PreferenceChangeListener {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.git.GitVCS");
    private final CollocationQueryImplementation collocationQueryImplementation = new CollocationQueryImplementation(){

        public boolean areCollocated(File a, File b) {
            File fra = GitVCS.this.getTopmostManagedAncestor(a);
            File frb = GitVCS.this.getTopmostManagedAncestor(b);
            return fra != null && fra.equals(frb);
        }

        public File findRoot(File file) {
            return GitVCS.this.getTopmostManagedAncestor(file);
        }
    };

    public GitVCS() {
        this.putProperty("String VCS.DisplayName", GitVCS.getDisplayName());
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(GitVCS.class, (String)"CTL_Git_MainMenu"));
        GitModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        Git.getInstance().registerGitVCS(this);
    }

    public static String getDisplayName() throws MissingResourceException {
        return NbBundle.getMessage(GitVCS.class, (String)"CTL_Git_DisplayName");
    }

    public VCSAnnotator getVCSAnnotator() {
        return Git.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Git.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        Git.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    public File getTopmostManagedAncestor(File file) {
        return Git.getInstance().getTopmostManagedAncestor(file);
    }

    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public VCSHistoryProvider getVCSHistoryProvider() {
        return Git.getInstance().getHistoryProvider();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("status.changed")) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)event.getNewValue();
            this.fireStatusChanged(changedEvent.getFile());
        } else if (event.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)event.getNewValue());
        } else if (event.getPropertyName().equals("versionedFilesChanged")) {
            LOG.fine("cleaning unversioned parents cache");
            Git.getInstance().clearAncestorCaches();
            this.fireVersionedFilesChanged();
        }
    }

    void refreshStatus(Set<File> files) {
        this.fireStatusChanged(files == null || files.isEmpty() ? null : files);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }
}

