/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.commit.GitCommitParameters;
import org.netbeans.modules.git.ui.commit.MessageArea;
import org.netbeans.modules.git.ui.commit.MessageAreaBuilder;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.TemplateSelector;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommitPanel
extends JPanel {
    private final GitCommitParameters parameters;
    private String headCommitMessage;
    private boolean commitMessageEdited;
    private static final int TITLE_WIDTH;
    private static final int MESSAGE_WIDTH;
    private boolean opened;
    JCheckBox amendCheckBox;
    final JComboBox authorComboBox = new JComboBox();
    final JComboBox commiterComboBox = new JComboBox();
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JLabel messageLabel;
    final MessageArea messageTextArea = new MessageAreaBuilder().setWraplineHint(MESSAGE_WIDTH).setTitleHint(TITLE_WIDTH).setAccessibleName(this.getMessage("ACSN_CommitForm_Message")).setAccessibleDescription(this.getMessage("ACSD_CommitForm_Message")).build();
    private JLabel recentLabel;
    private JLabel templatesLabel;

    public CommitPanel(GitCommitParameters parameters, String commitMessage, boolean preferredMessage, String user) {
        this.parameters = parameters;
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)this.getMessage("CTL_CommitForm_Message"));
        this.authorComboBox.setModel(this.prepareUserModel(GitModuleConfig.getDefault().getRecentCommitAuthors(), user));
        this.setCaretPosition(this.authorComboBox);
        this.commiterComboBox.setModel(this.prepareUserModel(GitModuleConfig.getDefault().getRecentCommiters(), user));
        this.setCaretPosition(this.commiterComboBox);
        this.initCommitMessage(commitMessage, preferredMessage);
        this.attacheMessageListener();
    }

    private void setCaretPosition(JComboBox cbo) {
        Component cmp = cbo.getEditor().getEditorComponent();
        if (cmp instanceof JTextComponent) {
            ((JTextComponent)cmp).setCaretPosition(0);
        }
    }

    private void initCommitMessage(String commitMessage, boolean preferred) {
        TemplateSelector ts = new TemplateSelector(this.parameters.getPreferences());
        if (commitMessage != null) {
            this.messageTextArea.setText(commitMessage);
        }
        if (!preferred) {
            if (ts.isAutofill()) {
                this.messageTextArea.setText(ts.getTemplate());
            } else {
                List<String> messages;
                String lastCommitMessage = this.parameters.getLastCanceledCommitMessage();
                if (lastCommitMessage.isEmpty() && new StringSelector.RecentMessageSelector(this.parameters.getPreferences()).isAutoFill() && (messages = this.parameters.getCommitMessages()).size() > 0) {
                    lastCommitMessage = messages.get(0);
                }
                if (!lastCommitMessage.isEmpty()) {
                    this.messageTextArea.setText(lastCommitMessage);
                }
            }
        }
        this.messageTextArea.selectAll();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.opened) {
            this.opened = true;
            this.messageTextArea.open();
        }
    }

    @Override
    public void removeNotify() {
        if (this.getParent() == null || !this.getParent().isShowing() && this.opened) {
            this.messageTextArea.close();
        }
        super.removeNotify();
    }

    private void attacheMessageListener() {
        this.messageTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.modified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.modified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void modified() {
                CommitPanel.this.commitMessageEdited = true;
                CommitPanel.this.messageTextArea.getDocument().removeDocumentListener(this);
            }
        });
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.templatesLabel = this.parameters.getMessagesTemplateLink(this.messageTextArea);
        this.recentLabel = this.parameters.getRecentMessagesLink(this.messageTextArea);
        this.amendCheckBox = new JCheckBox();
        this.messageLabel.setLabelFor(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.messageLabel.text"));
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.jLabel2.setLabelFor(this.authorComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.jLabel2.text"));
        this.authorComboBox.setEditable(true);
        this.commiterComboBox.setEditable(true);
        this.jLabel3.setLabelFor(this.commiterComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.templatesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.recentLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.recentLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.amendCheckBox, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.amendCheckBox.text"));
        this.amendCheckBox.setToolTipText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.amendCheckBox.TTtext"));
        this.amendCheckBox.setEnabled(false);
        this.amendCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommitPanel.this.amendCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 355, Short.MAX_VALUE).addComponent(this.recentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templatesLabel).addGap(57, 57, 57)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.authorComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.commiterComboBox, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.amendCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messageLabel).addComponent(this.templatesLabel).addComponent(this.recentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 92, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.authorComboBox, -2, -1, -2).addComponent(this.commiterComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.amendCheckBox).addContainerGap()));
    }

    private void amendCheckBoxActionPerformed(ActionEvent evt) {
        if (this.amendCheckBox.isSelected() && !this.commitMessageEdited) {
            this.messageTextArea.setText(this.headCommitMessage);
            this.commitMessageEdited = true;
        }
    }

    private String getMessage(String msgKey) {
        return NbBundle.getMessage(CommitPanel.class, (String)msgKey);
    }

    public String getHeadCommitMessage() {
        return this.headCommitMessage;
    }

    public void setHeadCommitMessage(String headCommitMessage) {
        this.headCommitMessage = headCommitMessage;
        this.amendCheckBox.setEnabled(true);
    }

    private ComboBoxModel prepareUserModel(List<String> authors, String user) {
        if (authors == null) {
            authors = new LinkedList<String>();
        }
        authors.remove(user);
        authors.add(0, user);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(authors.toArray(new String[authors.size()]));
        return model;
    }

    static {
        int width = Integer.getInteger("versioning.git.commitMessageWidth", 72);
        if (width < 0) {
            width = 72;
        }
        MESSAGE_WIDTH = width;
        width = Integer.getInteger("versioning.git.commitMessageTitleWidth", 0);
        if (width < 0) {
            width = 50;
        }
        TITLE_WIDTH = width;
    }
}

