/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.Locale;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.NamedBooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectOptionsFormat;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;

public class ArchiverConfiguration
implements AllOptionsProvider,
Cloneable {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration output;
    private NamedBooleanConfiguration runRanlib;
    private BooleanConfiguration replaceOption;
    private BooleanConfiguration verboseOption;
    private BooleanConfiguration supressOption;
    private OptionsConfiguration commandLineConfiguration;
    private OptionsConfiguration additionalDependencies;
    private StringConfiguration tool;
    private StringConfiguration ranlibTool;

    public ArchiverConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.output = new StringConfiguration(null, "");
        this.runRanlib = new NamedBooleanConfiguration(true, "", "$(RANLIB)");
        this.replaceOption = new BooleanConfiguration(true);
        this.verboseOption = new BooleanConfiguration(true);
        this.supressOption = new BooleanConfiguration(false);
        this.commandLineConfiguration = new OptionsConfiguration();
        this.additionalDependencies = new OptionsConfiguration();
        this.tool = new StringConfiguration(null, "ar");
        this.ranlibTool = new StringConfiguration(null, "ranlib");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setRunRanlib(NamedBooleanConfiguration runRanlib) {
        this.runRanlib = runRanlib;
    }

    public NamedBooleanConfiguration getRunRanlib() {
        return this.runRanlib;
    }

    public void setReplaceOption(BooleanConfiguration replaceOption) {
        this.replaceOption = replaceOption;
    }

    public BooleanConfiguration getReplaceOption() {
        return this.replaceOption;
    }

    public void setVerboseOption(BooleanConfiguration verboseOption) {
        this.verboseOption = verboseOption;
    }

    public BooleanConfiguration getVerboseOption() {
        return this.verboseOption;
    }

    public void setSupressOption(BooleanConfiguration supressOption) {
        this.supressOption = supressOption;
    }

    public BooleanConfiguration getSupressOption() {
        return this.supressOption;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration commandLineConfiguration) {
        this.commandLineConfiguration = commandLineConfiguration;
    }

    public OptionsConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setAdditionalDependencies(OptionsConfiguration additionalDependencies) {
        this.additionalDependencies = additionalDependencies;
    }

    public void setTool(StringConfiguration tool) {
        this.tool = tool;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void setRanlibTool(StringConfiguration ranlibTool) {
        this.ranlibTool = ranlibTool;
    }

    public StringConfiguration getRanlibTool() {
        return this.ranlibTool;
    }

    public void assign(ArchiverConfiguration conf) {
        this.getOutput().assign(conf.getOutput());
        this.getRunRanlib().assign(conf.getRunRanlib());
        this.getReplaceOption().assign(conf.getReplaceOption());
        this.getVerboseOption().assign(conf.getVerboseOption());
        this.getSupressOption().assign(conf.getSupressOption());
        this.getAdditionalDependencies().assign(conf.getAdditionalDependencies());
        this.getCommandLineConfiguration().assign(conf.getCommandLineConfiguration());
        this.getTool().assign(conf.getTool());
        this.getRanlibTool().assign(conf.getRanlibTool());
    }

    public ArchiverConfiguration clone() {
        ArchiverConfiguration clone = new ArchiverConfiguration(this.getMakeConfiguration());
        clone.setOutput(this.getOutput().clone());
        clone.setRunRanlib(this.getRunRanlib().clone());
        clone.setReplaceOption(this.getReplaceOption().clone());
        clone.setVerboseOption(this.getVerboseOption().clone());
        clone.setSupressOption(this.getSupressOption().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setTool(this.getTool().clone());
        clone.setRanlibTool(this.getRanlibTool().clone());
        return clone;
    }

    public String getOptions() {
        String options = this.getAllOptions(false) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        options = options + this.getOutputValue() + " ";
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        return this.getAllOptions(true);
    }

    private String getAllOptions(boolean includeOutput) {
        StringBuilder options = new StringBuilder();
        options.append(this.getReplaceOption().getValue() ? "r" : "");
        options.append(this.getVerboseOption().getValue() ? "v" : "");
        options.append(this.getSupressOption().getValue() ? "c" : "");
        if (options.length() > 0) {
            options.insert(0, "-");
        }
        options.append(" ");
        if (includeOutput) {
            options.append(this.getOutputValue());
            options.append(" ");
        }
        return MakeProjectOptionsFormat.reformatWhitespaces(options.toString());
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    private String getOutputDefault() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir()).toLowerCase(Locale.getDefault());
        switch (this.getMakeConfiguration().getConfigurationType().getValue()) {
            case 3: {
                outputName = "lib" + outputName + ".a";
            }
        }
        outputName = ConfigurationSupport.makeNameLegal(outputName);
        return "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}/" + outputName;
    }

    public String getOutputDefault27() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir()).toLowerCase(Locale.getDefault());
        outputName = "lib" + outputName + ".a";
        return "dist/" + this.getMakeConfiguration().getName() + "/" + outputName;
    }
}

