/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.api.PlatformManager;
import org.netbeans.modules.cordova.platforms.ios.Bundle;
import org.netbeans.modules.cordova.platforms.ios.IOSDevice;
import org.netbeans.modules.cordova.platforms.ios.IOSSDK;
import org.netbeans.modules.cordova.platforms.spi.PropertyProvider;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class IOSConfigurationPanel
extends JPanel {
    private PropertyProvider config;
    final RequestProcessor RP = new RequestProcessor(IOSConfigurationPanel.class);
    private JCheckBox debuggerCheckBox;
    private JComboBox deviceCombo;
    private JLabel deviceLabel;
    private JComboBox sdkCombo;
    private JLabel sdkLabel;
    private JComboBox virtualDeviceCombo;
    private JLabel virtualDeviceLabel;

    private void refreshDeviceCombo(Collection sdKs) {
        String deviceProp;
        IOSSDK[] sdks = sdKs.toArray(new IOSSDK[sdKs.size()]);
        this.sdkCombo.setEnabled(true);
        this.sdkCombo.setRenderer(new SDKRenderer());
        this.sdkCombo.setModel(new DefaultComboBoxModel<IOSSDK>(sdks));
        for (IOSSDK sdk : sdks) {
            String sdkProp = this.config.getProperty("ios.build.sdk");
            if (!sdk.getName().equals(sdkProp)) continue;
            this.sdkCombo.setSelectedItem(sdk);
            break;
        }
        if ((deviceProp = this.config.getProperty("virtual.device")) != null) {
            this.virtualDeviceCombo.setSelectedItem((Object)IOSDevice.valueOf(deviceProp));
        }
    }

    private void initControls(PropertyProvider config) {
        this.initComponents();
        this.virtualDeviceCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{IOSDevice.IPHONE, IOSDevice.IPHONE_RETINA, IOSDevice.IPAD, IOSDevice.IPAD_RETINA}));
        this.virtualDeviceCombo.setRenderer(new DeviceRenderer());
        String device = config.getProperty("device");
        if ("device".equals(device)) {
            this.deviceCombo.setSelectedIndex("device".equals(device) ? 1 : 0);
        }
        this.setCombosVisible(!"device".equals(device));
        this.debuggerCheckBox.setVisible(false);
        this.deviceCombo.setVisible(false);
        this.deviceLabel.setVisible(false);
        this.validate();
    }

    public IOSConfigurationPanel(PropertyProvider config) {
        this.config = config;
        if (!Utilities.isMac()) {
            this.setLayout(new BorderLayout());
            this.add(new JLabel(Bundle.LBL_NoMac()));
            this.validate();
        } else if (!PlatformManager.getPlatform((String)"ios").isReady()) {
            this.setLayout(new BorderLayout());
            this.add(new JLabel(Bundle.LBL_NoXcode()));
            this.validate();
        } else {
            this.initControls(config);
        }
    }

    private void setCombosVisible(boolean visible) {
        if (visible) {
            this.sdkCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{Bundle.LBL_PleaseWait()}));
            this.sdkCombo.setEnabled(false);
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Collection sdKs = PlatformManager.getPlatform((String)"ios").getSDKs();
                        IOSConfigurationPanel.this.refreshDeviceCombo(sdKs);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        this.virtualDeviceCombo.setVisible(visible);
        this.virtualDeviceLabel.setVisible(visible);
        this.sdkCombo.setVisible(visible);
        this.sdkLabel.setVisible(visible);
    }

    private void initComponents() {
        this.sdkLabel = new JLabel();
        this.sdkCombo = new JComboBox();
        this.virtualDeviceLabel = new JLabel();
        this.virtualDeviceCombo = new JComboBox();
        this.deviceLabel = new JLabel();
        this.deviceCombo = new JComboBox();
        this.debuggerCheckBox = new JCheckBox();
        this.sdkLabel.setLabelFor(this.sdkCombo);
        Mnemonics.setLocalizedText((JLabel)this.sdkLabel, (String)NbBundle.getMessage(IOSConfigurationPanel.class, (String)"IOSConfigurationPanel.sdkLabel.text"));
        this.sdkCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.LBL_PleaseWait()}));
        this.sdkCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOSConfigurationPanel.this.sdkComboActionPerformed(evt);
            }
        });
        this.virtualDeviceLabel.setLabelFor(this.virtualDeviceCombo);
        Mnemonics.setLocalizedText((JLabel)this.virtualDeviceLabel, (String)NbBundle.getMessage(IOSConfigurationPanel.class, (String)"IOSConfigurationPanel.virtualDeviceLabel.text"));
        this.virtualDeviceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOSConfigurationPanel.this.virtualDeviceComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.deviceLabel, (String)NbBundle.getMessage(IOSConfigurationPanel.class, (String)"IOSConfigurationPanel.deviceLabel.text"));
        this.deviceCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.LBL_Simulator(), Bundle.LBL_ConnectedDevice()}));
        this.deviceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOSConfigurationPanel.this.deviceComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.debuggerCheckBox, (String)NbBundle.getMessage(IOSConfigurationPanel.class, (String)"IOSConfigurationPanel.debuggerCheckBox.text"));
        this.debuggerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOSConfigurationPanel.this.debuggerCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.virtualDeviceLabel).addComponent(this.sdkLabel).addComponent(this.deviceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.virtualDeviceCombo, 0, -1, Short.MAX_VALUE).addComponent(this.sdkCombo, 0, -1, Short.MAX_VALUE).addComponent(this.deviceCombo, 0, 372, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.debuggerCheckBox).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deviceLabel).addComponent(this.deviceCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sdkLabel).addComponent(this.sdkCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.virtualDeviceLabel).addComponent(this.virtualDeviceCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggerCheckBox, -2, 36, -2).addContainerGap()));
    }

    private void sdkComboActionPerformed(ActionEvent evt) {
        this.config.putProperty("ios.build.sdk", ((IOSSDK)this.sdkCombo.getSelectedItem()).getIdentifier());
    }

    private void virtualDeviceComboActionPerformed(ActionEvent evt) {
        IOSDevice val = (IOSDevice)((Object)this.virtualDeviceCombo.getSelectedItem());
        if (val != null) {
            this.config.putProperty("virtual.device", val.name());
        }
    }

    private void deviceComboActionPerformed(ActionEvent evt) {
        if (this.deviceCombo.getSelectedIndex() == 0) {
            this.config.putProperty("device", "emulator");
            this.setCombosVisible(true);
        } else {
            this.config.putProperty("device", "device");
            this.setCombosVisible(false);
        }
    }

    private void debuggerCheckBoxActionPerformed(ActionEvent evt) {
        this.config.putProperty("debug.enabled", Boolean.toString(this.debuggerCheckBox.isSelected()));
    }

    private static class DeviceRenderer
    extends DefaultListCellRenderer {
        private DeviceRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof IOSDevice) {
                this.setText(((IOSDevice)((Object)value)).getDisplayName());
            }
            return this;
        }
    }

    private static class SDKRenderer
    extends DefaultListCellRenderer {
        private SDKRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof IOSSDK) {
                this.setText(((IOSSDK)value).getName());
            }
            return this;
        }
    }

    public static class IOSConfigurationCustomizer
    implements ProjectConfigurationCustomizer {
        private final Project p;
        private PropertyProvider config;

        public IOSConfigurationCustomizer(Project p, PropertyProvider config) {
            this.p = p;
            this.config = config;
        }

        public JPanel createPanel() {
            return new IOSConfigurationPanel(this.config);
        }

        public EnumSet<ProjectConfigurationCustomizer.HiddenProperties> getHiddenProperties() {
            return EnumSet.of(ProjectConfigurationCustomizer.HiddenProperties.WEB_SERVER);
        }
    }
}

