/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.util.ChangeSupport;

public class SourcesVisibilityQuery
implements ChangeListener {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final SourcesVisibilityQuery INSTANCE = new SourcesVisibilityQuery();
    private Pattern acceptedFilesPattern = null;
    private static final String DEFAULT_IGNORE_BYNARY_PATTERN = ".*\\.(il|o|a|dll|dylib|lib|lo|la|Po|Plo|so(\\.[0-9]*)*)$";
    private final Pattern ignoredFilesPattern = Pattern.compile(".*\\.(il|o|a|dll|dylib|lib|lo|la|Po|Plo|so(\\.[0-9]*)*)$");

    private SourcesVisibilityQuery() {
        MIMEExtensions.get((String)"text/x-c").addChangeListener((ChangeListener)this);
        MIMEExtensions.get((String)"text/x-c++").addChangeListener((ChangeListener)this);
        MIMEExtensions.get((String)"text/x-fortran").addChangeListener((ChangeListener)this);
    }

    public static SourcesVisibilityQuery getDefault() {
        return INSTANCE;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.acceptedFilesPattern = null;
        this.cs.fireChange();
    }

    boolean isVisible(String fileName) {
        Pattern pattern = this.getAcceptedFilesPattern();
        return pattern != null ? pattern.matcher(fileName).find() : true;
    }

    public boolean isIgnored(String fileName) {
        return this.ignoredFilesPattern.matcher(fileName).find();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    private List<Collection<String>> getAcceptedFilesExtensions() {
        ArrayList<Collection<String>> suffixes = new ArrayList<Collection<String>>();
        suffixes.add(MIMEExtensions.get((String)"text/x-c").getValues());
        suffixes.add(MIMEExtensions.get((String)"text/x-c++").getValues());
        suffixes.add(MIMEExtensions.get((String)"text/x-fortran").getValues());
        return suffixes;
    }

    private Pattern getAcceptedFilesPattern() {
        if (this.acceptedFilesPattern == null) {
            List<Collection<String>> acceptedFileExtensions = this.getAcceptedFilesExtensions();
            StringBuilder pat = new StringBuilder();
            for (Collection<String> col : acceptedFileExtensions) {
                for (String s : col) {
                    if (pat.length() > 0) {
                        pat.append('|');
                    }
                    if (s.indexOf(43) >= 0) {
                        s = s.replace("+", "\\+");
                    }
                    pat.append(s);
                }
                String ignoredFiles = ".*\\.(" + pat.toString() + ")$";
                this.acceptedFilesPattern = Pattern.compile(ignoredFiles);
            }
        }
        return this.acceptedFilesPattern;
    }
}

